/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.bpel.project.ui.IcanproViews;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class IcanproLogicalViewProvider
implements LogicalViewProvider {
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SubprojectProvider spp;
    private final ReferenceHelper resolver;
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "src.dir"};

    public IcanproLogicalViewProvider(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SubprojectProvider subprojectProvider, ReferenceHelper referenceHelper) {
        this.project = project;
        assert (project != null);
        this.helper = antProjectHelper;
        assert (antProjectHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new IcanLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Node[] nodeArray;
        for (Node node2 : nodeArray = node.getChildren().getNodes(true)) {
            FileObject fileObject;
            DataObject dataObject;
            if (!(object instanceof DataObject) && !(object instanceof FileObject) || (dataObject = (DataObject)node2.getLookup().lookup(DataObject.class)) == null) continue;
            FileObject fileObject2 = dataObject.getPrimaryFile();
            FileObject fileObject3 = fileObject = object instanceof DataObject ? ((DataObject)object).getPrimaryFile() : (FileObject)object;
            if (fileObject2 == fileObject) {
                return node2;
            }
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            ArrayList<Object> arrayList = Collections.list(new StringTokenizer(string, "/"));
            arrayList.set(arrayList.size() - 1, fileObject.getName());
            try {
                Node node3 = NodeOp.findPath((Node)node2, Collections.enumeration(arrayList));
                if (this.hasObject(node3, object)) {
                    return node3;
                }
                Node node4 = node3.getParentNode();
                Children children = node4.getChildren();
                for (Node node5 : nodeArray = children.getNodes()) {
                    if (!this.hasObject(node5, object)) continue;
                    return node5;
                }
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private boolean hasObject(Node node, Object object) {
        if (object == null) {
            return false;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        if (object instanceof DataObject) {
            if (dataObject.equals(object)) {
                return true;
            }
            FileObject fileObject = ((DataObject)object).getPrimaryFile();
            return this.hasObject(node, fileObject);
        }
        if (object instanceof FileObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return object.equals(fileObject);
        }
        return false;
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder;
        DataFolder dataFolder2 = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        Sources sources = ProjectUtils.getSources((Project)project);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("BIZPRO");
        arrayList.addAll(Arrays.asList(sourceGroupArray));
        if (arrayList.isEmpty()) {
            dataFolder = sources.getSourceGroups("generic");
            arrayList.addAll(Arrays.asList(dataFolder));
        }
        dataFolder2 = (dataFolder = DataFolder.findFolder((FileObject)((SourceGroup)arrayList.get(0)).getRootFolder())) != null ? dataFolder : dataFolder2;
        return Lookups.fixed((Object[])new Object[]{project, dataFolder2});
    }

    public static boolean hasBrokenLinks(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        return false;
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String string, String string2, boolean bl) {
            return new ActionImpl(string, string2, (Lookup)(bl ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            Lookup context;
            String name;
            String command;

            public ActionImpl(String string, String string2, Lookup lookup) {
                super(string2);
                this.context = lookup;
                this.command = string;
                this.name = string2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    private final class IcanLogicalViewRootNode
    extends AbstractNode {
        private Action brokenLinksAction;
        private boolean broken;

        public IcanLogicalViewRootNode() {
            super((Children)new IcanproViews.LogicalViewChildren(IcanproLogicalViewProvider.this.helper, IcanproLogicalViewProvider.this.evaluator, IcanproLogicalViewProvider.this.project), IcanproLogicalViewProvider.createLookup(IcanproLogicalViewProvider.this.project));
            this.setIconBaseWithExtension("org/netbeans/modules/bpel/project/ui/resources/icanproProjectIcon.gif");
            super.setName(ProjectUtils.getInformation((Project)IcanproLogicalViewProvider.this.project).getDisplayName());
            if (IcanproLogicalViewProvider.hasBrokenLinks(IcanproLogicalViewProvider.this.helper, IcanproLogicalViewProvider.this.resolver)) {
                this.broken = true;
                this.brokenLinksAction = new BrokenLinksAction();
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(IcanproLogicalViewProvider.class);
        }

        public Action[] getActions(boolean bl) {
            if (bl) {
                return super.getActions(true);
            }
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)IcanproLogicalViewProvider.this.project, (String)string);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(IcanproLogicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"populate_catalog", (String)resourceBundle.getString("LBL_Populate_Catalog"), null));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            arrayList.add(this.brokenLinksAction);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener {
            public BrokenLinksAction() {
                IcanproLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.putValue("Name", NbBundle.getMessage(IcanproLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!IcanLogicalViewRootNode.this.broken) {
                    this.disable();
                    return;
                }
                IcanLogicalViewRootNode.this.broken = IcanproLogicalViewProvider.hasBrokenLinks(IcanproLogicalViewProvider.this.helper, IcanproLogicalViewProvider.this.resolver);
                if (!IcanLogicalViewRootNode.this.broken) {
                    this.disable();
                }
            }

            private void disable() {
                IcanLogicalViewRootNode.this.broken = false;
                this.setEnabled(false);
                IcanproLogicalViewProvider.this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
                IcanLogicalViewRootNode.this.fireIconChange();
                IcanLogicalViewRootNode.this.fireOpenedIconChange();
            }
        }
    }
}

