/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.text.MessageFormat;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkImplementation;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.NbBookmarkManager;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public final class NbBookmarkImplementation
extends Annotation
implements BookmarkImplementation {
    static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    private final NbBookmarkManager manager;
    private Document document;
    private Line line;

    NbBookmarkImplementation(NbBookmarkManager nbBookmarkManager, int n) {
        this.manager = nbBookmarkManager;
        this.document = nbBookmarkManager.getDocument();
        this.line = NbEditorUtilities.getLine((Document)this.document, (int)n, (boolean)false);
        if (this.line != null) {
            this.attach((Annotatable)this.line);
        }
    }

    public String getAnnotationType() {
        return BOOKMARK_ANNOTATION_TYPE;
    }

    public String getShortDescription() {
        String string = NbBundle.getBundle(NbBookmarkImplementation.class).getString("Bookmark_Tooltip");
        int n = this.getLineIndex();
        return MessageFormat.format(string, new Integer(n + 1));
    }

    public int getOffset() {
        if (this.line == null) {
            return 0;
        }
        return NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.document), (int)this.line.getLineNumber());
    }

    public int getLineIndex() {
        return this.manager.getDocument().getDefaultRootElement().getElementIndex(this.getOffset());
    }

    public void release() {
        Document document = this.manager.getDocument();
        if (document instanceof StyledDocument) {
            NbDocument.removeAnnotation((StyledDocument)((StyledDocument)document), (Annotation)this);
        }
    }

    public String toString() {
        return this.getShortDescription();
    }
}

