/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.bookmarks.PersistentBookmarks;
import org.openide.modules.ModuleInstall;
import org.openide.util.WeakListeners;

public class EditorBookmarksModule
extends ModuleInstall {
    private static final String DOCUMENT_TRACKER_PROP = "EditorBookmarksModule.DOCUMENT_TRACKER_PROP";
    private PropertyChangeListener editorsTracker;
    private PropertyChangeListener documentTracker;
    private PropertyChangeListener openProjectsListener;
    private static List listeners = new ArrayList();
    private PropertyChangeListener annotationTypesListener;
    private List lastOpenProjects;

    public void restored() {
        this.editorsTracker = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == EditorRegistry.class) {
                    if (propertyChangeEvent.getPropertyName() == null || "focusGained".equals(propertyChangeEvent.getPropertyName())) {
                        JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                        BookmarkList.get(jTextComponent.getDocument());
                        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)jTextComponent.getClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP);
                        if (propertyChangeListener == null) {
                            jTextComponent.putClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP, EditorBookmarksModule.this.documentTracker);
                            jTextComponent.addPropertyChangeListener(EditorBookmarksModule.this.documentTracker);
                        }
                    }
                    return;
                }
                if (propertyChangeEvent.getSource() instanceof JTextComponent) {
                    Document document;
                    if ((propertyChangeEvent.getPropertyName() == null || "document".equals(propertyChangeEvent.getPropertyName())) && (document = (Document)propertyChangeEvent.getNewValue()) != null) {
                        BookmarkList.get(document);
                    }
                    return;
                }
            }
        };
        this.documentTracker = WeakListeners.propertyChange((PropertyChangeListener)this.editorsTracker, null);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this.editorsTracker);
        this.openProjectsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                List<Project> list = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                EditorBookmarksModule.this.lastOpenProjects.removeAll(list);
                for (Project project : EditorBookmarksModule.this.lastOpenProjects) {
                    PersistentBookmarks.saveProjectBookmarks(project);
                }
                EditorBookmarksModule.this.lastOpenProjects = new ArrayList<Project>(list);
            }
        };
        OpenProjects openProjects = OpenProjects.getDefault();
        this.lastOpenProjects = new ArrayList<Project>(Arrays.asList(openProjects.getOpenProjects()));
        openProjects.addPropertyChangeListener(this.openProjectsListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final Iterator iterator = EditorRegistry.componentList().iterator();
                if (!iterator.hasNext()) {
                    return;
                }
                AnnotationType annotationType = AnnotationTypes.getTypes().getType("editor-bookmark");
                if (annotationType == null) {
                    AnnotationTypes.getTypes().addPropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            AnnotationType annotationType = AnnotationTypes.getTypes().getType("editor-bookmark");
                            if (annotationType != null) {
                                AnnotationTypes.getTypes().removePropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                                while (iterator.hasNext()) {
                                    JTextComponent jTextComponent = (JTextComponent)iterator.next();
                                    BookmarkList.get(jTextComponent.getDocument());
                                }
                            }
                        }
                    });
                } else {
                    while (iterator.hasNext()) {
                        JTextComponent jTextComponent = (JTextComponent)iterator.next();
                        BookmarkList.get(jTextComponent.getDocument());
                    }
                }
            }
        });
    }

    public boolean closing() {
        this.finish();
        return super.closing();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        OpenProjects.getDefault().removePropertyChangeListener(this.openProjectsListener);
        EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this.editorsTracker);
        PersistentBookmarks.saveAllProjectBookmarks();
        EditorBookmarksModule.fireChange();
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(EditorBookmarksModule.class);
        Class<EditorBookmarksModule> clazz = EditorBookmarksModule.class;
        synchronized (EditorBookmarksModule.class) {
            ChangeListener[] changeListenerArray = listeners.toArray(new ChangeListener[listeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged(changeEvent);
            }
            return;
        }
    }
}

