/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static final Map nameMap = new WeakHashMap();

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
        }
        FileNaming fileNaming = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            File file3 = (File)linkedList.get(i);
            if ("\\\\".equals(file3.getPath())) {
                ++i;
                continue;
            }
            FileType fileType = i == linkedList.size() - 1 ? FileType.unknown : FileType.directory;
            fileNaming = NamingFactory.registerInstanceOfFileNaming(fileNaming, file3, fileType);
        }
        return fileNaming;
    }

    public static synchronized int getSize() {
        return nameMap.size();
    }

    public static synchronized FileNaming fromFile(FileNaming fileNaming, File file) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, FileType.unknown);
    }

    public static synchronized void checkCaseSensitivity(FileNaming fileNaming, File file) {
        if (!fileNaming.getFile().getName().equals(file.getName())) {
            boolean bl;
            boolean bl2 = bl = !new File(file, "a").equals(new File(file, "A"));
            if (!bl) {
                NamingFactory.rename(fileNaming, file.getName());
            }
        }
    }

    private static synchronized FileNaming[] rename(FileNaming fileNaming, String string) {
        return NamingFactory.rename(fileNaming, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fileNaming, String string, ProvidedExtensions.IOHandler iOHandler) {
        ArrayList<FileNaming> arrayList = new ArrayList<FileNaming>();
        boolean bl = false;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            NamingFactory.remove(fileNaming, null);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            bl = fileNaming.rename(string, iOHandler);
            clazz = NamingFactory.class;
            synchronized (NamingFactory.class) {
                arrayList.add(fileNaming);
                NamingFactory.registerInstanceOfFileNaming(fileNaming.getParent(), fileNaming.getFile(), fileNaming, true, FileType.unknown);
                NamingFactory.renameChildren(arrayList);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return bl ? arrayList.toArray(new FileNaming[arrayList.size()]) : null;
            }
        }
    }

    private static void renameChildren(ArrayList arrayList) {
        Object object;
        Integer n;
        HashMap<Integer, FileNaming> hashMap = new HashMap<Integer, FileNaming>();
        for (Map.Entry entry : nameMap.entrySet()) {
            n = (Integer)entry.getKey();
            object = new ArrayList();
            Object v = entry.getValue();
            if (v instanceof Reference) {
                object.add(v);
            } else if (v instanceof List) {
                object.addAll((List)v);
            }
            for (int i = 0; i < object.size(); ++i) {
                boolean bl;
                FileNaming fileNaming = (FileNaming)((Reference)object.get(i)).get();
                if (fileNaming == null) continue;
                Integer n2 = NamingFactory.createID(fileNaming.getFile());
                boolean bl2 = bl = !n2.equals(n);
                if (!bl) continue;
                hashMap.put(n, fileNaming);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            n = (Integer)entry.getKey();
            object = (FileNaming)entry.getValue();
            arrayList.add(object);
            NamingFactory.remove((FileNaming)object, n);
            object.getId(true);
            NamingFactory.registerInstanceOfFileNaming(object.getParent(), object.getFile(), (FileNaming)object, false, FileType.unknown);
        }
    }

    public static void remove(FileNaming fileNaming, Integer n) {
        Object v = nameMap.get(n = n != null ? n : fileNaming.getId());
        if (v instanceof List) {
            Reference reference = NamingFactory.getReference((List)v, fileNaming.getFile());
            if (reference != null) {
                ((List)v).remove(reference);
            }
        } else {
            nameMap.remove(n);
        }
    }

    public static Integer createID(File file) {
        return new Integer(file.hashCode());
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileType fileType) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, null, false, fileType);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileNaming fileNaming2, boolean bl, FileType fileType) {
        FileNaming fileNaming3;
        FileNaming fileNaming4;
        Object v = nameMap.get(new Integer(file.hashCode()));
        Reference reference = (Reference)(v instanceof Reference ? v : null);
        reference = reference == null && v instanceof List ? NamingFactory.getReference((List)v, file) : reference;
        FileNaming fileNaming5 = fileNaming4 = reference != null ? (FileNaming)reference.get() : null;
        if (!bl && fileNaming4 != null && fileNaming4.getFile().compareTo(file) == 0) {
            fileNaming3 = fileNaming4;
        } else {
            fileNaming3 = fileNaming2 == null ? NamingFactory.createFileNaming(file, fileNaming, fileType) : fileNaming2;
            WeakReference<FileNaming> weakReference = new WeakReference<FileNaming>(fileNaming3);
            boolean bl2 = v instanceof List;
            if (!bl && fileNaming4 != null || bl2) {
                if (bl2) {
                    ((List)v).add(weakReference);
                } else {
                    ArrayList<WeakReference<FileNaming>> arrayList = new ArrayList<WeakReference<FileNaming>>();
                    arrayList.add(weakReference);
                    nameMap.put(fileNaming3.getId(), arrayList);
                }
            } else {
                FileName fileName;
                Reference reference2 = nameMap.put(fileNaming3.getId(), weakReference);
                if (bl && reference2 != null && (fileName = (FileName)reference2.get()) != null) {
                    List list = NamingFactory.collectChildren(fileName);
                    for (FileNaming fileNaming6 : list) {
                        NamingFactory.remove(fileNaming6, null);
                    }
                }
            }
        }
        assert (fileNaming3 != null);
        return fileNaming3;
    }

    private static List collectChildren(FileName fileName) {
        Collection collection = nameMap.values();
        ArrayList<FileNaming> arrayList = new ArrayList<FileNaming>();
        for (Reference reference : collection) {
            FileNaming fileNaming = (FileNaming)reference.get();
            if (!NamingFactory.isChild(fileName, fileNaming)) continue;
            arrayList.add(fileNaming);
        }
        return arrayList;
    }

    private static boolean isChild(FileName fileName, FileNaming fileNaming) {
        for (FileNaming fileNaming2 = fileNaming; fileNaming2 != null; fileNaming2 = fileNaming2.getParent()) {
            if (fileNaming2 != fileName) continue;
            return true;
        }
        return false;
    }

    private static Reference getReference(List list, File file) {
        Reference reference = null;
        for (int i = 0; reference == null && i < list.size(); ++i) {
            FileNaming fileNaming;
            Reference reference2 = (Reference)list.get(i);
            FileNaming fileNaming2 = fileNaming = reference2 != null ? (FileNaming)reference2.get() : null;
            if (fileNaming == null || fileNaming.getFile().compareTo(file) != 0) continue;
            reference = reference2;
        }
        return reference;
    }

    private static FileNaming createFileNaming(File file, FileNaming fileNaming, FileType fileType) {
        FileName fileName = null;
        if (fileType.equals((Object)FileType.unknown)) {
            fileType = file.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (fileType) {
            case file: {
                fileName = new FileName(fileNaming, file);
                break;
            }
            case directory: {
                fileName = new FolderName(fileNaming, file);
            }
        }
        return fileName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        file,
        directory,
        unknown;

    }
}

