/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.impl.DebugConstants;
import org.netbeans.modules.web.client.tools.impl.Log;
import org.netbeans.modules.web.client.tools.impl.ui.DebugConfigPanel;
import org.netbeans.modules.web.client.tools.spi.WebClientToolsSessionStarter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class WebClientToolsSessionStarterImpl
implements WebClientToolsSessionStarter {
    public void startSession(URI uRI, HtmlBrowser.Factory factory, Lookup lookup) throws WebClientToolsSessionException {
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null) {
            boolean bl;
            boolean bl2 = WebClientToolsProjectUtils.isInternetExplorerSupported();
            boolean bl3 = WebClientToolsProjectUtils.isFirefoxSupported();
            Preferences preferences = NbPreferences.forModule(DebugConstants.class);
            boolean bl4 = preferences.getBoolean("debugConfigShowDialog", true);
            if (!bl2 && !bl3) {
                this.displayNoBrowserDialog(preferences);
                this.displayInBrowser(uRI);
                return;
            }
            Project project2 = (Project)project.getLookup().lookup(Project.class);
            Project project3 = project = project2 != null ? project2 : project;
            if (project.getClass().getName().equals("org.netbeans.modules.groovy.grailsproject.GrailsProject")) {
                factory = this.getSupportedBrowser(factory, bl3, bl2);
                NbJSDebugger.startDebugging(uRI, factory, lookup);
                return;
            }
            boolean bl5 = WebClientToolsProjectUtils.getServerDebugProperty((Project)project);
            if (bl4 &= bl5) {
                boolean bl6 = bl = !this.displayDebugConfigDialog(bl3, bl2, preferences);
                if (bl) {
                    this.displayInBrowser(uRI);
                    return;
                }
                boolean bl7 = preferences.getBoolean("clientDebugSwitch", true);
                boolean bl8 = preferences.getBoolean("debugConfigShowDialog", true);
                if (!bl7 && !bl8) {
                    WebClientToolsProjectUtils.Browser browser = WebClientToolsProjectUtils.isFirefox((Project)project) ? WebClientToolsProjectUtils.Browser.FIREFOX : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER;
                    WebClientToolsProjectUtils.setProjectProperties((Project)project, (boolean)true, (boolean)false, (WebClientToolsProjectUtils.Browser)browser);
                }
            }
            if (bl4 || !WebClientToolsProjectUtils.isDebugPropertySet((Project)project)) {
                bl = preferences.getBoolean("clientDebugSwitch", true);
                if (!bl) {
                    this.displayInBrowser(uRI);
                    return;
                }
                String string = bl3 ? WebClientToolsProjectUtils.Browser.FIREFOX.name() : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name();
                String string2 = preferences.get("debugConfigBrowser", string);
                factory = WebClientToolsProjectUtils.Browser.valueOf((String)string2) == WebClientToolsProjectUtils.Browser.FIREFOX ? WebClientToolsProjectUtils.getFirefoxBrowser() : WebClientToolsProjectUtils.getInternetExplorerBrowser();
            } else {
                factory = this.getSupportedBrowser(factory, bl3, bl2);
            }
        }
        NbJSDebugger.startDebugging(uRI, factory, lookup);
    }

    private void displayNoBrowserDialog(Preferences preferences) {
        if (preferences.getBoolean("noBrowserShowDialog", true)) {
            JCheckBox jCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)NbBundle.getMessage(WebClientToolsSessionStarterImpl.class, (String)"DO_NOT_SHOW_AGAIN"));
            jCheckBox.setSelected(false);
            String string = NbBundle.getMessage(WebClientToolsSessionStarterImpl.class, (String)"NO_BROWSER_TEXT");
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(false);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)new Object[]{jLabel, jCheckBox});
            message.setMessageType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            if (jCheckBox.isSelected()) {
                preferences.putBoolean("noBrowserShowDialog", false);
                try {
                    preferences.sync();
                }
                catch (BackingStoreException backingStoreException) {
                    Log.getLogger().log(Level.WARNING, "Could not save preference", backingStoreException);
                }
            }
        }
    }

    private boolean displayDebugConfigDialog(boolean bl, boolean bl2, Preferences preferences) {
        DebugConfigPanel debugConfigPanel = new DebugConfigPanel(bl, bl2, preferences);
        String string = NbBundle.getMessage(WebClientToolsSessionStarterImpl.class, (String)"DEBUG_CONFIG_TITLE");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)debugConfigPanel, string, true, 2, DialogDescriptor.CANCEL_OPTION, 0, null, debugConfigPanel.getPanelCloseHandler());
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION;
    }

    private void displayInBrowser(URI uRI) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Could not launch browser", malformedURLException);
        }
    }

    private HtmlBrowser.Factory getSupportedBrowser(HtmlBrowser.Factory factory, boolean bl, boolean bl2) {
        if (bl && bl2) {
            return factory;
        }
        if (bl2) {
            return WebClientToolsProjectUtils.getInternetExplorerBrowser();
        }
        return WebClientToolsProjectUtils.getFirefoxBrowser();
    }
}

