/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.StyledDocument;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointManager;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSFileObjectBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.customizer.NbJSBreakpointConditionsPanel;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class NbJSBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private NbJSBreakpointConditionsPanel conditionsPanel;
    private NbJSBreakpoint breakpoint = null;
    private String orFileName;
    private final int orLineNum;
    private final String orResolvedLoc;
    private boolean createBreakpoint = false;
    private JPanel cPanel;
    private JLabel fileLabel;
    private JLabel lineNumLabel;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;
    private JTextField tfURL;
    private JLabel urlLabel;

    public NbJSBreakpointPanel() {
        this.orFileName = "";
        this.orLineNum = 0;
        this.createBreakpoint = true;
        this.orResolvedLoc = "";
        this.initBreakpointPanel(this.orFileName, this.orResolvedLoc, this.orLineNum);
    }

    public NbJSBreakpointPanel(NbJSBreakpoint nbJSBreakpoint) {
        assert (nbJSBreakpoint != null);
        this.breakpoint = nbJSBreakpoint;
        this.orFileName = null;
        if (nbJSBreakpoint instanceof NbJSFileObjectBreakpoint) {
            this.orFileName = FileUtil.getFileDisplayName((FileObject)nbJSBreakpoint.getFileObject());
        } else if (nbJSBreakpoint instanceof NbJSURIBreakpoint) {
            NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)nbJSBreakpoint;
            this.orFileName = nbJSURIBreakpoint.getLocation().getURI().toString();
        }
        this.orLineNum = nbJSBreakpoint.getLineNumber();
        this.orResolvedLoc = nbJSBreakpoint.getResolvedLocation() != null ? nbJSBreakpoint.getResolvedLocation() : "";
        this.initBreakpointPanel(this.orFileName, this.orResolvedLoc, this.orLineNum);
    }

    private void initBreakpointPanel(String string, String string2, int n) {
        this.initComponents();
        assert (this.orFileName != null);
        this.tfFileName.setText(this.orFileName);
        this.tfFileName.setPreferredSize(new Dimension(this.tfFileName.getFontMetrics(this.tfFileName.getFont()).charWidth('W'), this.tfFileName.getPreferredSize().height));
        this.tfURL.setText(string2);
        this.tfLineNumber.setText(Integer.toString(this.orLineNum));
        this.conditionsPanel = new NbJSBreakpointConditionsPanel(this.breakpoint);
        this.cPanel.add((Component)this.conditionsPanel, "Center");
    }

    private static int getMaxLineNumber(FileObject fileObject) {
        DataObject dataObject;
        if (fileObject == null) {
            return 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return 0;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return 0;
        }
        editorCookie.prepareDocument().waitFinished();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (!(styledDocument instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument2 = styledDocument;
        return NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getLength()) + 1;
    }

    private void setupConditionPane() {
        if (this.breakpoint == null) {
            return;
        }
        FileObject fileObject = this.breakpoint.getFileObject();
        if (fileObject == null) {
            return;
        }
        this.conditionsPanel.setupConditionPaneContext(fileObject.getPath(), this.breakpoint.getLineNumber());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLine");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.fileLabel = new JLabel();
        this.tfFileName = new JTextField();
        this.lineNumLabel = new JLabel();
        this.tfLineNumber = new JTextField();
        this.urlLabel = new JLabel();
        this.tfURL = new JTextField();
        this.cPanel = new JPanel();
        this.setMinimumSize(new Dimension(300, 10));
        this.setName("NbJSPBreakpointPanel");
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/client/javascript/debugger/ui/breakpoints/customizer/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.fileLabel.setLabelFor(this.tfFileName);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)resourceBundle.getString("L_Line_Breakpoint_File_Name"));
        this.fileLabel.setToolTipText("");
        this.tfFileName.setColumns(60);
        this.tfFileName.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        this.lineNumLabel.setLabelFor(this.tfLineNumber);
        Mnemonics.setLocalizedText((JLabel)this.lineNumLabel, (String)resourceBundle.getString("L_Line_Breakpoint_Line_Number"));
        this.lineNumLabel.setToolTipText("");
        this.tfLineNumber.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        this.urlLabel.setLabelFor(this.tfLineNumber);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)resourceBundle.getString("L_Line_Breakpoint_URL"));
        this.urlLabel.setToolTipText("");
        this.tfURL.setColumns(60);
        this.tfURL.setEditable(false);
        this.tfURL.setToolTipText(resourceBundle.getString("TTT_TF_Resolved_URL"));
        GroupLayout groupLayout = new GroupLayout((Container)this.pSettings);
        this.pSettings.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.fileLabel, -2, 87, -2).addPreferredGap(1).add((Component)this.tfFileName, -1, 417, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.urlLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(9, 9, 9).add((Component)this.lineNumLabel, -2, 87, -2))).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tfLineNumber, -1, 417, Short.MAX_VALUE).add((Component)this.tfURL, -1, 417, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.fileLabel, this.lineNumLabel, this.urlLabel}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileLabel).add((Component)this.tfFileName, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.tfURL, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lineNumLabel).add((Component)this.tfLineNumber, -2, 19, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.fileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"L_Line_Breakpoint_File_Name"));
        this.fileLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"A11y_TF_ File"));
        this.tfFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name_Description"));
        this.lineNumLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"ACSD_L_Line_Breakpoint_Line_Number"));
        this.lineNumLabel.getAccessibleContext().setAccessibleDescription("null");
        this.tfLineNumber.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"A11y_TF_ LineNumber"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("A11Y_TF_LineNumber_Desc"));
        this.tfURL.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"A11y_TF_ ResolvedURL"));
        this.tfURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"A11y_TF_ ResolvedURL_TF_Desc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pSettings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"L_Line_Breakpoint_BorderTitle"));
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"ACSN_LineBreakpoint"));
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string == null) {
            string = this.conditionsPanel.valiadateMsg();
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        String string2 = this.tfFileName.getText().trim();
        int n = Integer.parseInt(this.tfLineNumber.getText().trim()) - 1;
        boolean bl = false;
        if (this.createBreakpoint || this.orLineNum - 1 != n || !string2.equals(this.orFileName)) {
            Line line = NbJSEditorUtil.getLine(string2, n);
            if (this.createBreakpoint) {
                this.breakpoint = NbJSBreakpointManager.addBreakpoint(line);
            }
            if (this.breakpoint instanceof NbJSFileObjectBreakpoint) {
                this.breakpoint.setLine(line);
            } else if (this.breakpoint instanceof NbJSURIBreakpoint) {
                NbJSBreakpointManager.removeBreakpoint(this.breakpoint);
                NbJSBreakpointManager.addURIBreakpoint(string2, n);
            }
        }
        if (bl) {
            this.breakpoint.notifyUpdated(this);
        }
        this.conditionsPanel.ok();
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String valiadateMsg() {
        int n;
        String string = this.tfFileName.getText().trim();
        try {
            n = Integer.parseInt(this.tfLineNumber.getText().trim()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec");
        }
        if (n < 0) {
            return NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec");
        }
        if (this.breakpoint != null) {
            if (this.breakpoint instanceof NbJSURIBreakpoint) {
                return this.validateURIMsg(string, n);
            }
            if (this.breakpoint instanceof NbJSBreakpoint) {
                return this.validateFileNameMsg(string, n);
            }
        }
        return null;
    }

    private String validateURIMsg(String string, int n) {
        DebuggerEngine debuggerEngine;
        FileObject fileObject;
        FileObject fileObject2 = fileObject = this.breakpoint != null ? this.breakpoint.getFileObject() : null;
        if (fileObject == null && (debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine()) != null) {
            NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
            fileObject = nbJSDebugger.getFileObjectForSource(JSFactory.createJSSource((String)string));
        }
        if (fileObject != null) {
            int n2 = NbJSBreakpointPanel.getMaxLineNumber(fileObject);
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n > n2) {
                return NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(n), (Object)Integer.toString(n2 + 1));
            }
        }
        return null;
    }

    private String validateFileNameMsg(String string, int n) {
        FileObject fileObject;
        FileObject fileObject2 = fileObject = this.breakpoint != null ? this.breakpoint.getFileObject() : null;
        if (fileObject == null) {
            try {
                fileObject = URLMapper.findFileObject((URL)new URL("file:" + string));
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        if (fileObject != null) {
            int n2 = NbJSBreakpointPanel.getMaxLineNumber(fileObject);
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n > n2) {
                return NbBundle.getMessage(NbJSBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(n), (Object)Integer.toString(n2 + 1));
            }
        }
        return null;
    }
}

