/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class NbJSCallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private final NbJSDebugger debugger;
    private JSDebuggerEventListener debuggerListener;
    private final List<ModelListener> listeners;
    private final Action GO_TO_SOURCE;
    private final Action COPY_TO_CLBD_ACTION = new AbstractAction(NbBundle.getMessage(NbJSCallStackModel.class, (String)"CTL_CallstackAction_Copy2CLBD_Label")){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            NbJSCallStackModel.this.stackToCLBD();
        }
    };

    public NbJSCallStackModel(ContextProvider contextProvider) {
        this.debugger = NbJSContextProviderWrapper.getContextProviderWrapper(contextProvider).getNbJSDebugger();
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
        this.debuggerListener = new JSDebuggerEventListenerImpl();
        this.debugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)this.debuggerListener, (Object)this.debugger));
        this.GO_TO_SOURCE = NbJSEditorUtil.createDebuggerGoToAction(this.debugger);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            JSDebuggerState jSDebuggerState = this.debugger.getState();
            switch (jSDebuggerState.getState()) {
                case SUSPENDED: {
                    return this.debugger.getCallStackFrames();
                }
            }
            return new Object[0];
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            JSDebuggerState jSDebuggerState = this.debugger.getState();
            switch (jSDebuggerState.getState()) {
                case SUSPENDED: {
                    return false;
                }
            }
            return true;
        }
        if (object instanceof JSCallStackFrame) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            JSDebuggerState jSDebuggerState = this.debugger.getState();
            switch (jSDebuggerState.getState()) {
                case SUSPENDED: {
                    return this.debugger.getCallStackFrames().length;
                }
            }
            return 0;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(NbJSCallStackModel.class, (String)"CTL_CallstackModel.Column.Name.Name");
        }
        if (object instanceof JSCallStackFrame) {
            JSCallStackFrame jSCallStackFrame = (JSCallStackFrame)object;
            String string = jSCallStackFrame.getDisplayName();
            return this.debugger.isSelectedFrame(jSCallStackFrame) ? "<html><b>" + string + "</b></html>" : string;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof JSCallStackFrame) {
            if (this.debugger.isSelectedFrame((JSCallStackFrame)object)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (object == "Root") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(NbJSCallStackModel.class, (String)"CTL_CallstackModel.Column.Name.Desc");
        }
        if (object instanceof JSCallStackFrame) {
            return ((JSCallStackFrame)object).getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof JSCallStackFrame) {
            JSCallStackFrame jSCallStackFrame = (JSCallStackFrame)object;
            Line line = NbJSEditorUtil.getLine(this.debugger, jSCallStackFrame);
            NbJSEditorUtil.showLine(line, true);
            this.debugger.selectFrame(jSCallStackFrame);
            this.fireTreeChanges();
            return;
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof JSCallStackFrame) {
            return new Action[]{this.GO_TO_SOURCE, this.COPY_TO_CLBD_ACTION};
        }
        return new Action[0];
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof JSCallStackFrame) {
            if (string.equals("CallStackFrameLocation")) {
                JSCallStackFrame jSCallStackFrame = (JSCallStackFrame)object;
                JSSource jSSource = JSFactory.createJSSource((String)jSCallStackFrame.getLocation().getURI().toString());
                FileObject fileObject = this.debugger.getFileObjectForSource(jSSource);
                return (fileObject instanceof URLFileObject ? fileObject.getPath() : FileUtil.getFileDisplayName((FileObject)fileObject)) + ":" + jSCallStackFrame.getLineNumber();
            }
            if (string.equals("RESOLVED_LOCATION")) {
                JSCallStackFrame jSCallStackFrame = (JSCallStackFrame)object;
                return jSCallStackFrame.getLocation().getDisplayName();
            }
        }
        throw new UnknownTypeException((Object)("Unknown Type Node: " + object + " or columnID: " + string));
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof JSCallStackFrame && (string.equals("CallStackFrameLocation") || string.equals("RESOLVED_LOCATION"))) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    private void stackToCLBD() {
        StringBuffer stringBuffer = new StringBuffer(50);
        JSCallStackFrame[] jSCallStackFrameArray = this.debugger.getCallStackFrames();
        if (jSCallStackFrameArray != null) {
            int n = jSCallStackFrameArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(jSCallStackFrameArray[i].getFunctionName());
                String string = jSCallStackFrameArray[i].getURI().toString();
                stringBuffer.append("(");
                stringBuffer.append(string);
                int n2 = jSCallStackFrameArray[i].getLineNumber();
                if (n2 > 0) {
                    stringBuffer.append(":");
                    stringBuffer.append(n2);
                }
                stringBuffer.append(")");
                if (i == n - 1) continue;
                stringBuffer.append('\n');
            }
        }
        Clipboard clipboard = NbJSCallStackModel.getClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private class JSDebuggerEventListenerImpl
    implements JSDebuggerEventListener {
        private JSDebuggerEventListenerImpl() {
        }

        public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
            NbJSCallStackModel.this.fireTreeChanges();
        }
    }
}

