/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.filesystem;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.BufferedURLContent;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLContent;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLContentProvider;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileSystem;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLFileObject
extends FileObject {
    private static final long serialVersionUID = -129282139186842072L;
    private static final String EXC_STRING = "FileObject is read-only";
    private final URL sourceURL;
    private final String name;
    private final String ext;
    private final URLFileSystem filesystem;
    private final URLFileObject parent;
    private transient URLContent cachedContent;
    private final String relativePath;
    private Hashtable<String, Object> attributes;
    private transient List<FileChangeListener> listeners;

    protected URLFileObject(URLFileSystem uRLFileSystem) {
        this.name = "";
        this.ext = "";
        this.filesystem = uRLFileSystem;
        this.parent = null;
        this.sourceURL = null;
        this.relativePath = "";
    }

    public URLFileObject(URL uRL, URLFileSystem uRLFileSystem, URLFileObject uRLFileObject) {
        this.filesystem = uRLFileSystem;
        this.parent = uRLFileObject;
        this.sourceURL = uRL;
        String string = this.sourceURL.toExternalForm();
        this.relativePath = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        String string2 = this.relativePath.substring(this.relativePath.lastIndexOf("/") + 1);
        int n = string2.lastIndexOf(".");
        if (n > 0 && n < string2.length() - 1) {
            this.name = string2.substring(0, n);
            this.ext = string2.substring(n + 1, string2.length());
        } else {
            this.name = string2;
            this.ext = "";
        }
    }

    URL getSourceURL() {
        return this.sourceURL;
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        return this.filesystem;
    }

    public FileObject getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isData() {
        return true;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public Date lastModified() {
        return new Date(0L);
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public void setAttribute(String string, Object object) throws IOException {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
    }

    public Enumeration<String> getAttributes() {
        if (this.attributes == null) {
            return Enumerations.empty();
        }
        return this.attributes.keys();
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<FileChangeListener>();
        }
        this.listeners.add(fileChangeListener);
    }

    public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(fileChangeListener);
        }
    }

    public FileLock lock() throws IOException {
        return FileLock.NONE;
    }

    public FileObject[] getChildren() {
        return new FileObject[0];
    }

    public FileObject getFileObject(String string, String string2) {
        return null;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.isData()) {
            URLContentProvider uRLContentProvider = this.filesystem.getContentProvider();
            if (this.cachedContent == null && uRLContentProvider != null) {
                this.cachedContent = new BufferedURLContent(uRLContentProvider.getContent(this.sourceURL));
            } else if (uRLContentProvider == null) {
                String string = NbBundle.getMessage(URLFileObject.class, (String)"NO_CONTENT_MSG");
                return new ByteArrayInputStream(string.getBytes());
            }
            try {
                return this.cachedContent.getInputStream();
            }
            catch (IOException iOException) {
                throw new FileNotFoundException("Could not open InputStream for URL: " + this.sourceURL.toExternalForm());
            }
        }
        return null;
    }

    public long getSize() {
        return 0L;
    }

    @Deprecated
    public boolean isReadOnly() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getExt() {
        return this.ext;
    }

    public String getPath() {
        return this.relativePath;
    }

    public String getMIMEType() {
        String string = super.getMIMEType();
        if ("text/html".equals(string) || "text/javascript".equals(string) || "text/x-css".equals(string)) {
            return string;
        }
        return "text/html";
    }

    @Deprecated
    public void setImportant(boolean bl) {
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        throw new IOException(EXC_STRING);
    }

    public void delete(FileLock fileLock) throws IOException {
        throw new IOException(EXC_STRING);
    }

    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        throw new IOException(EXC_STRING);
    }

    public FileObject createFolder(String string) throws IOException {
        throw new IOException(EXC_STRING);
    }

    public FileObject createData(String string, String string2) throws IOException {
        throw new IOException(EXC_STRING);
    }
}

