/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SourcesModel
implements TreeModel,
TableModel,
NodeActionsProvider {
    private static final String FILTER_PREFIX = "Do not stop in: ";
    private static final String DISP_FILTER_PREFIX = NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Name_DoNotStopIn");
    private Listener listener;
    private SourcePath sourcePath;
    private JPDADebugger debugger;
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> filters = new HashSet<String>();
    private Set<String> enabledFilters = new HashSet<String>();
    private Set<String> enabledSourceRoots = new HashSet<String>();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = new ArrayList<String>();
    private Properties filterProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private final Set<String> sourceRootsSet = new HashSet<String>();
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (SourcesModel.this.newSourceFileChooser == null) {
                SourcesModel.this.newSourceFileChooser = new JFileChooser();
                SourcesModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                });
                SourcesModel.this.newSourceFileChooser.setFileSelectionMode(1);
            }
            if ((n = SourcesModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File file = SourcesModel.this.newSourceFileChooser.getSelectedFile();
                if (!file.isDirectory()) {
                    return;
                }
                try {
                    String string = file.getCanonicalPath();
                    String[] stringArray = SourcesModel.this;
                    synchronized (SourcesModel.this) {
                        SourcesModel.this.additionalSourceRoots.add(string);
                        SourcesModel.this.enabledSourceRoots.add(string);
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        stringArray = SourcesModel.this.sourcePath.getSourceRoots();
                        int n2 = stringArray.length;
                        String[] stringArray2 = new String[n2 + 1];
                        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                        stringArray2[n2] = string;
                        SourcesModel.this.sourcePath.setSourceRoots(stringArray2);
                        SourcesModel.this.saveFilters();
                        SourcesModel.this.fireTreeChanged();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    };
    private final Action NEW_FILTER_ACTION = new AbstractAction(NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Action_AddFilter")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_NewFilter_Filter_Label"), NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_NewFilter_Title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                SourcesModel sourcesModel = SourcesModel.this;
                synchronized (sourcesModel) {
                    SourcesModel.this.filters.add(string);
                    SourcesModel.this.enabledFilters.add(string);
                }
                SourcesModel.this.debugger.getSmartSteppingFilter().addExclusionPatterns(Collections.singleton(string));
                SourcesModel.this.saveFilters();
                SourcesModel.this.fireTreeChanged();
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            int n2 = 0;
            while (true) {
                String[] stringArray;
                if (n2 >= n) {
                    SourcesModel.this.saveFilters();
                    SourcesModel.this.fireTreeChanged();
                    return;
                }
                String string = (String)objectArray[n2];
                if (string.startsWith(DISP_FILTER_PREFIX)) {
                    string = string.substring(DISP_FILTER_PREFIX.length());
                    stringArray = SourcesModel.this;
                    // MONITORENTER : stringArray
                    SourcesModel.this.filters.remove(string);
                    SourcesModel.this.enabledFilters.remove(string);
                    // MONITOREXIT : stringArray
                } else {
                    stringArray = SourcesModel.this;
                    // MONITORENTER : SourcesModel.this
                    SourcesModel.this.additionalSourceRoots.remove(string);
                    SourcesModel.this.enabledSourceRoots.remove(string);
                    SourcesModel.this.disabledSourceRoots.remove(string);
                    // MONITOREXIT : stringArray
                    stringArray = SourcesModel.this.sourcePath.getSourceRoots();
                    int n3 = stringArray.length;
                    String[] stringArray2 = new String[n3 - 1];
                    int n4 = -1;
                    for (int i = 0; i < n3; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        n4 = i;
                        break;
                    }
                    if (n4 >= 0) {
                        System.arraycopy(stringArray, 0, stringArray2, 0, n4);
                        System.arraycopy(stringArray, n4 + 1, stringArray2, n4, n3 - (n4 + 1));
                        SourcesModel.this.sourcePath.setSourceRoots(stringArray2);
                    }
                }
                ++n2;
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesModel(ContextProvider contextProvider) {
        this.sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.loadFilters();
        this.updateCachedRoots();
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            String[] stringArray = this.sourcePath.getOriginalSourceRoots();
            String[] stringArray2 = new String[this.filters.size()];
            stringArray2 = this.filters.toArray(stringArray2);
            int n3 = stringArray2.length;
            for (int i = 0; i < n3; ++i) {
                stringArray2[i] = DISP_FILTER_PREFIX + stringArray2[i];
            }
            Object[] objectArray = this;
            synchronized (this) {
                List list;
                if (this.additionalSourceRoots.size() > 0) {
                    list = new ArrayList(this.additionalSourceRoots.size());
                    for (String string : this.additionalSourceRoots) {
                        if (this.enabledSourceRoots.contains(string)) continue;
                        list.add(string);
                    }
                } else {
                    list = Collections.emptyList();
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                objectArray = new Object[stringArray.length + list.size() + stringArray2.length];
                System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
                System.arraycopy(list.toArray(), 0, objectArray, stringArray.length, list.size());
                System.arraycopy(stringArray2, 0, objectArray, stringArray.length + list.size(), stringArray2.length);
                n2 = Math.min(objectArray.length, n2);
                n = Math.min(objectArray.length, n);
                Object[] objectArray2 = new Object[n2 - n];
                System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
                if (this.listener == null) {
                    this.listener = new Listener((SourcesModel)this);
                }
                return objectArray2;
            }
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if ("use".equals(string) && object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if ("use".equals(string) && object instanceof String) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if ("use".equals(string) && object instanceof String) {
            this.setEnabled((String)object, (Boolean)object2);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (((String)object).startsWith(DISP_FILTER_PREFIX) || this.additionalSourceRoots.contains(object)) {
                return new Action[]{this.NEW_FILTER_ACTION, this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION};
            }
            return new Action[]{this.NEW_FILTER_ACTION, this.NEW_SOURCE_ROOT_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String string) {
        if (string.startsWith(DISP_FILTER_PREFIX)) {
            return this.enabledFilters.contains(string.substring(DISP_FILTER_PREFIX.length()));
        }
        SourcesModel sourcesModel = this;
        synchronized (sourcesModel) {
            return this.sourceRootsSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void setEnabled(String string, boolean bl) {
        if (string.startsWith(DISP_FILTER_PREFIX)) {
            String string2 = string.substring(DISP_FILTER_PREFIX.length());
            if (bl) {
                String[] stringArray = this;
                // MONITORENTER : this
                this.enabledFilters.add(string2);
                // MONITOREXIT : stringArray
                this.debugger.getSmartSteppingFilter().addExclusionPatterns(Collections.singleton(string2));
            } else {
                String[] stringArray = this;
                // MONITORENTER : this
                this.enabledFilters.remove(string2);
                // MONITOREXIT : stringArray
                this.debugger.getSmartSteppingFilter().removeExclusionPatterns(Collections.singleton(string2));
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(this.sourceRootsSet);
            String[] stringArray = this;
            // MONITORENTER : this
            if (bl) {
                this.enabledSourceRoots.add(string);
                this.disabledSourceRoots.remove(string);
                arrayList.add(string);
            } else {
                this.disabledSourceRoots.add(string);
                this.enabledSourceRoots.remove(string);
                arrayList.remove(string);
            }
            // MONITOREXIT : stringArray
            stringArray = new String[arrayList.size()];
            this.sourcePath.setSourceRoots(arrayList.toArray(stringArray));
        }
        this.saveFilters();
    }

    private void loadFilters() {
        this.filters = new HashSet<String>(this.filterProperties.getProperties("class_filters").getCollection("all", (Collection)Collections.EMPTY_SET));
        this.enabledFilters = new HashSet<String>(this.filterProperties.getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        this.enabledSourceRoots = new HashSet<String>(this.filterProperties.getProperties("source_roots").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        this.disabledSourceRoots = new HashSet<String>(this.filterProperties.getProperties("source_roots").getCollection("disabled", (Collection)Collections.EMPTY_SET));
        this.additionalSourceRoots = new ArrayList<String>(this.filterProperties.getProperties("additional_source_roots").getCollection("src_roots", (Collection)Collections.EMPTY_LIST));
        if (this.additionalSourceRoots.size() > 0) {
            String[] stringArray = this.sourcePath.getSourceRoots();
            int n = stringArray.length;
            Object[] objectArray = this.additionalSourceRoots.toArray();
            int n2 = objectArray.length;
            String[] stringArray2 = new String[n + n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            System.arraycopy(objectArray, 0, stringArray2, n, n2);
            this.sourcePath.setSourceRoots(stringArray2);
        }
    }

    private synchronized void saveFilters() {
        this.filterProperties.getProperties("class_filters").setCollection("all", this.filters);
        this.filterProperties.getProperties("class_filters").setCollection("enabled", this.enabledFilters);
        this.filterProperties.getProperties("source_roots").setCollection("enabled", this.enabledSourceRoots);
        this.filterProperties.getProperties("source_roots").setCollection("disabled", this.disabledSourceRoots);
        this.filterProperties.getProperties("additional_source_roots").setCollection("src_roots", this.additionalSourceRoots);
    }

    private synchronized void updateCachedRoots() {
        String[] stringArray = this.sourcePath.getSourceRoots();
        this.sourceRootsSet.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.sourceRootsSet.add(stringArray[i]);
        }
    }

    public static abstract class AbstractColumn
    extends ColumnModel {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sorted", bl);
        }

        public void setSortedDescending(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
        }

        public int getCurrentOrderNumber() {
            return this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", true);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference<SourcesModel> model;

        private Listener(SourcesModel sourcesModel) {
            this.model = new WeakReference<SourcesModel>(sourcesModel);
            sourcesModel.sourcePath.addPropertyChangeListener(this);
            sourcesModel.debugger.getSmartSteppingFilter().addPropertyChangeListener((PropertyChangeListener)this);
        }

        private SourcesModel getModel() {
            SourcesModel sourcesModel = (SourcesModel)this.model.get();
            if (sourcesModel == null) {
                sourcesModel.sourcePath.removePropertyChangeListener(this);
                sourcesModel.debugger.getSmartSteppingFilter().removePropertyChangeListener((PropertyChangeListener)this);
            }
            return sourcesModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourcesModel sourcesModel = this.getModel();
            if (sourcesModel == null) {
                return;
            }
            sourcesModel.updateCachedRoots();
            sourcesModel.fireTreeChanged();
        }
    }

    public static class SourcesUsedColumn
    extends AbstractColumn {
        public String getID() {
            return "use";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Name_Mnc").charAt(0));
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumn {
        public String getID() {
            return "DefaultSourcesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_Name_Name_Mnc").charAt(0));
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }
}

