/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private static final int ANNOTATION_SCHEDULE_TIME = 100;
    private transient Object currentPC;
    private final transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private JPDAThread currentThread;
    private JPDADebugger currentDebugger;
    private SourcePath currentSourcePath;
    private String currentLanguage;
    private AllThreadsAnnotator allThreadsAnnotator;
    private HashMap stackAnnotations = new HashMap();
    private RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private CallStackFrame[] stackToAnnotate;
    private SourcePath sourcePathToAnnotate;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("currentEngine".equals(string)) {
            this.updateCurrentDebugger((DebuggerEngine)propertyChangeEvent.getNewValue());
            this.updateCurrentThread();
            this.annotate();
        } else if ("currentThread".equals(string)) {
            this.updateCurrentThread((JPDAThread)propertyChangeEvent.getNewValue());
            this.annotate();
        } else if ("state".equals(string)) {
            this.annotate();
        }
        if ("threadStarted".equals(string)) {
            CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
            synchronized (currentThreadAnnotationListener) {
                if (this.allThreadsAnnotator != null) {
                    this.allThreadsAnnotator.add((JPDAThread)propertyChangeEvent.getNewValue());
                }
            }
        }
    }

    private synchronized void updateCurrentDebugger(DebuggerEngine debuggerEngine) {
        JPDADebugger jPDADebugger = debuggerEngine == null ? null : (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (this.currentDebugger == jPDADebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.allThreadsAnnotator != null) {
            this.allThreadsAnnotator.cancel();
            this.allThreadsAnnotator = null;
        }
        this.currentSourcePath = null;
        if (jPDADebugger != null) {
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.allThreadsAnnotator = new AllThreadsAnnotator(jPDADebugger);
            this.currentSourcePath = this.getCurrentSourcePath(jPDADebugger);
        }
        this.currentDebugger = jPDADebugger;
        if (this.currentThread != null && this.allThreadsAnnotator != null) {
            this.allThreadsAnnotator.remove(this.currentThread);
            this.currentThread = null;
        }
        this.updateCurrentThread();
    }

    private synchronized void updateCurrentThread() {
        this.updateCurrentThread(this.currentDebugger != null ? this.currentDebugger.getCurrentThread() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCurrentThread(JPDAThread jPDAThread) {
        JPDAThread jPDAThread2 = null;
        JPDAThread jPDAThread3 = null;
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            jPDAThread2 = this.currentThread;
            if (this.currentDebugger != null) {
                jPDAThread3 = this.currentThread = jPDAThread;
            } else {
                this.currentThread = null;
            }
            AllThreadsAnnotator allThreadsAnnotator = this.allThreadsAnnotator;
            if (allThreadsAnnotator != null) {
                if (jPDAThread2 != null) {
                    allThreadsAnnotator.annotate(jPDAThread2, false);
                }
                if (jPDAThread3 != null) {
                    allThreadsAnnotator.annotate(jPDAThread3, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourcePath getCurrentSourcePath(JPDADebugger jPDADebugger) {
        Session session = null;
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            if (sessionArray[i].lookupFirst(null, JPDADebugger.class) != jPDADebugger) continue;
            session = sessionArray[i];
            break;
        }
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            this.currentLanguage = session == null ? null : session.getCurrentLanguage();
        }
        currentThreadAnnotationListener = session == null ? null : session.getCurrentEngine();
        SourcePath sourcePath = currentThreadAnnotationListener == null ? null : (SourcePath)currentThreadAnnotationListener.lookupFirst(null, SourcePath.class);
        return sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        String string;
        SourcePath sourcePath;
        CallStackFrame callStackFrame;
        CallStackFrame[] callStackFrameArray;
        Object object = this;
        synchronized (object) {
            JPDADebugger jPDADebugger = this.currentDebugger;
            if (this.currentThread == null || jPDADebugger.getState() != 3) {
                Object object2 = this.currentPCLock;
                synchronized (object2) {
                    this.currentPCSet = false;
                }
                this.removeAnnotations();
                return;
            }
            try {
                callStackFrameArray = this.currentThread.getCallStack();
            }
            catch (AbsentInformationException absentInformationException) {
                ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
                Object object3 = this.currentPCLock;
                synchronized (object3) {
                    this.currentPCSet = false;
                }
                this.removeAnnotations();
                return;
            }
            callStackFrame = jPDADebugger.getCurrentCallStackFrame();
            sourcePath = this.currentSourcePath;
            string = this.currentLanguage;
        }
        object = this.currentPCLock;
        synchronized (object) {
            this.currentPCSet = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JPDAThread jPDAThread;
                Object object = CurrentThreadAnnotationListener.this;
                synchronized (object) {
                    jPDAThread = CurrentThreadAnnotationListener.this.currentThread;
                }
                object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.getContext().removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (callStackFrame != null && sourcePath != null && jPDAThread != null) {
                        sourcePath.showSource(callStackFrame, string);
                        CurrentThreadAnnotationListener.this.currentPC = sourcePath.annotate(jPDAThread, string);
                    }
                }
            }
        });
        this.annotateCallStack(callStackFrameArray, sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create((Runnable)new RemoveAnnotationsTask());
            }
        }
        this.taskRemove.schedule(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(CallStackFrame[] callStackFrameArray, SourcePath sourcePath) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = callStackFrameArray;
            this.sourcePathToAnnotate = sourcePath;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.create((Runnable)new AnnotateCallStackTask());
            }
        }
        this.taskAnnotate.schedule(100);
    }

    static /* synthetic */ CallStackFrame[] access$902(CurrentThreadAnnotationListener currentThreadAnnotationListener, CallStackFrame[] callStackFrameArray) {
        currentThreadAnnotationListener.stackToAnnotate = callStackFrameArray;
        return callStackFrameArray;
    }

    private class AllThreadsAnnotator
    implements Runnable,
    PropertyChangeListener {
        private boolean active = true;
        private JPDADebugger debugger;
        private Map<JPDAThread, Object> threadAnnotations = new HashMap<JPDAThread, Object>();
        private Set<JPDAThread> threadsToAnnotate = new HashSet<JPDAThread>();
        private Map<JPDAThread, FutureAnnotation> futureAnnotations = new HashMap<JPDAThread, FutureAnnotation>();
        private Set<Object> annotationsToRemove = new HashSet<Object>();
        private RequestProcessor.Task task = CurrentThreadAnnotationListener.access$800(CurrentThreadAnnotationListener.this).create((Runnable)this);

        public AllThreadsAnnotator(JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            for (JPDAThread jPDAThread : jPDADebugger.getThreadsCollector().getAllThreads()) {
                this.add(jPDAThread);
            }
        }

        public void add(JPDAThread jPDAThread) {
            ((Customizer)jPDAThread).addPropertyChangeListener(this);
            this.annotate(jPDAThread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(JPDAThread jPDAThread) {
            ((Customizer)jPDAThread).removePropertyChangeListener(this);
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                Object object = this.threadAnnotations.remove(jPDAThread);
                if (object != null) {
                    this.threadsToAnnotate.remove(jPDAThread);
                    this.annotationsToRemove.add(object);
                    this.task.schedule(100);
                }
            }
        }

        public synchronized void cancel() {
            this.active = false;
            for (JPDAThread jPDAThread : new HashSet<JPDAThread>(this.threadAnnotations.keySet())) {
                this.remove(jPDAThread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                if (!this.active) {
                    ((Customizer)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
                    return;
                }
            }
            allThreadsAnnotator = (JPDAThread)propertyChangeEvent.getSource();
            this.annotate((JPDAThread)allThreadsAnnotator);
        }

        private void annotate(JPDAThread jPDAThread) {
            this.annotate(jPDAThread, jPDAThread == this.debugger.getCurrentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void annotate(JPDAThread jPDAThread, boolean bl) {
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                Object object = this.threadAnnotations.remove(jPDAThread);
                if (object != null) {
                    this.threadsToAnnotate.remove(jPDAThread);
                    this.annotationsToRemove.add(object);
                    this.task.schedule(100);
                }
                if (!bl) {
                    this.threadsToAnnotate.add(jPDAThread);
                    FutureAnnotation futureAnnotation = this.futureAnnotations.get(jPDAThread);
                    if (futureAnnotation == null) {
                        futureAnnotation = new FutureAnnotation(jPDAThread);
                    }
                    this.threadAnnotations.put(jPDAThread, futureAnnotation);
                    this.futureAnnotations.put(jPDAThread, futureAnnotation);
                    this.task.schedule(100);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void run() {
            HashMap<JPDAThread, FutureAnnotation> hashMap;
            HashSet<JPDAThread> hashSet;
            HashSet<Object> hashSet2;
            HashMap<JPDAThread, Object> hashMap2 = this;
            synchronized (hashMap2) {
                hashSet2 = new HashSet<Object>(this.annotationsToRemove);
                this.annotationsToRemove.clear();
                hashSet = new HashSet<JPDAThread>(this.threadsToAnnotate);
                this.threadsToAnnotate.clear();
                hashMap = new HashMap<JPDAThread, FutureAnnotation>(this.futureAnnotations);
                this.futureAnnotations.clear();
            }
            for (Object e : hashSet2) {
                void object2;
                Object object;
                if (e instanceof FutureAnnotation && (object = ((FutureAnnotation)e).getAnnotation()) == null) continue;
                EditorContextBridge.getContext().removeAnnotation((Object)object2);
            }
            hashMap2 = new HashMap<JPDAThread, Object>();
            HashSet<JPDAThread> hashSet3 = new HashSet<JPDAThread>();
            for (JPDAThread jPDAThread : hashSet) {
                Object object = CurrentThreadAnnotationListener.this.currentSourcePath != null ? CurrentThreadAnnotationListener.this.currentSourcePath.annotate(jPDAThread, CurrentThreadAnnotationListener.this.currentLanguage, false) : null;
                if (object != null) {
                    hashMap2.put(jPDAThread, object);
                    ((FutureAnnotation)hashMap.get(jPDAThread)).setAnnotation(object);
                    continue;
                }
                hashSet3.add(jPDAThread);
            }
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                this.threadAnnotations.keySet().removeAll(hashSet3);
                this.threadAnnotations.putAll(hashMap2);
            }
        }

        private final class FutureAnnotation {
            private JPDAThread thread;
            private Object annotation;

            public FutureAnnotation(JPDAThread jPDAThread) {
                this.thread = jPDAThread;
            }

            public JPDAThread getThread() {
                return this.thread;
            }

            public void setAnnotation(Object object) {
                this.annotation = object;
            }

            public Object getAnnotation() {
                return this.annotation;
            }

            public String toString() {
                return "Future annotation (" + this.annotation + ") for " + this.thread;
            }
        }
    }

    private class AnnotateCallStackTask
    implements Runnable {
        private AnnotateCallStackTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            SourcePath sourcePath;
            CallStackFrame[] callStackFrameArray;
            Object object2 = CurrentThreadAnnotationListener.this.rp;
            synchronized (object2) {
                if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                    return;
                }
                callStackFrameArray = CurrentThreadAnnotationListener.this.stackToAnnotate;
                sourcePath = CurrentThreadAnnotationListener.this.sourcePathToAnnotate;
                CurrentThreadAnnotationListener.access$902(CurrentThreadAnnotationListener.this, null);
                CurrentThreadAnnotationListener.this.sourcePathToAnnotate = null;
            }
            object2 = new HashMap();
            int n = callStackFrameArray.length;
            for (int i = 1; i < n; ++i) {
                object = callStackFrameArray[i].getDefaultStratum();
                String string = EditorContextBridge.getRelativePath(callStackFrameArray[i], (String)object);
                int n2 = callStackFrameArray[i].getLineNumber((String)object);
                String string2 = string + n2;
                if (((HashMap)object2).containsKey(string2)) continue;
                Object object3 = CurrentThreadAnnotationListener.this.stackAnnotations.remove(string2);
                if (object3 == null) {
                    object3 = sourcePath.annotate(callStackFrameArray[i], (String)object);
                }
                if (object3 == null) continue;
                ((HashMap)object2).put(string2, object3);
            }
            object = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
            while (object.hasNext()) {
                EditorContextBridge.getContext().removeAnnotation(object.next());
            }
            CurrentThreadAnnotationListener.this.stackAnnotations = (HashMap)object2;
        }
    }

    private class RemoveAnnotationsTask
    implements Runnable {
        private RemoveAnnotationsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator iterator = CurrentThreadAnnotationListener.this.currentPCLock;
            synchronized (iterator) {
                if (CurrentThreadAnnotationListener.this.currentPCSet) {
                    return;
                }
                if (CurrentThreadAnnotationListener.this.currentPC != null) {
                    EditorContextBridge.getContext().removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                }
                CurrentThreadAnnotationListener.this.currentPC = null;
            }
            iterator = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
            while (iterator.hasNext()) {
                EditorContextBridge.getContext().removeAnnotation(iterator.next());
            }
            CurrentThreadAnnotationListener.this.stackAnnotations.clear();
        }
    }
}

