/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryModel;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLHistoryModelImpl
implements SQLHistoryModel {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history";
    public static final String SAVE_STATEMENTS_MAX_LIMIT_ENTERED = "10000";
    public static final int SAVE_STATEMENTS_EMPTY = 0;
    public static final String SAVE_STATEMENTS_CLEARED = "";
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryModelImpl.class.getName());
    List<SQLHistory> _sqlHistoryList = new ArrayList<SQLHistory>();

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFilter(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getFilter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SQLHistory> getSQLHistoryList() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        List<SQLHistory> list = new ArrayList<SQLHistory>();
        this._sqlHistoryList.clear();
        try {
            String string;
            boolean bl = false;
            FileObject fileObject2 = fileObject.getFileObject(SQL_HISTORY_FOLDER);
            String string2 = FileUtil.getFileDisplayName((FileObject)fileObject2) + File.separator + SQL_HISTORY_FILE_NAME + ".xml";
            list = SQLHistoryPersistenceManager.getInstance().retrieve(string2, fileObject2);
            if (!this.isSQLUnique(list)) {
                list = this.removeDuplicates(list);
                bl = true;
            }
            if ((string = NbPreferences.forModule(SQLHistoryPersistenceManager.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED)).equals(SAVE_STATEMENTS_CLEARED)) {
                string = SAVE_STATEMENTS_MAX_LIMIT_ENTERED;
            }
            int n = Integer.parseInt(string);
            if (list.size() > n) {
                list = this.removeExtraSQL(list, n);
                bl = true;
            }
            if (bl) {
                SQLHistoryPersistenceManager.getInstance().updateSQLSaved(0, fileObject2);
                SQLHistoryPersistenceManager.getInstance().create(fileObject2, list);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        return list;
    }

    private boolean isSQLUnique(List<SQLHistory> list) {
        ArrayList<SQLHistory> arrayList = new ArrayList<SQLHistory>();
        boolean bl = true;
        for (SQLHistory sQLHistory : list) {
            for (SQLHistory sQLHistory2 : arrayList) {
                if (!sQLHistory2.getSql().trim().equals(sQLHistory.getSql().trim()) || !sQLHistory2.getUrl().equals(sQLHistory.getUrl())) continue;
                bl = false;
            }
            arrayList.add(sQLHistory);
        }
        return bl;
    }

    private List<SQLHistory> removeDuplicates(List<SQLHistory> list) {
        ArrayList<SQLHistory> arrayList = new ArrayList<SQLHistory>();
        boolean bl = true;
        for (SQLHistory sQLHistory : list) {
            for (SQLHistory sQLHistory2 : arrayList) {
                if (!sQLHistory2.getSql().trim().equals(sQLHistory.getSql().trim()) || !sQLHistory2.getUrl().equals(sQLHistory.getUrl())) continue;
                bl = false;
            }
            if (bl) {
                arrayList.add(sQLHistory);
                continue;
            }
            bl = true;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private List<SQLHistory> removeExtraSQL(List<SQLHistory> list, int n) {
        int n2 = 0;
        ArrayList<SQLHistory> arrayList = new ArrayList<SQLHistory>();
        for (SQLHistory sQLHistory : list) {
            if (n2 < n) {
                arrayList.add(sQLHistory);
            }
            ++n2;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    @Override
    public void setSQLHistoryList(List<SQLHistory> list) {
        this._sqlHistoryList = list;
    }
}

