/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class EditorBufferSelectorPanel
extends JPanel
implements ListSelectionListener {
    private final JFileChooser fileChooser;
    private final FileObject peer;
    private JList elementsList;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public EditorBufferSelectorPanel(JFileChooser jFileChooser, FileObject fileObject) {
        this.fileChooser = jFileChooser;
        this.peer = fileObject;
        this.initComponents();
        this.initEditorDocuments();
    }

    private void initEditorDocuments() {
        this.elementsList = new JList(){

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    EditorListElement editorListElement = (EditorListElement)EditorBufferSelectorPanel.this.elementsList.getModel().getElementAt(n);
                    return editorListElement.fileObject.getPath();
                }
                return null;
            }
        };
        ArrayList<EditorListElement> arrayList = new ArrayList<EditorListElement>();
        WindowManager windowManager = WindowManager.getDefault();
        Set set = windowManager.getModes();
        for (Mode mode : set) {
            TopComponent[] topComponentArray;
            if (!windowManager.isEditorMode(mode)) continue;
            for (TopComponent topComponent : topComponentArray = mode.getTopComponents()) {
                DataObject dataObject;
                Lookup lookup = topComponent.getLookup();
                FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
                if (fileObject == null && (dataObject = (DataObject)lookup.lookup(DataObject.class)) != null) {
                    fileObject = dataObject.getPrimaryFile();
                }
                if (fileObject == null || fileObject == this.peer) continue;
                if (topComponent.getHtmlDisplayName() != null) {
                    arrayList.add(new EditorListElement(fileObject, topComponent.getHtmlDisplayName()));
                    continue;
                }
                arrayList.add(new EditorListElement(fileObject, topComponent.getName()));
            }
        }
        this.elementsList.setListData(arrayList.toArray(new EditorListElement[arrayList.size()]));
        this.elementsList.setSelectionMode(0);
        this.elementsList.addListSelectionListener(this);
        this.jPanel1.add(this.elementsList);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        EditorListElement editorListElement = (EditorListElement)this.elementsList.getSelectedValue();
        if (editorListElement != null) {
            File file = FileUtil.toFile((FileObject)editorListElement.fileObject);
            this.fileChooser.setSelectedFile(file);
        } else {
            File file = new File("");
            this.fileChooser.setSelectedFile(file);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditorBufferSelectorPanel.class, (String)"EditorBufferSelectorPanel.jLabel1.text"));
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jPanel1, -1, 216, Short.MAX_VALUE).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanel1, -1, 162, Short.MAX_VALUE).addContainerGap()));
    }

    private class EditorListElement {
        FileObject fileObject;
        String displayName;

        EditorListElement(FileObject fileObject, String string) {
            this.fileObject = fileObject;
            this.displayName = string;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

