/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.xerces.util.XMLChar;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.wizards.BrowseFolders;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.TargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class TargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(TargetChooserPanelGUI.class.getName());
    private static final String TAG_FILE_FOLDER = "WEB-INF/tags";
    private static final String TAG_FILE_IN_JAVALIB_FOLDER = "META-INF/tags";
    private static final String TLD_FOLDER = "WEB-INF/tlds";
    private static final String TLD_IN_JAVALIB_FOLDER = "META-INF";
    private TargetChooserPanel wizardPanel;
    private Project project;
    private String expectedExtension;
    private final List listeners = new ArrayList();
    private SourceGroup[] folders;
    private FileType fileType;
    private WebModule wm;
    private ButtonGroup buttonGroup1;
    private JTextArea descriptionArea;
    private JScrollPane jScrollPane1;
    private JRadioButton jspSyntaxButton;
    private JRadioButton xmlSyntaxButton;
    private JCheckBox segmentBox;
    private JCheckBox tldCheckBox;
    private JButton browseButton1;
    private JLabel descriptionLabel;
    private JLabel optionLabel;
    private JPanel optionsPanel;
    private Set tagValues;
    private String tagName;
    private JTextField uriTextField;
    private JTextField prefixTextField;
    private JTextField tldTextField;
    private JTextField tagNameTextField;
    private JLabel uriLabel;
    private JLabel prefixLabel;
    private boolean uriWasTyped;
    private boolean prefixWasTyped;
    boolean tagFileValid = true;
    private FileObject tldFo;
    private JButton browseButton;
    private JPanel customPanel;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JPanel fillerPanel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JLabel nameLabel;
    private JLabel pathLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    public TargetChooserPanelGUI(final TargetChooserPanel targetChooserPanel, Project project, SourceGroup[] sourceGroupArray, FileType fileType) {
        this.wizardPanel = targetChooserPanel;
        this.project = project;
        this.folders = sourceGroupArray;
        this.fileType = fileType;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_TargetPanel", (Object)fileType.toString()));
        if (FileType.JSP.equals(fileType) || FileType.TAG.equals(fileType)) {
            this.buttonGroup1 = new ButtonGroup();
            this.jScrollPane1 = new JScrollPane();
            this.descriptionArea = new JTextArea();
            this.segmentBox = new JCheckBox();
            this.descriptionLabel = new JLabel();
            this.optionLabel = new JLabel();
            this.jspSyntaxButton = new JRadioButton();
            this.xmlSyntaxButton = new JRadioButton();
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.fill = 1;
            this.customPanel.add((Component)this.optionsPanel, gridBagConstraints);
            this.segmentBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    TargetChooserPanelGUI.this.checkBoxChanged(itemEvent);
                }
            });
            this.optionLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Options"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 18;
            this.optionsPanel.add((Component)this.optionLabel, gridBagConstraints);
            this.jspSyntaxButton.setSelected(true);
            if (FileType.JSP.equals(fileType)) {
                this.jspSyntaxButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_JspStandard_mnem").charAt(0));
            } else {
                this.jspSyntaxButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_TagStandard_mnem").charAt(0));
            }
            this.buttonGroup1.add(this.jspSyntaxButton);
            this.jspSyntaxButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    TargetChooserPanelGUI.this.checkBoxChanged(itemEvent);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            this.optionsPanel.add((Component)this.jspSyntaxButton, gridBagConstraints);
            this.xmlSyntaxButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_JspXml_mnem").charAt(0));
            this.buttonGroup1.add(this.xmlSyntaxButton);
            this.xmlSyntaxButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    TargetChooserPanelGUI.this.checkBoxChanged(itemEvent);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            this.optionsPanel.add((Component)this.xmlSyntaxButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.segmentBox.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_JspSegment_mnem").charAt(0));
            this.optionsPanel.add((Component)this.segmentBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 2.0;
            this.optionsPanel.add((Component)new JPanel(), gridBagConstraints);
            this.descriptionLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_description"));
            this.descriptionLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Description_mnem").charAt(0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 2, 0);
            this.descriptionLabel.setLabelFor(this.descriptionArea);
            this.customPanel.add((Component)this.descriptionLabel, gridBagConstraints);
            this.descriptionArea.setEditable(false);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setRows(2);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setOpaque(false);
            this.descriptionArea.getAccessibleContext().setAccessibleDescription(this.descriptionLabel.getText());
            this.jScrollPane1.setViewportView(this.descriptionArea);
            this.jScrollPane1.setVerticalScrollBarPolicy(21);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 2.0;
            this.customPanel.add((Component)this.jScrollPane1, gridBagConstraints);
            if (FileType.TAG.equals(fileType)) {
                this.tldCheckBox = new JCheckBox();
                this.tldCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_AddToTLD_mnem").charAt(0));
                this.tldCheckBox.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_addTagFileToTLD"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 4;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(6, 0, 2, 0);
                this.customPanel.add((Component)this.tldCheckBox, gridBagConstraints);
                this.tldCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("OPT_addToTLD"));
                JLabel jLabel = new JLabel();
                jLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TLDName_mnem").charAt(0));
                jLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_tldFile"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                this.customPanel.add((Component)jLabel, gridBagConstraints);
                this.tldTextField = new JTextField();
                this.tldTextField.setEditable(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(0, 12, 0, 0);
                this.customPanel.add((Component)this.tldTextField, gridBagConstraints);
                this.tldTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TLDFile"));
                jLabel.setLabelFor(this.tldTextField);
                this.browseButton1 = new JButton();
                this.browseButton1.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse1_Mnemonic").charAt(0));
                this.browseButton1.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse"));
                this.browseButton1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TargetChooserPanelGUI.this.browseButton1ActionPerformed(actionEvent);
                    }
                });
                this.browseButton1.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 6, 0, 0);
                this.customPanel.add((Component)this.browseButton1, gridBagConstraints);
                this.browseButton1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse"));
                this.tldCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        String string;
                        TargetChooserPanelGUI.this.tagNameTextField.setEditable(TargetChooserPanelGUI.this.tldCheckBox.isSelected());
                        TargetChooserPanelGUI.this.browseButton1.setEnabled(TargetChooserPanelGUI.this.tldCheckBox.isSelected());
                        if (TargetChooserPanelGUI.this.tldCheckBox.isSelected() && TargetChooserPanelGUI.this.tagName == null && (string = TargetChooserPanelGUI.this.documentNameTextField.getText().trim()).length() > 0) {
                            TargetChooserPanelGUI.this.tagNameTextField.setText(string);
                            TargetChooserPanelGUI.this.tagName = string;
                        }
                        targetChooserPanel.fireChange();
                    }
                });
                JLabel jLabel2 = new JLabel();
                jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagName_mnem").charAt(0));
                jLabel2.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_tagName"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(6, 0, 0, 0);
                this.customPanel.add((Component)jLabel2, gridBagConstraints);
                this.tagNameTextField = new JTextField();
                this.tagNameTextField.setEditable(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(6, 12, 0, 0);
                this.customPanel.add((Component)this.tagNameTextField, gridBagConstraints);
                this.tagNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagName"));
                jLabel2.setLabelFor(this.tagNameTextField);
                this.tagNameTextField.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        TargetChooserPanelGUI.this.tagName = TargetChooserPanelGUI.this.tagNameTextField.getText().trim();
                        targetChooserPanel.fireChange();
                    }
                });
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                this.customPanel.add((Component)new JPanel(), gridBagConstraints);
            }
        } else if (FileType.TAGLIBRARY.equals(fileType)) {
            this.uriTextField = new JTextField();
            this.uriTextField.setColumns(20);
            this.prefixTextField = new JTextField();
            this.prefixTextField.setColumns(5);
            this.uriLabel = new JLabel(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_URI"));
            this.uriLabel.setToolTipText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TTT_URI"));
            this.uriLabel.setLabelFor(this.uriTextField);
            this.uriLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_URI_mnem").charAt(0));
            this.uriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_URI"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(6, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.customPanel.add((Component)this.uriLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 6, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.customPanel.add((Component)this.uriTextField, gridBagConstraints);
            this.prefixLabel = new JLabel(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Prefix"));
            this.prefixLabel.setLabelFor(this.prefixTextField);
            this.prefixLabel.setToolTipText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TTT_prefix"));
            this.prefixLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Prefix_mnem").charAt(0));
            this.prefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Prefix"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            this.customPanel.add((Component)this.prefixLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.customPanel.add((Component)this.prefixTextField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.weightx = 2.0;
            this.customPanel.add((Component)new JPanel(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.customPanel.add((Component)new JPanel(), gridBagConstraints);
            this.uriTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    TargetChooserPanelGUI.this.uriWasTyped = true;
                    targetChooserPanel.fireChange();
                }
            });
            this.prefixTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    TargetChooserPanelGUI.this.prefixWasTyped = true;
                    targetChooserPanel.fireChange();
                }
            });
        }
        this.browseButton.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TITLE_name_location"));
        if (fileType.equals(FileType.JSP)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_JspName"));
            this.jspSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_JspSyntax"));
            this.jspSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP"));
            this.xmlSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_XmlSyntax"));
            this.xmlSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP_XML"));
            this.segmentBox.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_JspSegment"));
            this.segmentBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_JSP_segment"));
            this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP"));
        } else if (fileType.equals(FileType.TAG)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_TagFileName"));
            this.jspSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_TagFileJsp"));
            this.jspSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFile"));
            this.xmlSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_TagFileXml"));
            this.xmlSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileXml"));
            this.segmentBox.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_TagFileSegment"));
            this.segmentBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_TagFile_segment"));
            this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFile"));
        } else if (fileType.equals(FileType.TAGLIBRARY)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_TldName"));
        } else if (fileType.equals(FileType.HTML)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_HtmlName"));
            this.locationCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TargetChooserPanelGUI.this.changedUpdate(null);
                }
            });
        } else if (fileType.equals(FileType.CSS)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_CssName"));
            this.locationCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TargetChooserPanelGUI.this.changedUpdate(null);
                }
            });
        } else if (fileType.equals(FileType.XHTML)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_XHtmlName"));
            this.locationCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TargetChooserPanelGUI.this.changedUpdate(null);
                }
            });
        }
    }

    WebModule getWebModule() {
        return this.wm;
    }

    public void initValues(Project project, FileObject fileObject, FileObject fileObject2) {
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        if (this.folders != null && this.folders.length > 0) {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(this.getLocations(this.folders)));
            this.wm = WebModule.getWebModule((FileObject)this.folders[0].getRootFolder());
        } else {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(new Object[]{new LocationItem(project.getProjectDirectory())}));
        }
        String string = null;
        if (fileObject2 != null) {
            for (int i = 0; string == null && i < this.locationCB.getModel().getSize(); ++i) {
                FileObject fileObject3 = ((LocationItem)this.locationCB.getModel().getElementAt(i)).getFileObject();
                if (!fileObject2.equals(fileObject3) && !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject2)) continue;
                string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2);
                this.locationCB.getModel().setSelectedItem(this.locationCB.getModel().getElementAt(i));
                break;
            }
        }
        if (this.wm == null) {
            if (FileType.TAG.equals(this.fileType) && string != null && !string.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
                string = null;
            }
            if (FileType.TAGLIBRARY.equals(this.fileType) && string != null && !string.startsWith(TLD_IN_JAVALIB_FOLDER)) {
                string = null;
            }
        }
        if (FileType.TAG.equals(this.fileType)) {
            if (this.wm != null) {
                if (string == null || !string.startsWith(TAG_FILE_FOLDER)) {
                    this.folderTextField.setText("WEB-INF/tags/");
                } else {
                    this.folderTextField.setText(string == null ? "" : string);
                }
            } else if (string == null || !string.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
                this.folderTextField.setText("META-INF/tags/");
            } else {
                this.folderTextField.setText(string == null ? "" : string);
            }
        } else if (FileType.TAGLIBRARY.equals(this.fileType) && string == null) {
            if (this.wm == null) {
                this.folderTextField.setText("META-INF/");
            } else {
                this.folderTextField.setText("WEB-INF/tlds/");
            }
        } else {
            this.folderTextField.setText(string == null ? "" : string);
        }
        String string2 = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = string2.length() == 0 ? "" : "." + string2;
    }

    private Object[] getLocations(SourceGroup[] sourceGroupArray) {
        Object[] objectArray = new Object[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            objectArray[i] = new LocationItem(sourceGroupArray[i]);
        }
        return objectArray;
    }

    private String getRelativeSourcesFolder() {
        FileObject fileObject;
        FileObject fileObject2;
        String string = "";
        if (this.wm != null && (string = FileUtil.getRelativePath((FileObject)(fileObject2 = this.wm.getDocumentBase()), (FileObject)(fileObject = ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject()))) == null) {
            string = "";
        }
        return string.length() == 0 ? "" : string + "/";
    }

    public String getRelativeTargetFolder() {
        return this.getRelativeSourcesFolder() + this.getNormalizedFolder();
    }

    public String getNormalizedFolder() {
        int n;
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        string = string.replace('\\', '/');
        for (n = 0; n < string.length() && string.charAt(n) == '/'; ++n) {
        }
        if (n == string.length()) {
            return "";
        }
        string = string.substring(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        ArrayList arrayList = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            stringBuffer.append("/" + string2);
        }
        return stringBuffer.toString();
    }

    public String getTargetFolder() {
        return this.getTargetFile().getPath();
    }

    public File getTargetFile() {
        String string = this.getRelativeTargetFolder();
        if (string.length() == 0) {
            if (this.wm == null) {
                return FileUtil.toFile((FileObject)this.getLocationRoot());
            }
            return FileUtil.toFile((FileObject)this.wm.getDocumentBase());
        }
        if (this.wm == null) {
            return new File(FileUtil.toFile((FileObject)this.getLocationRoot()), string);
        }
        return new File(FileUtil.toFile((FileObject)this.wm.getDocumentBase()), string);
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.pathLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.customPanel = new JPanel();
        this.fillerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_FileName_mnem").charAt(0));
        this.nameLabel.setLabelFor(this.documentNameTextField);
        this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_JspName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_FileName"));
        this.projectLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Project_mnem").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Project"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Location_mnem").charAt(0));
        this.locationLabel.setLabelFor(this.locationCB);
        this.locationLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.locationCB, gridBagConstraints);
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Location"));
        this.folderLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Folder_mnem").charAt(0));
        this.folderLabel.setLabelFor(this.folderTextField);
        this.folderLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Folder"));
        this.browseButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"ACSD_Browse"));
        this.pathLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_CreatedFile_mnem").charAt(0));
        this.pathLabel.setLabelFor(this.fileTextField);
        this.pathLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.customPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPanel, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            Sources sources;
            FileObject fileObject = null;
            if (this.folders != null) {
                fileObject = BrowseFolders.showDialog(this.folders, DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            } else {
                sources = ProjectUtils.getSources((Project)this.project);
                fileObject = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            }
            if (fileObject != null && fileObject.isFolder()) {
                sources = ((LocationItem)this.locationCB.getSelectedItem()).getFileObject();
                this.folderTextField.setText(FileUtil.getRelativePath((FileObject)sources, (FileObject)fileObject));
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Object object;
        String string;
        File file = FileUtil.toFile((FileObject)((LocationItem)this.locationCB.getSelectedItem()).getFileObject());
        if (file != null) {
            string = this.documentNameTextField.getText().trim();
            if (string.length() == 0) {
                this.fileTextField.setText("");
            } else {
                object = new File(new File(file, this.folderTextField.getText().replace('/', File.separatorChar)), string + this.expectedExtension + (this.isSegment() ? "f" : (this.isXml() ? "x" : "")));
                this.fileTextField.setText(((File)object).getAbsolutePath());
            }
        } else {
            this.fileTextField.setText("");
        }
        if (FileType.TAGLIBRARY.equals(this.fileType)) {
            if (!this.uriWasTyped) {
                string = this.getNormalizedFolder();
                if (this.wm == null) {
                    object = this.getPackageNameInMetaInf();
                    this.uriTextField.setText((((String)object).length() > 0 ? (String)object + "." : "") + this.documentNameTextField.getText());
                } else {
                    this.uriTextField.setText((string.length() == 0 ? "" : "/" + this.getNormalizedFolder()) + "/" + this.documentNameTextField.getText().trim());
                }
            }
            if (!this.prefixWasTyped) {
                this.prefixTextField.setText(this.documentNameTextField.getText().trim().toLowerCase());
            }
        }
        this.wizardPanel.fireChange();
    }

    private String getPackageNameInMetaInf() {
        String string = this.getRelativeTargetFolder();
        if (string.startsWith(TLD_IN_JAVALIB_FOLDER)) {
            if ((string = string.substring(8)).length() == 0) {
                return "";
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
        }
        if (string.length() == 0) {
            return "";
        }
        string = string.replace('/', '.');
        return string;
    }

    private void checkBoxChanged(ItemEvent itemEvent) {
        if (this.fileType.equals(FileType.JSP)) {
            if (this.isSegment()) {
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_segment_XML"));
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_segment"));
                }
                String string = this.fileTextField.getText();
                if (string.endsWith("jspx")) {
                    this.fileTextField.setText(string.substring(0, string.length() - 1) + "f");
                } else if (string.endsWith("jsp")) {
                    this.fileTextField.setText(string + "f");
                }
            } else {
                String string = this.fileTextField.getText();
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP_XML"));
                    if (string.endsWith("jspf")) {
                        this.fileTextField.setText(string.substring(0, string.length() - 1) + "x");
                    } else if (string.endsWith("jsp")) {
                        this.fileTextField.setText(string + "x");
                    }
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP"));
                    if (string.endsWith("jspf") || string.endsWith("jspx")) {
                        this.fileTextField.setText(string.substring(0, string.length() - 1));
                    }
                }
            }
        } else if (this.fileType.equals(FileType.TAG)) {
            if (this.isSegment()) {
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileSegmentXml"));
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileSegment"));
                }
                String string = this.fileTextField.getText();
                if (string.endsWith("tagx")) {
                    this.fileTextField.setText(string.substring(0, string.length() - 1) + "f");
                } else if (string.endsWith("tag")) {
                    this.fileTextField.setText(string + "f");
                }
            } else {
                String string = this.fileTextField.getText();
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileXml"));
                    if (string.endsWith("tagf")) {
                        this.fileTextField.setText(string.substring(0, string.length() - 1) + "x");
                    } else if (string.endsWith("tag")) {
                        this.fileTextField.setText(string + "x");
                    }
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFile"));
                    if (string.endsWith("tagf") || string.endsWith("tagx")) {
                        this.fileTextField.setText(string.substring(0, string.length() - 1));
                    }
                }
            }
        }
        this.wizardPanel.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    boolean isXml() {
        if (this.xmlSyntaxButton == null) {
            return false;
        }
        return this.xmlSyntaxButton.isSelected();
    }

    boolean isSegment() {
        if (this.segmentBox == null) {
            return false;
        }
        return this.segmentBox.isSelected();
    }

    String getUri() {
        if (this.uriTextField == null) {
            return "";
        }
        return this.uriTextField.getText();
    }

    String getPrefix() {
        if (this.prefixTextField == null) {
            return "";
        }
        return this.prefixTextField.getText();
    }

    String getErrorMessage() {
        if (FileType.JSP.equals(this.fileType)) {
            if (this.isSegment() && !this.getNormalizedFolder().startsWith("WEB-INF/jspf")) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"NOTE_segment");
            }
        } else if (FileType.TAG.equals(this.fileType)) {
            this.tagFileValid = true;
            if (this.wm != null) {
                if (!this.getNormalizedFolder().startsWith(TAG_FILE_FOLDER)) {
                    this.tagFileValid = false;
                    return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_TagFile");
                }
            } else if (!this.getNormalizedFolder().startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
                this.tagFileValid = false;
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_TagFileInJavalib");
            }
        } else if (FileType.TAGLIBRARY.equals(this.fileType)) {
            if (this.wm == null) {
                if (!this.getNormalizedFolder().startsWith(TLD_IN_JAVALIB_FOLDER)) {
                    return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"NOTE_TLDInJavalib");
                }
            } else if (!this.getNormalizedFolder().startsWith("WEB-INF")) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"NOTE_TLDInWeb");
            }
            if (this.getUri().length() == 0) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_missingUri");
            }
            if (this.getPrefix().length() == 0) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_missingPrefix");
            }
        }
        return null;
    }

    boolean isPanelValid() {
        if (FileType.TAGLIBRARY.equals(this.fileType) && (this.getUri().length() == 0 || this.getPrefix().length() == 0)) {
            return false;
        }
        return !FileType.TAG.equals(this.fileType) || this.tagFileValid;
    }

    FileObject getLocationRoot() {
        return ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject();
    }

    private void browseButton1ActionPerformed(ActionEvent actionEvent) {
        Sources sources;
        FileObject fileObject = null;
        if (this.folders != null) {
            fileObject = BrowseFolders.showDialog(this.folders, TLDDataObject.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
        } else {
            sources = ProjectUtils.getSources((Project)this.project);
            fileObject = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
        }
        if (fileObject != null) {
            this.tldFo = fileObject;
            sources = Templates.getTargetFolder((WizardDescriptor)this.wizardPanel.getTemplateWizard());
            WebModule webModule = sources == null ? null : WebModule.getWebModule((FileObject)sources);
            this.tldTextField.setText(FileUtil.getRelativePath((FileObject)(webModule == null ? this.project.getProjectDirectory() : webModule.getDocumentBase()), (FileObject)fileObject));
            try {
                InputStream inputStream = this.tldFo.getInputStream();
                this.tagValues = Util.getTagValues(inputStream, new String[]{"tag", "tag-file"}, "name");
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "error", iOException);
            }
            catch (SAXException sAXException) {
                LOG.log(Level.FINE, "error", sAXException);
            }
            this.wizardPanel.fireChange();
        }
    }

    boolean isTldCheckBoxSelected() {
        return this.tldCheckBox.isSelected();
    }

    String getTagName() {
        return this.tagName;
    }

    FileObject getTldFileObject() {
        return this.tldFo;
    }

    static boolean isTagNameEmpty(String string) {
        if (string == null) {
            return true;
        }
        return "".equals(string);
    }

    static boolean isValidTagName(String string) {
        if (string == null) {
            return false;
        }
        return XMLChar.isValidNCName((String)string);
    }

    boolean tagNameExists(String string) {
        return this.tagValues != null && this.tagValues.contains(string);
    }

    public String getCreatedFilePath() {
        return this.fileTextField.getText();
    }

    public static class LocationItem {
        FileObject fo;
        SourceGroup group;

        public LocationItem(FileObject fileObject) {
            this.fo = fileObject;
        }

        public LocationItem(SourceGroup sourceGroup) {
            this.fo = sourceGroup.getRootFolder();
            this.group = sourceGroup;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public String toString() {
            return this.group == null ? this.fo.getName() : this.group.getDisplayName();
        }
    }
}

