/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.xml.text.navigator.HTMLTextEncoder;
import org.netbeans.modules.xml.text.navigator.NavigatorContent;
import org.openide.ErrorManager;

public class TreeNodeAdapter
implements TreeNode,
DocumentElementListener {
    private DocumentElement de;
    private DefaultTreeModel tm;
    private TreeNode parent;
    private JTree tree;
    private ArrayList children = null;
    private ArrayList textElements = new ArrayList();
    private String textContent = EMPTY_STRING;
    private boolean containsError = false;
    private int childrenErrorCount = 0;
    private static final String EMPTY_STRING = new String("");
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final int ATTRIBS_MAX_LEN = 30;
    private static final int TEXT_MAX_LEN = 30;

    public TreeNodeAdapter(DocumentElement documentElement, DefaultTreeModel defaultTreeModel, JTree jTree, TreeNode treeNode) {
        this.de = documentElement;
        this.tm = defaultTreeModel;
        this.tree = jTree;
        this.parent = treeNode;
    }

    private String getDocumentContent() {
        this.checkChildrenAdapters();
        this.checkDocumentContent();
        return this.textContent;
    }

    public Enumeration children() {
        this.checkChildrenAdapters();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        this.checkChildrenAdapters();
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        this.checkChildrenAdapters();
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        this.checkChildrenAdapters();
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DocumentElement getDocumentElement() {
        return this.de;
    }

    private TreeNodeAdapter getChildTreeNode(DocumentElement documentElement) {
        this.checkChildrenAdapters();
        for (TreeNodeAdapter treeNodeAdapter : this.children) {
            if (!treeNodeAdapter.getDocumentElement().equals((Object)documentElement)) continue;
            return treeNodeAdapter;
        }
        return null;
    }

    public boolean containsError() {
        this.checkChildrenAdapters();
        return this.containsError;
    }

    public int getChildrenErrorCount() {
        this.checkChildrenAdapters();
        return this.childrenErrorCount;
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean bl) {
        if (this.de.getType().equals("tag") || this.de.getType().equals("empty_tag")) {
            String string;
            String string2 = "";
            AttributeSet attributeSet = this.getDocumentElement().getAttributes();
            if (attributeSet.getAttributeCount() > 0) {
                string = this.getAttribsText();
                if (NavigatorContent.showAttributes) {
                    string2 = string.length() > 30 ? string.substring(0, 30) + "..." : string.toString();
                }
            }
            string = "";
            String string3 = this.getDocumentContent();
            if (NavigatorContent.showContent) {
                string = string3.length() > 30 ? string3.substring(0, 30) + "..." : string3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bl ? "<html>" : "");
            stringBuffer.append(bl && this.containsError ? "<font color=FF0000><b>" : "");
            stringBuffer.append(this.getDocumentElement().getName());
            stringBuffer.append(bl && this.containsError ? "</b></font>" : "");
            stringBuffer.append(bl ? "<font color=888888>" : "");
            if (string2.trim().length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
            }
            stringBuffer.append(bl ? "</font>" : "");
            if (string.trim().length() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(HTMLTextEncoder.encodeHTMLText(string));
                stringBuffer.append(")");
            }
            stringBuffer.append(bl ? "</html>" : "");
            return stringBuffer.toString();
        }
        if (this.de.getType().equals("pi")) {
            String string = this.getPIText();
            string = string.length() > 30 ? string.substring(0, 30) + "..." : string;
            return string;
        }
        if (this.de.getType().equals("doctype")) {
            String string = this.getDoctypeText();
            String string4 = string.length() > 30 ? string.substring(0, 30) + "..." : string;
            return string4;
        }
        if (this.de.getType().equals("cdata")) {
            String string = this.getCDATAText();
            String string5 = string.length() > 30 ? string.substring(0, 30) + "..." : string;
            return string5;
        }
        return this.de.getName() + " [unknown content]";
    }

    public String getToolTipText() {
        if (this.de.getType().equals("tag") || this.de.getType().equals("empty_tag")) {
            return this.getAttribsText() + " " + this.getDocumentContent();
        }
        if (this.de.getType().equals("pi")) {
            return this.getPIText();
        }
        if (this.de.getType().equals("doctype")) {
            return this.getDoctypeText();
        }
        if (this.de.getType().equals("cdata")) {
            return this.getCDATAText();
        }
        return "";
    }

    private String getPIText() {
        String string = null;
        try {
            string = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            int n = "<?".length() + this.de.getName().length();
            if (n > string.length() - 1) {
                n = string.length() - 1;
            }
            if (string.length() > 0) {
                string = string.substring(n, string.length() - 1).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        return string;
    }

    private String getDoctypeText() {
        String string = "???";
        try {
            string = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            if (string.length() > 0) {
                string = string.substring("<!DOCTYPE ".length() + this.de.getName().length(), string.length() - 1).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        return string;
    }

    private String getCDATAText() {
        String string = "???";
        try {
            string = this.de.getDocumentModel().getDocument().getText(this.de.getStartOffset(), this.de.getEndOffset() - this.de.getStartOffset());
            if (string.length() > 0) {
                string = string.substring("<![CDATA[".length(), string.indexOf("]]")).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            return "???";
        }
        return string;
    }

    public void childrenReordered(DocumentElementEvent documentElementEvent) {
        this.tm.nodeStructureChanged(this);
    }

    public String getAttribsText() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = this.getDocumentElement().getAttributes().getAttributeNames();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.getDocumentElement().getAttributes().getAttribute(string);
                stringBuffer.append(string);
                stringBuffer.append("=\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public void elementAdded(DocumentElementEvent documentElementEvent) {
        DocumentElement documentElement = documentElementEvent.getChangedChild();
        if (debug) {
            System.out.println(">>> +EVENT called on " + this.hashCode() + " - " + this.de + ": element " + documentElement + " is going to be added");
        }
        if (documentElement.getType().equals("content")) {
            this.textElements.add(new TextElementWrapper(documentElement));
            this.childTextElementChanged();
        } else if (documentElement.getType().equals("error")) {
            this.markNodeAsError(this);
        } else if (!documentElement.getType().equals("comment")) {
            TreeNodeAdapter treeNodeAdapter = new TreeNodeAdapter(documentElement, this.tm, this.tree, this);
            int n = this.getVisibleChildIndex(documentElement);
            if (this.getChildTreeNode(documentElement) == null) {
                if (this.children.size() < n) {
                    this.tm.nodeStructureChanged(this);
                } else {
                    this.children.add(n, treeNodeAdapter);
                    int n2 = this.getIndex(treeNodeAdapter);
                    this.tm.nodesWereInserted(this, new int[]{n2});
                }
            }
            if (debug) {
                System.out.println("<<<EVENT finished (node " + treeNodeAdapter + " added)");
            }
        }
        if (this.de.equals((Object)this.de.getDocumentModel().getRootElement())) {
            this.tree.expandPath(new TreePath(this));
        }
    }

    private void debugError(DocumentElementEvent documentElementEvent) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("An inconsistency between XML navigator and XML DocumentModel occured when adding a new element in the XML DocumentModel! Please report the problem and add following debug messages to the issue along with the XML document you are editing.");
        stringBuffer.append("Debug for Node " + this + ":\n");
        stringBuffer.append("Children of current node:\n");
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            object = (TreeNodeAdapter)iterator.next();
            stringBuffer.append(((TreeNodeAdapter)object).toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nChildren of DocumentElement (" + this.getDocumentElement() + ") wrapped by the current node:\n");
        object = this.getDocumentElement().getChildren().iterator();
        while (iterator.hasNext()) {
            DocumentElement documentElement = (DocumentElement)iterator.next();
            stringBuffer.append(documentElement.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("------------");
        ErrorManager.getDefault().log(1, stringBuffer.toString());
    }

    private void markNodeAsError(TreeNodeAdapter treeNodeAdapter) {
        treeNodeAdapter.containsError = true;
        TreeNodeAdapter treeNodeAdapter2 = treeNodeAdapter;
        this.tm.nodeChanged(treeNodeAdapter);
        while ((treeNodeAdapter2 = (TreeNodeAdapter)treeNodeAdapter2.getParent()) != null) {
            if (treeNodeAdapter2.getParent() != null) {
                ++treeNodeAdapter2.childrenErrorCount;
            }
            this.tm.nodeChanged(treeNodeAdapter2);
        }
    }

    private int getVisibleChildIndex(DocumentElement documentElement) {
        int n = 0;
        for (DocumentElement documentElement2 : this.getDocumentElement().getChildren()) {
            if (documentElement2.equals((Object)documentElement)) {
                return n;
            }
            if (documentElement2.getType().equals("content") || documentElement2.getType().equals("error") || documentElement2.getType().equals("comment")) continue;
            ++n;
        }
        return -1;
    }

    public void elementRemoved(DocumentElementEvent documentElementEvent) {
        DocumentElement documentElement = documentElementEvent.getChangedChild();
        if (debug) {
            System.out.println(">>> -EVENT on " + this.hashCode() + " - " + this.de + ": element " + documentElement + " is going to be removed ");
        }
        if (documentElement.getType().equals("content")) {
            if (debug) {
                System.out.println(">>> removing CONTENT element");
            }
            Iterator iterator = this.textElements.iterator();
            ArrayList<TextElementWrapper> arrayList = new ArrayList<TextElementWrapper>();
            while (iterator.hasNext()) {
                TextElementWrapper textElementWrapper = (TextElementWrapper)iterator.next();
                if (!documentElement.equals((Object)textElementWrapper.getDocumentElement())) continue;
                arrayList.add(textElementWrapper);
            }
            this.textElements.removeAll(arrayList);
            this.childTextElementChanged();
        } else if (documentElement.getType().equals("error")) {
            this.unmarkNodeAsError(this);
        } else if (!documentElement.getType().equals("comment")) {
            if (debug) {
                System.out.println(">>> removing tag element");
            }
            TreeNodeAdapter treeNodeAdapter = this.getChildTreeNode(documentElement);
            int n = this.getIndex(treeNodeAdapter);
            if (treeNodeAdapter != null) {
                this.children.remove(treeNodeAdapter);
                this.tm.nodesWereRemoved(this, new int[]{n}, new Object[]{treeNodeAdapter});
            } else if (debug) {
                System.out.println("Warning: TreeNode for removed element doesn't exist!!!");
            }
        }
        if (debug) {
            System.out.println("<<<EVENT finished (node removed)");
        }
    }

    private void unmarkNodeAsError(TreeNodeAdapter treeNodeAdapter) {
        treeNodeAdapter.containsError = false;
        TreeNodeAdapter treeNodeAdapter2 = treeNodeAdapter;
        this.tm.nodeChanged(treeNodeAdapter);
        while ((treeNodeAdapter2 = (TreeNodeAdapter)treeNodeAdapter2.getParent()) != null) {
            if (treeNodeAdapter2.getParent() != null) {
                --treeNodeAdapter2.childrenErrorCount;
            }
            this.tm.nodeChanged(treeNodeAdapter2);
        }
    }

    public void attributesChanged(DocumentElementEvent documentElementEvent) {
        if (debug) {
            System.out.println("Attributes of treenode " + this + " has changed.");
        }
        this.tm.nodeChanged(this);
    }

    public void contentChanged(DocumentElementEvent documentElementEvent) {
        if (debug) {
            System.out.println("treenode " + this + " changed.");
        }
        this.tm.nodeChanged(this);
    }

    private synchronized void checkChildrenAdapters() {
        if (this.children == null) {
            this.de.addDocumentElementListener((DocumentElementListener)this);
            this.children = new ArrayList();
            Iterator iterator = this.de.getChildren().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                DocumentElement documentElement = (DocumentElement)iterator.next();
                if (documentElement.getType().equals("content")) {
                    this.textElements.add(new TextElementWrapper(documentElement));
                    bl = true;
                    continue;
                }
                if (documentElement.getType().equals("error")) {
                    this.markNodeAsError(this);
                    continue;
                }
                if (documentElement.getType().equals("comment") || this.getChildTreeNode(documentElement) != null) continue;
                TreeNodeAdapter treeNodeAdapter = new TreeNodeAdapter(documentElement, this.tm, this.tree, this);
                this.children.add(treeNodeAdapter);
            }
            if (bl) {
                this.childTextElementChanged();
            }
        }
    }

    private void childTextElementChanged() {
        this.textContent = null;
        this.tm.nodeChanged(this);
    }

    private void checkDocumentContent() {
        if (this.textContent == null) {
            Iterator iterator = this.getDocumentElement().getChildren().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                DocumentElement documentElement = (DocumentElement)iterator.next();
                if (!documentElement.getType().equals("content")) continue;
                try {
                    int n = documentElement.getEndOffset() - documentElement.getStartOffset() + 1;
                    n = n > documentElement.getDocument().getLength() ? documentElement.getDocument().getLength() : n;
                    stringBuffer.append(documentElement.getDocument().getText(documentElement.getStartOffset(), n).trim());
                }
                catch (BadLocationException badLocationException) {
                    stringBuffer.append("???");
                }
            }
            this.textContent = stringBuffer.length() == 0 ? EMPTY_STRING : stringBuffer.toString();
            this.tm.nodeChanged(this);
        }
    }

    private final class TextElementWrapper
    implements DocumentElementListener {
        private DocumentElement de;

        public TextElementWrapper(DocumentElement documentElement) {
            this.de = documentElement;
            documentElement.addDocumentElementListener((DocumentElementListener)this);
        }

        public DocumentElement getDocumentElement() {
            return this.de;
        }

        public void contentChanged(DocumentElementEvent documentElementEvent) {
            TreeNodeAdapter.this.childTextElementChanged();
        }

        public void elementAdded(DocumentElementEvent documentElementEvent) {
            System.err.println("????? a child node added into a text element!!!!");
        }

        public void elementRemoved(DocumentElementEvent documentElementEvent) {
        }

        public void childrenReordered(DocumentElementEvent documentElementEvent) {
        }

        public void attributesChanged(DocumentElementEvent documentElementEvent) {
        }
    }
}

