/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import antlr.ASTVisitor;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.FoldingParser;
import org.netbeans.modules.cnd.modelimpl.cache.CacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.trace.APTWalkerTest;
import org.netbeans.modules.cnd.modelimpl.trace.ASTFrameEx;
import org.netbeans.modules.cnd.modelimpl.trace.Cache;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModelBase;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceModel
extends TraceModelBase {
    private static final int APT_REPEAT_TEST = Integer.getInteger("apt.repeat.test", 3);
    private Cache cache;
    private static CsmTracer tracer = new CsmTracer(false);
    private boolean showAstWindow = false;
    private boolean dumpAst = false;
    private boolean dumpModel = false;
    private boolean dumpLib = false;
    private boolean dumpFileOnly = false;
    private boolean showTime = false;
    private boolean writeAst = false;
    private boolean readAst = false;
    private boolean useZip = false;
    private boolean testLibProject = false;
    private boolean deep = true;
    private boolean showMemoryUsage = false;
    private boolean testUniqueName = false;
    private boolean testAPT = false;
    private boolean testAPTLexer = false;
    private boolean testAPTDriver = false;
    private boolean testAPTWalkerVisit = false;
    private boolean testAPTWalkerGetStream = false;
    private boolean testAPTWalkerGetExpandedStream = false;
    private boolean testAPTWalkerGetFilteredStream = false;
    private boolean testAPTParser = false;
    private boolean breakAfterAPT = false;
    private boolean stopBeforeAll = false;
    private boolean stopAfterAll = false;
    private boolean printTokens = false;
    private boolean dumpModelAfterCleaningCache = false;
    private int repeatCount = 1;
    private boolean dumpStatistics = false;
    private static final int DEFAULT_TRACEMODEL_STATISTICS_LEVEL = 1;
    private String dumpFile = null;
    private String dumpDir = null;
    private static final String statPostfix = ".stat";
    private boolean enableCache = false;
    private boolean testCache = false;
    private boolean dumpPPState = false;
    private boolean listFilesAtEnd = false;
    private boolean testRawPerformance = false;
    private boolean printUserFileList = false;
    private boolean quiet = false;
    private boolean memBySize = false;
    private boolean doCleanRepository = Boolean.getBoolean("cnd.clean.repository");
    private boolean testFolding = false;
    private Map<String, Long> cacheTimes = new HashMap<String, Long>();
    private int lap = 0;
    private final Map<CsmFile, APTPreprocHandler> states = new HashMap<CsmFile, APTPreprocHandler>();
    FileImpl.Hook hook = new FileImpl.Hook(){

        public void parsingFinished(CsmFile csmFile, APTPreprocHandler aPTPreprocHandler) {
            TraceModel.this.states.put(csmFile, aPTPreprocHandler);
        }
    };
    private APTSystemStorage sysAPTData = APTSystemStorage.getDefault();
    private static String firstFile = null;
    long minDriver = Long.MAX_VALUE;
    long maxDriver = Long.MIN_VALUE;
    private static Comparator<CppFoldRecord> FOLD_COMPARATOR = new Comparator<CppFoldRecord>(){

        @Override
        public int compare(CppFoldRecord cppFoldRecord, CppFoldRecord cppFoldRecord2) {
            int n;
            int n2 = cppFoldRecord.getStartLine();
            if (n2 == (n = cppFoldRecord2.getStartLine())) {
                return cppFoldRecord.getStartOffset() - cppFoldRecord2.getStartOffset();
            }
            return n2 - n;
        }
    };

    public static void main(String[] stringArray) {
        new TraceModel().test(stringArray);
        if (TraceFlags.USE_AST_CACHE) {
            CacheManager.getInstance().close();
        } else {
            APTDriver.getInstance().close();
        }
    }

    public void setDumpModel(boolean bl) {
        this.dumpModel = bl;
    }

    public void setDumpPPState(boolean bl) {
        this.dumpPPState = bl;
    }

    public TraceModel() {
        FileImpl.setHook(this.hook);
    }

    @Override
    protected TraceModelBase.ProcessFlagResult processFlag(char c, String string) {
        TraceModelBase.ProcessFlagResult processFlagResult = super.processFlag(c, string);
        if (processFlagResult != TraceModelBase.ProcessFlagResult.NONE_PROCESSED) {
            return processFlagResult;
        }
        processFlagResult = TraceModelBase.ProcessFlagResult.CHAR_PROCESSED;
        switch (c) {
            case 'n': {
                this.deep = false;
                break;
            }
            case 'e': {
                System.setErr(System.out);
                break;
            }
            case 'w': {
                this.showAstWindow = true;
                break;
            }
            case 'a': {
                this.dumpAst = true;
                break;
            }
            case 'm': {
                this.dumpModel = true;
                this.dumpFileOnly = false;
                break;
            }
            case 'M': {
                this.showMemoryUsage = true;
                break;
            }
            case 'u': {
                this.testUniqueName = true;
                break;
            }
            case 'f': {
                if (this.dumpModel) break;
                this.dumpModel = true;
                this.dumpFileOnly = true;
                break;
            }
            case 't': {
                this.showTime = true;
                break;
            }
            case 'W': {
                this.writeAst = true;
                break;
            }
            case 'R': {
                this.readAst = true;
                break;
            }
            case 'Z': {
                this.useZip = true;
                break;
            }
            case 'C': {
                this.enableCache = true;
                break;
            }
            case 'l': {
                this.testLibProject = true;
                break;
            }
            case 'c': {
                this.testCache = true;
                break;
            }
            case 'p': {
                this.dumpPPState = true;
                break;
            }
            case 'S': {
                this.dumpStatistics = true;
                if (string.length() <= 0) break;
                File file = new File(string);
                file.mkdirs();
                if (!file.isDirectory()) {
                    TraceModel.print("Parameter -S" + string + " does not specify valid directory");
                } else {
                    this.dumpDir = file.getAbsolutePath();
                }
                processFlagResult = TraceModelBase.ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            case 's': {
                this.dumpStatistics = true;
                if (string.length() <= 0) break;
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                try {
                    if (file.getParentFile() == null) break;
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    this.dumpFile = file.getAbsolutePath();
                    processFlagResult = TraceModelBase.ProcessFlagResult.ALL_PROCESSED;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
            }
            case 'A': {
                this.testAPT = true;
                this.testAPTWalkerVisit = true;
                this.testAPTWalkerGetStream = true;
                this.testAPTWalkerGetExpandedStream = true;
                this.testAPTWalkerGetFilteredStream = true;
                this.testAPTLexer = true;
                this.breakAfterAPT = true;
                this.testAPTDriver = true;
                break;
            }
            case 'B': {
                this.testAPTLexer = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'o': {
                this.printTokens = true;
                break;
            }
            case 'v': {
                this.testAPTWalkerVisit = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'g': {
                this.testAPTWalkerGetStream = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'G': {
                this.testAPTWalkerGetExpandedStream = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'F': {
                this.testAPTWalkerGetFilteredStream = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'd': {
                this.testAPTDriver = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'h': {
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'H': {
                this.testAPTParser = true;
                this.testAPT = true;
                this.breakAfterAPT = true;
                break;
            }
            case 'O': {
                this.stopBeforeAll = true;
                this.stopAfterAll = true;
                break;
            }
            case 'q': {
                this.quiet = true;
                break;
            }
            default: {
                processFlagResult = TraceModelBase.ProcessFlagResult.NONE_PROCESSED;
            }
        }
        return processFlagResult;
    }

    @Override
    protected boolean processFlag(String string) {
        if (super.processFlag(string)) {
            return true;
        }
        if ("dumplib".equals(string)) {
            this.dumpLib = true;
        } else if ("listfiles".equals(string)) {
            this.listFilesAtEnd = true;
        } else if ("raw".equals(string)) {
            this.testRawPerformance = true;
        } else if ("listfiles".equals(string)) {
            this.printUserFileList = true;
        } else if ("mbs".equals(string)) {
            this.memBySize = true;
        } else if ("cleanrepository".equals(string)) {
            this.doCleanRepository = true;
        } else if ("folding".equals(string)) {
            this.testFolding = true;
        } else if ("clean4dump".equals(string)) {
            this.dumpModelAfterCleaningCache = true;
        } else if ("repeat".equals(string) || string.startsWith("repeat:")) {
            int n = "repeat".length();
            this.repeatCount = string.length() == n ? 2 : Integer.parseInt(string.substring(n + 1));
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(String[] stringArray) {
        try {
            this.processArguments(stringArray);
            this.doTest();
        }
        catch (Error error) {
            System.err.printf("\n", new Object[0]);
            DiagnosticExceptoins.register(error);
            return;
        }
        finally {
            this.getModel().shutdown();
        }
    }

    void doTest() {
        if (this.repeatCount > 1) {
            for (int i = 0; i < this.repeatCount; ++i) {
                TraceModel.print("\n\n==================== Pass " + i + "====================\n");
                this.doTest2();
                this.resetProject();
            }
        } else {
            this.doTest2();
        }
    }

    /*
     * WARNING - void declaration
     */
    void doTest2() {
        Object object;
        if (this.stopBeforeAll) {
            this.waitAnyKey();
        }
        if (this.writeAst || this.readAst) {
            try {
                this.cache = new Cache(this.useZip);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
                return;
            }
        }
        if (this.writeAst && this.readAst) {
            TraceModel.print("Impossible options combination: both writing and reading AST\n");
            return;
        }
        if (this.useZip && !this.writeAst && !this.readAst) {
            TraceModel.print("Impossible options combination: using ZIP format, but neither writing nor reading AST. Ignoring ZIP format.\n");
            this.useZip = false;
        }
        if (this.testCache) {
            this.enableCache = true;
        } else if (this.dumpStatistics) {
            if (this.dumpFile == null && this.dumpDir == null) {
                TraceModel.print("Turning OFF statistics as neither global file nor directory is specified");
                this.dumpStatistics = false;
            } else {
                TraceModel.print("Dumping Statistics is ON");
                if (Diagnostic.getStatisticsLevel() == 0) {
                    Diagnostic.setStatisticsLevel(1);
                }
                if (this.dumpFile != null) {
                    TraceModel.print("Global Dump file is " + this.dumpFile);
                }
                if (this.dumpDir != null) {
                    TraceModel.print("Dump directory for per file statistics is " + this.dumpDir);
                }
            }
        }
        if (this.testLibProject) {
            this.testLibProject();
        }
        if (this.printUserFileList) {
            TraceModel.print("Processing files:\n");
            for (NativeFileItem nativeFileItem : this.getFileItems()) {
                this.print(nativeFileItem.getFile().getAbsolutePath() + ' ', false);
            }
            TraceModel.print("");
        }
        long l = 0L;
        if (this.showMemoryUsage) {
            l = this.usedMemory();
        }
        long l2 = System.currentTimeMillis();
        TestResult testResult = this.test();
        testResult.time = System.currentTimeMillis() - l2;
        if (this.testRawPerformance) {
            TraceModel.print("Take one finished.");
            TraceModel.print("Total parsing time " + testResult.time + " ms");
            this.calculateAverageLPS(testResult, true);
            TraceModel.print("Lines count " + testResult.lineCount);
            TraceModel.print("Average LPS " + testResult.getLPS());
            if (this.showMemoryUsage) {
                this.showMemoryUsage(l);
            }
            TraceModel.print("\nTesting raw performance: parsing project, take two\n");
            this.resetProject();
            if (this.stopBeforeAll) {
                this.waitAnyKey();
            }
            l2 = System.currentTimeMillis();
            testResult = this.test();
            testResult.time = System.currentTimeMillis() - l2;
        }
        if (this.dumpLib) {
            object = this.getProject().getLibraries().iterator();
            while (object.hasNext()) {
                CsmProject csmProject = object.next();
                tracer.dumpModel(csmProject);
            }
        }
        if (this.isShowTime()) {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < CPPParserEx.MAX_GUESS_IDX; ++n2) {
                if (CPPParserEx.guessingNames[n2] == null || (n = CPPParserEx.guessingNames[n2].length()) <= n3) continue;
                n3 = n;
            }
            n2 = 0;
            for (n = 0; n < CPPParserEx.MAX_GUESS_IDX; ++n) {
                if (CPPParserEx.guessingCount[n] == 0L) continue;
                n2 = 1;
                break;
            }
            if (this.listFilesAtEnd) {
                TraceModel.print("\n========== User project files ==========");
                ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.getProject().getAllFiles().size());
                for (CsmFile object2 : this.getProject().getAllFiles()) {
                    arrayList.add(object2.getAbsolutePath());
                }
                Collections.sort(arrayList, CharSequenceKey.Comparator);
                Iterator<Object> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    TraceModel.print((String)iterator.next());
                }
                TraceModel.print("\n========== Library files ==========");
                arrayList = new ArrayList();
                for (ProjectBase projectBase : this.getProject().getLibraries()) {
                    for (CsmFile csmFile : projectBase.getAllFiles()) {
                        arrayList.add(csmFile.getAbsolutePath());
                    }
                }
                Collections.sort(arrayList, CharSequenceKey.Comparator);
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    TraceModel.print((String)iterator.next());
                }
            }
            if (n2 != 0) {
                void var10_23;
                TraceModel.print("\nGuessing statistics:");
                TraceModel.print("Id\t" + this.padR("Rule:Line", n3) + "\tTime" + "\tCount" + "\tFail" + "\tSuccess, %");
                long l3 = 0L;
                boolean bl = false;
                while (var10_23 < CPPParserEx.MAX_GUESS_IDX) {
                    l3 += CPPParserEx.guessingTimes[var10_23];
                    double d = 0.0;
                    if (CPPParserEx.guessingCount[var10_23] != 0L) {
                        d = (1.0 - (double)CPPParserEx.guessingFailures[var10_23] / (double)CPPParserEx.guessingCount[var10_23]) * 100.0;
                    }
                    TraceModel.print("" + (int)var10_23 + "\t" + this.padR(CPPParserEx.guessingNames[var10_23], n3) + "\t" + CPPParserEx.guessingTimes[var10_23] + "\t" + CPPParserEx.guessingCount[var10_23] + "\t" + CPPParserEx.guessingFailures[var10_23] + "\t" + (int)d);
                    ++var10_23;
                }
                TraceModel.print("\nTotal guessing time: " + l3 + "ms " + "(" + (testResult.getTime() != 0L ? l3 * 100L / testResult.getTime() : -1L) + "% of total parse time)");
            }
        }
        if (this.isShowTime() || this.testRawPerformance) {
            TraceModel.print("Total parsing time: " + testResult.getTime() + "ms");
            this.calculateAverageLPS(testResult, !this.testRawPerformance);
            TraceModel.print("Lines count " + testResult.lineCount);
            object = this.testRawPerformance ? "Raw performance (average LPS): " : "Average LPS: ";
            TraceModel.print((String)object + testResult.getLPS());
            int n = this.countUserFiles();
            int n4 = this.countSystemHeaders();
            TraceModel.print("" + n + " user files");
            TraceModel.print("" + n4 + " system headers");
        }
        if (this.showMemoryUsage) {
            this.showMemoryUsage(l);
        }
        if (this.isShowTime() || this.showMemoryUsage || this.dumpModel || this.dumpFileOnly || this.dumpPPState) {
            TraceModel.print("\n");
        }
        if (this.dumpStatistics && this.dumpFile != null) {
            try {
                Diagnostic.dumpUnresolvedStatistics(this.dumpFile, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                DiagnosticExceptoins.register(fileNotFoundException);
            }
        }
        if (TraceFlags.CLEAN_MACROS_AFTER_PARSE && (object = ProjectBase.testGetRestoredFiles()) != null) {
            System.err.println("the number of restored files " + object.size());
            for (int i = 0; i < object.size(); ++i) {
                System.err.println("#" + i + ":" + object.get(i));
            }
        }
        if (this.dumpModelAfterCleaningCache) {
            this.anyKey("Press any key to clean repository:");
            RepositoryAccessor.getRepository().debugClear();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            this.anyKey("Press any key to dump model:");
            if (!this.dumpFileOnly) {
                tracer.dumpModel((CsmProject)this.getProject());
            }
        }
        if (this.stopAfterAll) {
            System.gc();
            this.anyKey("Press any key to finish:");
        }
    }

    private void anyKey(String string) {
        System.err.println(string);
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
        }
    }

    private void showMemoryUsage(long l) {
        long l2 = this.usedMemory();
        long l3 = l2 - l;
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMinimumIntegerDigits(6);
        TraceModel.print("Amount of memory used" + this.getLap() + ": " + numberFormat.format(l3 / 1024L) + " Kb");
        if (this.memBySize) {
            TestResult testResult = new TestResult();
            TestResult testResult2 = new TestResult();
            this.calculateAverageLPS(testResult, true);
            this.calculateAverageLPS(testResult2, false);
            TraceModel.print("User code lines:  " + testResult2.lineCount);
            TraceModel.print("Total lines (including all headers):  " + testResult.lineCount);
            TraceModel.print("Memory usage per (user) line " + this.getLap() + '\t' + numberFormat.format(l3 / testResult2.lineCount) + " bytes per line");
            TraceModel.print("Memory usage per (total) line" + this.getLap() + '\t' + numberFormat.format(l3 / testResult.lineCount) + " bytes per line");
        }
    }

    private void waitAnyKey() {
        System.out.println("Press any key to continue:");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
        }
    }

    private TestResult test() {
        ++this.lap;
        TestResult testResult = new TestResult();
        for (NativeFileItem nativeFileItem : this.getFileItems()) {
            try {
                if (!this.testFolding) {
                    TestResult testResult2 = this.test(nativeFileItem);
                    testResult.accumulate(testResult2);
                    continue;
                }
                this.testFolding(nativeFileItem.getFile());
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
        return testResult;
    }

    private String getLap() {
        return " (lap " + this.lap + ") ";
    }

    private String padR(String string, int n) {
        if (string == null) {
            string = "";
        }
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.setLength(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuilder.setCharAt(i, ' ');
        }
        return stringBuilder.toString();
    }

    private void waitProjectParsed(boolean bl) {
        boolean bl2 = true;
        while (bl2) {
            bl2 = this.waitParsed(this.getProject(), bl);
            if (this.getProject().getLibraries().size() <= 0) continue;
            if (bl) {
                System.err.println("checking libraries");
            }
            for (CsmProject csmProject : this.getProject().getLibraries()) {
                if (bl) {
                    System.err.println("checking library " + csmProject.getName());
                }
                bl2 |= this.waitParsed((ProjectBase)csmProject, bl);
            }
        }
    }

    private boolean waitParsed(ProjectBase projectBase, boolean bl) {
        boolean bl2 = false;
        projectBase.waitParse();
        return bl2;
    }

    private void sleep(int n, String string) {
        System.err.printf("Sleeping: %s\n", string);
        this.sleep(n);
        System.err.printf("Awoke (%s)\n", string);
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private APTIncludeHandler getIncludeHandler(File file) {
        List list = this.sysAPTData.getIncludes("TraceModelSysIncludes", this.getSystemIncludes());
        List<String> list2 = this.getQuoteIncludePaths();
        if (this.isPathsRelCurFile()) {
            list2 = new ArrayList<String>(this.getQuoteIncludePaths().size());
            for (String string : this.getQuoteIncludePaths()) {
                if (!new File(string).isAbsolute()) {
                    File file2 = file.getParentFile();
                    File file3 = new File(file2, string);
                    string = file3.getAbsolutePath();
                }
                list2.add(string);
            }
        }
        StartEntry startEntry = new StartEntry(file.getAbsolutePath(), RepositoryUtils.UIDtoKey(this.getProject().getUID()));
        return APTHandlersSupport.createIncludeHandler((StartEntry)startEntry, (List)list, list2);
    }

    private APTMacroMap getMacroMap(File file) {
        APTMacroMap aPTMacroMap = APTHandlersSupport.createMacroMap((APTMacroMap)this.getSysMap(file), this.getMacros());
        return aPTMacroMap;
    }

    private APTPreprocHandler getPreprocHandler(File file) {
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)this.getMacroMap(file), (APTIncludeHandler)this.getIncludeHandler(file), (!file.getPath().endsWith(".h") ? 1 : 0) != 0);
        return aPTPreprocHandler;
    }

    private APTMacroMap getSysMap(File file) {
        APTMacroMap aPTMacroMap = this.sysAPTData.getMacroMap("TraceModelSysMacros", this.getSysMacros());
        return aPTMacroMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long testAPTLexer(File file, boolean bl) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException, ClassNotFoundException {
        TraceModel.print("Testing APT lexer:");
        long l = System.currentTimeMillis();
        Reader reader = null;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file), TraceFlags.BUF_SIZE);
            reader = new InputStreamReader(inputStream, FileEncodingQuery.getDefaultEncoding());
            TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream((String)file.getAbsolutePath(), (Reader)reader);
            Token token = tokenStream.nextToken();
            while (!APTUtils.isEOF((Token)token)) {
                if (bl) {
                    TraceModel.print("" + token);
                }
                token = tokenStream.nextToken();
            }
            l = System.currentTimeMillis() - l;
            if (this.isShowTime()) {
                TraceModel.print("APT Lexing " + file.getName() + " took " + l + " ms");
            }
            long l2 = l;
            return l2;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private long testAPTWalkerVisit(APTFile aPTFile, FileBuffer fileBuffer) throws TokenStreamException, IOException {
        File file = fileBuffer.getFile();
        boolean bl = aPTFile == null;
        long l = System.currentTimeMillis();
        if (bl) {
            this.invalidateAPT(fileBuffer);
            l = System.currentTimeMillis();
            aPTFile = APTDriver.getInstance().findAPTLight((APTFileBuffer)fileBuffer);
        }
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)this.getMacroMap(file), (APTIncludeHandler)this.getIncludeHandler(file), (boolean)true);
        APTWalkerTest aPTWalkerTest = new APTWalkerTest(aPTFile, aPTPreprocHandler);
        aPTWalkerTest.visit();
        l = System.currentTimeMillis() - l;
        if (this.isShowTime()) {
            TraceModel.print("Visiting APT " + (bl ? "with cleaning APT in driver" : "") + " took " + l + " ms");
            TraceModel.print(" resolving include paths took " + aPTWalkerTest.getIncludeResolvingTime() + " ms");
        }
        return l;
    }

    private long testAPTWalkerGetStream(APTFile aPTFile, FileBuffer fileBuffer, boolean bl, boolean bl2, boolean bl3) throws TokenStreamException, IOException {
        File file = fileBuffer.getFile();
        boolean bl4 = aPTFile == null;
        long l = System.currentTimeMillis();
        if (bl4) {
            this.invalidateAPT(fileBuffer);
            l = System.currentTimeMillis();
            aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)fileBuffer);
        }
        APTMacroMap aPTMacroMap = this.getMacroMap(file);
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)aPTMacroMap, (APTIncludeHandler)this.getIncludeHandler(file), (boolean)true);
        APTWalkerTest aPTWalkerTest = new APTWalkerTest(aPTFile, aPTPreprocHandler);
        TokenStream tokenStream = aPTWalkerTest.getTokenStream();
        if (bl) {
            tokenStream = new APTMacroExpandedStream(tokenStream, (APTMacroCallback)aPTMacroMap);
        }
        if (bl2) {
            tokenStream = APTLanguageSupport.getInstance().getFilter("Gnu C++ Language").getFilteredStream((TokenStream)new APTCommentsFilter(tokenStream));
        }
        int n = -1;
        Token token = tokenStream.nextToken();
        while (!APTUtils.isEOF((Token)token)) {
            if (bl3) {
                this.print(" " + token.getText(), token.getLine() != n);
            }
            n = token.getLine();
            token = tokenStream.nextToken();
        }
        if (bl3 && n > 0) {
            this.print("", true);
        }
        l = System.currentTimeMillis() - l;
        if (this.isShowTime()) {
            TraceModel.print("Getting" + (bl ? " expanded" : "") + (bl2 ? " filtered" : "") + " APT token stream " + (bl4 ? "with cleaning APT in driver" : "") + " took " + l + " ms");
            TraceModel.print(" resolving include paths took " + aPTWalkerTest.getIncludeResolvingTime() + " ms");
        }
        return l;
    }

    private long testAPTParser(NativeFileItem nativeFileItem, boolean bl) throws IOException, RecognitionException, TokenStreamException {
        FileBufferFile fileBufferFile = new FileBufferFile(nativeFileItem.getFile());
        TraceModel.print("Testing APT Parser");
        int n = 8;
        File file = fileBufferFile.getFile();
        long l = System.currentTimeMillis();
        if (bl) {
            this.invalidateAPT(fileBufferFile);
            l = System.currentTimeMillis();
        }
        FileImpl fileImpl = null;
        fileImpl = (FileImpl)this.getProject().testAPTParseFile(nativeFileItem);
        this.getProject().waitParse();
        l = System.currentTimeMillis() - l;
        if (this.isShowTime()) {
            TraceModel.print("Parsing" + (bl ? " with cleaning APT in driver" : "") + " took " + l + " ms");
        }
        return l;
    }

    private void testAPT(NativeFileItem nativeFileItem) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException, ClassNotFoundException {
        File file = nativeFileItem.getFile();
        FileBufferFile fileBufferFile = new FileBufferFile(file);
        TraceModel.print("Testing APT: " + file.getName());
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MIN_VALUE;
        if (this.testAPTLexer) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                long l5 = this.testAPTLexer(file, i == -1 ? this.printTokens : false);
                l3 = Math.min(l3, l5);
                l4 = Math.max(l4, l5);
            }
        }
        APTFile aPTFile = null;
        this.minDriver = Long.MAX_VALUE;
        this.maxDriver = Long.MIN_VALUE;
        if (this.testAPTDriver) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                this.invalidateAPT(fileBufferFile);
                aPTFile = this.testAPTDriver(fileBufferFile, i == -1);
            }
        }
        boolean bl = this.minDriver == Long.MAX_VALUE;
        long l6 = Long.MAX_VALUE;
        long l7 = Long.MIN_VALUE;
        if (this.testAPTWalkerVisit) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                long l8 = this.testAPTWalkerVisit(aPTFile, fileBufferFile);
                l6 = Math.min(l6, l8);
                l7 = Math.max(l7, l8);
            }
        }
        long l9 = Long.MAX_VALUE;
        long l10 = Long.MIN_VALUE;
        if (this.testAPTWalkerGetStream) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                long l11 = this.testAPTWalkerGetStream(aPTFile, fileBufferFile, false, false, i == -1 ? this.printTokens : false);
                l9 = Math.min(l9, l11);
                l10 = Math.max(l10, l11);
            }
        }
        long l12 = Long.MAX_VALUE;
        long l13 = Long.MIN_VALUE;
        if (this.testAPTWalkerGetExpandedStream) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                long l14 = this.testAPTWalkerGetStream(aPTFile, fileBufferFile, true, false, i == -1 ? this.printTokens : false);
                l12 = Math.min(l12, l14);
                l13 = Math.max(l13, l14);
            }
        }
        long l15 = Long.MAX_VALUE;
        long l16 = Long.MIN_VALUE;
        if (this.testAPTWalkerGetFilteredStream) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                long l17 = this.testAPTWalkerGetStream(aPTFile, fileBufferFile, true, true, i == -1 ? this.printTokens : false);
                l15 = Math.min(l15, l17);
                l16 = Math.max(l16, l17);
            }
        }
        long l18 = Long.MAX_VALUE;
        long l19 = Long.MIN_VALUE;
        long l20 = Long.MAX_VALUE;
        long l21 = Long.MIN_VALUE;
        if (this.testAPTParser) {
            for (int i = -1; i < APT_REPEAT_TEST; ++i) {
                long l22 = this.testAPTParser(nativeFileItem, bl);
                l20 = Math.min(l20, l22);
                l21 = Math.max(l21, l22);
            }
        }
        if (this.isShowTime()) {
            TraceModel.print("APT BEST/WORST results for " + file.getAbsolutePath());
            if (l != Long.MAX_VALUE) {
                TraceModel.print(l + " ms BEST Plain lexer");
                TraceModel.print(l2 + " ms WORST Plain lexer");
            }
            if (l3 != Long.MAX_VALUE) {
                TraceModel.print(l3 + " ms BEST APT lexer");
                TraceModel.print(l4 + " ms WORST APT lexer");
            }
            if (this.minDriver != Long.MAX_VALUE) {
                TraceModel.print(this.minDriver + " ms BEST Building APT:");
                TraceModel.print(this.maxDriver + " ms WORST Building APT:");
            }
            if (l6 != Long.MAX_VALUE) {
                TraceModel.print(l6 + " ms BEST Visiting APT" + (bl ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(l7 + " ms WORST Visiting APT" + (bl ? " with cleaning APT in driver:" : ":"));
            }
            if (l9 != Long.MAX_VALUE) {
                TraceModel.print(l9 + " ms BEST Getting APT token stream" + (bl ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(l10 + " ms WORST Getting APT token stream" + (bl ? " with cleaning APT in driver:" : ":"));
            }
            if (l12 != Long.MAX_VALUE) {
                TraceModel.print(l12 + " ms BEST Getting Expanded APT token stream" + (bl ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(l13 + " ms WORST Getting Expanded APT token stream" + (bl ? " with cleaning APT in driver:" : ":"));
            }
            if (l15 != Long.MAX_VALUE) {
                TraceModel.print(l15 + " ms BEST Getting Expanded Filtered APT token stream" + (bl ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(l16 + " ms WORST Getting Expanded Filtered APT token stream" + (bl ? " with cleaning APT in driver:" : ":"));
            }
            if (l18 != Long.MAX_VALUE) {
                TraceModel.print(l18 + " ms BEST Plaing Parsing");
                TraceModel.print(l19 + " ms WORST Plaing Parsing");
            }
            if (l20 != Long.MAX_VALUE) {
                TraceModel.print(l20 + " ms BEST APT parsing" + (bl ? " with cleaning APT in driver:" : ":"));
                TraceModel.print(l21 + " ms WORST APT parsing" + (bl ? " with cleaning APT in driver:" : ":"));
            }
        }
    }

    private void invalidateAPT(FileBuffer fileBuffer) {
        File file = fileBuffer.getFile();
        if (firstFile == null || firstFile.equalsIgnoreCase(file.getAbsolutePath())) {
            firstFile = file.getAbsolutePath();
            APTDriver.getInstance().invalidateAll();
            this.getProject().invalidateFiles();
        } else {
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)fileBuffer);
        }
    }

    private APTFile testAPTDriver(FileBuffer fileBuffer, boolean bl) throws IOException, FileNotFoundException {
        File file = fileBuffer.getFile();
        long l = this.usedMemory();
        long l2 = System.currentTimeMillis();
        APTFile aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)fileBuffer);
        l2 = System.currentTimeMillis() - l2;
        long l3 = this.usedMemory();
        if (this.isShowTime()) {
            this.minDriver = Math.min(this.minDriver, l2);
            this.maxDriver = Math.max(this.maxDriver, l2);
            TraceModel.print("Building APT for " + file.getName() + "\n SIZE OF FILE:" + file.length() / 1024L + "Kb\n TIME: took " + l2 + " ms\n MEMORY: changed from " + l / 1024L + " to " + l3 / 1024L + "[" + (l3 - l) / 1024L + "]Kb");
        }
        if (bl) {
            File file2 = new File("/tmp/aptout/");
            file2.mkdirs();
            File file3 = new File(file2, file.getName() + ".xml");
            if (file3.exists()) {
                file3.delete();
            }
            file3.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
            APTTraceUtils.xmlSerialize((APT)aPTFile, (Writer)bufferedWriter);
            ((Writer)bufferedWriter).flush();
            APT aPT = APTBuilder.buildAPTLight((APT)aPTFile);
            File file4 = new File(file2, file.getName() + "_lw.xml");
            if (file4.exists()) {
                file4.delete();
            }
            file4.createNewFile();
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file4));
            APTTraceUtils.xmlSerialize((APT)aPT, (Writer)bufferedWriter2);
            ((Writer)bufferedWriter2).flush();
        }
        return aPTFile;
    }

    private long usedMemory() {
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    void test(String[] stringArray, PrintStream printStream, PrintStream printStream2) throws Exception {
        tracer.setPrintStream(printStream);
        this.processArguments(stringArray);
        this.doTest();
        this.initDataObjects();
    }

    private TestResult test(NativeFileItem nativeFileItem) throws FileNotFoundException, RecognitionException, TokenStreamException, IOException, ClassNotFoundException {
        String string;
        Object object;
        TestResult testResult = new TestResult();
        if (this.testAPT) {
            this.testAPT(nativeFileItem);
            if (this.breakAfterAPT) {
                return new TestResult();
            }
        }
        AST aST = null;
        if (this.dumpStatistics) {
            Diagnostic.initFileStatistics(nativeFileItem.getFile().getAbsolutePath());
        }
        long l = System.currentTimeMillis();
        if (this.readAst) {
            long l2 = System.currentTimeMillis();
            aST = this.cache.readAst(nativeFileItem.getFile());
            l2 = System.currentTimeMillis() - l2;
            TraceModel.print("AST read; time: " + l2 + " ms");
        }
        AST aST2 = null;
        int n = 0;
        FileImpl fileImpl = (FileImpl)this.getProject().testAPTParseFile(nativeFileItem);
        this.waitProjectParsed(false);
        if (this.dumpAst || this.writeAst || this.showAstWindow) {
            aST2 = fileImpl.parse(null);
        }
        n = fileImpl.getErrorCount();
        if (this.dumpPPState) {
            this.sleep(100);
            object = this.states.get(fileImpl);
            assert (object != null);
            this.dumpMacroMap(object.getMacroMap());
        }
        l = System.currentTimeMillis() - l;
        if (this.isShowTime()) {
            testResult.setTime(l);
            testResult.setLineCount(this.countLines(fileImpl));
            if (!this.quiet) {
                TraceModel.print("Processing " + nativeFileItem.getFile().getName() + " took " + l + " ms; LPS=" + testResult.getLPS() + "; error count: " + n);
            }
        }
        if (this.dumpStatistics) {
            if (this.dumpDir != null) {
                object = statPostfix;
                if (Diagnostic.getStatisticsLevel() > 1) {
                    object = (String)object + "." + Diagnostic.getStatisticsLevel();
                }
                string = nativeFileItem.getFile().getName() + (String)object;
                String string2 = new File(this.dumpDir, string).getAbsolutePath();
                Diagnostic.dumpFileStatistics(string2);
            }
            if (this.dumpFile != null) {
                Diagnostic.dumpFileStatistics(this.dumpFile, true);
            }
        }
        if (this.testCache) {
            this.cacheTimes.put(nativeFileItem.getFile().getName(), new Long(l));
        }
        if (this.dumpAst) {
            System.out.println("AST DUMP for file " + nativeFileItem.getFile().getName());
            TraceModel.dumpAst(aST2);
        }
        if (this.writeAst && aST2 != null) {
            long l3 = System.currentTimeMillis();
            l3 = System.currentTimeMillis() - l3;
            this.cache.writeAst(aST2, nativeFileItem.getFile());
            TraceModel.print("AST stored; time: " + l3 + " ms");
        }
        if (this.doCleanRepository) {
            CsmProject csmProject = fileImpl.getProject();
            string = fileImpl.getAbsolutePath();
            fileImpl = null;
            ParserThreadManager.instance().waitEmptyProjectQueue((ProjectBase)csmProject);
            this.sleep(100);
            RepositoryAccessor.getRepository().debugClear();
            fileImpl = (FileImpl)csmProject.findFile((CharSequence)string);
        }
        if (this.dumpModel) {
            if (fileImpl != null) {
                tracer.setDeep(this.deep);
                tracer.setTestUniqueName(this.testUniqueName);
                tracer.dumpModel((CsmFile)fileImpl);
                if (!this.dumpFileOnly) {
                    tracer.dumpModel((CsmProject)this.getProject());
                }
            } else {
                TraceModel.print("FileImpl is null - not possible to dump File Model");
            }
        }
        if (this.showAstWindow) {
            this.test(aST2, nativeFileItem.getFile().getName());
        }
        return testResult;
    }

    private boolean hasNonEmptyIncludes(CsmFile csmFile) {
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            if (csmInclude.getIncludeFile() == null) continue;
            return true;
        }
        return false;
    }

    private long countLines(CsmFile csmFile) {
        return this.countLines(csmFile, false);
    }

    private long countLines(CsmFile csmFile, boolean bl) {
        if (csmFile == null) {
            return -1L;
        }
        if (!bl && this.hasNonEmptyIncludes(csmFile)) {
            return -1L;
        }
        CharSequence charSequence = csmFile.getText();
        long l = 0L;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '\n') continue;
            ++l;
        }
        return l;
    }

    private void test(AST aST, String string) {
        ASTFrameEx aSTFrameEx = new ASTFrameEx(string, aST);
        aSTFrameEx.setVisible(true);
    }

    private boolean isDummyUnresolved(CsmDeclaration csmDeclaration) {
        return csmDeclaration == null || csmDeclaration instanceof Unresolved.UnresolvedClass;
    }

    public static void dumpAst(AST aST) {
        ASTVisitor aSTVisitor = new ASTVisitor(){

            public void visit(AST aST) {
                for (AST aST2 = aST; aST2 != null; aST2 = aST2.getNextSibling()) {
                    String string = aST2 instanceof CsmAST ? " offset=" + ((CsmAST)aST2).getOffset() + " file = " + ((CsmAST)aST2).getFilename() : "";
                    TraceModel.print("" + aST2.getText() + " [" + aST2.getType() + "] " + aST2.getLine() + ':' + aST2.getColumn() + string);
                    if (aST2.getFirstChild() == null) continue;
                    TraceModel.indent();
                    this.visit(aST2.getFirstChild());
                    TraceModel.unindent();
                }
            }
        };
        aSTVisitor.visit(aST);
    }

    private void dumpMacroMap(APTMacroMap aPTMacroMap) {
        tracer.print("State of macro map:");
        tracer.print(aPTMacroMap == null ? "empty macro map" : aPTMacroMap.toString());
    }

    private void testLibProject() {
        LibProjectImpl libProjectImpl = LibProjectImpl.createInstance(this.getModel(), "/usr/include");
        this.getModel().addProject(libProjectImpl);
        tracer.dumpModel((CsmProject)libProjectImpl);
    }

    private static void print(String string) {
        tracer.print(string);
    }

    private void print(String string, boolean bl) {
        tracer.print(string, bl);
    }

    private static void indent() {
        tracer.indent();
    }

    private static void unindent() {
        tracer.unindent();
    }

    private int countUserFiles() {
        return this.getProject().getAllFiles().size();
    }

    private int countSystemHeaders() {
        int n = 0;
        HashSet hashSet = new HashSet();
        Iterator<CsmProject> iterator = this.getProject().getLibraries().iterator();
        while (iterator.hasNext()) {
            n += this.countFiles((ProjectBase)iterator.next(), hashSet);
        }
        return n;
    }

    private int countFiles(ProjectBase projectBase, Collection collection) {
        if (collection.contains(projectBase)) {
            return 0;
        }
        int n = projectBase.getAllFiles().size();
        Iterator<CsmProject> iterator = projectBase.getLibraries().iterator();
        while (iterator.hasNext()) {
            n += this.countFiles((ProjectBase)iterator.next(), collection);
        }
        return n;
    }

    private void calculateAverageLPS(TestResult testResult, boolean bl) {
        testResult.lineCount = 0L;
        for (CsmFile object : this.getProject().getAllFiles()) {
            testResult.lineCount += this.countLines(object, true);
        }
        if (bl) {
            for (ProjectBase projectBase : this.getProject().getLibraries()) {
                for (CsmFile csmFile : projectBase.getAllFiles()) {
                    testResult.lineCount += this.countLines(csmFile, true);
                }
            }
        }
    }

    private void testFolding(File file) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        if (fileInputStream == null) {
            return;
        }
        Reader reader = new InputStreamReader(fileInputStream);
        reader = new BufferedReader(reader);
        FoldingParser foldingParser = (FoldingParser)Lookup.getDefault().lookup(FoldingParser.class);
        if (foldingParser != null) {
            List list = foldingParser.parse(file.getAbsolutePath(), reader);
            try {
                reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.printFolds(file.getAbsolutePath(), list);
        } else {
            System.out.println("No Folding Provider");
        }
    }

    private void printFolds(String string, List<CppFoldRecord> list) {
        Collections.sort(list, FOLD_COMPARATOR);
        System.out.println("Foldings of the file " + string);
        for (CppFoldRecord cppFoldRecord : list) {
            System.out.println(cppFoldRecord);
        }
    }

    boolean isShowTime() {
        return this.showTime;
    }

    private List<NativeFileItem> getFileItems() {
        NativeProject nativeProject;
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        Object object = this.getProject().getPlatformProject();
        if (object instanceof NativeProject && (nativeProject = (NativeProject)object) != null) {
            arrayList.addAll(nativeProject.getAllFiles());
        }
        return arrayList;
    }

    private static class TestResult {
        private long time;
        private long lineCount;

        public TestResult() {
            this(0L);
        }

        public TestResult(long l) {
            this.setTime(l);
        }

        public TestResult(long l, long l2) {
            this.setTime(l);
            this.setLineCount(l2);
        }

        public String getLPS() {
            if (this.time == 0L || this.lineCount <= 0L) {
                return "N/A";
            }
            return "" + this.lineCount * 1000L / this.time;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long l) {
            this.time = l;
        }

        public long getLineCount() {
            return this.lineCount < 0L ? 0L : this.lineCount;
        }

        public boolean isLineCountValid() {
            return this.lineCount >= 0L;
        }

        public void setLineCount(long l) {
            this.lineCount = l;
        }

        public void accumulate(TestResult testResult) {
            this.time += testResult.time;
            if (this.isLineCountValid() && testResult.isLineCountValid()) {
                this.lineCount += testResult.getLineCount();
            }
        }
    }
}

