/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.LinkedList;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;

public class ProjectListenerThread
implements Runnable {
    private static ProjectListenerThread instance = new ProjectListenerThread();
    private static TaskQueue queue = new TaskQueue();

    public static ProjectListenerThread instance() {
        return instance;
    }

    public void postTask(Runnable runnable) {
        queue.addTask(runnable);
    }

    public void run() {
        while (true) {
            try {
                Runnable runnable = queue.getTask();
                if (runnable == null) continue;
                runnable.run();
                continue;
            }
            catch (InterruptedException interruptedException) {
                DiagnosticExceptoins.register(interruptedException);
                continue;
            }
            break;
        }
    }

    private static class TaskQueue {
        LinkedList queue = new LinkedList();

        private TaskQueue() {
        }

        public synchronized void addTask(Runnable runnable) {
            this.queue.addLast(runnable);
            this.notify();
        }

        public synchronized Runnable getTask() throws InterruptedException {
            while (this.queue.isEmpty()) {
                this.wait();
            }
            return (Runnable)this.queue.removeFirst();
        }
    }
}

