/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceRepositoryImpl
extends CsmReferenceRepository {
    public Collection<CsmReference> getReferences(CsmObject csmObject, CsmProject csmProject, Set<CsmReferenceKind> set) {
        ArrayList<CsmReference> arrayList;
        CsmFile csmFile;
        if (!(csmProject instanceof ProjectBase)) {
            return Collections.emptyList();
        }
        ProjectBase projectBase = (ProjectBase)csmProject;
        boolean bl = true;
        CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject, (boolean)bl);
        CsmObject csmObject2 = csmObjectArray[0];
        CsmObject csmObject3 = csmObjectArray[1];
        CsmScope csmScope = this.getDeclarationScope(csmObject2);
        CsmFile csmFile2 = csmFile = CsmKindUtilities.isOffsetable((Object)csmScope) ? ((CsmOffsetable)csmScope).getContainingFile() : null;
        if (csmFile instanceof FileImpl) {
            arrayList = new ArrayList<CsmReference>(10);
            CsmOffsetable csmOffsetable = (CsmOffsetable)csmScope;
            arrayList.addAll(this.getReferences(csmObject2, csmObject3, (FileImpl)csmFile, set, bl, csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset()));
        } else {
            Collection<FileImpl> collection = projectBase.getAllFileImpls();
            arrayList = new ArrayList(collection.size() * 10);
            for (FileImpl fileImpl : collection) {
                arrayList.addAll(this.getReferences(csmObject2, csmObject3, fileImpl, set, bl, 0, Integer.MAX_VALUE));
            }
        }
        return arrayList;
    }

    public Collection<CsmReference> getReferences(CsmObject csmObject, CsmFile csmFile, Set<CsmReferenceKind> set) {
        CsmFile csmFile2;
        CsmScope csmScope = this.getDeclarationScope(csmObject);
        CsmFile csmFile3 = csmFile2 = CsmKindUtilities.isOffsetable((Object)csmScope) ? ((CsmOffsetable)csmScope).getContainingFile() : null;
        if (!(csmFile instanceof FileImpl)) {
            return Collections.emptyList();
        }
        if (csmFile2 != null && !csmFile2.equals(csmFile)) {
            return Collections.emptyList();
        }
        boolean bl = true;
        CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject, (boolean)bl);
        CsmObject csmObject2 = csmObjectArray[0];
        CsmObject csmObject3 = csmObjectArray[1];
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        if (CsmKindUtilities.isOffsetable((Object)csmScope)) {
            n = ((CsmOffsetable)csmScope).getStartOffset();
            n2 = ((CsmOffsetable)csmScope).getEndOffset();
        }
        return this.getReferences(csmObject2, csmObject3, (FileImpl)csmFile, set, bl, n, n2);
    }

    public Map<CsmObject, Collection<CsmReference>> getReferences(CsmObject[] csmObjectArray, CsmProject csmProject, Set<CsmReferenceKind> set) {
        HashMap<CsmObject, Collection<CsmReference>> hashMap = new HashMap<CsmObject, Collection<CsmReference>>(csmObjectArray.length);
        for (CsmObject csmObject : csmObjectArray) {
            hashMap.put(csmObject, this.getReferences(csmObject, csmProject, set));
        }
        return hashMap;
    }

    public Collection<CsmReference> getReferences(CsmObject[] csmObjectArray, CsmFile csmFile, Set<CsmReferenceKind> set) {
        AbstractCollection object = new LinkedHashSet<CsmReference>(1024);
        for (CsmObject csmObject : csmObjectArray) {
            object.addAll(this.getReferences(csmObject, csmFile, set));
        }
        if (!object.isEmpty() && csmObjectArray.length > 1) {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(object);
            Collections.sort(arrayList, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference csmReference, CsmReference csmReference2) {
                    return csmReference.getStartOffset() - csmReference2.getStartOffset();
                }
            });
            object = arrayList;
        }
        return object;
    }

    private Collection<CsmReference> getReferences(CsmObject csmObject, CsmObject csmObject2, FileImpl fileImpl, Set<CsmReferenceKind> set, boolean bl, int n, int n2) {
        assert (csmObject != null);
        assert (fileImpl != null);
        CharSequence charSequence = "";
        if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
            charSequence = ((CsmNamedElement)csmObject).getName();
        } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
            if (csmObject instanceof CsmLabel) {
                charSequence = ((CsmLabel)csmObject).getLabel();
            } else if (csmObject instanceof CsmGotoStatement) {
                charSequence = ((CsmGotoStatement)csmObject).getLabel();
            }
        }
        if (charSequence.length() == 0) {
            if (TraceFlags.TRACE_XREF_REPOSITORY) {
                System.err.println("resolving unnamed element is not yet supported " + csmObject);
            }
            return Collections.emptyList();
        }
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            System.err.println("resolving " + charSequence + " in file " + fileImpl.getAbsolutePath());
        }
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(20);
        long l = 0L;
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            l = System.currentTimeMillis();
        }
        Collection<APTToken> collection = this.getTokensToResolve(fileImpl, charSequence.toString(), n, n2);
        if (TraceFlags.TRACE_XREF_REPOSITORY) {
            l = System.currentTimeMillis() - l;
            System.err.println("collecting tokens");
        }
        for (APTToken aPTToken : collection) {
            int n3 = aPTToken.getOffset();
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference((CsmFile)fileImpl, n3);
            if (!this.acceptReference(csmReference, csmObject, csmObject2, set, bl)) continue;
            arrayList.add(csmReference);
        }
        return arrayList;
    }

    private boolean hasName(FileImpl fileImpl, String string) {
        try {
            String string2 = fileImpl.getBuffer().getText();
            if (string2.indexOf(string) < 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return true;
    }

    private Collection<APTToken> getTokensToResolve(FileImpl fileImpl, String string, int n, int n2) {
        if (!this.hasName(fileImpl, string)) {
            return Collections.emptyList();
        }
        TokenStream tokenStream = this.getTokenStream(fileImpl);
        ArrayList<APTToken> arrayList = new ArrayList<APTToken>(100);
        boolean bl = false;
        if (string.startsWith("~")) {
            bl = true;
            string = string.substring(1);
        }
        if (tokenStream != null) {
            try {
                APTToken aPTToken = (APTToken)tokenStream.nextToken();
                APTToken aPTToken2 = null;
                while (!APTUtils.isEOF((Token)aPTToken)) {
                    int n3;
                    if (aPTToken.getOffset() >= n && ((n3 = aPTToken.getType()) == 204 || n3 == 233) && string.equals(aPTToken.getText()) && (!bl || aPTToken2 != null && aPTToken2.getType() == 170)) {
                        arrayList.add(aPTToken);
                    }
                    if (aPTToken.getEndOffset() <= n2) {
                        aPTToken2 = aPTToken;
                        aPTToken = (APTToken)tokenStream.nextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (TokenStreamException tokenStreamException) {
                DiagnosticExceptoins.register(tokenStreamException);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenStream getTokenStream(FileImpl fileImpl) {
        Reader reader = null;
        TokenStream tokenStream = null;
        try {
            reader = fileImpl.getBuffer().getReader();
            tokenStream = APTTokenStreamBuilder.buildTokenStream((String)fileImpl.getAbsolutePath(), (Reader)reader);
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            tokenStream = null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    DiagnosticExceptoins.register(iOException);
                }
            }
        }
        return tokenStream == null ? null : fileImpl.getLanguageFilter().getFilteredStream((TokenStream)new APTCommentsFilter(tokenStream));
    }

    private boolean acceptReference(CsmReference csmReference, CsmObject csmObject, CsmObject csmObject2, Set<CsmReferenceKind> set, boolean bl) {
        CsmObject csmObject3;
        assert (csmObject != null);
        boolean bl2 = false;
        CsmObject csmObject4 = csmObject3 = csmReference == null ? null : csmReference.getReferencedObject();
        if (bl && CsmKindUtilities.isTemplateInstantiation((CsmObject)csmObject3)) {
            csmObject3 = ((CsmInstantiation)csmObject3).getTemplateDeclaration();
        }
        if (csmObject.equals(csmObject3) || csmObject2 != null && csmObject2.equals(csmObject3)) {
            if (set == CsmReferenceKind.ALL) {
                bl2 = true;
            } else {
                CsmReferenceKind csmReferenceKind = csmReference.getKind();
                bl2 = set.contains(csmReferenceKind);
            }
        }
        return bl2;
    }

    private CsmScope getDeclarationScope(CsmObject csmObject) {
        assert (csmObject != null);
        CsmObject csmObject2 = csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                return (CsmFunction)csmScope;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmObject2 = (CsmScopeElement)csmScope;
        }
        return null;
    }
}

