/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.modelimpl.cache.CacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ClassifierContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeProjectListenerImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.Terminator;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTRestorePreprocStateWalker;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.util.Cancellable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectBase
implements CsmProject,
Persistent,
SelfPersistent {
    private transient boolean needParseOrphan;
    private CsmUID<CsmProject> uid = null;
    private transient Status status;
    private Cancellable initializationTask;
    private Object initializationTaskLock = new Object();
    private Object waitParseLock = new Object();
    private ModelImpl model;
    private Unresolved unresolved;
    private CharSequence name;
    private final CsmUID<CsmNamespace> globalNamespaceUID;
    private Object platformProject;
    private boolean disposing;
    private ReadWriteLock disposeLock = new ReentrantReadWriteLock();
    private CharSequence uniqueName = null;
    private Map<CharSequence, CsmUID<CsmNamespace>> namespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
    private ClassifierContainer classifierContainer = new ClassifierContainer();
    private APTSystemStorage sysAPTData = APTSystemStorage.getDefault();
    private Object namespaceLock = new String("namespaceLock in Projectbase " + this.hashCode());
    private final Key declarationsSorageKey;
    private final Key fileContainerKey;
    private final Key graphStorageKey;
    protected final SourceRootContainer projectRoots = new SourceRootContainer();
    private NativeProjectListenerImpl projectListener;
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private static final boolean REMEMBER_RESTORED = TraceFlags.CLEAN_MACROS_AFTER_PARSE && (DebugUtils.getBoolean((String)"cnd.remember.restored", (boolean)false) || TRACE_PP_STATE_OUT);
    public static final int GATHERING_MACROS = 0;
    public static final int GATHERING_TOKENS = 1;
    private static List<String> testRestoredFiles = null;

    protected ProjectBase(ModelImpl modelImpl, Object object, String string) {
        this.setStatus(Status.Initial);
        this.name = ProjectNameCache.getManager().getString((CharSequence)string);
        this.init(modelImpl, object);
        NamespaceImpl namespaceImpl = new NamespaceImpl(this);
        assert (namespaceImpl != null);
        this.globalNamespaceUID = UIDCsmConverter.namespaceToUID(namespaceImpl);
        this.declarationsSorageKey = new DeclarationContainer(this).getKey();
        this.fileContainerKey = new FileContainer(this).getKey();
        this.graphStorageKey = new GraphContainer(this).getKey();
    }

    private void init(ModelImpl modelImpl, Object object) {
        this.model = modelImpl;
        this.platformProject = object;
        RepositoryUtils.hang((CsmIdentifiable)this);
        if (TraceFlags.CLOSE_AFTER_PARSE) {
            Terminator.create(this);
        }
        this.needParseOrphan = ModelSupport.needParseOrphan(object);
    }

    private boolean checkConsistency() {
        long l;
        long l2 = l = TraceFlags.TIMING ? System.currentTimeMillis() : 0L;
        if (this.getFileContainer() == null) {
            return false;
        }
        if (this.getDeclarationsSorage() == null) {
            return false;
        }
        if (this.getGraph() == null) {
            return false;
        }
        if (this.getGlobalNamespace() == null) {
            return false;
        }
        if (TraceFlags.TIMING) {
            System.err.printf("Consistency check took %d ms\n", System.currentTimeMillis() - l);
        }
        return true;
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    protected static void cleanRepository(Object object, boolean bl) {
        Key key = KeyUtilities.createProjectKey(((Object)ProjectBase.getUniqueName(object)).toString());
        RepositoryUtils.closeUnit(key, null, true);
    }

    public static ProjectBase readInstance(ModelImpl modelImpl, Object object, String string) {
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("Project %s: instantiating...\n", string);
            l = System.currentTimeMillis();
        }
        assert (TraceFlags.PERSISTENT_REPOSITORY);
        Key key = KeyUtilities.createProjectKey(((Object)ProjectBase.getUniqueName(object)).toString());
        RepositoryUtils.openUnit(key);
        Persistent persistent = RepositoryUtils.get(key);
        if (persistent != null) {
            assert (persistent instanceof ProjectBase);
            ProjectBase projectBase = (ProjectBase)persistent;
            if (!projectBase.name.equals(string)) {
                projectBase.setName(string);
            }
            projectBase.init(modelImpl, object);
            if (TraceFlags.TIMING) {
                l = System.currentTimeMillis() - l;
                System.err.printf("Project %s: loaded. %d ms\n", string, l);
            }
            if (projectBase.checkConsistency()) {
                return projectBase;
            }
        }
        return null;
    }

    public CsmNamespace getGlobalNamespace() {
        return this._getGlobalNamespace();
    }

    public CharSequence getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public CharSequence getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = ProjectBase.getUniqueName(this.getPlatformProject());
        }
        return this.uniqueName;
    }

    public static CharSequence getUniqueName(Object object) {
        String string;
        if (object instanceof NativeProject) {
            string = ((NativeProject)object).getProjectRoot() + 'N';
        } else if (object instanceof String) {
            string = (String)object + 'L';
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Incorrect platform project: null");
            }
            throw new IllegalArgumentException("Incorrect platform project class: " + object.getClass());
        }
        return ProjectNameCache.getManager().getString((CharSequence)string);
    }

    public Object getPlatformProject() {
        return this.platformProject;
    }

    protected void setPlatformProject(Object object) {
        this.platformProject = object;
        this.uniqueName = null;
    }

    public CsmNamespace findNamespace(CharSequence charSequence, boolean bl) {
        CsmNamespace csmNamespace;
        block1: {
            CsmProject csmProject;
            csmNamespace = this.findNamespace(charSequence);
            if (csmNamespace != null || !bl) break block1;
            Iterator<CsmProject> iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && (csmNamespace = (csmProject = iterator.next()).findNamespace(charSequence)) == null) {
            }
        }
        return csmNamespace;
    }

    public CsmNamespace findNamespace(CharSequence charSequence) {
        NamespaceImpl namespaceImpl = this._getNamespace(charSequence);
        return namespaceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceImpl findNamespaceCreateIfNeeded(NamespaceImpl namespaceImpl, CharSequence charSequence) {
        String string = Utils.getNestedNamespaceQualifiedName(charSequence, namespaceImpl, true);
        NamespaceImpl namespaceImpl2 = this._getNamespace(string);
        if (namespaceImpl2 == null) {
            Object object = this.namespaceLock;
            synchronized (object) {
                namespaceImpl2 = this._getNamespace(string);
                if (namespaceImpl2 == null) {
                    namespaceImpl2 = new NamespaceImpl(this, namespaceImpl, ((Object)charSequence).toString(), string);
                }
            }
        }
        return namespaceImpl2;
    }

    public void registerNamespace(NamespaceImpl namespaceImpl) {
        this._registerNamespace(namespaceImpl);
    }

    public void unregisterNamesace(NamespaceImpl namespaceImpl) {
        this._unregisterNamespace(namespaceImpl);
    }

    public CsmClassifier findClassifier(CharSequence charSequence, boolean bl) {
        CsmClassifier csmClassifier;
        block1: {
            CsmProject csmProject;
            csmClassifier = this.findClassifier(charSequence);
            if (csmClassifier != null || !bl) break block1;
            Iterator<CsmProject> iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && (csmClassifier = (csmProject = iterator.next()).findClassifier(charSequence)) == null) {
            }
        }
        return csmClassifier;
    }

    public CsmClassifier findClassifier(CharSequence charSequence) {
        CsmClassifier csmClassifier = this.classifierContainer.getClassifier(charSequence);
        return csmClassifier;
    }

    public CsmDeclaration findDeclaration(CharSequence charSequence) {
        return this.getDeclarationsSorage().getDeclaration(charSequence);
    }

    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        return this.getDeclarationsSorage().findDeclarations(charSequence);
    }

    public Collection<CsmOffsetableDeclaration> findDeclarationsByPrefix(String string) {
        return this.getDeclarationsSorage().getDeclarationsRange(string, string + '\uffff');
    }

    public Collection<CsmFriend> findFriendDeclarations(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return this.getDeclarationsSorage().findFriends(csmOffsetableDeclaration);
    }

    public static boolean isCppFile(CsmFile csmFile) {
        return csmFile instanceof FileImpl && ((FileImpl)csmFile).isCppFile();
    }

    public static boolean canRegisterDeclaration(CsmDeclaration csmDeclaration) {
        assert (csmDeclaration != null);
        assert (csmDeclaration.getName() != null);
        if (csmDeclaration.getName().length() == 0) {
            return false;
        }
        CsmScope csmScope = csmDeclaration.getScope();
        if (csmScope instanceof CsmCompoundClassifier) {
            return ProjectBase.canRegisterDeclaration((CsmDeclaration)((CsmCompoundClassifier)csmScope));
        }
        return true;
    }

    public void registerDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        if (!ProjectBase.canRegisterDeclaration((CsmDeclaration)csmOffsetableDeclaration)) {
            if (TraceFlags.TRACE_REGISTRATION) {
                System.err.println("not registered decl " + csmOffsetableDeclaration + " UID " + csmOffsetableDeclaration.getUID());
            }
            return;
        }
        if (TraceFlags.CHECK_DECLARATIONS && (object = this.getDeclarationsSorage().getDeclaration(csmOffsetableDeclaration.getUniqueName())) != null && object != csmOffsetableDeclaration) {
            System.err.println("\n\nRegistering different declaration with the same name:" + csmOffsetableDeclaration.getUniqueName());
            System.err.print("WAS:");
            new CsmTracer().dumpModel(object);
            System.err.print("\nNOW:");
            new CsmTracer().dumpModel((CsmDeclaration)csmOffsetableDeclaration);
        }
        this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
        if (csmOffsetableDeclaration instanceof CsmClassifier) {
            CsmClassifier csmClassifier;
            object = csmOffsetableDeclaration.getQualifiedName();
            if (!this.classifierContainer.putClassifier((CsmClassifier)csmOffsetableDeclaration) && TraceFlags.CHECK_DECLARATIONS && (csmClassifier = this.classifierContainer.getClassifier((CharSequence)object)) != null && csmClassifier != csmOffsetableDeclaration) {
                System.err.println("\n\nRegistering different classifier with the same name:" + object);
                System.err.print("ALREADY EXISTS:");
                new CsmTracer().dumpModel((CsmDeclaration)csmClassifier);
                System.err.print("\nFAILED TO ADD:");
                new CsmTracer().dumpModel((CsmDeclaration)csmOffsetableDeclaration);
            }
        }
        if (TraceFlags.TRACE_REGISTRATION) {
            System.err.println("registered " + csmOffsetableDeclaration + " UID " + csmOffsetableDeclaration.getUID());
        }
    }

    public void unregisterDeclaration(CsmDeclaration csmDeclaration) {
        if (TraceFlags.TRACE_REGISTRATION) {
            System.err.println("unregistered " + csmDeclaration + " UID " + csmDeclaration.getUID());
        }
        if (csmDeclaration instanceof CsmClassifier) {
            this.classifierContainer.removeClassifier(csmDeclaration);
        }
        this.getDeclarationsSorage().removeDeclaration(csmDeclaration);
    }

    public void waitParse() {
        boolean bl = ParserThreadManager.instance().isParserThread();
        if (bl) {
            new Throwable("project.waitParse should NEVER be called in parser thread !!!").printStackTrace(System.err);
        }
        if (bl) {
            return;
        }
        this.ensureFilesCreated();
        this.ensureChangedFilesEnqueued();
        this.waitParseImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitParseImpl() {
        Object object = this.waitParseLock;
        synchronized (object) {
            while (ParserQueue.instance().hasFiles(this, null)) {
                try {
                    this.waitParseLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void ensureChangedFilesEnqueued() {
    }

    protected boolean hasChangedFiles(CsmFile csmFile) {
        return false;
    }

    public boolean acceptNativeItem(NativeFileItem nativeFileItem) {
        NativeFileItem.Language language = nativeFileItem.getLanguage();
        return (language == NativeFileItem.Language.C || language == NativeFileItem.Language.CPP || language == NativeFileItem.Language.C_HEADER) && !nativeFileItem.isExcluded();
    }

    protected synchronized void registerProjectListeners() {
        if (this.platformProject instanceof NativeProject) {
            if (this.projectListener == null) {
                this.projectListener = new NativeProjectListenerImpl(this.getModel(), (NativeProject)this.platformProject);
            }
            ((NativeProject)this.platformProject).addProjectItemsListener((NativeProjectItemsListener)this.projectListener);
        }
    }

    protected synchronized void unregisterProjectListeners() {
        if (this.projectListener != null && this.platformProject instanceof NativeProject) {
            ((NativeProject)this.platformProject).removeProjectItemsListener((NativeProjectItemsListener)this.projectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void ensureFilesCreated() {
        if (this.status == Status.Initial || this.status == Status.Restored) {
            try {
                this.setStatus(this.status == Status.Initial ? Status.AddingFiles : Status.Validating);
                long l = 0L;
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    System.err.println("suspend queue");
                    ParserQueue.instance().suspend();
                    if (TraceFlags.TIMING) {
                        l = System.currentTimeMillis();
                    }
                }
                ParserQueue.instance().onStartAddingProjectFiles(this);
                this.registerProjectListeners();
                NativeProject nativeProject = ModelSupport.getNativeProject(this.platformProject);
                if (nativeProject != null) {
                    try {
                        ParserQueue.instance().suspend();
                        this.createProjectFilesIfNeed(nativeProject);
                    }
                    finally {
                        ParserQueue.instance().resume();
                    }
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    if (TraceFlags.TIMING) {
                        l = System.currentTimeMillis() - l;
                        System.err.println("getting files from project system + put in queue took " + l + "ms");
                    }
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before resuming queue");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ParserQueue.instance().resume();
                }
                ParserQueue.instance().onEndAddingProjectFiles(this);
            }
            finally {
                this.setStatus(Status.Ready);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createProjectFilesIfNeed(NativeProject var1_1) {
        block27: {
            block28: {
                if (TraceFlags.TIMING) {
                    System.err.printf("\n\nGetting files from project system for %s...\n", new Object[]{this.getName()});
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException var2_2) {
                        // empty catch block
                    }
                }
                var2_3 = System.currentTimeMillis();
                var4_4 = Collections.synchronizedSet(new HashSet<E>());
                var5_5 = new NativeProjectItemsListener(){

                    public void fileAdded(NativeFileItem nativeFileItem) {
                    }

                    public void filesAdded(List<NativeFileItem> list) {
                    }

                    public void fileRemoved(NativeFileItem nativeFileItem) {
                        var4_4.add(nativeFileItem);
                    }

                    public void filesRemoved(List<NativeFileItem> list) {
                        var4_4.addAll(list);
                    }

                    public void fileRenamed(String string, NativeFileItem nativeFileItem) {
                    }

                    public void filePropertiesChanged(NativeFileItem nativeFileItem) {
                    }

                    public void filesPropertiesChanged(List<NativeFileItem> list) {
                    }

                    public void filesPropertiesChanged() {
                    }

                    public void projectDeleted(NativeProject nativeProject) {
                    }
                };
                var1_1.addProjectItemsListener(var5_5);
                var6_6 = new ArrayList<NativeFileItem>();
                var7_7 = new ArrayList<NativeFileItem>();
                var8_8 = new ArrayList<NativeFileItem>();
                block14: for (Object var10_11 : var1_1.getAllFiles()) {
                    if (!var10_11.isExcluded()) {
                        switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[var10_11.getLanguage().ordinal()]) {
                            case 1: 
                            case 2: {
                                var6_6.add((NativeFileItem)var10_11);
                                continue block14;
                            }
                            case 3: {
                                var7_7.add((NativeFileItem)var10_11);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[var10_11.getLanguage().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            var8_8.add((NativeFileItem)var10_11);
                            break;
                        }
                    }
                }
                if (TraceFlags.TIMING) {
                    var2_3 = System.currentTimeMillis() - var2_3;
                    System.err.printf("Getting files from project system took  %d ms for %s\n", new Object[]{var2_3, this.getName()});
                    System.err.printf("FILES COUNT for %s:\nSource files:\t%d\nHeader files:\t%d\nTotal files:\t%d\n", new Object[]{this.getName(), var6_6.size(), var7_7.size(), var6_6.size() + var7_7.size()});
                    var2_3 = System.currentTimeMillis();
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec after getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException var9_10) {
                        // empty catch block
                    }
                }
                if (TraceFlags.DUMP_PROJECT_ON_OPEN) {
                    ModelSupport.dumpNativeProject(var1_1);
                }
                this.disposeLock.readLock().lock();
                if (TraceFlags.TIMING) {
                    var2_3 = System.currentTimeMillis() - var2_3;
                    System.err.printf("Waited on disposeLock: %d ms for %s\n", new Object[]{var2_3, this.getName()});
                    var2_3 = System.currentTimeMillis();
                }
                if (!this.disposing) break block27;
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", new Object[]{this.getName()});
                }
                this.disposeLock.readLock().unlock();
                if (!TraceFlags.TIMING) break block28;
                var2_3 = System.currentTimeMillis() - var2_3;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
            }
            return;
        }
        try {
            var9_9 = null;
            if (this.status == Status.Validating) {
                var9_9 = new ProjectSettingsValidator(this);
                var9_9.restoreSettings();
            }
            this.projectRoots.fixFolder(var1_1.getProjectRoot());
            for (String var11_12 : var1_1.getSourceRoots()) {
                this.projectRoots.fixFolder(var11_12);
            }
            this.projectRoots.addSources(var6_6);
            this.projectRoots.addSources(var7_7);
            this.projectRoots.addSources(var8_8);
            this.createProjectFilesIfNeed(var6_6, true, var4_4, (ProjectSettingsValidator)var9_9);
            this.createProjectFilesIfNeed(var7_7, false, var4_4, (ProjectSettingsValidator)var9_9);
            this.disposeLock.readLock().unlock();
            ** if (!TraceFlags.TIMING) goto lbl-1000
        }
        catch (Throwable var12_13) {
            this.disposeLock.readLock().unlock();
            if (TraceFlags.TIMING) {
                var2_3 = System.currentTimeMillis() - var2_3;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
            }
            throw var12_13;
        }
lbl-1000:
        // 1 sources

        {
            var2_3 = System.currentTimeMillis() - var2_3;
            System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
        }
lbl-1000:
        // 2 sources

        {
        }
        var1_1.removeProjectItemsListener(var5_5);
    }

    private void createProjectFilesIfNeed(List<NativeFileItem> list, boolean bl, Set<NativeFileItem> set, ProjectSettingsValidator projectSettingsValidator) {
        for (NativeFileItem nativeFileItem : list) {
            if (this.disposing) {
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", this.getName());
                }
                return;
            }
            if (set.contains(nativeFileItem)) continue;
            assert (nativeFileItem.getFile() != null) : "native file item must have valid File object";
            if (TraceFlags.DEBUG) {
                ModelSupport.trace(nativeFileItem);
            }
            try {
                this.createIfNeed(nativeFileItem, bl, projectSettingsValidator);
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
    }

    protected void createIfNeed(NativeFileItem nativeFileItem, boolean bl, ProjectSettingsValidator projectSettingsValidator) {
        assert (nativeFileItem != null && nativeFileItem.getFile() != null);
        if (!this.acceptNativeItem(nativeFileItem)) {
            return;
        }
        File file = nativeFileItem.getFile();
        APTPreprocHandler aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
        assert (aPTPreprocHandler != null);
        int n = bl ? ProjectBase.getFileType(nativeFileItem) : 4;
        FileAndHandler fileAndHandler = this.createOrFindFileImpl(ModelSupport.getFileBuffer(file), nativeFileItem, n);
        if (fileAndHandler.preprocHandler == null) {
            fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFileItem);
        }
        if (bl || this.needParseOrphan) {
            ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
        }
        if (projectSettingsValidator != null) {
            if (fileAndHandler.fileImpl.validate()) {
                if (projectSettingsValidator.arePropertiesChanged(nativeFileItem)) {
                    if (TraceFlags.TRACE_VALIDATION) {
                        System.err.printf("Validation: %s properties are changed \n", nativeFileItem.getFile().getAbsolutePath());
                    }
                    DeepReparsingUtils.reparseOnPropertyChanged(nativeFileItem, this);
                }
            } else {
                if (TraceFlags.TRACE_VALIDATION) {
                    System.err.printf("Validation: file %s is changed\n", nativeFileItem.getFile().getAbsolutePath());
                }
                DeepReparsingUtils.reparseOnEdit(fileAndHandler.fileImpl, this, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAddedToModel() {
        boolean bl;
        boolean bl2 = bl = this.status == Status.Restored;
        if (this.status == Status.Initial || this.status == Status.Restored) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProjectBase.this.onAddedToModelImpl(bl);
                    Object object = ProjectBase.this.initializationTaskLock;
                    synchronized (object) {
                        ProjectBase.this.initializationTask = null;
                    }
                }
            };
            String string = this.status == Status.Initial ? "Filling parser queue for " : "Validating files for ";
            Object object = this.initializationTaskLock;
            synchronized (object) {
                this.initializationTask = ModelImpl.instance().enqueueModelTask(runnable, string + this.getName());
            }
        }
    }

    protected Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAddedToModelImpl(boolean bl) {
        if (this.disposing) {
            return;
        }
        try {
            this.disposeLock.readLock().lock();
            if (this.disposing) {
                return;
            }
            this.ensureFilesCreated();
            if (this.disposing) {
                return;
            }
            this.ensureChangedFilesEnqueued();
            if (this.disposing) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
        if (bl) {
            ProgressSupport.instance().fireProjectLoaded(this);
        }
        try {
            this.disposeLock.readLock().lock();
            if (bl && !this.disposing) {
                try {
                    this.waitParseImpl();
                    this.checkForRemoved();
                }
                catch (Exception exception) {
                    DiagnosticExceptoins.register(exception);
                }
            }
            if (this.disposing) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    private void checkForRemoved() {
        NativeFileItem nativeFileItem2;
        NativeProject nativeProject = this.platformProject instanceof NativeProject ? (NativeProject)this.platformProject : null;
        HashSet<String> hashSet = null;
        if (nativeProject != null) {
            hashSet = new HashSet<String>();
            for (NativeFileItem nativeFileItem2 : nativeProject.getAllFiles()) {
                if (nativeFileItem2.isExcluded()) continue;
                switch (nativeFileItem2.getLanguage()) {
                    case C: 
                    case CPP: 
                    case C_HEADER: {
                        hashSet.add(nativeFileItem2.getFile().getAbsolutePath());
                        break;
                    }
                }
            }
        }
        HashSet hashSet2 = new HashSet();
        nativeFileItem2 = new HashSet();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (!fileImpl.getFile().exists()) {
                nativeFileItem2.add(fileImpl);
                continue;
            }
            if (hashSet == null || hashSet.contains(fileImpl.getAbsolutePath())) continue;
            hashSet2.add(fileImpl);
        }
        for (FileImpl fileImpl : nativeFileItem2) {
            if (TraceFlags.TRACE_VALIDATION) {
                System.err.printf("Validation: removing (physically deleted) %s\n", fileImpl.getAbsolutePath());
            }
            this.onFileRemoved(fileImpl);
        }
        Iterator<FileImpl> iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            FileImpl fileImpl;
            fileImpl = iterator.next();
            boolean bl = true;
            Set<CsmFile> set = this.getGraphStorage().getParentFiles(fileImpl);
            for (CsmFile csmFile : set) {
                if (hashSet2.contains(csmFile)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (TraceFlags.TRACE_VALIDATION) {
                System.err.printf("Validation: removing (removed from project) %s\n", fileImpl.getAbsolutePath());
            }
            this.onFileRemoved(fileImpl);
        }
    }

    protected APTPreprocHandler createEmptyPreprocHandler(File file) {
        StartEntry startEntry = new StartEntry(FileContainer.getFileKey(file, true), RepositoryUtils.UIDtoKey(this.getUID()));
        return APTHandlersSupport.createEmptyPreprocHandler((StartEntry)startEntry);
    }

    protected APTPreprocHandler createPreprocHandler(NativeFileItem nativeFileItem) {
        assert (nativeFileItem != null);
        APTMacroMap aPTMacroMap = this.getMacroMap(nativeFileItem);
        APTIncludeHandler aPTIncludeHandler = this.getIncludeHandler(nativeFileItem);
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)aPTMacroMap, (APTIncludeHandler)aPTIncludeHandler, (boolean)this.isSourceFile(nativeFileItem));
        return aPTPreprocHandler;
    }

    private APTIncludeHandler getIncludeHandler(NativeFileItem nativeFileItem) {
        if (!this.isSourceFile(nativeFileItem)) {
            nativeFileItem = DefaultFileItem.toDefault(nativeFileItem);
        }
        List list = nativeFileItem.getUserIncludePaths();
        List list2 = nativeFileItem.getSystemIncludePaths();
        list2 = this.sysAPTData.getIncludes(list2.toString(), list2);
        StartEntry startEntry = new StartEntry(FileContainer.getFileKey(nativeFileItem.getFile(), true), RepositoryUtils.UIDtoKey(this.getUID()));
        return APTHandlersSupport.createIncludeHandler((StartEntry)startEntry, (List)list2, (List)list);
    }

    private APTMacroMap getMacroMap(NativeFileItem nativeFileItem) {
        if (!this.isSourceFile(nativeFileItem)) {
            nativeFileItem = DefaultFileItem.toDefault(nativeFileItem);
        }
        List list = nativeFileItem.getUserMacroDefinitions();
        List list2 = nativeFileItem.getSystemMacroDefinitions();
        APTMacroMap aPTMacroMap = APTHandlersSupport.createMacroMap((APTMacroMap)this.getSysMacroMap(list2), (List)list);
        return aPTMacroMap;
    }

    protected boolean isSourceFile(NativeFileItem nativeFileItem) {
        int n = ProjectBase.getFileType(nativeFileItem);
        return n == 3 || n == 2 || n == 1;
    }

    protected static int getFileType(NativeFileItem nativeFileItem) {
        switch (nativeFileItem.getLanguage()) {
            case C: {
                return 2;
            }
            case CPP: {
                return 3;
            }
            case C_HEADER: {
                return 4;
            }
        }
        return 0;
    }

    private APTMacroMap getSysMacroMap(List<String> list) {
        APTMacroMap aPTMacroMap = this.sysAPTData.getMacroMap(list.toString(), list);
        return aPTMacroMap;
    }

    public final APTPreprocHandler getPreprocHandler(File file) {
        APTPreprocHandler aPTPreprocHandler = this.createEmptyPreprocHandler(file);
        APTPreprocHandler.State state = this.getPreprocState(file);
        if (state != null) {
            if (state.isCleaned()) {
                return this.restorePreprocHandler(file, aPTPreprocHandler, state);
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.println("copying state for " + file);
            }
            aPTPreprocHandler.setState(state);
            return aPTPreprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.printf("null state for %s, returning default one", file);
        }
        return aPTPreprocHandler;
    }

    public final APTPreprocHandler.State getPreprocState(FileImpl fileImpl) {
        APTPreprocHandler.State state = null;
        FileContainer fileContainer = this.getFileContainer();
        if (fileContainer != null) {
            File file = fileImpl.getBuffer().getFile();
            state = fileContainer.getPreprocState(file);
        }
        return state;
    }

    public CsmFile testAPTParseFile(NativeFileItem nativeFileItem) {
        APTPreprocHandler aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
        return this.findFile(nativeFileItem.getFile(), ProjectBase.getFileType(nativeFileItem), aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
    }

    protected final void putPreprocState(File file, APTPreprocHandler.State state) {
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        }
        this.getFileContainer().putPreprocState(file, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final APTPreprocHandler.State setChangedFileState(NativeFileItem nativeFileItem) {
        Object object;
        APTPreprocHandler.State state = this.createPreprocHandler(nativeFileItem).getState();
        File file = nativeFileItem.getFile();
        Object object2 = object = this.getFileContainer().getLock(file);
        synchronized (object2) {
            this.getFileContainer().invalidatePreprocState(file);
            this.putPreprocState(file, state);
        }
        return state;
    }

    protected APTPreprocHandler.State getPreprocState(File file) {
        return this.getFileContainer().getPreprocState(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidatePreprocState(File file) {
        Object object;
        Object object2 = object = this.getFileContainer().getLock(file);
        synchronized (object2) {
            this.getFileContainer().invalidatePreprocState(file);
        }
    }

    public void invalidateFiles() {
        this.getFileContainer().clearState();
        for (ProjectBase projectBase : this.getLibraries()) {
            projectBase.invalidateFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileImpl onFileIncluded(ProjectBase projectBase, String string, APTPreprocHandler aPTPreprocHandler, int n) throws IOException {
        try {
            Object object;
            this.disposeLock.readLock().lock();
            if (this.disposing) {
                FileImpl fileImpl = null;
                return fileImpl;
            }
            FileImpl fileImpl = this.findFile(new File(string), 4, aPTPreprocHandler, false, null, null);
            APTFile aPTFile = this.getAPTLight(fileImpl);
            if (fileImpl != null && aPTFile != null) {
                fileImpl.initGuardIfNeeded(aPTPreprocHandler, aPTFile);
            }
            APTPreprocHandler.State state = this.updateFileStateIfNeeded(fileImpl, aPTPreprocHandler);
            if (aPTFile != null) {
                object = new APTParseFileWalker(projectBase, aPTFile, fileImpl, aPTPreprocHandler);
                object.visit();
            }
            if (state != null && !this.isDisposing() && !projectBase.isDisposing()) {
                this.scheduleIncludedFileParsing(fileImpl, state);
            }
            object = fileImpl;
            return object;
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected APTPreprocHandler.State updateFileStateIfNeeded(FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
        Object object;
        APTPreprocHandler.State state = null;
        File file = fileImpl.getBuffer().getFile();
        Object object2 = object = this.getFileContainer().getLock(file);
        synchronized (object2) {
            if (fileImpl.isNeedReparse(this.getPreprocState(file), aPTPreprocHandler)) {
                state = aPTPreprocHandler.getState();
                this.putPreprocState(file, state);
                fileImpl.stateChanged(true);
            }
        }
        return state;
    }

    public ProjectBase findFileProject(CharSequence charSequence) {
        this.ensureFilesCreated();
        File file = new File(((Object)charSequence).toString());
        if (this.getFile(file) != null) {
            return this;
        }
        for (CsmProject csmProject : this.getLibraries()) {
            ((ProjectBase)csmProject).ensureFilesCreated();
            if (((ProjectBase)csmProject).getFile(file) == null) continue;
            return (ProjectBase)csmProject;
        }
        return null;
    }

    public boolean isMySource(String string) {
        return this.projectRoots.isMySource(string);
    }

    public abstract void onFileAdded(NativeFileItem var1);

    public abstract void onFileAdded(List<NativeFileItem> var1);

    public abstract void onFileRemoved(FileImpl var1);

    public abstract void onFileRemoved(List<NativeFileItem> var1);

    public abstract void onFilePropertyChanged(NativeFileItem var1);

    public abstract void onFilePropertyChanged(List<NativeFileItem> var1);

    protected abstract void scheduleIncludedFileParsing(FileImpl var1, APTPreprocHandler.State var2);

    public abstract NativeFileItem getNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void putNativeFileItem(CsmUID<CsmFile> var1, NativeFileItem var2);

    protected abstract void removeNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void clearNativeFileContainer();

    public void onFileRemoved(File file) {
        this.onFileRemoved(this.getFile(file));
    }

    public void onFileExternalChange(FileImpl fileImpl) {
        DeepReparsingUtils.reparseOnEdit(fileImpl, this);
    }

    public CsmFile findFile(CharSequence charSequence) {
        File file = new File(((Object)charSequence).toString());
        APTPreprocHandler aPTPreprocHandler = null;
        if (this.getPreprocState(file) == null) {
            NativeProject nativeProject;
            NativeFileItem nativeFileItem = null;
            if (this.getPlatformProject() instanceof NativeProject && (nativeProject = (NativeProject)this.getPlatformProject()) != null) {
                nativeFileItem = nativeProject.findFileItem(file);
                if (nativeFileItem == null) {
                    return null;
                }
                if (!this.acceptNativeItem(nativeFileItem)) {
                    return null;
                }
                aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
            }
            if (aPTPreprocHandler != null) {
                return this.findFile(file, 0, aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
            }
        }
        return this.findFile(file, 0, aPTPreprocHandler, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileImpl findFile(File file, int n, APTPreprocHandler aPTPreprocHandler, boolean bl, APTPreprocHandler.State state, NativeFileItem nativeFileItem) {
        Object object;
        Object object2;
        FileImpl fileImpl = this.getFile(file);
        if (fileImpl == null) {
            object2 = this.getFileContainer();
            synchronized (object2) {
                fileImpl = this.getFile(file);
                if (fileImpl == null) {
                    aPTPreprocHandler = aPTPreprocHandler == null ? this.getPreprocHandler(file) : aPTPreprocHandler;
                    fileImpl = new FileImpl(ModelSupport.getFileBuffer(file), this, n, nativeFileItem);
                    if (nativeFileItem != null) {
                        this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
                    }
                    this.putFile(file, fileImpl, state);
                    if (bl) {
                        object = aPTPreprocHandler == null ? null : aPTPreprocHandler.getState();
                        ParserQueue.instance().add(fileImpl, (APTPreprocHandler.State)object, ParserQueue.Position.TAIL);
                    }
                }
            }
        }
        if (n == 1 && !fileImpl.isSourceFile()) {
            fileImpl.setSourceFile();
        } else if (n == 4 && !fileImpl.isHeaderFile()) {
            fileImpl.setHeaderFile();
        }
        object = object2 = this.getFileContainer().getLock(file);
        synchronized (object) {
            if (state != null && this.getPreprocState(file) == null) {
                this.putPreprocState(file, state);
            }
        }
        return fileImpl;
    }

    protected FileImpl createOrFindFileImpl(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        return this.createOrFindFileImpl((FileBuffer)fileBuffer, (NativeFileItem)nativeFileItem, (int)ProjectBase.getFileType((NativeFileItem)nativeFileItem)).fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAndHandler createOrFindFileImpl(FileBuffer fileBuffer, NativeFileItem nativeFileItem, int n) {
        APTPreprocHandler aPTPreprocHandler = null;
        File file = fileBuffer.getFile();
        FileImpl fileImpl = this.getFile(file);
        if (fileImpl == null) {
            FileContainer fileContainer = this.getFileContainer();
            synchronized (fileContainer) {
                fileImpl = this.getFile(file);
                if (fileImpl == null) {
                    aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
                    assert (aPTPreprocHandler != null);
                    fileImpl = new FileImpl(fileBuffer, this, n, nativeFileItem);
                    this.putFile(file, fileImpl, aPTPreprocHandler.getState());
                } else {
                    this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
                }
            }
        } else {
            this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
        }
        return new FileAndHandler(fileImpl, aPTPreprocHandler);
    }

    public FileImpl getFile(File file) {
        return this.getFileContainer().getFile(file);
    }

    protected void removeFile(File file) {
        this.getFileContainer().removeFile(file);
    }

    protected void putFile(File file, FileImpl fileImpl, APTPreprocHandler.State state) {
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        }
        this.getFileContainer().putFile(file, fileImpl, state);
    }

    protected Collection<Key> getLibrariesKeys() {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        if (this.platformProject instanceof NativeProject) {
            for (NativeProject nativeProject : ((NativeProject)this.platformProject).getDependences()) {
                Key key = KeyUtilities.createProjectKey(((Object)ProjectBase.getUniqueName(nativeProject)).toString());
                if (key == null) continue;
                arrayList.add(key);
            }
        }
        if (!this.isArtificial()) {
            for (CsmUID csmUID : LibraryManager.getInstance().getLirariesKeys(this.getUID())) {
                arrayList.add(RepositoryUtils.UIDtoKey(csmUID));
            }
        }
        return arrayList;
    }

    public Collection<CsmProject> getLibraries() {
        ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>();
        if (this.platformProject instanceof NativeProject) {
            for (NativeProject object : ((NativeProject)this.platformProject).getDependences()) {
                CsmProject csmProject = this.model.findProject(object);
                if (csmProject == null) continue;
                arrayList.add(csmProject);
            }
        }
        if (!this.isArtificial()) {
            for (LibProjectImpl libProjectImpl : LibraryManager.getInstance().getLibraries((ProjectImpl)this)) {
                arrayList.add(libProjectImpl);
            }
        }
        return arrayList;
    }

    public List<ProjectBase> getDependentProjects() {
        ArrayList<ProjectBase> arrayList = new ArrayList<ProjectBase>();
        for (CsmProject csmProject : this.model.projects()) {
            if (!(csmProject instanceof ProjectBase) || !csmProject.getLibraries().contains(this)) continue;
            arrayList.add((ProjectBase)csmProject);
        }
        return arrayList;
    }

    public CsmClass getDummyForUnresolved(CharSequence[] charSequenceArray, CsmFile csmFile, int n) {
        if (Diagnostic.needStatistics()) {
            Diagnostic.onUnresolvedError(charSequenceArray, csmFile, n);
        }
        return this.getUnresolved().getDummyForUnresolved(charSequenceArray);
    }

    public CsmClass getDummyForUnresolved(String string) {
        return this.getUnresolved().getDummyForUnresolved(string);
    }

    public CsmNamespace getUnresolvedNamespace() {
        return this.getUnresolved().getUnresolvedNamespace();
    }

    public CsmFile getUnresolvedFile() {
        return this.getUnresolved().getUnresolvedFile();
    }

    private Unresolved getUnresolved() {
        if (this.unresolved == null) {
            this.unresolved = new Unresolved(this);
        }
        return this.unresolved;
    }

    public boolean isValid() {
        return this.platformProject != null && !this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisposed() {
        this.disposing = true;
        Object object = this.initializationTaskLock;
        synchronized (object) {
            if (this.initializationTask != null) {
                this.initializationTask.cancel();
                this.initializationTask = null;
            }
        }
        this.unregisterProjectListeners();
        ParserQueue.instance().removeAll(this);
    }

    public boolean isDisposing() {
        return this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean bl) {
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("\n\nProject %s: disposing...\n", this.name);
            l = System.currentTimeMillis();
        }
        this.setDisposed();
        try {
            this.disposeLock.writeLock().lock();
            ProjectSettingsValidator projectSettingsValidator = new ProjectSettingsValidator(this);
            projectSettingsValidator.storeSettings();
            RepositoryUtils.closeUnit(this.getUID(), this.getRequiredUnits(), bl);
            this.platformProject = null;
            this.unresolved = null;
            this.uid = null;
        }
        finally {
            this.disposeLock.writeLock().unlock();
        }
        if (TraceFlags.TIMING) {
            l = System.currentTimeMillis() - l;
            System.err.printf("Project %s: disposing took %d ms\n", this.name, l);
        }
    }

    protected Set<String> getRequiredUnits() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Key key : this.getLibrariesKeys()) {
            hashSet.add(((Object)key.getUnit()).toString());
        }
        return hashSet;
    }

    private void disposeFiles() {
        Collection<FileImpl> collection = this.getFileContainer().getFileImpls();
        this.getFileContainer().clear();
        for (FileImpl fileImpl : collection) {
            fileImpl.onProjectDispose();
            if (TraceFlags.USE_AST_CACHE) {
                CacheManager.getInstance().invalidate(fileImpl);
                continue;
            }
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)fileImpl.getBuffer());
        }
        this.clearNativeFileContainer();
    }

    private NamespaceImpl _getGlobalNamespace() {
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.globalNamespaceUID);
        if (namespaceImpl == null) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get global namespace by key " + this.globalNamespaceUID));
        }
        return namespaceImpl;
    }

    private NamespaceImpl _getNamespace(CharSequence charSequence) {
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        CsmUID<CsmNamespace> csmUID = this.namespaces.get(charSequence);
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(csmUID);
        return namespaceImpl;
    }

    private void _registerNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CharSequence charSequence = namespaceImpl.getQualifiedName();
        assert (charSequence != null && !(charSequence instanceof String));
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)namespaceImpl);
        assert (csmUID != null);
        this.namespaces.put(charSequence, (CsmUID<CsmNamespace>)csmUID);
    }

    private void _unregisterNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        assert (!namespaceImpl.isGlobal());
        CharSequence charSequence = namespaceImpl.getQualifiedName();
        assert (charSequence != null && !(charSequence instanceof String));
        CsmUID<CsmNamespace> csmUID = this.namespaces.remove(charSequence);
        assert (csmUID != null);
        RepositoryUtils.remove(csmUID);
    }

    protected ModelImpl getModel() {
        return this.model;
    }

    public void onFileEditStart(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
    }

    public void onFileEditEnd(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
    }

    public final CsmUID<CsmProject> getUID() {
        if (this.uid == null) {
            this.uid = UIDUtilities.createProjectUID(this);
        }
        return this.uid;
    }

    public boolean isStable(CsmFile csmFile) {
        if (this.status == Status.Ready && !this.disposing) {
            return !ParserQueue.instance().hasFiles(this, (FileImpl)csmFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onParseFinish() {
        Iterator<CsmFile> iterator = this.waitParseLock;
        synchronized (iterator) {
            this.waitParseLock.notifyAll();
        }
        try {
            this.disposeLock.readLock().lock();
            if (!this.disposing) {
                for (FileImpl fileImpl : this.getAllFiles()) {
                    fileImpl.fixFakeRegistrations();
                }
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            this.disposeLock.readLock().unlock();
            ProjectComponent.setStable(this.declarationsSorageKey);
            ProjectComponent.setStable(this.fileContainerKey);
            ProjectComponent.setStable(this.graphStorageKey);
        }
    }

    public Collection<CsmFile> getAllFiles() {
        return this.getFileContainer().getFiles();
    }

    public Collection<FileImpl> getAllFileImpls() {
        return this.getFileContainer().getFileImpls();
    }

    public Collection<CsmFile> getSourceFiles() {
        ArrayList arrayList = new ArrayList();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (!fileImpl.isSourceFile()) continue;
            arrayList.add(fileImpl.getUID());
        }
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public Collection<CsmFile> getHeaderFiles() {
        ArrayList arrayList = new ArrayList();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (fileImpl.isSourceFile()) continue;
            arrayList.add(fileImpl.getUID());
        }
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public long getMemoryUsageEstimation() {
        return this.getFileContainer().getSize();
    }

    public String toString() {
        return ((Object)this.getName()).toString() + ' ' + this.getClass().getName() + " @" + this.hashCode();
    }

    private StartEntryInfo getStartEntryInfo(APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        NativeFileItem nativeFileItem;
        FileImpl fileImpl;
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase projectBase = ProjectBase.getStartProject(startEntry);
        FileImpl fileImpl2 = fileImpl = projectBase == null ? null : projectBase.getFile(new File(startEntry.getStartFile()));
        if (fileImpl != null && (nativeFileItem = fileImpl.getNativeFileItem()) != null) {
            aPTPreprocHandler = projectBase.createPreprocHandler(nativeFileItem);
        }
        return new StartEntryInfo(aPTPreprocHandler, projectBase, fileImpl);
    }

    private APTPreprocHandler restorePreprocHandler(File file, APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        assert (state != null);
        assert (state.isCleaned());
        List list = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
        assert (list != null);
        if (list.isEmpty()) {
            if (TRACE_PP_STATE_OUT) {
                System.err.println("stack is empty; return default for " + file);
            }
            return this.getStartEntryInfo((APTPreprocHandler)aPTPreprocHandler, (APTPreprocHandler.State)state).preprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.println("restoring for " + file);
        }
        assert (!list.isEmpty()) : "state of stack is " + list;
        Stack stack = ProjectBase.reverse(list);
        StartEntryInfo startEntryInfo = this.getStartEntryInfo(aPTPreprocHandler, state);
        FileImpl fileImpl = startEntryInfo.csmFile;
        ProjectBase projectBase = startEntryInfo.startProject;
        aPTPreprocHandler = startEntryInfo.preprocHandler;
        APTFile aPTFile = null;
        try {
            aPTFile = fileImpl == null ? null : this.getAPTLight(fileImpl);
        }
        catch (IOException iOException) {
            System.err.println("can't restore preprocessor state for " + file + "\nreason: " + iOException.getMessage());
            DiagnosticExceptoins.register(iOException);
        }
        boolean bl = false;
        if (aPTFile != null) {
            long l = REMEMBER_RESTORED ? System.currentTimeMillis() : 0L;
            int n = stack.size();
            APTRestorePreprocStateWalker aPTRestorePreprocStateWalker = new APTRestorePreprocStateWalker(projectBase, aPTFile, fileImpl, aPTPreprocHandler, stack, FileContainer.getFileKey(file, false));
            aPTRestorePreprocStateWalker.visit();
            if (aPTPreprocHandler.isValid()) {
                if (REMEMBER_RESTORED) {
                    if (testRestoredFiles == null) {
                        testRestoredFiles = new ArrayList<String>();
                    }
                    FileImpl fileImpl2 = this.getFile(file);
                    assert (fileImpl2 != null);
                    String string = file.getAbsolutePath() + " [" + (fileImpl2.isHeaderFile() ? "H" : (fileImpl2.isSourceFile() ? "S" : "U")) + "]";
                    l = System.currentTimeMillis() - l;
                    string = string + " within " + l + "ms" + " stack " + n + " elems";
                    System.err.println("#" + testRestoredFiles.size() + " restored: " + string);
                    testRestoredFiles.add(string);
                }
                if (TRACE_PP_STATE_OUT) {
                    System.err.println("after restoring " + aPTPreprocHandler);
                }
                bl = true;
            }
        }
        if (!bl) {
            if (projectBase == null) {
                projectBase = this;
            }
            aPTPreprocHandler = projectBase.createDefaultPreprocHandler(file);
        }
        return aPTPreprocHandler;
    }

    private NativeProject findNativeProjectHolder(Set<ProjectBase> set) {
        NativeProject nativeProject;
        block1: {
            set.add(this);
            nativeProject = ModelSupport.getNativeProject(this.getPlatformProject());
            if (nativeProject != null) break block1;
            List<ProjectBase> list = this.getDependentProjects();
            for (ProjectBase projectBase : list) {
                if (!set.contains(projectBase) && (nativeProject = projectBase.findNativeProjectHolder(set)) != null) break;
            }
        }
        return nativeProject;
    }

    private APTPreprocHandler createDefaultPreprocHandler(File file) {
        NativeProject nativeProject = this.findNativeProjectHolder(new HashSet<ProjectBase>(10));
        APTPreprocHandler aPTPreprocHandler = null;
        if (nativeProject != null) {
            DefaultFileItem defaultFileItem = new DefaultFileItem(nativeProject, file.getAbsolutePath());
            aPTPreprocHandler = this.createPreprocHandler(defaultFileItem);
        } else {
            aPTPreprocHandler = this.createEmptyPreprocHandler(file);
        }
        assert (aPTPreprocHandler != null) : "failed creating default ppState for " + file;
        return aPTPreprocHandler;
    }

    private static <T> Stack<T> reverse(List<T> list) {
        Stack<T> stack = new Stack<T>();
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            stack.push(t);
        }
        return stack;
    }

    public static NativeFileItem getCompiledFileItem(FileImpl fileImpl) {
        NativeFileItem nativeFileItem = null;
        ProjectBase projectBase = fileImpl.getProjectImpl();
        if (projectBase != null) {
            APTPreprocHandler.State state = projectBase.getPreprocState(fileImpl);
            FileImpl fileImpl2 = ProjectBase.getStartFile(state);
            nativeFileItem = fileImpl2 != null ? fileImpl2.getNativeFileItem() : null;
        }
        return nativeFileItem;
    }

    public static FileImpl getStartFile(APTPreprocHandler.State state) {
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase projectBase = ProjectBase.getStartProject(startEntry);
        FileImpl fileImpl = projectBase == null ? null : projectBase.getFile(new File(startEntry.getStartFile()));
        return fileImpl;
    }

    public static ProjectBase getStartProject(APTPreprocHandler.State state) {
        return ProjectBase.getStartProject(APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state));
    }

    public static ProjectBase getStartProject(StartEntry startEntry) {
        Key key = startEntry.getStartFileProject();
        ProjectBase projectBase = (ProjectBase)RepositoryUtils.get(key);
        return projectBase;
    }

    public APTFile getAPTLight(CsmFile csmFile) throws IOException {
        APTFile aPTFile = null;
        aPTFile = TraceFlags.USE_AST_CACHE ? CacheManager.getInstance().findAPTLight(csmFile) : APTDriver.getInstance().findAPTLight((APTFileBuffer)((FileImpl)csmFile).getBuffer());
        return aPTFile;
    }

    public GraphContainer getGraph() {
        return this.getGraphStorage();
    }

    public static List testGetRestoredFiles() {
        return testRestoredFiles;
    }

    public void write(DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        dataOutput.writeUTF(((Object)RepositoryUtils.getUnitName(this.getUID())).toString());
        uIDObjectFactory.writeUID(this.globalNamespaceUID, dataOutput);
        uIDObjectFactory.writeStringToUIDMap(this.namespaces, dataOutput, false);
        this.classifierContainer.write(dataOutput);
        ProjectComponent.writeKey(this.fileContainerKey, dataOutput);
        ProjectComponent.writeKey(this.declarationsSorageKey, dataOutput);
        ProjectComponent.writeKey(this.graphStorageKey, dataOutput);
        PersistentUtils.writeUTF(this.uniqueName, dataOutput);
    }

    protected ProjectBase(DataInput dataInput) throws IOException {
        this.setStatus(Status.Restored);
        assert (dataInput != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null) : "default UID factory can not be bull";
        this.name = ProjectNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null) : "project name can not be null";
        String string = dataInput.readUTF();
        this.globalNamespaceUID = uIDObjectFactory.readUID(dataInput);
        assert (this.globalNamespaceUID != null) : "globalNamespaceUID can not be null";
        uIDObjectFactory.readStringToUIDMap(this.namespaces, dataInput, QualifiedNameCache.getManager());
        this.classifierContainer = new ClassifierContainer(dataInput);
        this.fileContainerKey = ProjectComponent.readKey(dataInput);
        assert (this.fileContainerKey != null) : "fileContainerKey can not be null";
        this.declarationsSorageKey = ProjectComponent.readKey(dataInput);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.graphStorageKey = ProjectComponent.readKey(dataInput);
        assert (this.graphStorageKey != null) : "graphStorageKey can not be null";
        this.uniqueName = PersistentUtils.readUTF(dataInput);
        assert (this.uniqueName != null) : "uniqueName can not be null";
        this.uniqueName = ProjectNameCache.getManager().getString(this.uniqueName);
        this.model = (ModelImpl)CsmModelAccessor.getModel();
    }

    DeclarationContainer getDeclarationsSorage() {
        DeclarationContainer declarationContainer = (DeclarationContainer)RepositoryUtils.get(this.declarationsSorageKey);
        if (declarationContainer == null) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get DeclarationsSorage by key " + this.declarationsSorageKey));
        }
        return declarationContainer;
    }

    FileContainer getFileContainer() {
        FileContainer fileContainer = (FileContainer)RepositoryUtils.get(this.fileContainerKey);
        if (fileContainer == null) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get FileContainer by key " + this.fileContainerKey));
        }
        return fileContainer;
    }

    public GraphContainer getGraphStorage() {
        GraphContainer graphContainer = (GraphContainer)RepositoryUtils.get(this.graphStorageKey);
        if (graphContainer == null) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get GraphContainer by key " + this.graphStorageKey));
        }
        return graphContainer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Status {
        Initial,
        Restored,
        AddingFiles,
        Validating,
        Ready;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class DefaultFileItem
    implements NativeFileItem {
        private NativeProject project;
        private String absolutePath;

        public DefaultFileItem(NativeProject nativeProject, String string) {
            this.project = nativeProject;
            this.absolutePath = string;
        }

        public DefaultFileItem(NativeFileItem nativeFileItem) {
            this.project = nativeFileItem.getNativeProject();
            this.absolutePath = nativeFileItem.getFile().getAbsolutePath();
        }

        public static NativeFileItem toDefault(NativeFileItem nativeFileItem) {
            if (!(nativeFileItem instanceof DefaultFileItem)) {
                nativeFileItem = new DefaultFileItem(nativeFileItem);
            }
            return nativeFileItem;
        }

        public List<String> getUserMacroDefinitions() {
            if (this.project != null) {
                return this.project.getUserMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<String> getUserIncludePaths() {
            if (this.project != null) {
                return this.project.getUserIncludePaths();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemMacroDefinitions() {
            if (this.project != null) {
                return this.project.getSystemMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemIncludePaths() {
            if (this.project != null) {
                return this.project.getSystemIncludePaths();
            }
            return Collections.emptyList();
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public File getFile() {
            return new File(this.absolutePath);
        }

        public NativeFileItem.Language getLanguage() {
            return NativeFileItem.Language.C_HEADER;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.GENERIC;
        }

        public boolean isExcluded() {
            return false;
        }
    }

    private static class StartEntryInfo {
        public final APTPreprocHandler preprocHandler;
        public final ProjectBase startProject;
        public final FileImpl csmFile;

        public StartEntryInfo(APTPreprocHandler aPTPreprocHandler, ProjectBase projectBase, FileImpl fileImpl) {
            this.preprocHandler = aPTPreprocHandler;
            this.startProject = projectBase;
            this.csmFile = fileImpl;
        }
    }

    private static class FileAndHandler {
        public FileImpl fileImpl;
        public APTPreprocHandler preprocHandler;

        public FileAndHandler(FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
            this.fileImpl = fileImpl;
            this.preprocHandler = aPTPreprocHandler;
        }
    }
}

