/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LazyOffsPositionImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public class OffsetableBase
implements CsmOffsetable,
Disposable {
    private CsmFile fileRef;
    private final CsmUID<CsmFile> fileUID;
    private final int startPosition;
    private final int endPosition;

    protected OffsetableBase(AST aST, CsmFile csmFile) {
        this(csmFile, OffsetableBase.getStartOffset(aST), OffsetableBase.getEndOffset(aST));
    }

    protected OffsetableBase(CsmFile csmFile, CsmOffsetable csmOffsetable) {
        this(csmFile, csmOffsetable != null ? csmOffsetable.getStartOffset() : 0, csmOffsetable != null ? csmOffsetable.getEndOffset() : 0);
    }

    public OffsetableBase(CsmFile csmFile, int n, int n2) {
        this.fileUID = UIDCsmConverter.fileToUID(csmFile);
        this.fileRef = null;
        this.startPosition = n;
        this.endPosition = n2;
    }

    public int getStartOffset() {
        return this.startPosition;
    }

    public int getEndOffset() {
        return this.endPosition != 0 ? this.endPosition : this.startPosition;
    }

    public CsmOffsetable.Position getStartPosition() {
        return new LazyOffsPositionImpl((FileImpl)this.getContainingFile(), this.getStartOffset());
    }

    public CsmOffsetable.Position getEndPosition() {
        return new LazyOffsPositionImpl((FileImpl)this.getContainingFile(), this.getEndOffset());
    }

    public static int getStartOffset(AST aST) {
        CsmAST csmAST;
        if (aST != null && (csmAST = AstUtil.getFirstCsmAST(aST)) != null) {
            return csmAST.getOffset();
        }
        return 0;
    }

    protected static int getEndOffset(AST aST) {
        AST aST2;
        if (aST != null && (aST2 = AstUtil.getLastChildRecursively(aST)) instanceof CsmAST) {
            return ((CsmAST)aST2).getEndOffset();
        }
        return 0;
    }

    public CsmFile getContainingFile() {
        return this._getFile();
    }

    public CharSequence getText() {
        return this.getContainingFile().getText(this.getStartOffset(), this.getEndOffset());
    }

    public void dispose() {
        this.onDispose();
    }

    private void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.fileRef = UIDCsmConverter.UIDtoFile(this.fileUID);
            assert (this.fileRef != null) : "no object for UID " + this.fileUID;
        }
    }

    private CsmFile _getFile() {
        CsmFile csmFile = this.fileRef;
        if (csmFile == null) {
            csmFile = UIDCsmConverter.UIDtoFile(this.fileUID);
            assert (csmFile != null) : "no object for UID " + this.fileUID;
        }
        return csmFile;
    }

    protected void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.startPosition);
        dataOutput.writeInt(this.endPosition);
        assert (this.fileUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.fileUID, dataOutput);
    }

    protected OffsetableBase(DataInput dataInput) throws IOException {
        this.startPosition = dataInput.readInt();
        this.endPosition = dataInput.readInt();
        this.fileUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        assert (this.fileUID != null);
        this.fileRef = null;
    }

    protected String getOffsetString() {
        return "[" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }
}

