/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import antlr.Parser;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.cache.CacheManager;
import org.netbeans.modules.cnd.modelimpl.cache.impl.FileCacheImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.GuardBlockState;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.GuardBlockWalker;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.syntaxerr.spi.ReadOnlyTokenBuffer;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImpl
implements CsmFile,
MutableDeclarationsContainer,
ChangeListener,
Disposable,
Persistent,
SelfPersistent {
    public static final boolean reportErrors = TraceFlags.REPORT_PARSING_ERRORS | TraceFlags.DEBUG;
    private static final boolean reportParse = Boolean.getBoolean("parser.log.parse");
    private static final boolean emptyAstStatictics = Boolean.getBoolean("parser.empty.ast.statistics");
    private static final boolean SKIP_UNNECESSARY_FAKE_FIXES = false;
    public static final int UNDEFINED_FILE = 0;
    public static final int SOURCE_FILE = 1;
    public static final int SOURCE_C_FILE = 2;
    public static final int SOURCE_CPP_FILE = 3;
    public static final int HEADER_FILE = 4;
    private FileBuffer fileBuffer;
    private ProjectBase projectRef;
    private final CsmUID<CsmProject> projectUID;
    private Map<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> declarations = new TreeMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>();
    private ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private Set<CsmUID<CsmInclude>> includes = this.createIncludes();
    private ReadWriteLock includesLock = new ReentrantReadWriteLock();
    private Map<NameSortedKey, CsmUID<CsmMacro>> macros = this.createMacros();
    private ReadWriteLock macrosLock = new ReentrantReadWriteLock();
    private int errorCount = 0;
    private State state;
    private int fileType = 0;
    private final Object stateLock = new Object();
    private Collection<FunctionImplEx> fakeRegistrationsOLD = new ArrayList<FunctionImplEx>();
    private Collection<CsmUID<FunctionImplEx>> fakeRegistrationUIDs = new CopyOnWriteArrayList<CsmUID<FunctionImplEx>>();
    private final GuardBlockState guardState;
    private long lastParsed = Long.MIN_VALUE;
    private int hash;
    private ReadWriteLock staticLock = new ReentrantReadWriteLock();
    private Collection<CsmUID<CsmFunction>> staticFunctionDeclarationUIDs = new ArrayList<CsmUID<CsmFunction>>();
    private Collection<CsmUID<CsmVariable>> staticVariableUIDs = new ArrayList<CsmUID<CsmVariable>>();
    private List<CsmReference> lastMacroUsages;
    private static Hook hook = null;
    private final Object changeStateLock = new Object();
    private final String tokStreamLock = new String("TokenStream lock");
    private Reference<OffsetTokenStream> ref = new SoftReference<Object>(null);
    public static final Comparator<CsmOffsetable> START_OFFSET_COMPARATOR = new Comparator<CsmOffsetable>(){

        @Override
        public int compare(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
            int n;
            if (csmOffsetable == csmOffsetable2) {
                return 0;
            }
            int n2 = csmOffsetable.getStartOffset();
            if (n2 == (n = csmOffsetable2.getStartOffset())) {
                return 0;
            }
            return n2 - n;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return 11;
        }
    };
    private static final Comparator<CsmUID> UID_START_OFFSET_COMPARATOR = new Comparator<CsmUID>(){

        @Override
        public int compare(CsmUID csmUID, CsmUID csmUID2) {
            if (csmUID == csmUID2) {
                return 0;
            }
            Comparable comparable = (Comparable)csmUID;
            assert (comparable != null);
            return comparable.compareTo(csmUID2);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return 11;
        }
    };
    private CsmUID<CsmFile> uid = null;

    public FileImpl(FileBuffer fileBuffer, ProjectBase projectBase, int n, NativeFileItem nativeFileItem) {
        this.state = State.INITIAL;
        this.setBuffer(fileBuffer);
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        this.projectRef = null;
        this.fileType = n;
        this.guardState = new GuardBlockState();
        if (nativeFileItem != null) {
            projectBase.putNativeFileItem(this.getUID(), nativeFileItem);
        }
        Notificator.instance().registerNewFile(this);
    }

    public static void setHook(Hook hook) {
        FileImpl.hook = hook;
    }

    public final NativeFileItem getNativeFileItem() {
        return this.getProjectImpl().getNativeFileItem(this.getUID());
    }

    private ProjectBase _getProject(boolean bl) {
        ProjectBase projectBase = this.projectRef;
        if (projectBase == null) {
            projectBase = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
            if (bl) assert (projectBase != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
        }
        return projectBase;
    }

    public boolean isSourceFile() {
        return this.fileType == 1 || this.fileType == 2 || this.fileType == 3;
    }

    public boolean isCppFile() {
        return this.fileType == 3;
    }

    void setSourceFile() {
        if (this.fileType != 2 && this.fileType != 3) {
            this.fileType = 1;
        }
    }

    public boolean isHeaderFile() {
        return this.fileType == 4;
    }

    void setHeaderFile() {
        if (this.fileType == 0) {
            this.fileType = 4;
        }
    }

    public APTLanguageFilter getLanguageFilter() {
        String string = "Gnu C++ Language";
        String string2 = ((Object)this.getName()).toString();
        if (string2.length() > 2 && string2.endsWith(".c")) {
            string = "Gnu C Language";
        }
        return APTLanguageSupport.getInstance().getFilter(string);
    }

    public APTPreprocHandler getPreprocHandler() {
        return this.getProjectImpl() == null ? null : this.getProjectImpl().getPreprocHandler(this.fileBuffer.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(FileBuffer fileBuffer) {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (this.fileBuffer != null) {
                this.fileBuffer.removeChangeListener(this);
            }
            this.fileBuffer = fileBuffer;
            if (this.state != State.INITIAL) {
                this.state = State.MODIFIED;
            }
            this.fileBuffer.addChangeListener(this);
        }
    }

    public FileBuffer getBuffer() {
        return this.fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureParsed(APTPreprocHandler aPTPreprocHandler) {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case INITIAL: {
                    this.parse(aPTPreprocHandler);
                    if (!TraceFlags.DUMP_PARSE_RESULTS) break;
                    new CsmTracer().dumpModel((CsmFile)this);
                    break;
                }
                case MODIFIED: {
                    this.reparse(aPTPreprocHandler);
                    if (!TraceFlags.DUMP_PARSE_RESULTS && !TraceFlags.DUMP_REPARSE_RESULTS) break;
                    new CsmTracer().dumpModel((CsmFile)this);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        Object object = this.changeStateLock;
        synchronized (object) {
            long l;
            if (this.state == State.PARSED && (l = this.getBuffer().lastModified()) > this.lastParsed) {
                if (TraceFlags.TRACE_VALIDATION) {
                    System.err.printf("VALIDATED %s\n\t lastModified=%d\n\t   lastParsed=%d\n", this.getAbsolutePath(), l, this.lastParsed);
                }
                this.state = State.MODIFIED;
                return false;
            }
            return true;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.stateChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(boolean bl) {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (this.state != State.INITIAL) {
                this.state = State.MODIFIED;
            }
            if (bl) {
                String string = this.tokStreamLock;
                synchronized (string) {
                    this.ref = null;
                }
                if (TraceFlags.USE_AST_CACHE) {
                    CacheManager.getInstance().invalidate(this);
                } else {
                    APTDriver.getInstance().invalidateAPT((APTFileBuffer)this.getBuffer());
                }
            }
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void render(AST aST) {
        new AstRenderer(this).render(aST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparse(APTPreprocHandler aPTPreprocHandler) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = State.BEING_PARSED;
            try {
                this._reparse(aPTPreprocHandler == null ? this.getPreprocHandler() : aPTPreprocHandler);
            }
            finally {
                Object object2 = this.changeStateLock;
                synchronized (object2) {
                    if (this.state != State.MODIFIED) {
                        this.state = State.PARSED;
                    }
                }
                this.stateLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reparse(APTPreprocHandler aPTPreprocHandler) {
        String string;
        if (!ParserThreadManager.instance().isParserThread() && !ParserThreadManager.instance().isStandalone()) {
            string = "Reparsing should be done only in a special Code Model Thread!!!";
            Diagnostic.trace(string);
            new Throwable(string).printStackTrace(System.err);
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------ reparsing " + this.fileBuffer.getFile().getName());
        }
        try {
            this._clearIncludes();
            this._clearMacros();
            string = this.doParse(aPTPreprocHandler);
            if (string != null) {
                this.disposeAll(false);
                this.render((AST)string);
            }
        }
        finally {
            RepositoryUtils.put((CsmIdentifiable)this);
            if (TraceFlags.USE_DEEP_REPARSING) {
                this.getProjectImpl().getGraph().putFile(this);
            }
            Notificator.instance().registerChangedFile(this);
            Notificator.instance().flush();
        }
    }

    @Override
    public void dispose() {
        this.onDispose();
        Notificator.instance().registerRemovedFile(this);
        this.disposeAll(true);
    }

    public void onProjectDispose() {
        this.onDispose();
    }

    private void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
            assert (this.projectRef != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAll(boolean bl) {
        Collection collection;
        try {
            this.declarationsLock.writeLock().lock();
            collection = this.declarations.values();
            this.declarations = new TreeMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (bl) {
            this._clearIncludes();
            this._clearMacros();
        }
        Collection collection2 = UIDCsmConverter.UIDsToDeclarations(collection);
        Utils.disposeAll(collection2);
        RepositoryUtils.remove(collection);
    }

    private void _clearMacros() {
        Collection<CsmUID<CsmMacro>> collection = this.macros.values();
        this.macros = this.createMacros();
        RepositoryUtils.remove(collection);
    }

    private Map<NameSortedKey, CsmUID<CsmMacro>> createMacros() {
        return new TreeMap<NameSortedKey, CsmUID<CsmMacro>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearIncludes() {
        try {
            this.includesLock.writeLock().lock();
            RepositoryUtils.remove(this.includes);
            this.includes = this.createIncludes();
        }
        finally {
            this.includesLock.writeLock().unlock();
        }
    }

    private Set<CsmUID<CsmInclude>> createIncludes() {
        return new TreeSet<CsmUID<CsmInclude>>(UID_START_OFFSET_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AST parse(APTPreprocHandler aPTPreprocHandler) {
        Object object = this.stateLock;
        synchronized (object) {
            Object object2;
            AST aST;
            this.state = State.BEING_PARSED;
            try {
                aST = this._parse(aPTPreprocHandler == null ? this.getPreprocHandler() : aPTPreprocHandler);
                object2 = this.changeStateLock;
            }
            catch (Throwable throwable) {
                Object object3 = this.changeStateLock;
                synchronized (object3) {
                    if (this.state != State.MODIFIED) {
                        this.state = State.PARSED;
                    }
                }
                this.stateLock.notifyAll();
                throw throwable;
            }
            synchronized (object2) {
                if (this.state != State.MODIFIED) {
                    this.state = State.PARSED;
                }
            }
            this.stateLock.notifyAll();
            return aST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AST _parse(APTPreprocHandler aPTPreprocHandler) {
        Object object;
        if (reportErrors && !ParserThreadManager.instance().isParserThread() && !ParserThreadManager.instance().isStandalone()) {
            object = "Reparsing should be done only in a special Code Model Thread!!!";
            Diagnostic.trace(object);
            new Throwable((String)object).printStackTrace(System.err);
        }
        object = TraceFlags.TIMING_PARSE_PER_FILE_DEEP ? new Diagnostic.StopWatch() : null;
        try {
            AST aST = this.doParse(aPTPreprocHandler == null ? this.getPreprocHandler() : aPTPreprocHandler);
            if (TraceFlags.TIMING_PARSE_PER_FILE_DEEP) {
                ((Diagnostic.StopWatch)object).stopAndReport("Parsing of " + this.fileBuffer.getFile().getName() + " took \t");
            }
            if (aST != null) {
                Diagnostic.StopWatch stopWatch;
                Diagnostic.StopWatch stopWatch2 = stopWatch = TraceFlags.TIMING_PARSE_PER_FILE_DEEP ? new Diagnostic.StopWatch() : null;
                if (this.isValid()) {
                    this.render(aST);
                    if (TraceFlags.TIMING_PARSE_PER_FILE_DEEP) {
                        stopWatch.stopAndReport("Rendering of " + this.fileBuffer.getFile().getName() + " took \t");
                    }
                }
                AST aST2 = aST;
                return aST2;
            }
        }
        finally {
            if (this.isValid()) {
                RepositoryUtils.put((CsmIdentifiable)this);
            }
            if (TraceFlags.USE_DEEP_REPARSING && this.isValid()) {
                this.getProjectImpl().getGraph().putFile(this);
            }
            if (this.isValid()) {
                Notificator.instance().registerChangedFile(this);
                Notificator.instance().flush();
            } else {
                Notificator.instance().reset();
            }
        }
        return null;
    }

    private TokenStream createFullTokenStream() {
        APTPreprocHandler aPTPreprocHandler = this.getPreprocHandler();
        APTFile aPTFile = null;
        if (TraceFlags.USE_AST_CACHE) {
            aPTFile = CacheManager.getInstance().findAPT(this);
        } else {
            try {
                aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)this.fileBuffer);
            }
            catch (IOException iOException) {
                DiagnosticExceptoins.register(iOException);
            }
        }
        if (aPTFile == null) {
            return null;
        }
        ProjectBase projectBase = ProjectBase.getStartProject(aPTPreprocHandler.getState());
        if (projectBase == null) {
            System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)aPTPreprocHandler.getState()) + "\n while getting TS of file " + this.getAbsolutePath() + "\n of project " + this.getProject());
            return null;
        }
        APTParseFileWalker aPTParseFileWalker = new APTParseFileWalker(projectBase, aPTFile, this, aPTPreprocHandler);
        return aPTParseFileWalker.getFilteredTokenStream(this.getLanguageFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenStream getTokenStream(int n, int n2) {
        try {
            OffsetTokenStream offsetTokenStream;
            String string = this.tokStreamLock;
            synchronized (string) {
                offsetTokenStream = this.ref != null ? this.ref.get() : null;
                this.ref = new SoftReference<Object>(null);
            }
            if (offsetTokenStream == null || offsetTokenStream.getStartOffset() > n) {
                if (offsetTokenStream == null) {
                    // empty if block
                }
                offsetTokenStream = new OffsetTokenStream(this.createFullTokenStream());
            }
            offsetTokenStream.moveTo(n, n2);
            return offsetTokenStream;
        }
        catch (TokenStreamException tokenStreamException) {
            Utils.LOG.severe("Can't create compound statement: " + tokenStreamException.getMessage());
            DiagnosticExceptoins.register(tokenStreamException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTokenStream(TokenStream tokenStream) {
        if (tokenStream instanceof OffsetTokenStream) {
            OffsetTokenStream offsetTokenStream = (OffsetTokenStream)tokenStream;
            String string = this.tokStreamLock;
            synchronized (string) {
                if (this.ref != null && this.ref.get() == null) {
                    this.ref = new SoftReference<OffsetTokenStream>(offsetTokenStream);
                }
            }
        }
    }

    public void getErrors(ErrorListener errorListener) {
        ArrayList<RecognitionException> arrayList = new ArrayList<RecognitionException>();
        this.getErrors(arrayList);
        for (RecognitionException recognitionException : arrayList) {
            errorListener.error(recognitionException.getMessage(), recognitionException.getLine(), recognitionException.getColumn());
        }
    }

    /*
     * Loose catch block
     */
    public ReadOnlyTokenBuffer getErrors(final Collection<RecognitionException> collection) {
        ParserBasedTokenBuffer parserBasedTokenBuffer;
        block9: {
            CPPParserEx.ErrorDelegate errorDelegate = new CPPParserEx.ErrorDelegate(){

                public void onError(RecognitionException recognitionException) {
                    collection.add(recognitionException);
                }
            };
            if (TraceFlags.TRACE_ERROR_PROVIDER) {
                System.err.printf("\n\n>>> Start parsing (getting errors) %s \n", this.getName());
            }
            long l = TraceFlags.TRACE_ERROR_PROVIDER ? System.currentTimeMillis() : 0L;
            APTPreprocHandler aPTPreprocHandler = this.getPreprocHandler();
            ProjectBase projectBase = ProjectBase.getStartProject(aPTPreprocHandler.getState());
            int n = 8;
            if (!TraceFlags.TRACE_ERROR_PROVIDER) {
                n |= 4;
            }
            try {
                APTFile aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)this.getBuffer());
                APTParseFileWalker aPTParseFileWalker = new APTParseFileWalker(projectBase, aPTFile, this, aPTPreprocHandler);
                CPPParserEx cPPParserEx = CPPParserEx.getInstance(this.fileBuffer.getFile().getName(), aPTParseFileWalker.getFilteredTokenStream(this.getLanguageFilter()), n);
                cPPParserEx.setErrorDelegate(errorDelegate);
                cPPParserEx.setLazyCompound(false);
                cPPParserEx.translation_unit();
                parserBasedTokenBuffer = new ParserBasedTokenBuffer((Parser)cPPParserEx);
                if (!TraceFlags.TRACE_ERROR_PROVIDER) break block9;
            }
            catch (IOException iOException) {
                ReadOnlyTokenBuffer readOnlyTokenBuffer;
                block10: {
                    DiagnosticExceptoins.register(iOException);
                    readOnlyTokenBuffer = null;
                    if (!TraceFlags.TRACE_ERROR_PROVIDER) break block10;
                    System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
                }
                return readOnlyTokenBuffer;
            }
            catch (Error error) {
                System.err.println(error.getClass().getName() + " at parsing file " + this.fileBuffer.getFile().getAbsolutePath());
                throw error;
                {
                    catch (Throwable throwable) {
                        if (TraceFlags.TRACE_ERROR_PROVIDER) {
                            System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
                        }
                        throw throwable;
                    }
                }
            }
            System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
        }
        return parserBasedTokenBuffer;
    }

    private AST doParse(APTPreprocHandler aPTPreprocHandler) {
        Hook hook;
        Object object;
        if (reportParse || TraceFlags.DEBUG) {
            System.err.println("# APT-based AST-cached Parsing " + this.fileBuffer.getFile().getPath() + " (Thread=" + Thread.currentThread().getName() + ')');
        }
        int n = 8;
        if (!reportErrors) {
            n |= 4;
        }
        APTPreprocHandler.State state = aPTPreprocHandler.getState();
        AST aST = null;
        APTFile aPTFile = null;
        APTFile aPTFile2 = null;
        if (TraceFlags.USE_AST_CACHE) {
            object = CacheManager.getInstance().findCacheWithAST(this, aPTPreprocHandler);
            assert (object != null);
            aST = object.getAST(aPTPreprocHandler);
            aPTFile = object.getAPTLight();
            aPTFile2 = object.getAPT();
        } else {
            try {
                aPTFile2 = APTDriver.getInstance().findAPT((APTFileBuffer)this.getBuffer());
            }
            catch (FileNotFoundException fileNotFoundException) {
                APTUtils.LOG.log(Level.WARNING, "FileImpl: file {0} not found", new Object[]{this.getBuffer().getFile().getAbsolutePath()});
                DiagnosticExceptoins.register(fileNotFoundException);
            }
            catch (IOException iOException) {
                DiagnosticExceptoins.register(iOException);
            }
        }
        if (aST != null) {
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: parsing using AST and APTLight for " + this.getAbsolutePath());
            }
            assert (aPTFile != null);
            boolean bl = TraceFlags.CACHE_SKIP_APT_VISIT;
            if (!bl) {
                APTParseFileWalker aPTParseFileWalker = new APTParseFileWalker(ProjectBase.getStartProject(aPTPreprocHandler.getState()), aPTFile, this, aPTPreprocHandler);
                aPTParseFileWalker.addMacroAndIncludes(true);
                aPTParseFileWalker.visit();
            } else if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: skipped APTLight visiting");
            }
        } else if (aPTFile2 != null) {
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: parsing using full APT for " + this.getAbsolutePath());
            }
            this.updateGuardAfterParse(aPTPreprocHandler, aPTFile2);
            object = ProjectBase.getStartProject(aPTPreprocHandler.getState());
            if (object == null) {
                System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)aPTPreprocHandler.getState()) + "\n while parsing file " + this.getAbsolutePath() + "\n of project " + this.getProject());
                return null;
            }
            APTParseFileWalker aPTParseFileWalker = new APTParseFileWalker((ProjectBase)object, aPTFile2, this, aPTPreprocHandler);
            aPTParseFileWalker.addMacroAndIncludes(true);
            if (TraceFlags.DEBUG) {
                System.err.println("doParse " + this.getAbsolutePath() + " with " + ParserQueue.tracePreprocState(state));
            }
            this.clearFakeRegistrations();
            CPPParserEx cPPParserEx = CPPParserEx.getInstance(this.fileBuffer.getFile().getName(), aPTParseFileWalker.getFilteredTokenStream(this.getLanguageFilter()), n);
            long l = emptyAstStatictics ? System.currentTimeMillis() : 0L;
            try {
                cPPParserEx.translation_unit();
            }
            catch (Error error) {
                System.err.println(error.getClass().getName() + " at parsing file " + this.fileBuffer.getFile().getAbsolutePath());
                throw error;
            }
            if (emptyAstStatictics) {
                l = System.currentTimeMillis() - l;
                System.err.println("PARSED FILE " + this.getAbsolutePath() + (AstUtil.isEmpty(cPPParserEx.getAST(), true) ? " EMPTY" : "") + ' ' + l + " ms");
            }
            if (TraceFlags.DUMP_AST) {
                System.err.println("\n");
                System.err.print("AST: ");
                System.err.print(this.getAbsolutePath());
                System.err.print(' ');
                AstUtil.toStream(cPPParserEx.getAST(), System.err);
                System.err.println("\n");
            }
            this.errorCount = cPPParserEx.getErrorCount();
            aST = cPPParserEx.getAST();
            if (this.state != State.MODIFIED) {
                if (TraceFlags.USE_AST_CACHE) {
                    if (this.getBuffer().isFileBased() && !TraceFlags.CACHE_SKIP_SAVE) {
                        CacheManager.getInstance().saveCache(this, new FileCacheImpl(aPTFile, aPTFile2, aST));
                    } else if (TraceFlags.TRACE_CACHE) {
                        System.err.println("CACHE: not save cache for document based file " + this.getAbsolutePath());
                    }
                }
            } else {
                aST = null;
                if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: not save cache for file modified during parsing" + this.getAbsolutePath());
                }
            }
        }
        this.lastParsed = Math.max(System.currentTimeMillis(), this.fileBuffer.lastModified());
        this.lastMacroUsages = null;
        if (TraceFlags.TRACE_VALIDATION) {
            System.err.printf("PARSED    %s \n\tlastModified=%d\n\t  lastParsed=%d  diff=%d\n", this.getAbsolutePath(), this.fileBuffer.lastModified(), this.lastParsed, this.fileBuffer.lastModified() - this.lastParsed);
        }
        if ((hook = FileImpl.hook) != null) {
            hook.parsingFinished(this, aPTPreprocHandler);
        }
        return aST;
    }

    void initGuardIfNeeded(APTPreprocHandler aPTPreprocHandler, APTFile aPTFile) {
        if (!this.getGuardState().isInited()) {
            this.setGuardState(aPTPreprocHandler, aPTFile);
        }
    }

    private void updateGuardAfterParse(APTPreprocHandler aPTPreprocHandler, APTFile aPTFile) {
        if (!this.getGuardState().isInited()) {
            this.setGuardState(aPTPreprocHandler, aPTFile);
        } else {
            this.getGuardState().setGuardBlockState(aPTPreprocHandler, this.getGuardState().getGuard());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGuardState(APTPreprocHandler aPTPreprocHandler, APTFile aPTFile) {
        GuardBlockState guardBlockState = this.getGuardState();
        synchronized (guardBlockState) {
            GuardBlockWalker guardBlockWalker = new GuardBlockWalker(aPTFile, aPTPreprocHandler);
            TokenStream tokenStream = guardBlockWalker.getTokenStream();
            try {
                Token token = tokenStream.nextToken();
                while (!APTUtils.isEOF((Token)token)) {
                    if (!APTUtils.isCommentToken((Token)token)) {
                        guardBlockWalker.clearGuard();
                        break;
                    }
                    token = tokenStream.nextToken();
                }
            }
            catch (TokenStreamException tokenStreamException) {
                guardBlockWalker.clearGuard();
            }
            this.getGuardState().setGuardBlockState(aPTPreprocHandler, guardBlockWalker.getGuard());
        }
    }

    public List<CsmReference> getLastMacroUsages() {
        List<CsmReference> list = this.lastMacroUsages;
        if (list != null) {
            return new ArrayList<CsmReference>(list);
        }
        return list;
    }

    public void setLastMacroUsages(List<CsmReference> list) {
        this.lastMacroUsages = new ArrayList<CsmReference>(list);
    }

    public long getLastParsedTime() {
        return this.lastParsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInclude(IncludeImpl includeImpl) {
        CsmUID csmUID = RepositoryUtils.put(includeImpl);
        assert (csmUID != null);
        try {
            this.includesLock.writeLock().lock();
            this.includes.add((CsmUID<CsmInclude>)csmUID);
        }
        finally {
            this.includesLock.writeLock().unlock();
        }
    }

    public String getText(int n, int n2) {
        try {
            return this.fileBuffer.getText(n, n2);
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            return "";
        }
    }

    public String getText() {
        try {
            return this.fileBuffer.getText();
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            return "";
        }
    }

    public CsmProject getProject() {
        return this._getProject(true);
    }

    public ProjectBase getProjectImpl() {
        return this._getProject(true);
    }

    public CharSequence getName() {
        return CharSequenceKey.create((CharSequence)this.fileBuffer.getFile().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInclude> getIncludes() {
        Collection<CsmInclude> collection;
        try {
            this.includesLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToIncludes(this.includes);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmInclude> getIncludes(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmInclude> iterator;
        try {
            this.includesLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToIncludes(this.includes, csmFilter);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> collection;
        this.fixFakeRegistrations();
        try {
            this.declarationsLock.readLock().lock();
            Collection collection2 = this.declarations.values();
            collection = UIDCsmConverter.UIDsToDeclarations(collection2);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmOffsetableDeclaration> iterator;
        this.fixFakeRegistrations();
        try {
            this.declarationsLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations.values(), csmFilter);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(CsmMacro csmMacro) {
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmMacro);
        assert (csmUID != null);
        try {
            this.macrosLock.writeLock().lock();
            this.macros.put(new NameSortedKey(csmMacro), (CsmUID<CsmMacro>)csmUID);
        }
        finally {
            this.macrosLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmMacro> getMacros() {
        Collection<CsmMacro> collection;
        try {
            this.macrosLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToMacros(this.macros.values());
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmMacro> iterator;
        try {
            this.macrosLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToMacros(this.macros.values(), csmFilter);
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmMacro>> findMacroUids(String string) {
        ArrayList<CsmUID<CsmMacro>> arrayList = new ArrayList<CsmUID<CsmMacro>>(2);
        NameSortedKey nameSortedKey = NameSortedKey.getStartKey(string);
        NameSortedKey nameSortedKey2 = NameSortedKey.getEndKey(string);
        try {
            this.macrosLock.readLock().lock();
            for (Map.Entry entry : ((TreeMap)this.macros).subMap(nameSortedKey, nameSortedKey2).entrySet()) {
                arrayList.add((CsmUID<CsmMacro>)entry.getValue());
            }
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        OffsetableDeclarationBase offsetableDeclarationBase;
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmOffsetableDeclaration);
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.put(this.getOffsetSortKey(csmOffsetableDeclaration), (CsmUID<CsmOffsetableDeclaration>)csmUID);
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (csmOffsetableDeclaration instanceof VariableImpl && !NamespaceImpl.isNamespaceScope((VariableImpl)(offsetableDeclarationBase = (VariableImpl)csmOffsetableDeclaration), true)) {
            ((VariableImpl)offsetableDeclarationBase).setScope((CsmScope)this);
            this.addStaticVariableDeclaration(csmUID);
        }
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetableDeclaration) && !NamespaceImpl.isNamespaceScope((FunctionImpl)(offsetableDeclarationBase = (FunctionImpl)csmOffsetableDeclaration))) {
            ((FunctionImpl)offsetableDeclarationBase).setScope((CsmScope)this);
            this.addStaticFunctionDeclaration(csmUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticFunctionDeclaration(CsmUID csmUID) {
        try {
            this.staticLock.writeLock().lock();
            this.staticFunctionDeclarationUIDs.add((CsmUID<CsmFunction>)csmUID);
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticVariableDeclaration(CsmUID csmUID) {
        try {
            this.staticLock.writeLock().lock();
            this.staticVariableUIDs.add((CsmUID<CsmVariable>)csmUID);
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFunction> getStaticFunctionDeclarations() {
        Collection<CsmFunction> collection;
        try {
            this.staticLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToDeclarations(this.staticFunctionDeclarationUIDs);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmFunction> getStaticFunctionDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmFunction> iterator;
        try {
            this.staticLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.staticFunctionDeclarationUIDs, csmFilter);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmVariable> getStaticVariableDeclarations() {
        Collection<CsmVariable> collection;
        try {
            this.staticLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToDeclarations(this.staticVariableUIDs);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmVariable> getStaticVariableDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmVariable> iterator;
        try {
            this.staticLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.staticVariableUIDs, csmFilter);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return iterator;
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        this._removeDeclaration(csmOffsetableDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID;
        try {
            this.declarationsLock.writeLock().lock();
            csmUID = this.declarations.remove(this.getOffsetSortKey(csmOffsetableDeclaration));
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        RepositoryUtils.remove(csmUID);
        RepositoryUtils.put((CsmIdentifiable)this);
    }

    private OffsetSortedKey getOffsetSortKey(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return new OffsetSortedKey(csmOffsetableDeclaration);
    }

    private NameSortedKey getOffsetSortKey(CsmMacro csmMacro) {
        return new NameSortedKey(csmMacro);
    }

    public String getAbsolutePath() {
        return this.fileBuffer.getFile().getAbsolutePath();
    }

    public File getFile() {
        return this.fileBuffer.getFile();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        for (CsmDeclaration csmDeclaration : this.getDeclarations()) {
            VariableImpl variableImpl;
            if (!(csmDeclaration instanceof VariableImpl) || NamespaceImpl.isNamespaceScope(variableImpl = (VariableImpl)csmDeclaration, true)) continue;
            arrayList.add((CsmScopeElement)variableImpl);
        }
        return arrayList;
    }

    public boolean isValid() {
        ProjectBase projectBase = this._getProject(false);
        return projectBase != null && projectBase.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state == State.PARSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsingOrParsed() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state == State.PARSED || this.state == State.BEING_PARSED;
        }
    }

    public void scheduleParsing(boolean bl) throws InterruptedException {
        this.scheduleParsing(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleParsing(boolean bl, APTPreprocHandler.State state) throws InterruptedException {
        boolean bl2 = false;
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.isParsed()) {
                ParserQueue.instance().add(this, state, ParserQueue.Position.HEAD);
                if (bl) {
                    this.stateLock.wait();
                    continue;
                }
                return;
            }
        }
    }

    public void onFakeRegisration(FunctionImplEx functionImplEx) {
        CsmUID<FunctionImplEx> csmUID = UIDCsmConverter.declarationToUID(functionImplEx);
        this.fakeRegistrationUIDs.add(csmUID);
    }

    private void clearFakeRegistrations() {
        this.fakeRegistrationUIDs.clear();
    }

    public void fixFakeRegistrations() {
        if (this.fakeRegistrationUIDs.size() == 0 || !this.isValid()) {
            return;
        }
        if (this.fakeRegistrationUIDs.size() > 0) {
            ArrayList<CsmUID<FunctionImplEx>> arrayList = new ArrayList<CsmUID<FunctionImplEx>>(this.fakeRegistrationUIDs);
            this.fakeRegistrationUIDs.clear();
            for (CsmUID csmUID : arrayList) {
                CsmDeclaration csmDeclaration = (CsmDeclaration)csmUID.getObject();
                if (csmDeclaration == null) continue;
                if (csmDeclaration instanceof FunctionImplEx) {
                    ((FunctionImplEx)csmDeclaration).fixFakeRegistration();
                    continue;
                }
                DiagnosticExceptoins.register(new Exception("Incorrect fake registration class: " + csmDeclaration.getClass()));
            }
        }
    }

    public String toString() {
        return "FileImpl @" + this.hashCode() + ' ' + this.getAbsolutePath();
    }

    public CsmUID<CsmFile> getUID() {
        if (this.uid == null) {
            this.uid = UIDUtilities.createFileUID(this);
        }
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput dataOutput) throws IOException {
        PersistentUtils.writeBuffer(this.fileBuffer, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        try {
            this.declarationsLock.readLock().lock();
            uIDObjectFactory.writeOffsetSortedToUIDMap(this.declarations, dataOutput, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        try {
            this.includesLock.readLock().lock();
            uIDObjectFactory.writeUIDCollection(this.includes, dataOutput, false);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        try {
            this.macrosLock.readLock().lock();
            uIDObjectFactory.writeNameSortedToUIDMap(this.macros, dataOutput, false);
        }
        finally {
            this.macrosLock.readLock().unlock();
        }
        uIDObjectFactory.writeUIDCollection(this.fakeRegistrationUIDs, dataOutput, false);
        dataOutput.writeInt(this.fileType);
        assert (this.projectUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.projectUID, dataOutput);
        this.guardState.write(dataOutput);
        dataOutput.writeLong(this.lastParsed);
        dataOutput.writeUTF(this.state.toString());
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.staticFunctionDeclarationUIDs, dataOutput, false);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.staticVariableUIDs, dataOutput, false);
    }

    public FileImpl(DataInput dataInput) throws IOException {
        this.fileBuffer = PersistentUtils.readBuffer(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.readOffsetSortedToUIDMap(this.declarations, dataInput, null);
        uIDObjectFactory.readUIDCollection(this.includes, dataInput);
        uIDObjectFactory.readNameSortedToUIDMap(this.macros, dataInput, null);
        uIDObjectFactory.readUIDCollection(this.fakeRegistrationUIDs, dataInput);
        this.fileType = dataInput.readInt();
        this.projectUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        assert (this.projectUID != null);
        this.projectRef = null;
        assert (this.fileBuffer != null);
        assert (this.fileBuffer.isFileBased());
        this.guardState = new GuardBlockState(dataInput);
        this.lastParsed = dataInput.readLong();
        this.state = State.valueOf(dataInput.readUTF());
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.staticFunctionDeclarationUIDs, dataInput);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.staticVariableUIDs, dataInput);
    }

    public int hashCode() {
        if (this.hash == 0) {
            String string = this.getProjectImpl().getUniqueName() + "*" + this.getAbsolutePath();
            this.hash = string.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FileImpl)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        FileImpl fileImpl = (FileImpl)object;
        if (this.getAbsolutePath().equals(fileImpl.getAbsolutePath())) {
            return this.getProjectImpl().getUniqueName().equals(fileImpl.getProjectImpl().getUniqueName());
        }
        return false;
    }

    private GuardBlockState getGuardState() {
        return this.guardState;
    }

    public GuardBlockState testGetGuardState() {
        return this.guardState;
    }

    public boolean isNeedReparse(APTPreprocHandler.State state, APTPreprocHandler aPTPreprocHandler) {
        boolean bl = false;
        bl = state == null || !state.isValid() ? true : (!state.isCompileContext() && aPTPreprocHandler.isCompileContext() ? true : this.getGuardState().isNeedReparse(aPTPreprocHandler));
        return bl;
    }

    public boolean isNeedReparse(APTPreprocHandler.State state, APTPreprocHandler.State state2) {
        if (state == null || !state.isValid()) {
            return true;
        }
        return state.isCompileContext() ? state2 != null && this.isNeedReparseGuardBlock(state2) : state2 != null && state2.isCompileContext();
    }

    private boolean isNeedReparseGuardBlock(APTPreprocHandler.State state) {
        StartEntry startEntry = new StartEntry(this.getAbsolutePath(), RepositoryUtils.UIDtoKey(this.getProject().getUID()));
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createEmptyPreprocHandler((StartEntry)startEntry);
        aPTPreprocHandler.setState(state);
        return this.getGuardState().isNeedReparse(aPTPreprocHandler);
    }

    public int getOffset(int n, int n2) {
        int n3;
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("line and column are 1-based");
        }
        int n4 = 1;
        String string = this.getText();
        for (n3 = 0; n3 < string.length() && n4 < n; ++n3) {
            if (string.charAt(n3) != '\n') continue;
            ++n4;
        }
        if (n4 < n) {
            throw new IllegalStateException("no line with index " + n + " in file " + this.getAbsolutePath());
        }
        int n5 = n3 + (n2 - 1);
        if (string.length() < n5 || string.substring(n3, n5).indexOf(10) >= 0) {
            throw new IllegalStateException("no column with index " + n2 + " in file " + this.getAbsolutePath());
        }
        return n5;
    }

    public int[] getLineColumn(int n) {
        int[] nArray = new int[]{1, 1};
        String string = this.getText();
        if (string.length() < n) {
            throw new IllegalArgumentException("offset is out of file length; " + (this.getBuffer().isFileBased() ? "file based" : "document based") + " file=" + this.getAbsolutePath() + ";length=" + string.length() + "; offset=" + n);
        }
        int n2 = ModelSupport.getTabSize();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                nArray[0] = nArray[0] + 1;
                nArray[1] = 1;
                continue;
            }
            if (c == '\t') {
                int n3;
                int n4 = nArray[1];
                nArray[1] = n3 = ((n4 - 1) / n2 + 1) * n2 + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameSortedKey
    implements Comparable<NameSortedKey>,
    Persistent,
    SelfPersistent {
        private int start = 0;
        private CharSequence name;

        private NameSortedKey(CsmMacro csmMacro) {
            this(csmMacro.getName(), csmMacro.getStartOffset());
        }

        private NameSortedKey(CharSequence charSequence, int n) {
            this.start = n;
            this.name = charSequence;
        }

        @Override
        public int compareTo(NameSortedKey nameSortedKey) {
            int n = CharSequenceKey.Comparator.compare(this.name, nameSortedKey.name);
            if (n == 0) {
                n = this.start - nameSortedKey.start;
            }
            return n;
        }

        public static NameSortedKey getStartKey(CharSequence charSequence) {
            return new NameSortedKey(CharSequenceKey.create((CharSequence)charSequence), 0);
        }

        public static NameSortedKey getEndKey(CharSequence charSequence) {
            return new NameSortedKey(CharSequenceKey.create((CharSequence)charSequence), Integer.MAX_VALUE);
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.start);
            dataOutput.writeUTF(((Object)this.name).toString());
        }

        public NameSortedKey(DataInput dataInput) throws IOException {
            this.start = dataInput.readInt();
            this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OffsetSortedKey
    implements Comparable<OffsetSortedKey>,
    Persistent,
    SelfPersistent {
        private int start = 0;
        private CharSequence name;

        private OffsetSortedKey(CsmOffsetableDeclaration csmOffsetableDeclaration) {
            this.start = csmOffsetableDeclaration.getStartOffset();
            this.name = csmOffsetableDeclaration.getName();
        }

        @Override
        public int compareTo(OffsetSortedKey offsetSortedKey) {
            int n = this.start - offsetSortedKey.start;
            if (n == 0) {
                n = CharSequenceKey.Comparator.compare(this.name, offsetSortedKey.name);
            }
            return n;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.start);
            dataOutput.writeUTF(((Object)this.name).toString());
        }

        public OffsetSortedKey(DataInput dataInput) throws IOException {
            this.start = dataInput.readInt();
            this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        }
    }

    private static class ParserBasedTokenBuffer
    implements ReadOnlyTokenBuffer {
        Parser parser;

        public ParserBasedTokenBuffer(Parser parser) {
            this.parser = parser;
        }

        public int LA(int n) {
            return this.parser.LA(n);
        }

        public Token LT(int n) {
            return this.parser.LT(n);
        }
    }

    public static interface ErrorListener {
        public void error(String var1, int var2, int var3);
    }

    private static class OffsetTokenStream
    implements TokenStream {
        private final TokenStream stream;
        private Token next;
        private int endOffset;

        public OffsetTokenStream(TokenStream tokenStream) {
            this.stream = tokenStream;
        }

        public Token nextToken() throws TokenStreamException {
            Token token = this.next;
            if (token == null || token.getType() == 1 || ((APTToken)token).getOffset() > this.endOffset) {
                token = APTUtils.EOF_TOKEN;
            } else {
                this.next = this.stream.nextToken();
            }
            return token;
        }

        public int getStartOffset() {
            return this.next == null || this.next.getType() == 1 ? Integer.MAX_VALUE : ((APTToken)this.next).getOffset();
        }

        public void moveTo(int n, int n2) throws TokenStreamException {
            this.endOffset = n2;
            assert (this.endOffset >= n);
            this.next = this.stream.nextToken();
            while (this.next != null && this.next.getType() != 1) {
                assert (this.next instanceof APTToken) : "we have only APTTokens in token stream";
                int n3 = ((APTToken)this.next).getOffset();
                if (n3 == n) break;
                this.next = this.stream.nextToken();
            }
        }
    }

    public static interface Hook {
        public void parsingFinished(CsmFile var1, APTPreprocHandler var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        PARSED,
        MODIFIED,
        BEING_PARSED;

    }
}

