/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingDeclarationImpl
extends OffsetableDeclarationBase<CsmUsingDeclaration>
implements CsmUsingDeclaration,
RawNamable,
Disposable {
    private final CharSequence name;
    private final int startOffset;
    private final CharSequence[] rawName;
    private CsmUID<CsmDeclaration> referencedDeclarationUID = null;
    private boolean lastResolveFalure;
    private final CsmUID<CsmScope> scopeUID;

    public UsingDeclarationImpl(AST aST, CsmFile csmFile, CsmScope csmScope) {
        super(aST, csmFile);
        this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
        this.name = NameCache.getManager().getString((CharSequence)aST.getText());
        this.startOffset = ((CsmAST)aST.getFirstChild()).getOffset();
        this.rawName = AstUtil.getRawNameInChildren(aST);
    }

    public CsmDeclaration getReferencedDeclaration() {
        return this.getReferencedDeclaration(null);
    }

    public CsmDeclaration getReferencedDeclaration(Resolver resolver) {
        CsmDeclaration csmDeclaration = this._getReferencedDeclaration();
        if (csmDeclaration == null && !this.lastResolveFalure) {
            this._setReferencedDeclaration(null);
            if (this.rawName != null) {
                CsmObject csmObject;
                Object object;
                ProjectBase projectBase = (ProjectBase)this.getProject();
                CsmNamespace csmNamespace = null;
                if (this.rawName.length == 1) {
                    csmNamespace = projectBase.getGlobalNamespace();
                } else if (this.rawName.length > 1) {
                    object = new CharSequence[this.rawName.length - 1];
                    System.arraycopy(this.rawName, 0, object, 0, this.rawName.length - 1);
                    csmObject = ResolverFactory.createResolver(this.getContainingFile(), this.startOffset, resolver).resolve((CharSequence[])object, 1);
                    if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
                        csmNamespace = (CsmNamespace)csmObject;
                    }
                }
                if (csmNamespace != null) {
                    object = this.rawName[this.rawName.length - 1];
                    csmObject = null;
                    CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().createNameFilter(object.toString(), true, true, false);
                    Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespace, csmFilter);
                    while (iterator.hasNext()) {
                        CsmDeclaration csmDeclaration2 = (CsmDeclaration)iterator.next();
                        if (CharSequenceKey.Comparator.compare(object, csmDeclaration2.getName()) != 0) continue;
                        if (!CsmKindUtilities.isExternVariable((CsmDeclaration)csmDeclaration2)) {
                            csmDeclaration = csmDeclaration2;
                            break;
                        }
                        csmObject = csmDeclaration2;
                    }
                    csmDeclaration = csmDeclaration == null ? csmObject : csmDeclaration;
                }
            }
            this._setReferencedDeclaration(csmDeclaration);
            this.lastResolveFalure = csmDeclaration == null;
        }
        return csmDeclaration;
    }

    private CsmDeclaration _getReferencedDeclaration() {
        CsmDeclaration csmDeclaration = UIDCsmConverter.UIDtoDeclaration(this.referencedDeclarationUID);
        return csmDeclaration;
    }

    private void _setReferencedDeclaration(CsmDeclaration csmDeclaration) {
        this.referencedDeclarationUID = UIDCsmConverter.declarationToUID(csmDeclaration);
        assert (this.referencedDeclarationUID != null || csmDeclaration == null);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.USING_DECLARATION;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    public CsmScope getScope() {
        return UIDCsmConverter.UIDtoScope(this.scopeUID);
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmScope csmScope = this.getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        dataOutput.writeInt(this.startOffset);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedDeclarationUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public UsingDeclarationImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.startOffset = dataInput.readInt();
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.referencedDeclarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

