/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderList
implements FileChangeListener,
DataObject.Container {
    static final long serialVersionUID = -592616022226761148L;
    private static final int LATER_PRIORITY = 5;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder recognizer");
    private static final Map<FileObject, Reference<FolderList>> map = new WeakHashMap<FileObject, Reference<FolderList>>(101);
    private static int REFRESH_TIME = -1;
    private FileObject folder;
    private volatile transient RequestProcessor.Task refreshTask;
    private volatile transient RequestProcessor.Task comparatorTask;
    private transient Map<FileObject, Reference<DataObject>> primaryFiles = null;
    private transient List<FileObject> order;
    private static final Logger err = Logger.getLogger("org.openide.loaders.FolderList");
    private transient PropertyChangeSupport pcs;
    private transient boolean folderCreated = false;
    private transient FileChangeListener weakFCL = FileUtil.weakFileChangeListener((FileChangeListener)this, null);

    private FolderList(FileObject fileObject, boolean bl) {
        this.folder = fileObject;
        if (bl) {
            fileObject.addFileChangeListener(this.weakFCL);
        }
    }

    public String toString() {
        return "FolderList{" + this.folder + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderList find(FileObject fileObject, boolean bl) {
        FolderList folderList = null;
        Class<FolderList> clazz = FolderList.class;
        synchronized (FolderList.class) {
            Reference<FolderList> reference = map.get(fileObject);
            FolderList folderList2 = folderList = reference == null ? null : reference.get();
            if (folderList == null && bl) {
                folderList = new FolderList(fileObject, true);
                map.put(fileObject, new SoftReference<FolderList>(folderList));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return folderList;
        }
    }

    public boolean isCreated() {
        return this.folderCreated;
    }

    public static boolean isFolderRecognizerThread() {
        return PROCESSOR.isRequestProcessorThread();
    }

    public static void changedFolderOrder(FileObject fileObject) {
        FolderList folderList = FolderList.find(fileObject, false);
        if (folderList != null) {
            folderList.changeComparator();
        }
    }

    public static void changedDataSystem(FileObject fileObject) {
        FolderList folderList = FolderList.find(fileObject, false);
        if (err.isLoggable(Level.FINE)) {
            err.fine("changedDataSystem: " + fileObject + " on " + Thread.currentThread());
        }
        if (folderList != null) {
            folderList.refresh();
        }
    }

    @Override
    public DataObject[] getChildren() {
        List<DataObject> list = this.getChildrenList();
        if (list == null) {
            return new DataObject[0];
        }
        DataObject[] dataObjectArray = new DataObject[list.size()];
        list.toArray(dataObjectArray);
        return dataObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataObject> getChildrenList() {
        ListTask listTask;
        try {
            DataObjectPool.getPOOL().enterPrivilegedProcessor(PROCESSOR);
            listTask = this.getChildrenList(null);
            listTask.task.waitFinished();
        }
        finally {
            DataObjectPool.getPOOL().exitPrivilegedProcessor(PROCESSOR);
        }
        assert (listTask.result != null);
        return listTask.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitProcessingFinished() {
        RequestProcessor.Task task;
        FolderList folderList = this;
        synchronized (folderList) {
            task = this.comparatorTask;
            err.log(Level.FINE, "Waiting for comparator {0}", task);
        }
        if (task != null) {
            task.waitFinished();
        }
        folderList = this;
        synchronized (folderList) {
            task = this.refreshTask;
            err.log(Level.FINE, "Waiting for refresh {0}", task);
        }
        if (task != null) {
            task.waitFinished();
        }
    }

    public RequestProcessor.Task computeChildrenList(FolderListListener folderListListener) {
        return this.getChildrenList((FolderListListener)folderListListener).task;
    }

    private ListTask getChildrenList(FolderListListener folderListListener) {
        ListTask listTask = new ListTask(folderListListener);
        int n = Thread.currentThread().getPriority();
        listTask.task = PROCESSOR.post((Runnable)listTask, 0, n);
        return listTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void changeComparator() {
        RequestProcessor.Task[] taskArray;
        final boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("changeComparator on " + this.folder);
        }
        final RequestProcessor.Task task = this.comparatorTask;
        RequestProcessor.Task[] taskArray2 = taskArray = new RequestProcessor.Task[1];
        synchronized (taskArray) {
            taskArray[0] = this.comparatorTask = PROCESSOR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    RequestProcessor.Task[] taskArray2 = taskArray;
                    synchronized (taskArray) {
                        Object object;
                        if (task != null) {
                            task.waitFinished();
                        }
                        if (FolderList.this.primaryFiles != null) {
                            if (bl) {
                                err.fine("changeComparator on " + FolderList.this.folder + ": get old");
                            }
                            if ((object = FolderList.this.getObjects(null)).size() != 0) {
                                FolderList.this.order = null;
                                if (bl) {
                                    err.fine("changeComparator: get new");
                                }
                                List list = FolderList.this.getObjects(null);
                                if (bl) {
                                    err.fine("changeComparator: fire change");
                                }
                                FolderList.this.fireChildrenChange(list, (Collection)object);
                            }
                        }
                        object = FolderList.this;
                        synchronized (object) {
                            if (FolderList.this.comparatorTask == taskArray[0]) {
                                FolderList.this.comparatorTask = null;
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, 0, 1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        final long l = System.currentTimeMillis();
        final boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("refresh on " + this.folder + " @" + l);
        }
        FolderList folderList = this;
        synchronized (folderList) {
            if (this.refreshTask == null) {
                this.refreshTask = PROCESSOR.post(new Runnable(){

                    public void run() {
                        RequestProcessor.Task task = FolderList.this.comparatorTask;
                        if (task != null) {
                            task.waitFinished();
                        }
                        if (bl) {
                            err.fine("-- refresh on " + FolderList.this.folder + ": now=" + l);
                        }
                        if (FolderList.this.primaryFiles != null) {
                            FolderList.this.createBoth(null, true);
                        }
                    }
                }, FolderList.getRefreshTime(), 5);
            } else {
                this.refreshTask.schedule(FolderList.getRefreshTime());
            }
        }
    }

    private static int getRefreshTime() {
        if (REFRESH_TIME >= 0) {
            return REFRESH_TIME;
        }
        String string = System.getProperty("org.openide.loaders.FolderList.refresh.interval");
        if (string != null) {
            try {
                REFRESH_TIME = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(FolderList.class.getName()).log(Level.WARNING, null, numberFormatException);
            }
        }
        if (REFRESH_TIME < 0) {
            REFRESH_TIME = 10;
        }
        err.fine("getRefreshTime: " + REFRESH_TIME);
        return REFRESH_TIME;
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject;
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("fileChanged: " + fileEvent);
        }
        if ((fileObject = fileEvent.getFile()).isData() && fileObject.isValid()) {
            Object object;
            if (this.primaryFiles != null) {
                try {
                    object = DataObject.find(fileObject);
                    if (!this.primaryFiles.containsKey(((DataObject)object).getPrimaryFile())) {
                        this.refresh();
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger(FolderList.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
                }
            }
            if ((object = this.getComparator().getSortMode()) == DataFolder.SortMode.LAST_MODIFIED || object == DataFolder.SortMode.SIZE) {
                this.changeComparator();
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("fileDeleted: " + fileEvent);
        }
        if (this.primaryFiles == null || this.primaryFiles.containsKey(fileEvent.getFile())) {
            this.refresh();
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("fileDataCreated: " + fileEvent);
        }
        this.refresh();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("fileFolderCreated: " + fileEvent);
        }
        this.refresh();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("fileRenamed: " + fileRenameEvent);
        }
        this.refresh();
        this.changeComparator();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("fileAttributeChanged: " + fileAttributeEvent);
        }
        if (fileAttributeEvent.getFile() == this.folder) {
            if (fileAttributeEvent.getName() == null) {
                this.changeComparator();
                return;
            }
            if ("OpenIDE-Folder-Order".equals(fileAttributeEvent.getName()) || "OpenIDE-Folder-SortMode".equals(fileAttributeEvent.getName())) {
                this.changeComparator();
            }
        } else if (FileUtil.affectsOrder((FileAttributeEvent)fileAttributeEvent)) {
            this.changeComparator();
        }
    }

    private FolderOrder getComparator() {
        return FolderOrder.findFor(this.folder);
    }

    private List<DataObject> getObjects(FolderListListener folderListListener) {
        List<DataObject> list;
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("getObjects on " + this.folder);
        }
        if (this.primaryFiles == null) {
            list = this.createBoth(folderListListener, false);
        } else if (this.order != null) {
            list = this.createObjects(this.order, this.primaryFiles, folderListListener);
        } else {
            list = this.createObjects(this.primaryFiles.keySet(), this.primaryFiles, folderListListener);
            list = this.carefullySort(list, this.getComparator());
            this.order = FolderList.createOrder(list);
        }
        return list;
    }

    private List<DataObject> carefullySort(List<DataObject> list, FolderOrder folderOrder) {
        Object object;
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("carefullySort on " + this.folder);
        }
        Collections.sort(list, folderOrder);
        LinkedHashMap<Object, DataObject> linkedHashMap = new LinkedHashMap<Object, DataObject>(list.size());
        for (DataObject serializable2 : list) {
            object = serializable2.getPrimaryFile();
            if (!this.folder.equals(object.getParent())) continue;
            object.removeFileChangeListener(this.weakFCL);
            object.addFileChangeListener(this.weakFCL);
            linkedHashMap.put(object, serializable2);
        }
        if (bl) {
            err.fine("carefullySort before getOrder");
        }
        List list2 = FileUtil.getOrder(linkedHashMap.keySet(), (boolean)true);
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(list2.size());
        object = list2.iterator();
        while (object.hasNext()) {
            FileObject fileObject = (FileObject)object.next();
            arrayList.add((DataObject)linkedHashMap.get(fileObject));
        }
        return arrayList;
    }

    private static List<FileObject> createOrder(List<DataObject> list) {
        int n = list.size();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(i).getPrimaryFile());
        }
        return arrayList;
    }

    private List<DataObject> createObjects(Collection<FileObject> collection, Map<FileObject, Reference<DataObject>> map, FolderListListener folderListListener) {
        boolean bl = err.isLoggable(Level.FINE);
        if (bl) {
            err.fine("createObjects on " + this.folder);
        }
        int n = collection.size();
        Iterator<FileObject> iterator = collection.iterator();
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(n);
        for (FileObject fileObject : collection) {
            DataObject dataObject;
            if (bl) {
                err.fine("  iterating" + fileObject);
            }
            if (!fileObject.isValid()) {
                if (!bl) continue;
                err.fine("    not valid, continue");
                continue;
            }
            Reference<DataObject> reference = map.get(fileObject);
            DataObject dataObject2 = dataObject = reference != null ? reference.get() : null;
            if (dataObject == null) {
                if (bl) {
                    err.fine("    reference is " + reference + " obj is " + dataObject);
                }
                try {
                    dataObject = DataObject.find(fileObject);
                    reference = new SoftReference<DataObject>(dataObject);
                    map.put(fileObject, reference);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger(FolderList.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
                }
            }
            if (dataObject == null) continue;
            if (bl) {
                err.fine("    deliver: ref is " + reference + " obj is " + dataObject);
            }
            if (folderListListener == null) {
                arrayList.add(dataObject);
                continue;
            }
            folderListListener.process(dataObject, arrayList);
        }
        if (folderListListener != null) {
            if (bl) {
                err.fine("  finished: " + arrayList);
            }
            folderListListener.finished(arrayList);
        }
        if (bl) {
            err.fine("createObjects ends on " + this.folder);
        }
        return arrayList;
    }

    private List<DataObject> createBoth(FolderListListener folderListListener, boolean bl) {
        boolean bl2 = err.isLoggable(Level.FINE);
        if (bl2) {
            err.fine("createBoth on " + this.folder);
        }
        HashMap<FileObject, Reference<DataObject>> hashMap = new HashMap<FileObject, Reference<DataObject>>();
        List<DataObject> list = new ArrayList<DataObject>();
        List<Object> list2 = new ArrayList();
        HashMap hashMap2 = this.primaryFiles == null ? new HashMap() : new HashMap<FileObject, Reference<DataObject>>(this.primaryFiles);
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
        final HashSet hashSet = new HashSet();
        DataLoader.RecognizedFiles recognizedFiles = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fileObject) {
                if (fileObject != null) {
                    hashSet.add(fileObject);
                }
            }
        };
        Enumeration enumeration = this.folder.getChildren(false);
        while (enumeration.hasMoreElements()) {
            DataObject dataObject;
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (hashSet.contains(fileObject)) continue;
            try {
                dataObject = dataLoaderPool.findDataObject(fileObject, recognizedFiles);
            }
            catch (DataObjectExistsException dataObjectExistsException) {
                dataObject = dataObjectExistsException.getDataObject();
            }
            catch (IOException iOException) {
                dataObject = null;
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (Throwable throwable) {
                dataObject = null;
                err.log(Level.WARNING, "Error recognizing " + fileObject, throwable);
            }
            if (dataObject == null) continue;
            dataObject.recognizedByFolder();
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl3 = false;
            if (!hashMap.containsKey(fileObject2)) {
                boolean bl4;
                boolean bl5 = bl4 = this.primaryFiles == null;
                if (!bl4) {
                    Reference<DataObject> reference = this.primaryFiles.get(fileObject2);
                    boolean bl6 = bl4 = reference == null;
                    if (!bl4) {
                        DataObject dataObject2 = reference.get();
                        boolean bl7 = bl4 = dataObject2 == null || dataObject2 != dataObject;
                        if (bl4) {
                            bl3 = true;
                        }
                    }
                }
                if (bl4) {
                    arrayList.add(dataObject);
                }
                list.add(dataObject);
                if (folderListListener == null) {
                    list2.add(dataObject);
                } else {
                    folderListListener.process(dataObject, list2);
                }
            }
            if (!bl3) {
                hashMap2.remove(fileObject2);
            }
            hashMap.put(fileObject2, new SoftReference<DataObject>(dataObject));
        }
        this.primaryFiles = hashMap;
        list = this.carefullySort(list, this.getComparator());
        this.order = FolderList.createOrder(list);
        list2 = list.size() == list2.size() ? list : this.carefullySort(list2, this.getComparator());
        if (bl) {
            this.fireChildrenChange(arrayList, hashMap2.keySet());
        }
        if (bl2) {
            err.fine("Notifying filter: " + folderListListener);
        }
        if (folderListListener != null) {
            folderListListener.finished(list2);
        }
        return list2;
    }

    private void fireChildrenChange(Collection<?> collection, Collection<?> collection2) {
        if (!(this.pcs == null || collection.isEmpty() && collection2.isEmpty())) {
            this.pcs.firePropertyChange("children", null, null);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    private final class ListTask
    implements Runnable {
        private FolderListListener filter;
        public List<DataObject> result;
        public RequestProcessor.Task task;

        public ListTask(FolderListListener folderListListener) {
            this.filter = folderListListener;
        }

        public void run() {
            try {
                this.computeResult();
            }
            catch (Error error) {
                err.log(Level.WARNING, "cannot compute data objects for " + FolderList.this.folder, error);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                err.log(Level.WARNING, "cannot compute data objects for " + FolderList.this.folder, runtimeException);
                throw runtimeException;
            }
        }

        private void computeResult() {
            boolean bl = err.isLoggable(Level.FINE);
            if (bl) {
                err.fine("ListTask.run 1 on " + FolderList.this.folder);
            }
            if (FolderList.this.comparatorTask != null) {
                FolderList.this.comparatorTask.waitFinished();
            }
            if (FolderList.this.refreshTask != null) {
                FolderList.this.refreshTask.waitFinished();
            }
            err.fine("ListTask.run 2");
            this.result = FolderList.this.getObjects(this.filter);
            assert (this.result != null);
            err.log(Level.FINE, "ListTask.run 3: {0}", this.result);
            FolderList.this.folderCreated = true;
        }

        public String toString() {
            return "ListTask@" + Integer.toHexString(System.identityHashCode(this)) + "[" + FolderList.this.folder + "]";
        }
    }
}

