/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderList;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderChildrenEager
extends Children.Keys<Pair>
implements PropertyChangeListener,
ChangeListener {
    private DataFolder folder;
    private final DataFilter filter;
    private PropertyChangeListener listener;
    private Logger err;
    private boolean refresh;
    private RequestProcessor.Task refreshTask;
    private ChildrenRefreshRunnable refreshRunnable;
    private static RequestProcessor refRP = new RequestProcessor("FolderChildren_Refresh");

    public FolderChildrenEager(DataFolder dataFolder) {
        this(dataFolder, DataFilter.ALL);
    }

    public FolderChildrenEager(DataFolder dataFolder, DataFilter dataFilter) {
        this.folder = dataFolder;
        this.filter = dataFilter;
        this.refreshRunnable = new ChildrenRefreshRunnable();
        this.refreshTask = refRP.create((Runnable)this.refreshRunnable);
        this.listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.folder);
        String string = dataFolder.getPrimaryFile().isRoot() ? "org.openide.loaders.FolderChildren" : "org.openide.loaders.FolderChildren." + dataFolder.getPrimaryFile().getPath().replace('/', '.');
        this.err = Logger.getLogger(string);
    }

    DataFilter getFilter() {
        return this.filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("children".equals(propertyChangeEvent.getPropertyName())) {
            this.err.fine("Got PROP_CHILDREN");
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
        if ("sortMode".equals(propertyChangeEvent.getPropertyName()) || "order".equals(propertyChangeEvent.getPropertyName())) {
            this.err.fine("Got PROP_SORT_MODE or PROP_ORDER");
            this.refreshChildren().schedule(0);
            this.postClearTask();
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh = true;
        this.refreshChildren().schedule(0);
        this.postClearTask();
    }

    private void postClearTask() {
        refRP.post(new Runnable(){

            public void run() {
                FolderChildrenEager.this.refreshRunnable.clear();
            }
        });
    }

    RequestProcessor.Task refreshChildren() {
        return this.refreshTask;
    }

    protected Node[] createNodes(Pair pair) {
        this.err.fine("createNodes: " + pair);
        FileObject fileObject = pair.primaryFile;
        try {
            DataObject dataObject = DataObject.find(fileObject);
            if (this.filter == null || this.filter.acceptDataObject(dataObject)) {
                return new Node[]{dataObject.getClonedNodeDelegate(this.filter)};
            }
            return new Node[0];
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(FolderChildrenEager.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
            return new Node[0];
        }
    }

    public Node[] getNodes(boolean bl) {
        Node[] nodeArray;
        if (bl) {
            if (FolderChildrenEager.checkChildrenMutex()) {
                this.err.fine("getNodes(true)");
                FolderList.find(this.folder.getPrimaryFile(), true).waitProcessingFinished();
                this.err.fine("getNodes(true): waitProcessingFinished");
                RequestProcessor.Task task = this.refreshChildren();
                nodeArray = this.getNodes();
                this.err.fine("getNodes(true): getNodes: " + nodeArray.length);
                task.schedule(0);
                task.waitFinished();
                this.err.fine("getNodes(true): waitFinished");
            } else {
                Logger.getLogger(FolderChildrenEager.class.getName()).log(Level.WARNING, null, new IllegalStateException("getNodes(true) called while holding the Children.MUTEX"));
            }
        }
        nodeArray = this.getNodes();
        this.err.fine("getNodes(boolean): post clear task");
        this.postClearTask();
        return nodeArray;
    }

    public Node findChild(String string) {
        if (FolderChildrenEager.checkChildrenMutex()) {
            this.getNodes(true);
        }
        return super.findChild(string);
    }

    static boolean checkChildrenMutex() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    protected void addNotify() {
        this.err.fine("addNotify begin");
        this.folder.addPropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).addChangeListener(this);
        }
        this.refreshChildren().schedule(0);
        this.err.fine("addNotify end");
    }

    protected void removeNotify() {
        this.err.fine("removeNotify begin");
        this.folder.removePropertyChangeListener(this.listener);
        if (this.filter instanceof ChangeableDataFilter) {
            ((ChangeableDataFilter)this.filter).removeChangeListener(this);
        }
        this.setKeys(Collections.emptySet());
        this.err.fine("removeNotify end");
    }

    public String toString() {
        return this.folder != null ? this.folder.getPrimaryFile().toString() : super.toString();
    }

    static final class Pair {
        public FileObject primaryFile;
        public int seq;

        public Pair(FileObject fileObject) {
            this.primaryFile = fileObject;
            this.seq = DataObjectPool.getPOOL().registrationCount(fileObject);
        }

        public int hashCode() {
            return this.primaryFile.hashCode() ^ this.seq;
        }

        public boolean equals(Object object) {
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.primaryFile.equals(pair.primaryFile) && this.seq == pair.seq;
            }
            return false;
        }

        public String toString() {
            return "FolderChildren.Pair[" + this.primaryFile + "," + this.seq + "]";
        }
    }

    private final class ChildrenRefreshRunnable
    implements Runnable {
        private DataObject[] ch;

        private ChildrenRefreshRunnable() {
        }

        public void run() {
            assert (refRP.isRequestProcessorThread());
            FolderList.find(FolderChildrenEager.this.folder.getPrimaryFile(), true).waitProcessingFinished();
            this.ch = FolderChildrenEager.this.folder.getChildren();
            FolderChildrenEager.this.err.fine("Children computed");
            Pair[] pairArray = new Pair[this.ch.length];
            for (int i = 0; i < pairArray.length; ++i) {
                pairArray[i] = new Pair(this.ch[i].getPrimaryFile());
            }
            FolderChildrenEager.this.setKeys(Arrays.asList(pairArray));
            if (FolderChildrenEager.this.refresh) {
                FolderChildrenEager.this.refresh = false;
                for (Pair pair : pairArray) {
                    FolderChildrenEager.this.refreshKey(pair);
                }
            }
            if (!FolderChildrenEager.this.isInitialized()) {
                this.clear();
            }
        }

        public void clear() {
            assert (refRP.isRequestProcessorThread());
            FolderChildrenEager.this.err.fine("Clearing the reference to children");
            this.ch = null;
        }
    }
}

