/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.BreakpointLineUpdater;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyExceptionBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;

public final class RubyBreakpointManager {
    private static final Map<RubyBreakpoint, BreakpointLineUpdater> BLUS = new HashMap<RubyBreakpoint, BreakpointLineUpdater>();

    private RubyBreakpointManager() {
    }

    static RubyLineBreakpoint createLineBreakpoint(Line line) {
        return RubyBreakpointManager.createLineBreakpoint(line, null);
    }

    static RubyLineBreakpoint createLineBreakpoint(Line line, String string) {
        RubyLineBreakpoint rubyLineBreakpoint = new RubyLineBreakpoint(line, string);
        BreakpointLineUpdater breakpointLineUpdater = new BreakpointLineUpdater(rubyLineBreakpoint);
        try {
            breakpointLineUpdater.attach();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        BLUS.put(rubyLineBreakpoint, breakpointLineUpdater);
        return rubyLineBreakpoint;
    }

    static RubyExceptionBreakpoint createExceptionBreakpoint(String string) {
        RubyExceptionBreakpoint rubyExceptionBreakpoint = new RubyExceptionBreakpoint(string);
        return rubyExceptionBreakpoint;
    }

    public static RubyLineBreakpoint addLineBreakpoint(Line line) throws RubyDebuggerException {
        RubyLineBreakpoint rubyLineBreakpoint = RubyBreakpointManager.createLineBreakpoint(line);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)rubyLineBreakpoint);
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            rubyDebuggerProxy.addBreakpoint((IRubyBreakpoint)rubyLineBreakpoint);
        }
        return rubyLineBreakpoint;
    }

    public static RubyExceptionBreakpoint addExceptionBreakpoint(String string) throws RubyDebuggerException {
        RubyExceptionBreakpoint rubyExceptionBreakpoint = RubyBreakpointManager.createExceptionBreakpoint(string);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)rubyExceptionBreakpoint);
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            rubyDebuggerProxy.addBreakpoint((IRubyBreakpoint)rubyExceptionBreakpoint);
        }
        return rubyExceptionBreakpoint;
    }

    public static void removeBreakpoint(RubyBreakpoint rubyBreakpoint) {
        if (rubyBreakpoint instanceof RubyLineBreakpoint) {
            BreakpointLineUpdater breakpointLineUpdater = BLUS.remove((Object)rubyBreakpoint);
            assert (breakpointLineUpdater != null) : "No BreakpointLineUpdater for RubyBreakpoint:" + (Object)((Object)rubyBreakpoint);
            if (breakpointLineUpdater != null) {
                breakpointLineUpdater.detach();
            }
        }
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            rubyDebuggerProxy.removeBreakpoint((IRubyBreakpoint)rubyBreakpoint);
        }
    }

    public static RubyBreakpoint[] getBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<RubyBreakpoint> arrayList = new ArrayList<RubyBreakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (!(breakpoint instanceof RubyBreakpoint)) continue;
            arrayList.add((RubyBreakpoint)breakpoint);
        }
        return arrayList.toArray(new RubyBreakpoint[arrayList.size()]);
    }

    static IRubyLineBreakpoint[] getLineBreakpoints(FileObject fileObject) {
        assert (fileObject != null);
        ArrayList<RubyLineBreakpoint> arrayList = new ArrayList<RubyLineBreakpoint>();
        for (RubyBreakpoint rubyBreakpoint : RubyBreakpointManager.getBreakpoints()) {
            RubyLineBreakpoint rubyLineBreakpoint;
            FileObject fileObject2;
            if (!(rubyBreakpoint instanceof RubyLineBreakpoint) || !fileObject.equals(fileObject2 = (rubyLineBreakpoint = (RubyLineBreakpoint)rubyBreakpoint).getFileObject())) continue;
            arrayList.add(rubyLineBreakpoint);
        }
        return arrayList.toArray(new RubyLineBreakpoint[arrayList.size()]);
    }

    public static boolean isBreakpointOnLine(FileObject fileObject, int n) {
        for (RubyBreakpoint rubyBreakpoint : RubyBreakpointManager.getBreakpoints()) {
            RubyLineBreakpoint rubyLineBreakpoint;
            if (!(rubyBreakpoint instanceof RubyLineBreakpoint) || !fileObject.equals((rubyLineBreakpoint = (RubyLineBreakpoint)rubyBreakpoint).getFileObject()) || n != rubyLineBreakpoint.getLineNumber()) continue;
            return true;
        }
        return false;
    }

    static RubyBreakpoint getCurrentLineBreakpoint() {
        Line line = EditorUtil.getCurrentLine();
        if (line == null) {
            return null;
        }
        for (RubyBreakpoint rubyBreakpoint : RubyBreakpointManager.getBreakpoints()) {
            if (!(rubyBreakpoint instanceof RubyLineBreakpoint) || !((RubyLineBreakpoint)rubyBreakpoint).getLine().equals(line)) continue;
            return rubyBreakpoint;
        }
        return null;
    }
}

