/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.text.Line;
import org.openide.util.WeakListeners;
import org.rubyforge.debugcommons.RubyDebuggerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set<Object> ACTIONS = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);

    public RubyBreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorContextDispatcher.getDefault());
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-ruby", propertyChangeListener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("application/x-httpd-eruby", propertyChangeListener);
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void doAction(Object object) {
        RubyBreakpoint rubyBreakpoint = RubyBreakpointManager.getCurrentLineBreakpoint();
        if (rubyBreakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)rubyBreakpoint);
        } else {
            try {
                Line line = EditorUtil.getCurrentLine();
                if (line != null) {
                    RubyBreakpointManager.addLineBreakpoint(line);
                }
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                Util.LOGGER.log(Level.WARNING, "Unable to add breakpoint.", rubyDebuggerException);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = EditorUtil.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

