/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.awt.EventQueue;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.ruby.debugger.DebuggerAnnotation;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class EditorUtil {
    private static DebuggerAnnotation currentLineDA;

    private EditorUtil() {
    }

    static void markCurrent(String string, int n) {
        EditorUtil.markCurrent(EditorUtil.getLineAnnotable(string, n));
    }

    private static void markCurrent(Line line) {
        EditorUtil.unmarkCurrent();
        if (line == null) {
            return;
        }
        currentLineDA = new DebuggerAnnotation("CurrentPC", (Annotatable)line);
        EditorUtil.showLine(line, true);
    }

    static void unmarkCurrent() {
        if (currentLineDA != null) {
            currentLineDA.detach();
            currentLineDA = null;
        }
    }

    public static Line getLineAnnotable(String string, int n) {
        return EditorUtil.getLine(string, n);
    }

    public static Line getLine(String string, int n) {
        if (string == null || n < 0) {
            return null;
        }
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            Util.info("Cannot resolve \"" + string + '\"');
            return null;
        }
        LineCookie lineCookie = EditorUtil.getLineCookie(fileObject);
        assert (lineCookie != null);
        try {
            return lineCookie.getLineSet().getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static LineCookie getLineCookie(FileObject fileObject) {
        LineCookie lineCookie = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Util.LOGGER.log(Level.FINE, "Cannot find DataObject for: " + fileObject, dataObjectNotFoundException.getMessage());
        }
        return lineCookie;
    }

    public static void showLine(final Line line, boolean bl) {
        if (line == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FRONT);
            }
        });
    }

    public static void showLine(Line line) {
        EditorUtil.showLine(line, false);
    }

    public static Line getCurrentLine() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        if (!Util.isRubySource(fileObject)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }
}

