/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import java.io.IOException;
import java.util.ArrayList;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class VariablesReader
extends XmlStreamReader {
    private RubyVariableInfo[] variables;

    public VariablesReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        String element = this.xpp.getName();
        assert (element.equals("variables") || element.equals("processingException"));
        if (element.equals("variables")) {
            this.parseVariables();
        } else if (element.equals("processingException")) {
            this.parseProcessingException();
        } else assert (false) : "Unexpected element: " + element;
    }

    private void parseVariables() throws XmlPullParserException, IOException {
        ArrayList<RubyVariableInfo> variables = new ArrayList<RubyVariableInfo>();
        while (this.nextEvent() != 3 || !"variables".equals(this.xpp.getName())) {
            RubyVariableInfo newVariable;
            if (this.xpp.getName() == null) {
                throw new XmlPullParserException("xpp.getName() returned 'null'. Segmentation fault. Bug in the Ruby interpreter/VM. Please provide possibly exact steps to reproduce and file a bug against Ruby or debug-commons tracker.");
            }
            assert (this.xpp.getName().equals("variable")) : this.xpp.getName() + " encountered";
            String name = this.getAttributeValue("name");
            String value = this.getAttributeValue("value");
            String kind = this.getAttributeValue("kind");
            if (value == null) {
                newVariable = new RubyVariableInfo(name, kind);
            } else {
                String type = this.getAttributeValue("type");
                boolean hasChildren = this.getAttributeBoolValue("hasChildren");
                String objectId = this.getAttributeValue("objectId");
                newVariable = new RubyVariableInfo(name, kind, value, type, hasChildren, objectId);
            }
            variables.add(newVariable);
            this.ensureEndTag("variable");
        }
        this.variables = variables.toArray(new RubyVariableInfo[variables.size()]);
    }

    private void parseProcessingException() throws XmlPullParserException, IOException {
        Util.severe("Processing exception occured. exceptionMessage: " + this.getAttributeValue("message") + ", exceptionType: " + this.getAttributeValue("type"));
        this.ensureEndTag("processingException");
    }

    public static RubyVariableInfo[] readVariables(XmlPullParser xpp) throws IOException, XmlPullParserException {
        VariablesReader reader = new VariablesReader(xpp);
        reader.parse();
        return reader.variables;
    }

    public static void logProcessingException(XmlPullParser xpp) throws IOException, XmlPullParserException {
        VariablesReader reader = new VariablesReader(xpp);
        reader.parse();
    }
}

