/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import java.io.File;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebugTarget
extends RubyEntity {
    private final Process process;
    private final int port;
    private final String debuggedFile;
    private final File baseDir;
    private RubyThread[] threads;

    public RubyDebugTarget(RubyDebuggerProxy proxy, Process process, int port, String debuggedFile, File baseDir) {
        super(proxy);
        this.process = process;
        this.port = port;
        this.debuggedFile = new File(debuggedFile).getName();
        this.baseDir = baseDir;
        this.threads = new RubyThread[0];
    }

    public Process getProcess() {
        return this.process;
    }

    public int getPort() {
        return this.port;
    }

    public String getDebuggedFile() {
        return this.debuggedFile;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreads() throws RubyDebuggerException {
        Util.fine("udpating threads");
        RubyThreadInfo[] threadInfos = this.getProxy().readThreadInfo();
        RubyThread[] updatedThreads = new RubyThread[threadInfos.length];
        int threadIndex = 0;
        RubyDebugTarget rubyDebugTarget = this;
        synchronized (rubyDebugTarget) {
            for (int i = 0; i < threadInfos.length; ++i) {
                while (threadIndex < this.threads.length && threadInfos[i].getId() != this.threads[threadIndex].getId()) {
                    ++threadIndex;
                }
                updatedThreads[i] = threadIndex == this.threads.length ? new RubyThread(this, threadInfos[i].getId()) : this.threads[threadIndex];
            }
            this.threads = updatedThreads;
        }
    }

    public void suspensionOccurred(SuspensionPoint suspensionPoint) {
        try {
            this.updateThreads();
        }
        catch (RubyDebuggerException e) {
            if (this.getProxy().checkConnection()) {
                throw new RuntimeException("Cannot update threads", e);
            }
            Util.fine("Session has finished. Ignoring unsuccessful thread update.");
            return;
        }
        RubyThread thread = this.getThreadById(suspensionPoint.getThreadId());
        if (thread == null) {
            Util.warning("Thread with id " + suspensionPoint.getThreadId() + " was not found");
            return;
        }
        thread.suspend(suspensionPoint);
    }

    public synchronized RubyThread getThreadById(int id) {
        for (RubyThread thread : this.threads) {
            if (thread.getId() != id) continue;
            return thread;
        }
        return null;
    }

    public boolean isRunning() {
        return Util.isRunning(this.process);
    }
}

