/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.junit.output.CallstackFrameNode;
import org.netbeans.modules.junit.output.Report;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class TestMethodNodeChildren
extends Children.Array {
    private final Report.Testcase testcase;

    public TestMethodNodeChildren(Report.Testcase testcase) {
        this.testcase = testcase;
    }

    static int getChildrenCount(Report.Testcase testcase) {
        Report.Trouble trouble = testcase.trouble;
        if (trouble == null) {
            return 0;
        }
        int n = 0;
        if (trouble.message != null) {
            ++n;
        }
        if (trouble.exceptionClsName != null) {
            ++n;
        }
        if (trouble.stackTrace != null) {
            n += trouble.stackTrace.length;
        }
        return n;
    }

    protected void addNotify() {
        Report.Trouble trouble = this.testcase.trouble;
        String string = trouble.stackTrace != null && trouble.stackTrace.length != 0 ? trouble.stackTrace[0] : null;
        int n = TestMethodNodeChildren.getChildrenCount(this.testcase);
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        if (trouble.message != null) {
            nodeArray[n2++] = new CallstackFrameNode(string, trouble.message);
        }
        if (trouble.exceptionClsName != null) {
            nodeArray[n2++] = new CallstackFrameNode(string, trouble.exceptionClsName);
        }
        int n3 = 0;
        while (n2 < n) {
            nodeArray[n2++] = new CallstackFrameNode(trouble.stackTrace[n3]);
            ++n3;
        }
        if (trouble.nestedTrouble != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n * 3);
            arrayList.addAll(Arrays.asList(nodeArray));
            trouble = trouble.nestedTrouble;
            do {
                String[] stringArray;
                string = (stringArray = trouble.stackTrace) != null && stringArray.length != 0 ? stringArray[0] : null;
                StringBuilder stringBuilder = new StringBuilder(200);
                stringBuilder.append("Caused by: ");
                stringBuilder.append(trouble.exceptionClsName);
                if (trouble.message != null) {
                    stringBuilder.append(": ").append(trouble.message);
                }
                arrayList.add((Object)new CallstackFrameNode(string, stringBuilder.toString()));
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    arrayList.add((Object)new CallstackFrameNode(string2));
                }
            } while ((trouble = trouble.nestedTrouble) != null);
            nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        }
        this.add(nodeArray);
    }
}

