/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.junit.output.HtmlMarkupUtils;
import org.netbeans.modules.junit.output.JumpAction;
import org.netbeans.modules.junit.output.OutputUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TestMethodNodeAction;
import org.netbeans.modules.junit.output.TestMethodNodeChildren;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class TestMethodNode
extends AbstractNode {
    private static final String[] NO_TIME_STATUS_KEYS = new String[]{null, "MSG_TestMethodError", "MSG_TestMethodFailed"};
    private static final String[] TIME_STATUS_KEYS = new String[]{"MSG_TestMethodPassed_time", "MSG_TestMethodError_time", "MSG_TestMethodFailed_time"};
    private static final String STATUS_KEY_INTERRUPTED = "MSG_TestMethodInterrupted";
    private static final String[] NO_TIME_STATUS_KEYS_HTML = new String[]{"MSG_TestMethodPassed_HTML", "MSG_TestMethodError_HTML", "MSG_TestMethodFailed_HTML"};
    private static final String[] TIME_STATUS_KEYS_HTML = new String[]{"MSG_TestMethodPassed_HTML_time", "MSG_TestMethodError_HTML_time", "MSG_TestMethodFailed_HTML_time"};
    private static final String STATUS_KEY_INTERRUPTED_HTML = "MSG_TestMethodInterrupted_HTML";
    private final Report.Testcase testcase;

    TestMethodNode(Report.Testcase testcase) {
        super((Children)(TestMethodNodeChildren.getChildrenCount(testcase) != 0 ? new TestMethodNodeChildren(testcase) : Children.LEAF));
        this.testcase = testcase;
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/method.gif");
    }

    private void setDisplayName() {
        Object[] objectArray;
        String string;
        int n;
        int n2 = this.testcase.trouble == null ? 0 : (n = this.testcase.trouble.isError() ? 1 : 2);
        if (n == 0 && this.testcase.timeMillis < 0) {
            this.setDisplayName(this.testcase.name);
            return;
        }
        if (this.testcase.timeMillis == -2) {
            string = STATUS_KEY_INTERRUPTED;
            objectArray = new Object[]{this.testcase.name};
        } else if (this.testcase.timeMillis == -1) {
            string = NO_TIME_STATUS_KEYS[n];
            objectArray = new Object[]{this.testcase.name};
        } else {
            string = TIME_STATUS_KEYS[n];
            objectArray = new Object[]{this.testcase.name, new Float((float)this.testcase.timeMillis / 1000.0f)};
        }
        this.setDisplayName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string, (Object[])objectArray));
    }

    public String getHtmlDisplayName() {
        Float f;
        String string;
        int n = this.testcase.trouble == null ? 0 : (this.testcase.trouble.isError() ? 1 : 2);
        String string2 = null;
        if (this.testcase.timeMillis == -2) {
            string = STATUS_KEY_INTERRUPTED_HTML;
            f = null;
            string2 = "CE7B00";
        } else if (this.testcase.timeMillis == -1) {
            string = NO_TIME_STATUS_KEYS_HTML[n];
            f = null;
        } else {
            string = TIME_STATUS_KEYS_HTML[n];
            f = new Float((float)this.testcase.timeMillis / 1000.0f);
        }
        if (string2 == null) {
            string2 = this.testcase.trouble != null ? "FF0000" : "00CC00";
        }
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append(this.testcase.name);
        stringBuilder.append("&nbsp;&nbsp;");
        if (f == null) {
            HtmlMarkupUtils.appendColourText(stringBuilder, string2, string);
        } else {
            HtmlMarkupUtils.appendColourText(stringBuilder, string2, string, f);
        }
        return stringBuilder.toString();
    }

    public Action getPreferredAction() {
        Report.Trouble trouble = this.testcase.trouble;
        String string = trouble != null && trouble.stackTrace != null && trouble.stackTrace.length != 0 ? trouble.stackTrace[0] : null;
        return new JumpAction((Node)this, string);
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return OutputUtils.NO_ACTIONS;
        }
        Report report = OutputUtils.getReport((Node)this);
        ClassPath classPath = report.getSourceClassPath();
        if (classPath == null) {
            return OutputUtils.NO_ACTIONS;
        }
        String string = report.suiteClassName;
        String string2 = string.replace('.', '/') + ".java";
        FileObject fileObject = classPath.findResource(string2);
        if (fileObject == null) {
            return OutputUtils.NO_ACTIONS;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return OutputUtils.NO_ACTIONS;
        }
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return OutputUtils.NO_ACTIONS;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string3 : actionProvider.getSupportedActions()) {
            if (!bl2 && string3.equals("run.single.method")) {
                bl2 = true;
                if (bl3) break;
            }
            if (bl3 || !string3.equals("debug.single.method")) continue;
            bl3 = true;
            if (bl2) break;
        }
        if (!bl2 && !bl3) {
            return OutputUtils.NO_ACTIONS;
        }
        SingleMethod singleMethod = new SingleMethod(fileObject, this.testcase.name);
        Lookup lookup = Lookups.singleton((Object)singleMethod);
        ArrayList<TestMethodNodeAction> arrayList = new ArrayList<TestMethodNodeAction>(2);
        if (bl2 && actionProvider.isActionEnabled("run.single.method", lookup)) {
            arrayList.add(new TestMethodNodeAction(actionProvider, lookup, "run.single.method", "LBL_RerunTest"));
        }
        if (bl3 && actionProvider.isActionEnabled("debug.single.method", lookup)) {
            arrayList.add(new TestMethodNodeAction(actionProvider, lookup, "debug.single.method", "LBL_DebugTest"));
        }
        if (arrayList.isEmpty()) {
            return OutputUtils.NO_ACTIONS;
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }
}

