/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.MetadataModels;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.sql.analyzer.FromClause;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItems;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionQuery
extends AsyncCompletionQuery {
    private final DatabaseConnection dbconn;
    private Metadata metadata;
    private String quoteString;
    private SQLCompletionEnv env;
    private FromClause fromClause;
    private int anchorOffset = -1;
    private int substitutionOffset = 0;
    private SQLCompletionItems items;

    public SQLCompletionQuery(DatabaseConnection databaseConnection) {
        this.dbconn = databaseConnection;
    }

    protected void query(CompletionResultSet completionResultSet, Document document, int n) {
        final SQLCompletionEnv sQLCompletionEnv = SQLCompletionEnv.create(document, n);
        try {
            MetadataModels.get((DatabaseConnection)this.dbconn).runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Connection connection = SQLCompletionQuery.this.dbconn.getJDBCConnection();
                    if (connection == null) {
                        return;
                    }
                    String string = null;
                    SQLIdentifiers.Quoter quoter = null;
                    try {
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        string = databaseMetaData.getIdentifierQuoteString();
                        quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)databaseMetaData);
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                    SQLCompletionQuery.this.doQuery(sQLCompletionEnv, metadata, quoter, string);
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        if (this.items != null) {
            this.items.fill(completionResultSet);
        }
        if (this.anchorOffset != -1) {
            completionResultSet.setAnchorOffset(this.env.getStatementOffset() + this.anchorOffset);
        }
        completionResultSet.finish();
    }

    SQLCompletionItems doQuery(SQLCompletionEnv sQLCompletionEnv, Metadata metadata, SQLIdentifiers.Quoter quoter, String string) {
        this.env = sQLCompletionEnv;
        this.metadata = metadata;
        this.quoteString = string;
        this.anchorOffset = -1;
        this.substitutionOffset = 0;
        if (sQLCompletionEnv != null && sQLCompletionEnv.isSelect()) {
            this.items = new SQLCompletionItems(quoter, sQLCompletionEnv.getStatementOffset());
            this.completeSelect();
        }
        return this.items;
    }

    private void completeSelect() {
        SQLCompletionEnv.Context context = this.env.getContext();
        if (context == null) {
            return;
        }
        SQLStatement sQLStatement = SQLStatementAnalyzer.analyze(this.env.getTokenSequence());
        this.fromClause = sQLStatement.getTablesInEffect(this.env.getCaretOffset());
        Identifier identifier = this.findIdentifier();
        if (identifier == null) {
            return;
        }
        this.anchorOffset = identifier.anchorOffset;
        this.substitutionOffset = identifier.substitutionOffset;
        switch (context) {
            case SELECT: {
                this.insideSelect(identifier);
                break;
            }
            case FROM: {
                this.insideFrom(identifier);
                break;
            }
            case JOIN_CONDITION: {
                this.insideJoinCondition(identifier);
                break;
            }
            case WHERE: {
                if (this.fromClause == null) break;
                this.insideWhere(identifier);
            }
        }
    }

    private void insideSelect(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeSelectSimpleIdent(identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSimple()) {
            this.completeSelectSingleQualIdent(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSingleQualified()) {
            this.completeSelectDoubleQualIdent(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        }
    }

    private void insideFrom(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeFromSimpleIdent(identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSimple()) {
            this.completeFromSingleQualIdent(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        }
    }

    private void insideJoinCondition(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeSimpleIdentBasedOnFromClause(identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSimple()) {
            this.completeSingleQualIdentBasedOnFromClause(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSingleQualified()) {
            this.completeDoubleQualIdentBasedOnFromClause(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        }
    }

    private void insideWhere(Identifier identifier) {
        if (identifier.fullyTypedIdent.isEmpty()) {
            this.completeSimpleIdentBasedOnFromClause(identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSimple()) {
            this.completeSingleQualIdentBasedOnFromClause(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        } else if (identifier.fullyTypedIdent.isSingleQualified()) {
            this.completeDoubleQualIdentBasedOnFromClause(identifier.fullyTypedIdent, identifier.lastPrefix, identifier.prefixQuoteString);
        }
    }

    private void completeSelectSimpleIdent(String string, String string2) {
        if (this.fromClause != null) {
            this.completeSimpleIdentBasedOnFromClause(string, string2);
        } else {
            Catalog catalog = this.metadata.getDefaultCatalog();
            Schema schema = this.metadata.getDefaultCatalog().getDefaultSchema();
            if (schema != null) {
                if (string != null) {
                    for (Table table : schema.getTables()) {
                        this.items.addColumns(schema, table, string, string2, this.substitutionOffset);
                    }
                }
                this.items.addTables(schema, null, string, string2, this.substitutionOffset);
                this.items.addSchemas(catalog, null, string, string2, this.substitutionOffset);
            }
        }
    }

    private void completeSelectSingleQualIdent(QualIdent qualIdent, String string, String string2) {
        if (this.fromClause != null) {
            this.completeSingleQualIdentBasedOnFromClause(qualIdent, string, string2);
        } else {
            Catalog catalog = this.metadata.getDefaultCatalog();
            Schema schema = catalog.getDefaultSchema();
            if (schema != null) {
                Schema schema2;
                Table table = schema.getTable(qualIdent.getSimpleName());
                if (table != null) {
                    this.items.addColumns(schema, table, string, string2, this.substitutionOffset);
                }
                if ((schema2 = catalog.getSchema(qualIdent.getSimpleName())) != null) {
                    this.items.addTables(schema2, null, string, string2, this.substitutionOffset);
                }
            }
        }
    }

    private void completeSelectDoubleQualIdent(QualIdent qualIdent, String string, String string2) {
        if (this.fromClause != null) {
            this.completeDoubleQualIdentBasedOnFromClause(qualIdent, string, string2);
        } else {
            this.items.addColumns(this.metadata.getDefaultCatalog(), qualIdent, string, string2, this.substitutionOffset);
        }
    }

    private void completeFromSimpleIdent(String string, String string2) {
        Catalog catalog = this.metadata.getDefaultCatalog();
        Schema schema = catalog.getDefaultSchema();
        if (schema != null) {
            this.items.addTables(schema, null, string, string2, this.substitutionOffset);
        }
        this.items.addSchemas(catalog, null, string, string2, this.substitutionOffset);
    }

    private void completeFromSingleQualIdent(QualIdent qualIdent, String string, String string2) {
        Schema schema = this.metadata.getDefaultCatalog().getSchema(qualIdent.getSimpleName());
        if (schema != null) {
            this.items.addTables(schema, null, string, string2, this.substitutionOffset);
        }
    }

    private void completeSimpleIdentBasedOnFromClause(String string, String string2) {
        HashSet<String> hashSet;
        assert (this.fromClause != null);
        Set<QualIdent> set = this.fromClause.getUnaliasedTableNames();
        TreeSet<QualIdent> treeSet = new TreeSet<QualIdent>(set);
        Map<String, QualIdent> map = this.fromClause.getAliasedTableNames();
        for (Map.Entry<String, QualIdent> object2 : map.entrySet()) {
            treeSet.add(object2.getValue());
        }
        Catalog catalog = this.metadata.getDefaultCatalog();
        for (QualIdent qualIdent : treeSet) {
            this.items.addColumns(catalog, qualIdent, string, string2, this.substitutionOffset);
        }
        Schema schema = catalog.getDefaultSchema();
        if (schema != null) {
            String string3 = schema != null ? schema.getName() : null;
            hashSet = new HashSet<String>();
            for (QualIdent qualIdent : set) {
                String string4 = qualIdent.getSimpleName();
                if (qualIdent.isSimple()) {
                    hashSet.add(string4);
                    continue;
                }
                if (!qualIdent.isSingleQualified() || string3 == null || !string3.equals(qualIdent.getFirstQualifier())) continue;
                hashSet.add(string4);
            }
            this.items.addTables(schema, hashSet, string, string2, this.substitutionOffset);
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        this.items.addAliases(arrayList, string, string2, this.substitutionOffset);
        hashSet = new HashSet();
        for (QualIdent qualIdent : set) {
            if (qualIdent.isSimple()) continue;
            hashSet.add(qualIdent.getFirstQualifier());
        }
        this.items.addSchemas(catalog, hashSet, string, string2, this.substitutionOffset);
    }

    private void completeSingleQualIdentBasedOnFromClause(QualIdent qualIdent, String string, String string2) {
        Object object;
        assert (this.fromClause != null);
        Catalog catalog = this.metadata.getDefaultCatalog();
        QualIdent qualIdent2 = qualIdent;
        String string3 = this.getDefaultSchemaName();
        boolean bl = false;
        Object object2 = this.fromClause.getUnaliasedTableNames().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!((QualIdent)object).equals(qualIdent2) && (string3 == null || !((QualIdent)object).equals(new QualIdent(string3, qualIdent2)))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object2 = qualIdent.getFirstQualifier();
            qualIdent2 = this.fromClause.getTableNameByAlias((String)object2);
        }
        if (qualIdent2 != null) {
            this.items.addColumns(catalog, qualIdent2, string, string2, this.substitutionOffset);
        }
        if ((object2 = catalog.getSchema(qualIdent.getSimpleName())) != null) {
            object = null;
            object = new HashSet();
            for (QualIdent qualIdent3 : this.fromClause.getUnaliasedTableNames()) {
                if (!qualIdent3.isSingleQualified() || !qualIdent3.getPrefix().equals(qualIdent)) continue;
                object.add(qualIdent3.getSimpleName());
            }
            this.items.addTables((Schema)object2, (Set<String>)object, string, string2, this.substitutionOffset);
        }
    }

    private void completeDoubleQualIdentBasedOnFromClause(QualIdent qualIdent, String string, String string2) {
        assert (this.fromClause != null);
        if (this.fromClause.getUnaliasedTableNames().contains(qualIdent)) {
            this.items.addColumns(this.metadata.getDefaultCatalog(), qualIdent, string, string2, this.substitutionOffset);
        }
    }

    private String getDefaultSchemaName() {
        Schema schema = this.metadata.getDefaultCatalog().getDefaultSchema();
        return schema != null ? schema.getName() : null;
    }

    private Identifier findIdentifier() {
        TokenSequence<SQLTokenId> tokenSequence = this.env.getTokenSequence();
        int n = this.env.getCaretOffset();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tokenSequence.move(n) > 0) {
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            switch ((SQLTokenId)tokenSequence.token().id()) {
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case INT_LITERAL: 
                case DOUBLE_LITERAL: 
                case STRING: 
                case INCOMPLETE_STRING: {
                    return null;
                }
            }
        } else if (!tokenSequence.movePrevious()) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        block8: do {
            switch ((SQLTokenId)tokenSequence.token().id()) {
                case DOT: {
                    if (arrayList.isEmpty()) {
                        n2 = n;
                        bl = true;
                    }
                    bl2 = true;
                    break;
                }
                case IDENTIFIER: 
                case KEYWORD: {
                    if (bl2 || arrayList.isEmpty()) {
                        if (arrayList.isEmpty() && n2 == -1) {
                            n2 = tokenSequence.offset();
                        }
                        bl2 = false;
                        int n3 = n - tokenSequence.offset();
                        String string = n3 > 0 && n3 < tokenSequence.token().length() ? ((Object)tokenSequence.token().text().subSequence(0, n3)).toString() : ((Object)tokenSequence.token().text()).toString();
                        arrayList.add(string);
                        break;
                    }
                    return null;
                }
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case WHITESPACE: {
                    if (!tokenSequence.movePrevious()) break block8;
                    if (tokenSequence.token().id() == SQLTokenId.IDENTIFIER) {
                        return null;
                    }
                    if (tokenSequence.token().id() != SQLTokenId.DOT) break block8;
                    tokenSequence.moveNext();
                    break;
                }
                default: {
                    break block8;
                }
            }
        } while (tokenSequence.movePrevious());
        Collections.reverse(arrayList);
        return this.createIdentifier(arrayList, bl, n2 >= 0 ? n2 : n);
    }

    private Identifier createIdentifier(List<String> list, boolean bl, int n) {
        String string = null;
        String string2 = null;
        int n2 = n;
        if (list.isEmpty()) {
            if (bl) {
                return null;
            }
        } else {
            int n3;
            if (!bl) {
                string = list.remove(list.size() - 1);
                if (this.quoteString != null) {
                    if (string.startsWith(this.quoteString)) {
                        if (string.endsWith(this.quoteString) && string.length() > this.quoteString.length()) {
                            return null;
                        }
                        n3 = string.length();
                        n = (string = SQLCompletionQuery.unquote(string, this.quoteString)) != null ? (n += n3 - string.length()) : (n += n3);
                        string2 = this.quoteString;
                    } else if (string.endsWith(this.quoteString)) {
                        return null;
                    }
                }
            }
            for (n3 = 0; n3 < list.size(); ++n3) {
                String string3 = SQLCompletionQuery.unquote(list.get(n3), this.quoteString);
                if (string3 == null) {
                    return null;
                }
                list.set(n3, string3);
            }
        }
        return new Identifier(new QualIdent(list), string, string2, n, n2);
    }

    static String unquote(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        int n = 0;
        while (string.regionMatches(n, string2, 0, string2.length())) {
            n += string2.length();
        }
        int n2 = string.length();
        if (n2 > n) {
            int n3;
            while (string.regionMatches(n3 = n2 - string2.length(), string2, 0, string2.length())) {
                n2 = n3;
            }
        }
        String string3 = null;
        if (n < n2 && (string3 = string.substring(n, n2)).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    private static final class Identifier {
        final QualIdent fullyTypedIdent;
        final String lastPrefix;
        final String prefixQuoteString;
        final int anchorOffset;
        final int substitutionOffset;

        private Identifier(QualIdent qualIdent, String string, String string2, int n, int n2) {
            this.fullyTypedIdent = qualIdent;
            this.lastPrefix = string;
            this.prefixQuoteString = string2;
            this.anchorOffset = n;
            this.substitutionOffset = n2;
        }
    }
}

