/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class SQLCompletionItem
implements CompletionItem {
    private static final String SCHEMA_COLOR = "<font color=#006666>";
    private static final String TABLE_COLOR = "<font color=#cc7800>";
    private static final String COLUMN_COLOR = "<font color=#0707ab>";
    private static final String COLOR_END = "</font>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private static final ImageIcon SCHEMA_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/db/sql/editor/completion/resources/schema.png"));
    private static final ImageIcon TABLE_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/db/sql/editor/completion/resources/table.png"));
    private static final ImageIcon COLUMN_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/db/sql/editor/completion/resources/column.png"));
    private final String substitutionText;
    private final int substitutionOffset;

    public static SQLCompletionItem schema(String string, String string2, int n) {
        return new Schema(string, string2, n);
    }

    public static SQLCompletionItem table(String string, String string2, int n) {
        return new Table(string, string2, n);
    }

    public static SQLCompletionItem alias(String string, String string2, int n) {
        return new Alias(string, string2, n);
    }

    public static SQLCompletionItem column(QualIdent qualIdent, String string, String string2, int n) {
        return new QualTableColumn(qualIdent, string, string2, n);
    }

    public static SQLCompletionItem column(String string, String string2, String string3, int n) {
        return new SimpleTableColumn(string, string2, string3, n);
    }

    protected SQLCompletionItem(String string, int n) {
        this.substitutionText = string;
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion.get().hideDocumentation();
        Completion.get().hideCompletion();
        int n = jTextComponent.getSelectionEnd();
        this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getImageIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return null;
    }

    public CharSequence getInsertPrefix() {
        return this.substitutionText;
    }

    protected abstract ImageIcon getImageIcon();

    protected abstract String getLeftHtmlText();

    protected abstract String getRightHtmlText();

    private void substituteText(JTextComponent jTextComponent, final int n, final int n2, final String string) {
        final CharSequence charSequence = this.getInsertPrefix();
        if (charSequence == null) {
            return;
        }
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        baseDocument.runAtomicAsUser(new Runnable(){

            public void run() {
                try {
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n, ((Object)charSequence).toString(), null);
                    if (string != null) {
                        baseDocument.insertString(n, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private static final class SimpleTableColumn
    extends AbstractColumn {
        private final String simpleTableName;

        public SimpleTableColumn(String string, String string2, String string3, int n) {
            super(string2, string3, n);
            this.simpleTableName = string;
        }

        protected String getTableName() {
            return this.simpleTableName;
        }
    }

    private static final class QualTableColumn
    extends AbstractColumn {
        private final QualIdent tableName;

        public QualTableColumn(QualIdent qualIdent, String string, String string2, int n) {
            super(string, string2, n);
            this.tableName = qualIdent;
        }

        protected String getTableName() {
            return this.tableName.toString();
        }
    }

    private static abstract class AbstractColumn
    extends SQLCompletionItem {
        private final String columnName;
        private String leftText;
        private String rightText;

        public AbstractColumn(String string, String string2, int n) {
            super(string2, n);
            this.columnName = string;
        }

        protected abstract String getTableName();

        protected String getColumnName() {
            return this.columnName;
        }

        protected ImageIcon getImageIcon() {
            return COLUMN_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.COLUMN_COLOR);
                stringBuilder.append(SQLCompletionItem.BOLD);
                stringBuilder.append(this.columnName);
                stringBuilder.append(SQLCompletionItem.BOLD_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.TABLE_COLOR);
                stringBuilder.append(this.getTableName());
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.rightText = MessageFormat.format(NbBundle.getMessage(SQLCompletionItem.class, (String)"MSG_Table"), stringBuilder.toString());
            }
            return this.rightText;
        }

        public String toString() {
            return MessageFormat.format("Column {0} in table {1}", this.columnName, this.getTableName());
        }
    }

    private static final class Alias
    extends SQLCompletionItem {
        private final String alias;

        public Alias(String string, String string2, int n) {
            super(string2, n);
            this.alias = string;
        }

        protected ImageIcon getImageIcon() {
            return null;
        }

        protected String getLeftHtmlText() {
            return this.alias;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Alias {0}", this.alias);
        }
    }

    private static final class Table
    extends SQLCompletionItem {
        private final String tableName;
        private String leftText;

        public Table(String string, String string2, int n) {
            super(string2, n);
            this.tableName = string;
        }

        protected ImageIcon getImageIcon() {
            return TABLE_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.TABLE_COLOR);
                stringBuilder.append(this.tableName);
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Table {0}", this.tableName);
        }
    }

    private static final class Schema
    extends SQLCompletionItem {
        private final String schemaName;
        private String leftText;

        public Schema(String string, String string2, int n) {
            super(string2, n);
            this.schemaName = string;
        }

        protected ImageIcon getImageIcon() {
            return SCHEMA_ICON;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SQLCompletionItem.SCHEMA_COLOR);
                stringBuilder.append(this.schemaName);
                stringBuilder.append(SQLCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Schema {0}", this.schemaName);
        }
    }
}

