/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.api.sql.execute.SQLScript;
import org.netbeans.modules.db.api.sql.execute.SQLScriptStatement;
import org.netbeans.modules.db.sql.editor.StringUtils;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionEnv {
    private final String statement;
    private int statementOffset;
    private final int caretOffset;
    private TokenSequence<SQLTokenId> seq;
    private boolean selectStatement;
    private Context context;
    private int contextOffset;

    public static SQLCompletionEnv create(Document document, int n) {
        String string = SQLCompletionEnv.getDocumentText(document);
        if (string != null) {
            return SQLCompletionEnv.create(string, n);
        }
        return null;
    }

    static SQLCompletionEnv create(String string, int n) {
        SQLScriptStatement sQLScriptStatement = SQLScript.create((String)string).getStatementAtOffset(n);
        if (sQLScriptStatement != null) {
            return new SQLCompletionEnv(sQLScriptStatement.getText(), sQLScriptStatement.getStartOffset(), n - sQLScriptStatement.getStartOffset());
        }
        return null;
    }

    private SQLCompletionEnv(String string, int n, int n2) {
        this.statement = string;
        this.statementOffset = n;
        this.caretOffset = n2;
        if (string != null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, SQLTokenId.language());
            this.seq = tokenHierarchy.tokenSequence(SQLTokenId.language());
            this.computeStatementType();
            if (this.selectStatement) {
                this.computeContext();
            }
        }
    }

    public String getStatement() {
        return this.statement;
    }

    public int getStatementOffset() {
        return this.statementOffset;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public TokenSequence<SQLTokenId> getTokenSequence() {
        return this.seq;
    }

    public boolean isSelect() {
        return this.selectStatement;
    }

    public Context getContext() {
        return this.context;
    }

    private static String getDocumentText(final Document document) {
        final String[] stringArray = new String[]{null};
        document.render(new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return stringArray[0];
    }

    private void computeStatementType() {
        this.seq.moveStart();
        block4: while (true) {
            if (!this.seq.moveNext()) {
                return;
            }
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block4;
                }
                case KEYWORD: {
                    if (StringUtils.textEqualsIgnoreCase("SELECT", this.seq.token().text())) {
                        this.selectStatement = true;
                    }
                    return;
                }
            }
            break;
        }
    }

    private void computeContext() {
        int n = this.seq.move(this.caretOffset);
        if (n > 0) {
            this.seq.moveNext();
        }
        while (true) {
            if (!this.seq.movePrevious()) {
                return;
            }
            if (this.seq.token().id() != SQLTokenId.KEYWORD) continue;
            CharSequence charSequence = this.seq.token().text();
            if (StringUtils.textEqualsIgnoreCase("FROM", charSequence)) {
                this.context = Context.FROM;
                return;
            }
            if (StringUtils.textEqualsIgnoreCase("ON", charSequence)) {
                this.context = Context.JOIN_CONDITION;
                return;
            }
            if (StringUtils.textEqualsIgnoreCase("SELECT", charSequence)) {
                this.context = Context.SELECT;
                return;
            }
            if (StringUtils.textEqualsIgnoreCase("WHERE", charSequence)) break;
        }
        this.context = Context.WHERE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Context {
        SELECT,
        FROM,
        JOIN_CONDITION,
        WHERE,
        HAVING,
        ORDER_BY;

    }
}

