/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.UserDataConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address10;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.AsymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss10;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss11;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ProfilesModelHelper {
    public static final String XWS_SECURITY_SERVER = "xws-security-server";
    public static final String XWS_SECURITY_CLIENT = "xws-security-client";
    public static final String WSSIP = "wssip";
    public static final String DEFAULT_PASSWORD = "wsit";
    public static final String DEFAULT_USERNAME = "wsit";
    public static final String DEFAULT_KERBEROS_LMODULE_SERVICE = "KerberosService";
    public static final String DEFAULT_KERBEROS_LMODULE_CLIENT = "KerberosClient";
    public static final String DEFAULT_KERBEROS_PRINCIPAL = "websvc/service@SUN.COM";
    private static final Logger logger = Logger.getLogger(ProfilesModelHelper.class.getName());
    private static HashMap<ConfigVersion, ProfilesModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.CONFIG_1_3;

    private ProfilesModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final ProfilesModelHelper getInstance(ConfigVersion configVersion) {
        ProfilesModelHelper profilesModelHelper = instances.get(configVersion);
        if (profilesModelHelper == null) {
            profilesModelHelper = new ProfilesModelHelper(configVersion);
            instances.put(configVersion, profilesModelHelper);
        }
        return profilesModelHelper;
    }

    public static boolean isSSLProfile(String string) {
        return ComboConstants.PROF_MSGAUTHSSL.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string) || ComboConstants.PROF_TRANSPORT.equals(string);
    }

    public static String getSecurityProfile(WSDLComponent wSDLComponent) {
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        Set<SecurityProfile> set = SecurityProfileRegistry.getDefault().getSecurityProfiles();
        for (SecurityProfile securityProfile : set) {
            if (!securityProfile.isCurrentProfile(wSDLComponent)) continue;
            return securityProfile.getDisplayName();
        }
        return ComboConstants.PROF_NOTRECOGNIZED;
    }

    public static boolean isSCEnabled(WSDLComponent wSDLComponent) {
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        SymmetricBinding symmetricBinding = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SymmetricBinding.class, false);
        if (symmetricBinding == null) {
            return false;
        }
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)symmetricBinding, ProtectionToken.class);
        if (wSDLComponent2 == null) {
            return false;
        }
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        if (wSDLComponent3 == null) {
            return false;
        }
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        return bl;
    }

    public static String getWSITSecurityProfile(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            RecipientToken recipientToken;
            InitiatorToken initiatorToken;
            String string;
            Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
            SymmetricBinding symmetricBinding = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SymmetricBinding.class, false);
            WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)symmetricBinding, ProtectionToken.class);
            WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
            ExtensibilityElement extensibilityElement = null;
            boolean bl = wSDLComponent3 instanceof SecureConversationToken;
            WSDLComponent wSDLComponent4 = null;
            if (bl) {
                wSDLComponent4 = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
                extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent4);
            }
            TransportBinding transportBinding = null;
            transportBinding = bl && extensibilityElement instanceof TransportBinding ? (TransportBinding)extensibilityElement : (TransportBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, TransportBinding.class, false);
            if (transportBinding != null) {
                Object object;
                if (wSDLComponent instanceof BindingOperation) {
                    BindingInput bindingInput = ((BindingOperation)wSDLComponent).getBindingInput();
                    WSDLComponent wSDLComponent5 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)bindingInput, 2);
                    if (wSDLComponent5 != null) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    wSDLComponent5 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)bindingInput, 1);
                    String string2 = SecurityTokensModelHelper.getTokenType(wSDLComponent5);
                    if (ComboConstants.SAML.equals(string2)) {
                        return ComboConstants.PROF_SAMLSSL;
                    }
                    if (ComboConstants.USERNAME.equals(string2) || ComboConstants.X509.equals(string2)) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    return ComboConstants.PROF_TRANSPORT;
                }
                WSDLComponent wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 2);
                if (wSDLComponent6 != null) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                if (bl) {
                    object = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class, false);
                    wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)object, 1);
                } else {
                    wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 1);
                }
                object = SecurityTokensModelHelper.getTokenType(wSDLComponent6);
                if (ComboConstants.SAML.equals(object)) {
                    return ComboConstants.PROF_SAMLSSL;
                }
                if (ComboConstants.USERNAME.equals(object) || ComboConstants.X509.equals(object)) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                return ComboConstants.PROF_TRANSPORT;
            }
            symmetricBinding = bl && extensibilityElement instanceof SymmetricBinding ? (SymmetricBinding)extensibilityElement : (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SymmetricBinding.class, false);
            if (symmetricBinding != null && (wSDLComponent3 = (ProtectionToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)symmetricBinding, ProtectionToken.class)) != null) {
                string = SecurityTokensModelHelper.getTokenType(wSDLComponent3);
                if (ComboConstants.ISSUED.equals(string)) {
                    return ComboConstants.PROF_STSISSUED;
                }
                if (ComboConstants.KERBEROS.equals(string)) {
                    return ComboConstants.PROF_KERBEROS;
                }
                if (ComboConstants.X509.equals(string)) {
                    initiatorToken = null;
                    if (bl) {
                        recipientToken = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class, false);
                        initiatorToken = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)recipientToken, 2);
                    } else {
                        initiatorToken = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 2);
                    }
                    string = SecurityTokensModelHelper.getTokenType((WSDLComponent)initiatorToken);
                    if (ComboConstants.ISSUED.equals(string)) {
                        return ComboConstants.PROF_STSISSUEDENDORSE;
                    }
                    if (ComboConstants.X509.equals(string)) {
                        return ComboConstants.PROF_ENDORSCERT;
                    }
                    if (string == null) {
                        recipientToken = null;
                        if (bl) {
                            Policy policy2 = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class, false);
                            initiatorToken = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)policy2, 1);
                            recipientToken = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)policy2, 5);
                        } else {
                            initiatorToken = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 1);
                            recipientToken = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 5);
                        }
                        if (recipientToken != null) {
                            string = SecurityTokensModelHelper.getTokenType((WSDLComponent)recipientToken);
                            if (ComboConstants.USERNAME.equals(string)) {
                                return ComboConstants.PROF_USERNAME;
                            }
                            return ComboConstants.PROF_STSISSUEDSUPPORTING;
                        }
                        string = SecurityTokensModelHelper.getTokenType((WSDLComponent)initiatorToken);
                        if (ComboConstants.ISSUED.equals(string)) {
                            return ComboConstants.PROF_STSISSUEDSUPPORTING;
                        }
                        return ComboConstants.PROF_USERNAME;
                    }
                }
            }
            string = null;
            string = bl && extensibilityElement instanceof AsymmetricBinding ? (AsymmetricBinding)extensibilityElement : (AsymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, AsymmetricBinding.class, false);
            if (string != null) {
                initiatorToken = (InitiatorToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)string, InitiatorToken.class);
                recipientToken = (RecipientToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)string, RecipientToken.class);
                if (initiatorToken != null && recipientToken != null) {
                    String string3 = SecurityTokensModelHelper.getTokenType((WSDLComponent)initiatorToken);
                    String string4 = SecurityTokensModelHelper.getTokenType((WSDLComponent)recipientToken);
                    if (ComboConstants.X509.equals(string3) && ComboConstants.X509.equals(string4)) {
                        if (wSDLComponent instanceof BindingOperation) {
                            BindingInput bindingInput = ((BindingOperation)wSDLComponent).getBindingInput();
                            WSDLComponent wSDLComponent7 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)bindingInput, 1);
                            String string5 = SecurityTokensModelHelper.getTokenType(wSDLComponent7);
                            if (ComboConstants.SAML.equals(string5)) {
                                return ComboConstants.PROF_SAMLSENDER;
                            }
                            if (string5 == null) {
                                return ComboConstants.PROF_MUTUALCERT;
                            }
                        } else {
                            Object object;
                            WSDLComponent wSDLComponent8 = null;
                            if (bl) {
                                object = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class, false);
                                wSDLComponent8 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)object, 1);
                            } else {
                                wSDLComponent8 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 1);
                            }
                            object = SecurityTokensModelHelper.getTokenType(wSDLComponent8);
                            if (ComboConstants.SAML.equals(object)) {
                                return ComboConstants.PROF_SAMLSENDER;
                            }
                            if (object == null) {
                                return ComboConstants.PROF_MUTUALCERT;
                            }
                        }
                    }
                    if (ComboConstants.SAML.equals(string3) && ComboConstants.X509.equals(string4)) {
                        return ComboConstants.PROF_SAMLHOLDER;
                    }
                    if (ComboConstants.ISSUED.equals(string3) && ComboConstants.X509.equals(string4)) {
                        return ComboConstants.PROF_STSISSUEDCERT;
                    }
                }
            }
        }
        return ComboConstants.PROF_NOTRECOGNIZED;
    }

    private static void updateServiceUrl(WSDLComponent wSDLComponent, boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = "http:";
            string = "https:";
        } else {
            string2 = "https:";
            string = "http:";
        }
        if (wSDLComponent instanceof Binding) {
            Collection collection = wSDLComponent.getModel().getDefinitions().getServices();
            for (Service service : collection) {
                Collection collection2 = service.getPorts();
                for (Port port : collection2) {
                    String string3;
                    Object object;
                    Object object2;
                    Object object3;
                    if (!port.getBinding().references((Referenceable)((Binding)wSDLComponent))) continue;
                    List list = port.getExtensibilityElements(Address.class);
                    if (list != null && !list.isEmpty()) {
                        object3 = list.iterator();
                        while (object3.hasNext()) {
                            object2 = (Address)object3.next();
                            object = object2.getAddress();
                            if (object == null) continue;
                            object2.setAddress(((String)object).replaceFirst(string2, string));
                        }
                    }
                    if ((object3 = port.getExtensibilityElements(Address10.class)) != null && !object3.isEmpty()) {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (Address10)object2.next();
                            string3 = object.getAddress();
                            if (string3 == null) continue;
                            object.setAddress(string3.replaceFirst(string2, string));
                        }
                    }
                    if ((object2 = port.getExtensibilityElements(SOAPAddress.class)) == null || object2.isEmpty()) continue;
                    object = object2.iterator();
                    while (object.hasNext()) {
                        string3 = (SOAPAddress)object.next();
                        String string4 = string3.getLocation();
                        if (string4 == null) continue;
                        string3.setLocation(string4.replaceFirst(string2, string));
                    }
                }
            }
        }
    }

    public static boolean isServiceUrlHttps(Binding binding) {
        Collection collection = binding.getModel().getDefinitions().getServices();
        for (Service service : collection) {
            Collection collection2 = service.getPorts();
            for (Port port : collection2) {
                String string;
                Object object;
                Object object2;
                Object object3;
                if (!port.getBinding().references((Referenceable)binding)) continue;
                List list = port.getExtensibilityElements(Address.class);
                if (list != null && !list.isEmpty()) {
                    object3 = list.iterator();
                    while (object3.hasNext()) {
                        object2 = (Address)object3.next();
                        object = object2.getAddress();
                        if (object == null || !((String)object).contains("https:")) continue;
                        return true;
                    }
                }
                if ((object3 = port.getExtensibilityElements(Address10.class)) != null && !object3.isEmpty()) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Address10)object2.next();
                        string = object.getAddress();
                        if (string == null || !string.contains("https:")) continue;
                        return true;
                    }
                }
                if ((object2 = port.getExtensibilityElements(SOAPAddress.class)) == null || object2.isEmpty()) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    string = (SOAPAddress)object.next();
                    String string2 = string.getLocation();
                    if (string2 == null || !string2.contains("https:")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setSecurityProfile(WSDLComponent wSDLComponent, String string, String string2, boolean bl) {
        assert (wSDLComponent != null);
        assert (string != null);
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        SecurityProfile securityProfile2 = SecurityProfileRegistry.getDefault().getProfile(string2);
        if (securityProfile2 != null) {
            securityProfile2.profileDeselected(wSDLComponent, this.configVersion);
        }
        securityProfile.profileSelected(wSDLComponent, bl, this.configVersion);
    }

    public static boolean isServiceDefaultSetupSupported(String string) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        return securityProfile instanceof ServiceDefaultsFeature;
    }

    public static boolean isClientDefaultSetupSupported(String string) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        return securityProfile instanceof ClientDefaultsFeature;
    }

    public static boolean isServiceDefaultSetupUsed(String string, Binding binding, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ServiceDefaultsFeature) {
            return ((ServiceDefaultsFeature)((Object)securityProfile)).isServiceDefaultSetupUsed((WSDLComponent)binding, project);
        }
        return false;
    }

    public static boolean isClientDefaultSetupUsed(String string, Binding binding, WSDLComponent wSDLComponent, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ClientDefaultsFeature) {
            return ((ClientDefaultsFeature)((Object)securityProfile)).isClientDefaultSetupUsed((WSDLComponent)binding, (Binding)wSDLComponent, project);
        }
        return false;
    }

    public static void setClientDefaults(String string, Binding binding, WSDLComponent wSDLComponent, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ClientDefaultsFeature) {
            ((ClientDefaultsFeature)((Object)securityProfile)).setClientDefaults((WSDLComponent)binding, wSDLComponent, project);
        }
    }

    public static void setServiceDefaults(String string, Binding binding, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ServiceDefaultsFeature) {
            ((ServiceDefaultsFeature)((Object)securityProfile)).setServiceDefaults((WSDLComponent)binding, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurityProfile(WSDLComponent wSDLComponent, String string, boolean bl) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        boolean bl2 = wSDLModel.isIntransaction();
        if (!bl2) {
            wSDLModel.startTransaction();
        }
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        SecurityTokensModelHelper securityTokensModelHelper = SecurityTokensModelHelper.getInstance(this.configVersion);
        SecurityPolicyModelHelper securityPolicyModelHelper = SecurityPolicyModelHelper.getInstance(this.configVersion);
        AlgoSuiteModelHelper algoSuiteModelHelper = AlgoSuiteModelHelper.getInstance(this.configVersion);
        policyModelHelper.createPolicy(wSDLComponent, true);
        try {
            boolean bl3;
            WSDLComponent wSDLComponent2;
            if (ComboConstants.PROF_TRANSPORT.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.TRANSPORT);
                securityTokensModelHelper.setTokenType(wSDLComponent2, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                securityPolicyModelHelper.enableWss(wSDLComponent, false);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.TRANSPORT);
                securityTokensModelHelper.setTokenType(wSDLComponent2, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, false);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.USERNAME, 1);
            } else if (ComboConstants.PROF_SAMLSSL.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.TRANSPORT);
                securityTokensModelHelper.setTokenType(wSDLComponent2, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, false);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.SAML, 1);
            } else if (ComboConstants.PROF_USERNAME.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent3 = securityTokensModelHelper.setTokenType(wSDLComponent2, "protection", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent3, ComboConstants.NEVER);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                int n = ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion) ? 1 : 5;
                securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.USERNAME, n);
            } else if (ComboConstants.PROF_MUTUALCERT.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent4 = securityTokensModelHelper.setTokenType(wSDLComponent2, "initiator", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent4, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent4 = securityTokensModelHelper.setTokenType(wSDLComponent2, "recipient", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent4, ComboConstants.NEVER);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, false);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_ENDORSCERT.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent5 = securityTokensModelHelper.setTokenType(wSDLComponent2, "protection", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent5, ComboConstants.NEVER);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                wSDLComponent5 = securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.X509, 2);
            } else if (ComboConstants.PROF_SAMLSENDER.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent6 = securityTokensModelHelper.setTokenType(wSDLComponent2, "initiator", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent6, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent6 = securityTokensModelHelper.setTokenType(wSDLComponent2, "recipient", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent6, ComboConstants.NEVER);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, false);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.SAML, 1);
            } else if (ComboConstants.PROF_SAMLHOLDER.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent7 = securityTokensModelHelper.setTokenType(wSDLComponent2, "initiator", ComboConstants.SAML);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent7, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent7 = securityTokensModelHelper.setTokenType(wSDLComponent2, "recipient", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent7, ComboConstants.NEVER);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, false);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_KERBEROS.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent8 = securityTokensModelHelper.setTokenType(wSDLComponent2, "protection", ComboConstants.KERBEROS);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent8, ComboConstants.ONCE);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.STRICT);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_STSISSUED.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent9 = securityTokensModelHelper.setTokenType(wSDLComponent2, "protection", ComboConstants.ISSUED);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent9, ComboConstants.ALWAYSRECIPIENT);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = securityPolicyModelHelper.enableTrust(wSDLComponent, this.configVersion);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                securityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_STSISSUEDCERT.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent10 = securityTokensModelHelper.setTokenType(wSDLComponent2, "initiator", ComboConstants.ISSUED);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent10, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent10 = securityTokensModelHelper.setTokenType(wSDLComponent2, "recipient", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent10, ComboConstants.NEVER);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = securityPolicyModelHelper.enableTrust(wSDLComponent, this.configVersion);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                securityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_STSISSUEDENDORSE.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent11 = securityTokensModelHelper.setTokenType(wSDLComponent2, "protection", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent11, ComboConstants.ALWAYS);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = securityPolicyModelHelper.enableTrust(wSDLComponent, this.configVersion);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                securityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                wSDLComponent11 = securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.ISSUED, 2);
            } else if (ComboConstants.PROF_STSISSUEDSUPPORTING.equals(string)) {
                wSDLComponent2 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent12 = securityTokensModelHelper.setTokenType(wSDLComponent2, "protection", ComboConstants.X509);
                securityTokensModelHelper.setTokenInclusionLevel(wSDLComponent12, ComboConstants.ALWAYS);
                securityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent2, true);
                algoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = securityPolicyModelHelper.enableTrust(wSDLComponent, this.configVersion);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                securityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                wSDLComponent12 = this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0) ? securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.ISSUED, 1) : securityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.ISSUED, 5);
            }
            this.setMessageLevelSecurityProfilePolicies(wSDLComponent, string);
            if (bl) {
                ProfilesModelHelper.updateServiceUrl(wSDLComponent, ProfilesModelHelper.isSSLProfile(string));
            }
            if (ConfigVersion.CONFIG_1_3.equals((Object)this.configVersion) && (bl3 = RMModelHelper.getInstance(this.configVersion).isRMEnabled(wSDLComponent)) && ProfilesModelHelper.isSSLProfile(string)) {
                if (ProfilesModelHelper.isSSLProfile(string)) {
                    RMSequenceBinding.SECURED_TRANSPORT.set(this.configVersion, (Binding)wSDLComponent);
                } else {
                    RMSequenceBinding.SECURED_TOKEN.set(this.configVersion, (Binding)wSDLComponent);
                }
            }
        }
        finally {
            if (!bl2) {
                wSDLModel.endTransaction();
            }
        }
    }

    private static FileObject getDDFO(WSDLComponent wSDLComponent) {
        WSDLModel wSDLModel;
        FileObject fileObject;
        if (wSDLComponent != null && (fileObject = Util.getFOForModel(wSDLModel = wSDLComponent.getModel())) != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (Util.isWebProject(project)) {
                WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
                return webModule.getDeploymentDescriptor();
            }
            return Util.getSunDDFO(project);
        }
        return null;
    }

    private static SecurityConstraint getSecurityConstraint(WSDLComponent wSDLComponent) {
        FileObject fileObject = ProfilesModelHelper.getDDFO(wSDLComponent);
        if (fileObject != null) {
            Object object;
            WebResourceCollection webResourceCollection;
            SecurityConstraint[] securityConstraintArray;
            WebApp webApp = null;
            try {
                webApp = DDProvider.getDefault().getDDRoot(fileObject);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, null, iOException);
            }
            String string = null;
            if (wSDLComponent instanceof Binding) {
                securityConstraintArray = wSDLComponent.getModel().getDefinitions().getServices();
                for (Service service : securityConstraintArray) {
                    Collection collection = service.getPorts();
                    SecurityConstraint securityConstraint = collection.iterator();
                    while (securityConstraint.hasNext()) {
                        webResourceCollection = (Port)securityConstraint.next();
                        object = webResourceCollection.getBinding().getQName();
                        String string2 = ((Binding)wSDLComponent).getName();
                        if (!string2.equals(((QName)object).getLocalPart())) continue;
                        string = service.getName();
                    }
                }
            }
            if (webApp != null && webApp.getStatus() != 2) {
                for (SecurityConstraint securityConstraint : securityConstraintArray = webApp.getSecurityConstraint()) {
                    webResourceCollection = securityConstraint.getWebResourceCollection(0);
                    if (webResourceCollection == null || (object = webResourceCollection.getUrlPattern(0)) == null || !((String)object).contains(string)) continue;
                    return securityConstraint;
                }
            }
        }
        return null;
    }

    public static void unsetSSLAttributes(WSDLComponent wSDLComponent) {
        SecurityConstraint securityConstraint = ProfilesModelHelper.getSecurityConstraint(wSDLComponent);
        if (securityConstraint != null) {
            try {
                FileObject fileObject = ProfilesModelHelper.getDDFO(wSDLComponent);
                if (fileObject == null) {
                    return;
                }
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && webApp.getStatus() != 2) {
                    webApp.removeSecurityConstraint(securityConstraint);
                    webApp.write(fileObject);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static void setSSLAttributes(WSDLComponent wSDLComponent) {
        if (ProfilesModelHelper.getSecurityConstraint(wSDLComponent) == null) {
            FileObject fileObject = ProfilesModelHelper.getDDFO(wSDLComponent);
            if (fileObject == null) {
                return;
            }
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && webApp.getStatus() != 2) {
                    Collection collection;
                    SecurityConstraint securityConstraint = (SecurityConstraint)webApp.createBean("SecurityConstraint");
                    AuthConstraint authConstraint = (AuthConstraint)webApp.createBean("AuthConstraint");
                    authConstraint.addRoleName("EMPLOYEE");
                    securityConstraint.setAuthConstraint(authConstraint);
                    UserDataConstraint userDataConstraint = (UserDataConstraint)webApp.createBean("UserDataConstraint");
                    userDataConstraint.setTransportGuarantee("CONFIDENTIAL");
                    securityConstraint.setUserDataConstraint(userDataConstraint);
                    String string = null;
                    String string2 = "/";
                    boolean bl = false;
                    if (wSDLComponent instanceof Binding) {
                        collection = wSDLComponent.getModel().getDefinitions().getServices();
                        for (Service service : collection) {
                            Collection collection2 = service.getPorts();
                            for (Port port : collection2) {
                                QName qName = port.getBinding().getQName();
                                String string3 = ((Binding)wSDLComponent).getName();
                                if (!string3.equals(qName.getLocalPart())) continue;
                                string = service.getName();
                                string2 = string2.concat(string + "/*");
                                bl = true;
                                break;
                            }
                            if (!bl) continue;
                            break;
                        }
                    }
                    securityConstraint.setDisplayName(NbBundle.getMessage(ProfilesModelHelper.class, (String)"LBL_SECCONSTRAINT_DNAME", string));
                    collection = (WebResourceCollection)webApp.createBean("WebResourceCollection");
                    collection.setHttpMethod(new String[]{"POST"});
                    collection.setUrlPattern(new String[]{string2});
                    collection.setWebResourceName("Secure Area");
                    securityConstraint.addWebResourceCollection((WebResourceCollection)collection);
                    webApp.addSecurityConstraint(securityConstraint);
                    webApp.write(fileObject);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
    }

    public void setMessageLevelSecurityProfilePolicies(WSDLComponent wSDLComponent, String string) {
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
        if (wSDLComponent instanceof Binding) {
            Collection collection = ((Binding)wSDLComponent).getBindingOperations();
            Iterator iterator = null;
            if (collection != null && collection.size() > 0) {
                iterator = collection.iterator();
                BindingOperation bindingOperation = (BindingOperation)iterator.next();
                this.setMessageLevelSecurityProfilePolicies(bindingOperation, string);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                String string2 = null;
                if (bindingInput != null) {
                    string2 = PolicyModelHelper.getPolicyUriForElement((WSDLComponent)bindingInput);
                }
                String string3 = null;
                if (bindingOutput != null) {
                    string3 = PolicyModelHelper.getPolicyUriForElement((WSDLComponent)bindingOutput);
                }
                while (iterator.hasNext()) {
                    BindingOperation bindingOperation2 = (BindingOperation)iterator.next();
                    if (bindingInput != null) {
                        bindingInput = bindingOperation2.getBindingInput();
                        policyModelHelper.attachPolicyToElement(string2, (WSDLComponent)bindingInput);
                    }
                    if (bindingOutput == null) continue;
                    bindingOutput = bindingOperation2.getBindingOutput();
                    policyModelHelper.attachPolicyToElement(string3, (WSDLComponent)bindingOutput);
                }
            }
        } else {
            this.setMessageLevelSecurityProfilePolicies((BindingOperation)wSDLComponent, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageLevelSecurityProfilePolicies(BindingOperation bindingOperation, String string) {
        assert (bindingOperation != null);
        WSDLModel wSDLModel = bindingOperation.getModel();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        Binding binding = (Binding)bindingOperation.getParent();
        boolean bl = SecurityPolicyModelHelper.isWss11((WSDLComponent)binding);
        boolean bl2 = RMModelHelper.getInstance(this.configVersion).isRMEnabled((WSDLComponent)binding);
        boolean bl3 = wSDLModel.isIntransaction();
        if (!bl3) {
            wSDLModel.startTransaction();
        }
        try {
            SecurityPolicyModelHelper securityPolicyModelHelper = SecurityPolicyModelHelper.getInstance(this.configVersion);
            if (ComboConstants.PROF_TRANSPORT.equals(string)) {
                return;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
                return;
            }
            if (ComboConstants.PROF_SAMLSSL.equals(string)) {
                return;
            }
            if (ComboConstants.PROF_USERNAME.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_MUTUALCERT.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, true, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, true, bl2);
                return;
            }
            if (ComboConstants.PROF_ENDORSCERT.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_SAMLSENDER.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_SAMLHOLDER.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_KERBEROS.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUED.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUEDCERT.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUEDENDORSE.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUEDSUPPORTING.equals(string)) {
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
        }
        finally {
            if (!bl3) {
                wSDLModel.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        assert (wSDLComponent != null);
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        Binding binding = null;
        binding = wSDLComponent instanceof BindingOperation ? (Binding)wSDLComponent.getParent() : (Binding)wSDLComponent;
        WSDLModel wSDLModel = wSDLComponent.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        boolean bl2 = wSDLModel.isIntransaction();
        if (!bl2) {
            wSDLModel.startTransaction();
        }
        try {
            PolicyModelHelper policyModelHelper = PolicyModelHelper.getInstance(this.configVersion);
            SecurityPolicyModelHelper securityPolicyModelHelper = SecurityPolicyModelHelper.getInstance(this.configVersion);
            SecurityTokensModelHelper securityTokensModelHelper = SecurityTokensModelHelper.getInstance(this.configVersion);
            if (bl) {
                TrustElement trustElement;
                Wss11 wss11;
                ExtensibilityElement extensibilityElement;
                ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
                WSDLComponent wSDLComponent2 = (WSDLComponent)extensibilityElement2.getParent();
                boolean bl3 = SecurityPolicyModelHelper.isSignEntireHeadersAndBody(wSDLComponent);
                boolean bl4 = SecurityPolicyModelHelper.isSignEntireHeadersAndBody(wSDLComponent);
                String string = AlgoSuiteModelHelper.getAlgorithmSuite(wSDLComponent);
                BootstrapPolicy bootstrapPolicy = (BootstrapPolicy)wSDLComponentFactory.create(wSDLComponent2, SecurityPolicyQName.BOOTSTRAPPOLICY.getQName(this.configVersion));
                wSDLComponent2.addExtensibilityElement((ExtensibilityElement)bootstrapPolicy);
                Policy policy = (Policy)policyModelHelper.createElement((WSDLComponent)bootstrapPolicy, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
                ExtensibilityElement extensibilityElement3 = (ExtensibilityElement)extensibilityElement2.copy((Component)policy);
                policy.addExtensibilityElement(extensibilityElement3);
                for (int i = 0; i < 3; ++i) {
                    extensibilityElement = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken(wSDLComponent, i);
                    if (extensibilityElement == null) continue;
                    policy.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy((Component)policy));
                    ((WSDLComponent)extensibilityElement.getParent()).removeExtensibilityElement(extensibilityElement);
                }
                WSDLComponent wSDLComponent3 = securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                extensibilityElement = (SecureConversationToken)SecurityTokensModelHelper.getInstance(this.configVersion).setTokenType(wSDLComponent3, "protection", ComboConstants.SECURECONVERSATION);
                securityTokensModelHelper.setTokenInclusionLevel((WSDLComponent)extensibilityElement, ComboConstants.ALWAYSRECIPIENT);
                policy = (Policy)policyModelHelper.createElement((WSDLComponent)extensibilityElement, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
                ExtensibilityElement extensibilityElement4 = (ExtensibilityElement)bootstrapPolicy.copy((Component)policy);
                policy.addExtensibilityElement(extensibilityElement4);
                wSDLComponent2.removeExtensibilityElement((ExtensibilityElement)bootstrapPolicy);
                policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)extensibilityElement4, Policy.class, false);
                Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent2);
                if (wss10 != null) {
                    policy.addExtensibilityElement((ExtensibilityElement)wss10.copy((Component)policy));
                }
                if ((wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent2)) != null) {
                    policy.addExtensibilityElement((ExtensibilityElement)wss11.copy((Component)policy));
                }
                if ((trustElement = SecurityPolicyModelHelper.getTrust(wSDLComponent2, this.configVersion)) != null) {
                    policy.addExtensibilityElement((ExtensibilityElement)trustElement.copy((Component)policy));
                }
                securityPolicyModelHelper.setLayout(wSDLComponent3, ComboConstants.STRICT);
                if (string != null) {
                    AlgoSuiteModelHelper.getInstance(this.configVersion).setAlgorithmSuite(wSDLComponent3, string);
                } else {
                    AlgoSuiteModelHelper.getInstance(this.configVersion).setAlgorithmSuite(wSDLComponent3, ComboConstants.BASIC128);
                }
                if (bl4) {
                    securityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent3, true);
                }
                if (bl3) {
                    securityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent3, true);
                }
                boolean bl5 = RMModelHelper.getInstance(this.configVersion).isRMEnabled((WSDLComponent)binding);
                securityPolicyModelHelper.setDefaultTargets((WSDLComponent)policy, true, bl5);
                securityPolicyModelHelper.disableWss(wSDLComponent2);
                WssElement wssElement = securityPolicyModelHelper.enableWss(wSDLComponent2, true);
                securityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                securityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                securityPolicyModelHelper.disableTrust(wSDLComponent2);
                trustElement = securityPolicyModelHelper.enableTrust(wSDLComponent2, this.configVersion);
                securityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                securityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                securityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
            } else {
                TrustElement trustElement;
                ExtensibilityElement extensibilityElement;
                ExtensibilityElement extensibilityElement5 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
                WSDLComponent wSDLComponent4 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement5, ProtectionToken.class);
                WSDLComponent wSDLComponent5 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
                WSDLComponent wSDLComponent6 = SecurityTokensModelHelper.getTokenElement(wSDLComponent5, BootstrapPolicy.class);
                ExtensibilityElement extensibilityElement6 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent6);
                WSDLComponent wSDLComponent7 = (WSDLComponent)((WSDLComponent)extensibilityElement5.getParent()).getParent();
                wSDLComponent7.addExtensibilityElement((ExtensibilityElement)extensibilityElement6.copy((Component)wSDLComponent7));
                for (int i = 0; i < 3; ++i) {
                    extensibilityElement = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken((WSDLComponent)extensibilityElement6.getParent(), i);
                    if (extensibilityElement == null) continue;
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy((Component)wSDLComponent7));
                    ((WSDLComponent)extensibilityElement.getParent()).removeExtensibilityElement(extensibilityElement);
                }
                Wss10 wss10 = SecurityPolicyModelHelper.getWss10((WSDLComponent)extensibilityElement6.getParent());
                if (wss10 != null) {
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)wss10.copy((Component)wSDLComponent7));
                }
                if ((extensibilityElement = SecurityPolicyModelHelper.getWss11((WSDLComponent)extensibilityElement6.getParent())) != null) {
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy((Component)wSDLComponent7));
                }
                if ((trustElement = SecurityPolicyModelHelper.getTrust((WSDLComponent)extensibilityElement6.getParent(), this.configVersion)) != null) {
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)trustElement.copy((Component)wSDLComponent7));
                }
                securityPolicyModelHelper.setSecurityBindingType(wSDLComponent, null);
                securityPolicyModelHelper.disableWss(wSDLComponent);
                securityPolicyModelHelper.disableTrust(wSDLComponent);
                Object t = PolicyModelHelper.getTopLevelElement(wSDLComponent7, All.class, false);
                ExtensibilityElement extensibilityElement7 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent7);
                t.addExtensibilityElement((ExtensibilityElement)extensibilityElement7.copy(t));
                ((WSDLComponent)extensibilityElement7.getParent()).removeExtensibilityElement(extensibilityElement7);
                wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent7);
                if (wss10 != null) {
                    t.addExtensibilityElement((ExtensibilityElement)wss10.copy(t));
                    ((WSDLComponent)wss10.getParent()).removeExtensibilityElement((ExtensibilityElement)wss10);
                }
                if ((extensibilityElement = SecurityPolicyModelHelper.getWss11(wSDLComponent7)) != null) {
                    t.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy(t));
                    ((WSDLComponent)extensibilityElement.getParent()).removeExtensibilityElement(extensibilityElement);
                }
                if ((trustElement = SecurityPolicyModelHelper.getTrust(wSDLComponent7, this.configVersion)) != null) {
                    t.addExtensibilityElement((ExtensibilityElement)trustElement.copy(t));
                    ((WSDLComponent)trustElement.getParent()).removeExtensibilityElement((ExtensibilityElement)trustElement);
                }
                for (int i = 0; i < 3; ++i) {
                    ExtensibilityElement extensibilityElement8 = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken(wSDLComponent7, i);
                    if (extensibilityElement8 == null) continue;
                    t.addExtensibilityElement((ExtensibilityElement)extensibilityElement8.copy(t));
                    ((WSDLComponent)extensibilityElement8.getParent()).removeExtensibilityElement(extensibilityElement8);
                }
            }
        }
        finally {
            if (!bl2) {
                wSDLModel.endTransaction();
            }
        }
    }
}

