/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.StoreFileFilter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TruststorePanel
extends JPanel {
    private static final String PKCS12 = "PKCS12";
    private static final String JKS = "JKS";
    private static final String DEFAULT_PASSWORD = "changeit";
    private WSDLComponent comp;
    private String storeType = "JKS";
    private boolean jsr109 = false;
    private Project project = null;
    private String profile = null;
    private boolean inSync = false;
    private ConfigVersion cfgVersion = null;
    private boolean client;
    String storeLocation = null;
    String ksType = null;
    String storePassword = null;
    String certSelector = null;
    private JButton certSelectorButton;
    private JTextField certSelectorField;
    private JLabel certSelectorLbl;
    private JComboBox keyAliasCombo;
    private JLabel keyAliasLabel;
    private JButton loadkeysButton;
    private JButton storeLocationButton;
    private JLabel storeLocationLabel;
    private JTextField storeLocationTextField;
    private JPasswordField storePasswordField;
    private JLabel storePasswordLabel;

    public TruststorePanel(WSDLComponent wSDLComponent, Project project, boolean bl, String string, boolean bl2, ConfigVersion configVersion) {
        this.comp = wSDLComponent;
        this.jsr109 = bl;
        this.project = project;
        this.profile = string;
        this.client = bl2;
        this.cfgVersion = configVersion;
        this.initComponents();
        this.keyAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storeLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storeLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storePasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storePasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certSelectorLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certSelectorButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certSelectorField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getPeerAlias() {
        return (String)this.keyAliasCombo.getSelectedItem();
    }

    private void setPeerAlias(String string) {
        this.keyAliasCombo.setSelectedItem(string);
    }

    private char[] getCharStorePassword() {
        return this.storePasswordField.getPassword();
    }

    private String getStorePassword() {
        return String.valueOf(this.storePasswordField.getPassword());
    }

    private void setStorePassword(String string) {
        this.storePasswordField.setText(string);
    }

    private void setStoreLocation(String string) {
        this.storeLocationTextField.setText(string);
    }

    private String getStoreLocation() {
        String string = this.storeLocationTextField.getText();
        if ("".equals(string) || string == null) {
            return null;
        }
        return string;
    }

    private void setStoreType(String string) {
        this.storeType = string;
    }

    private String getSelector() {
        String string = this.certSelectorField.getText();
        if ("".equals(string) || string == null) {
            return null;
        }
        return string;
    }

    private void setSelector(String string) {
        this.certSelectorField.setText(string);
    }

    public void sync() {
        String string;
        this.inSync = true;
        this.storeLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(this.comp, true);
        if (this.storeLocation != null) {
            this.setStoreLocation(this.storeLocation);
        } else if (this.jsr109) {
            this.setStoreLocation(Util.getStoreLocation(this.project, true, this.client));
        }
        this.ksType = ProprietarySecurityPolicyModelHelper.getStoreType(this.comp, true);
        if (this.ksType != null) {
            this.setStoreType(this.ksType);
        }
        this.storePassword = ProprietarySecurityPolicyModelHelper.getStorePassword(this.comp, true);
        if (this.storePassword != null) {
            this.setStorePassword(this.storePassword);
            this.reloadAliases();
        } else if (this.jsr109) {
            this.storePassword = DEFAULT_PASSWORD;
            this.setStorePassword(DEFAULT_PASSWORD);
            if (!this.reloadAliases()) {
                this.storePassword = string = Util.getPassword(this.project);
                this.setStorePassword(this.storePassword);
            }
            if (!this.reloadAliases()) {
                this.storePassword = "";
                this.setStorePassword("");
            }
        }
        string = ProprietarySecurityPolicyModelHelper.getTrustPeerAlias(this.comp);
        this.setPeerAlias(string);
        this.certSelector = ProprietarySecurityPolicyModelHelper.getCertSelector(this.comp);
        if (this.certSelector != null) {
            this.setSelector(this.certSelector);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
        if (!this.client) {
            boolean bl = true;
            if (ComboConstants.PROF_USERNAME.equals(this.profile) || ComboConstants.PROF_ENDORSCERT.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_STSISSUED.equals(this.profile) || ComboConstants.PROF_STSISSUEDCERT.equals(this.profile) || ComboConstants.PROF_STSISSUEDENDORSE.equals(this.profile) || ComboConstants.PROF_STSISSUEDSUPPORTING.equals(this.profile) || ComboConstants.PROF_MUTUALCERT.equals(this.profile)) {
                bl = false;
            }
            this.keyAliasCombo.setEnabled(bl);
            this.keyAliasLabel.setEnabled(bl);
            this.loadkeysButton.setEnabled(bl);
        }
    }

    private void initComponents() {
        this.storeLocationLabel = new JLabel();
        this.storePasswordLabel = new JLabel();
        this.storeLocationTextField = new JTextField();
        this.storeLocationButton = new JButton();
        this.keyAliasLabel = new JLabel();
        this.keyAliasCombo = new JComboBox();
        this.storePasswordField = new JPasswordField();
        this.loadkeysButton = new JButton();
        this.certSelectorLbl = new JLabel();
        this.certSelectorField = new JTextField();
        this.certSelectorButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.storeLocationLabel, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_KeyStorePanel_LocationLabel"));
        Mnemonics.setLocalizedText((JLabel)this.storePasswordLabel, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststorePanel_TruststorePassword"));
        Mnemonics.setLocalizedText((AbstractButton)this.storeLocationButton, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststorePanel_Browse"));
        this.storeLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TruststorePanel.this.storeLocationButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.keyAliasLabel, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_KeyStorePanel_KeyAliasLabel"));
        this.keyAliasCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.loadkeysButton, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_LoadKeys"));
        this.loadkeysButton.setActionCommand("&Load Aliases");
        this.loadkeysButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TruststorePanel.this.loadkeysButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.certSelectorLbl, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_Truststore_AliasSelectorLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.certSelectorButton, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststorePanel_Browse"));
        this.certSelectorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TruststorePanel.this.certSelectorButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.storeLocationLabel).add((Component)this.storePasswordLabel).add((Component)this.keyAliasLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.keyAliasCombo, 0, 164, Short.MAX_VALUE).add((Component)this.storePasswordField, -1, 164, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.loadkeysButton).addPreferredGap(0, 84, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.certSelectorField, -1, 355, Short.MAX_VALUE).add((Component)this.storeLocationTextField, -1, 355, Short.MAX_VALUE)).addPreferredGap(0)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.certSelectorLbl).add(384, 384, 384))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.storeLocationButton).add((Component)this.certSelectorButton)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.storeLocationLabel).add((Component)this.storeLocationButton).add((Component)this.storeLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.storePasswordLabel).add((Component)this.storePasswordField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyAliasLabel).add((Component)this.keyAliasCombo, -2, -1, -2).add((Component)this.loadkeysButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.certSelectorLbl).add((Component)this.certSelectorField, -2, -1, -2).add((Component)this.certSelectorButton)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.certSelectorField, this.keyAliasCombo, this.storeLocationTextField, this.storePasswordField}, 2);
    }

    private void loadkeysButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.reloadAliases();
        if (!bl) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TruststorePanel.class, (String)"MSG_WrongPassword")));
        }
    }

    private void storeLocationButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststoreBrowse_Title"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new StoreFileFilter());
        File file2 = new File(this.storeLocationTextField.getText());
        if (file2 != null && file2.exists()) {
            if (file2.isDirectory()) {
                jFileChooser.setCurrentDirectory(file2);
            } else {
                jFileChooser.setCurrentDirectory(file2.getParentFile());
            }
        }
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.setStoreLocation(file.getPath());
            String string = FileUtil.getExtension((String)file.getName());
            this.storeType = "jks".equals(string) ? JKS : PKCS12;
        }
    }

    private void certSelectorButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "java.security.cert.CertSelector");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setSelector(string);
                ProprietarySecurityPolicyModelHelper.setCertSelector(this.comp, string, this.client);
            }
        }
    }

    public void storeState() {
        String string = this.getPeerAlias();
        if (string != null && string.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(this.comp, null, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(this.comp, string, this.client);
        }
        String string2 = this.getStorePassword();
        String string3 = this.getStoreLocation();
        if (string2 != null && string2.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, null, true, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, string2, true, this.client);
        }
        ProprietarySecurityPolicyModelHelper.setStoreType(this.comp, this.storeType, true, this.client);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(this.comp, string3, true, this.client);
        String string4 = this.getSelector();
        ProprietarySecurityPolicyModelHelper.setCertSelector(this.comp, string4, this.client);
    }

    private boolean reloadAliases() {
        List<String> list;
        try {
            list = Util.getAliases(this.getStoreLocation(), this.getCharStorePassword(), this.storeType);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        this.keyAliasCombo.removeAllItems();
        if (list != null) {
            this.keyAliasCombo.addItem("");
            for (String string : list) {
                this.keyAliasCombo.addItem(string);
            }
            if (this.keyAliasCombo.getItemCount() > 1) {
                this.keyAliasCombo.setSelectedIndex(1);
            }
        }
        return true;
    }
}

