/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.actions;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.cast.SubtypeChooser;
import org.netbeans.modules.bpel.mapper.cast.SyntheticTypeCast;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.MapperTcContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.actions.MapperAction;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.ui.tree.ExtTreeModel;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.soa.ui.tree.impl.TreeFinderProcessor;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCastAction
extends MapperAction<TreeItem> {
    private static final long serialVersionUID = 1L;
    private boolean mInLeftTree;
    private TreePath mTreePath;
    private GlobalType mGType;

    public AddCastAction(GlobalType globalType, MapperTcContext mapperTcContext, boolean bl, TreePath treePath, TreeItem treeItem) {
        super(mapperTcContext, treeItem);
        this.mTreePath = treePath;
        this.mInLeftTree = bl;
        this.mGType = globalType;
        this.postInit();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MapperAction.class, (String)"ADD_CAST");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MapperModel mapperModel = this.mMapperTcContext.getMapper().getModel();
        assert (mapperModel instanceof BpelMapperModel);
        BpelMapperModel bpelMapperModel = (BpelMapperModel)mapperModel;
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = this.mInLeftTree ? bpelMapperModel.getLeftTreeModel() : bpelMapperModel.getRightTreeModel();
        SoaTreeModel soaTreeModel = mapperSwingTreeModel.getSourceModel();
        CastManager castManager = CastManager.getCastManager(soaTreeModel);
        if (castManager == null) {
            return;
        }
        BpelDesignContext bpelDesignContext = this.mMapperTcContext.getDesignContextController().getContext();
        assert (bpelDesignContext != null);
        SubtypeChooser subtypeChooser = new SubtypeChooser(this.mGType, bpelDesignContext.getBpelModel());
        if (!SubtypeChooser.showDlg(subtypeChooser)) {
            return;
        }
        GlobalType globalType = subtypeChooser.getSelectedValue();
        TreeItem treeItem = (TreeItem)this.getActionSubject();
        SyntheticTypeCast syntheticTypeCast = new SyntheticTypeCast(treeItem, globalType);
        boolean bl = castManager.addTypeCast(treeItem, syntheticTypeCast);
        TreePath treePath = this.mTreePath.getParentPath();
        if (bl) {
            int n = mapperSwingTreeModel.getIndexOfChild(treePath.getLastPathComponent(), this.mTreePath.getLastPathComponent());
            mapperSwingTreeModel.insertChild(treePath, n + 1, syntheticTypeCast);
        }
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor((ExtTreeModel)mapperSwingTreeModel);
        TreePath treePath2 = treeFinderProcessor.findChildByDataObj(treePath, (Object)syntheticTypeCast);
        if (this.mInLeftTree) {
            LeftTree leftTree = this.mMapperTcContext.getMapper().getLeftTree();
            leftTree.setSelectionPath(treePath2);
        } else {
            Mapper mapper = this.mMapperTcContext.getMapper();
            mapper.setSelected(treePath2);
        }
    }
}

