/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.cast.PseudoCompManager;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.bpel.model.ext.editor.api.Casts;
import org.netbeans.modules.bpel.model.ext.editor.api.Editor;
import org.netbeans.modules.bpel.model.ext.editor.api.PseudoComp;
import org.netbeans.modules.bpel.model.ext.editor.api.PseudoComps;
import org.netbeans.modules.bpel.model.ext.editor.api.Source;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorExtensionProcessor {
    private BpelMapperModel mModel;
    private BpelDesignContext mDContext;
    private CastManager mLeftCastManager;
    private PseudoCompManager mLeftPseudoCompManager;
    private PredicateManager mLeftPredicateManager;
    private CastManager mRightCastManager;
    private PseudoCompManager mRightPseudoCompManager;
    private PredicateManager mRightPredicateManager;

    public EditorExtensionProcessor(BpelMapperModel bpelMapperModel, BpelDesignContext bpelDesignContext) {
        this.mModel = bpelMapperModel;
        this.mDContext = bpelDesignContext;
    }

    public void processVariables() {
        Set set = this.mDContext.getVisibilityScope().getVisibleVariables().getAllVisibleVariables();
        for (VariableDeclaration variableDeclaration : set) {
            BpelEditorExtensions bpelEditorExtensions = this.getExtList((BpelEntity)variableDeclaration);
            this.registerCasts(bpelEditorExtensions.getFromCasts());
            this.registerCasts(bpelEditorExtensions.getToCasts());
            this.registerPseudoComps(bpelEditorExtensions.getFromPseudoComps());
            this.registerPseudoComps(bpelEditorExtensions.getToPseudoComps());
        }
    }

    public void registerCasts(BpelEditorExtensions bpelEditorExtensions) {
        this.registerCasts(bpelEditorExtensions.getFromCasts());
        this.registerCasts(bpelEditorExtensions.getToCasts());
    }

    public boolean registerCasts(List<Cast> list) {
        boolean bl = false;
        for (Cast cast : list) {
            Source source = cast.getSource();
            boolean bl2 = source != Source.TO;
            CastManager castManager = this.getCastManager(bl2);
            if (castManager == null || !castManager.addTypeCast(cast)) continue;
            bl = true;
        }
        return bl;
    }

    public void registerPseudoComps(BpelEditorExtensions bpelEditorExtensions) {
        this.registerPseudoComps(bpelEditorExtensions.getFromPseudoComps());
        this.registerPseudoComps(bpelEditorExtensions.getToPseudoComps());
    }

    public boolean registerPseudoComps(List<PseudoComp> list) {
        boolean bl = false;
        for (PseudoComp pseudoComp : list) {
            Source source = pseudoComp.getSource();
            boolean bl2 = source != Source.TO;
            PseudoCompManager pseudoCompManager = this.getPseudoCompManager(bl2);
            if (pseudoCompManager == null || !pseudoCompManager.addPseudoComp(pseudoComp)) continue;
            bl = true;
        }
        return bl;
    }

    public BpelEditorExtensions getExtList(BpelEntity bpelEntity) {
        BpelEditorExtensions bpelEditorExtensions = new BpelEditorExtensions();
        List list = bpelEntity.getChildren(Editor.class);
        for (Editor editor : list) {
            Cast cast;
            Object object;
            List<Cast> list2 = this.getCastList(editor);
            if (list2 != null) {
                object = list2.iterator();
                while (object.hasNext()) {
                    cast = (Cast)object.next();
                    if (cast.getSource() == Source.TO) {
                        bpelEditorExtensions.getToCasts().add(cast);
                        continue;
                    }
                    bpelEditorExtensions.getFromCasts().add(cast);
                }
            }
            if ((object = this.getPseudoCompList(editor)) == null) continue;
            cast = object.iterator();
            while (cast.hasNext()) {
                PseudoComp pseudoComp = (PseudoComp)cast.next();
                if (pseudoComp.getSource() == Source.TO) {
                    bpelEditorExtensions.getToPseudoComps().add(pseudoComp);
                    continue;
                }
                bpelEditorExtensions.getFromPseudoComps().add(pseudoComp);
            }
        }
        return bpelEditorExtensions;
    }

    public List<Cast> getCastList(Editor editor) {
        Cast[] castArray;
        Casts casts = editor.getCasts();
        if (casts != null && (castArray = casts.getCasts()).length > 0) {
            return Arrays.asList(castArray);
        }
        return null;
    }

    public List<PseudoComp> getPseudoCompList(Editor editor) {
        PseudoComp[] pseudoCompArray;
        PseudoComps pseudoComps = editor.getPseudoComps();
        if (pseudoComps != null && (pseudoCompArray = pseudoComps.getPseudoComps()).length > 0) {
            return Arrays.asList(pseudoCompArray);
        }
        return null;
    }

    public CastManager getCastManager(boolean bl) {
        if (bl) {
            if (this.mLeftCastManager == null) {
                this.initManagers(bl);
            }
            return this.mLeftCastManager;
        }
        if (this.mRightCastManager == null) {
            this.initManagers(bl);
        }
        return this.mRightCastManager;
    }

    public PseudoCompManager getPseudoCompManager(boolean bl) {
        if (bl) {
            if (this.mLeftPseudoCompManager == null) {
                this.initManagers(bl);
            }
            return this.mLeftPseudoCompManager;
        }
        if (this.mRightPseudoCompManager == null) {
            this.initManagers(bl);
        }
        return this.mRightPseudoCompManager;
    }

    public PredicateManager getPredicateManager(boolean bl) {
        if (bl) {
            if (this.mLeftPredicateManager == null) {
                this.initManagers(bl);
            }
            return this.mLeftPredicateManager;
        }
        if (this.mRightPredicateManager == null) {
            this.initManagers(bl);
        }
        return this.mRightPredicateManager;
    }

    public void initManagers(boolean bl) {
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = bl ? this.mModel.getLeftTreeModel() : this.mModel.getRightTreeModel();
        SoaTreeModel soaTreeModel = mapperSwingTreeModel.getSourceModel();
        if (bl) {
            this.mLeftCastManager = CastManager.getCastManager(soaTreeModel);
            this.mLeftPseudoCompManager = PseudoCompManager.getPseudoCompManager(soaTreeModel);
            this.mLeftPredicateManager = PredicateManager.getPredicateManager(soaTreeModel);
        } else {
            this.mRightCastManager = CastManager.getCastManager(soaTreeModel);
            this.mRightPseudoCompManager = PseudoCompManager.getPseudoCompManager(soaTreeModel);
            this.mRightPredicateManager = PredicateManager.getPredicateManager(soaTreeModel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BpelEditorExtensions {
        private ArrayList<Cast> mFromCasts = new ArrayList();
        private ArrayList<Cast> mToCasts = new ArrayList();
        private ArrayList<PseudoComp> mFromPseudoComps = new ArrayList();
        private ArrayList<PseudoComp> mToPseudoComps = new ArrayList();

        public List<Cast> getFromCasts() {
            return this.mFromCasts;
        }

        public List<Cast> getToCasts() {
            return this.mToCasts;
        }

        public List<PseudoComp> getFromPseudoComps() {
            return this.mFromPseudoComps;
        }

        public List<PseudoComp> getToPseudoComps() {
            return this.mToPseudoComps;
        }

        public String toString() {
            return "FromCast: " + this.mFromCasts + " FromPseudoComp: " + this.mFromPseudoComps + " ToCast: " + this.mToCasts + " ToPseudoComp: " + this.mToPseudoComps;
        }
    }
}

