/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.Collection;
import java.util.concurrent.Callable;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelModelUpdater;
import org.netbeans.modules.bpel.mapper.model.GraphChangeProcessor;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.schema.InvalidNamespaceException;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelChangeProcessor
implements GraphChangeProcessor {
    private Object mChangeSource;
    private BpelModelUpdater mBpelModelUpdater;

    public BpelChangeProcessor(Object object, BpelModelUpdater bpelModelUpdater) {
        assert (bpelModelUpdater != null);
        assert (object != null);
        this.mChangeSource = object;
        this.mBpelModelUpdater = bpelModelUpdater;
    }

    @Override
    public void processChanges(final TreePath treePath) {
        try {
            BpelModel bpelModel = this.getBpelModel();
            if (bpelModel == null) {
                return;
            }
            this.processRegisterExtensions(bpelModel);
            bpelModel.invoke((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    BpelChangeProcessor.this.mBpelModelUpdater.updateOnChanges(treePath);
                    return null;
                }
            }, this.mChangeSource);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private void processRegisterExtensions(final BpelModel bpelModel) {
        try {
            if (bpelModel == null) {
                return;
            }
            bpelModel.invoke((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    BpelChangeProcessor.this.registerExtensions(bpelModel);
                    return null;
                }
            }, this.mChangeSource);
            bpelModel.sync();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private void registerExtensions(BpelModel bpelModel) throws InvalidNamespaceException {
        Process process;
        Process process2 = process = bpelModel == null ? null : bpelModel.getProcess();
        if (process == null) {
            return;
        }
        ExNamespaceContext exNamespaceContext = process.getNamespaceContext();
        if (exNamespaceContext == null) {
            return;
        }
        exNamespaceContext.addNamespace("http://www.sun.com/wsbpel/2.0/process/executable/SUNExtension/Trace");
        exNamespaceContext.addNamespace("http://www.sun.com/wsbpel/2.0/process/executable/SUNExtension/Editor");
    }

    @Override
    public void processChanges(final Collection<TreePath> collection) {
        try {
            BpelModel bpelModel = this.getBpelModel();
            if (bpelModel == null) {
                return;
            }
            this.processRegisterExtensions(bpelModel);
            bpelModel.invoke((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    for (TreePath treePath : collection) {
                        BpelChangeProcessor.this.mBpelModelUpdater.updateOnChanges(treePath);
                    }
                    return null;
                }
            }, this.mChangeSource);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private BpelModel getBpelModel() {
        return this.mBpelModelUpdater.getDesignContext().getBpelModel();
    }
}

