/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.logging.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContextImpl;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class LoggingContextChangeListener
implements PropertyChangeListener {
    private DesignContextController mController;

    public LoggingContextChangeListener(DesignContextController designContextController) {
        assert (designContextController != null);
        this.mController = designContextController;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        BpelDesignContext bpelDesignContext = null;
        if (!string.equals("activatedNodes")) {
            return;
        }
        bpelDesignContext = LoggingContextChangeListener.getActivatedContext();
        if (this.mController != null && bpelDesignContext != null) {
            this.mController.setContext(bpelDesignContext);
        }
    }

    public static BpelDesignContext getActivatedContext() {
        Object object;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        BpelEntity bpelEntity = null;
        if (nodeArray[0] instanceof InstanceRef) {
            object = ((InstanceRef)nodeArray[0]).getReference();
            if (object instanceof BpelEntity) {
                bpelEntity = (BpelEntity)object;
            }
        } else {
            return null;
        }
        object = nodeArray[0].getLookup();
        BpelDesignContextImpl bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, bpelEntity, bpelEntity, nodeArray[0], (Lookup)object);
        return bpelDesignContextImpl;
    }

    public static BpelDesignContext getActivatedContext(BpelModel bpelModel) {
        Object object;
        if (bpelModel == null) {
            return null;
        }
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        BpelEntity bpelEntity = null;
        if (nodeArray[0] instanceof InstanceRef) {
            object = ((InstanceRef)nodeArray[0]).getReference();
            if (object instanceof BpelEntity && bpelModel.equals(((BpelEntity)object).getBpelModel())) {
                bpelEntity = (BpelEntity)object;
            }
        } else {
            return null;
        }
        object = nodeArray[0].getLookup();
        BpelDesignContextImpl bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, bpelEntity, bpelEntity, nodeArray[0], (Lookup)object);
        return bpelDesignContextImpl;
    }
}

