/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.FileOrZipEntry;

public class MiscUtils
implements CommonConstants {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.utils.Bundle");
    private static final String NOT_DIRECTORY_MSG = messages.getString("MiscUtils_NotDirectoryMsg");
    private static final String NOT_FILE_MSG = messages.getString("MiscUtils_NotFileMsg");
    private static final String FILE_NOT_READABLE_MSG = messages.getString("MiscUtils_FileNotReadableMsg");
    private static final String FILE_NOT_EXIST_MSG = messages.getString("MiscUtils_FileNotExistMsg");
    private static final String VM_VERSION_MSG = messages.getString("MiscUtils_VmVersionMsg");
    private static final String VM_UNKNOWN_MSG = messages.getString("MiscUtils_VmUnknownMsg");
    private static final String VM_INCOMPATIBLE_MSG = messages.getString("MiscUtils_VmIncompatibleMsg");
    private static boolean verbosePrint = false;
    private static boolean printInfo = true;

    public static String getAbsoluteFilePath(String string, String string2) {
        boolean bl = false;
        if (string.startsWith(".")) {
            bl = true;
        } else if (Platform.isWindows()) {
            if (string.charAt(0) != '\\' && string.charAt(0) != '/' && (string.length() <= 1 || string.charAt(1) != ':')) {
                bl = true;
            }
        } else if (string.charAt(0) != '/' && string.charAt(0) != '~') {
            bl = true;
        }
        if (bl) {
            string = string2 + "/" + string;
        }
        return string;
    }

    public static void getAllClassesInDir(String string, String string2, boolean bl, Collection collection) {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            if (stringArray[i].endsWith(".class")) {
                string3 = string2 + (bl ? stringArray[i].substring(0, stringArray[i].length() - 6) : stringArray[i]);
                collection.add(string3.intern());
                continue;
            }
            string3 = string + File.separator + stringArray[i];
            File file2 = new File(string3);
            if (!file2.exists() || !file2.isDirectory()) continue;
            String string4 = string2 + stringArray[i] + "/";
            MiscUtils.getAllClassesInDir(string3, string4, bl, collection);
        }
    }

    public static void getAllClassesInJar(String string, boolean bl, Collection collection) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
        }
        catch (Exception exception) {
            System.err.println("Warning: could not open archive " + string);
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.endsWith(".class")) continue;
            if (bl) {
                string2 = string2.substring(0, string2.length() - 6);
            }
            collection.add(string2.intern());
        }
    }

    public static String getCanonicalPath(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getClassNameForSource(String string, String string2, String string3, String string4) {
        if (string.charAt(1) == ':' && !Character.isLowerCase(string.charAt(0))) {
            string = string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        for (int i = 0; i < 2; ++i) {
            String string5;
            String string6 = string5 = i == 0 ? string2 : string3;
            if (string5 == null) continue;
            ArrayList arrayList = MiscUtils.getPathComponents(string5, true, string4);
            for (int j = 0; j < arrayList.size(); ++j) {
                String string7 = (String)arrayList.get(j);
                if (string7.charAt(1) == ':' && !Character.isLowerCase(string7.charAt(0))) {
                    string7 = string7.substring(0, 1).toLowerCase() + string7.substring(1);
                }
                if (!string7.endsWith(File.separator)) {
                    string7 = string7 + File.separator;
                }
                if (!string.startsWith(string7)) continue;
                String string8 = string.substring(string7.length(), string.length() - 5);
                return string8.replace(File.separatorChar, '.');
            }
        }
        return null;
    }

    public static String getFirstPathComponent(String string) {
        int n = string.indexOf(File.pathSeparatorChar);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getJDKVersionForJVMExeFile(File file) throws IOException {
        int n;
        String[] stringArray = new String[]{file.getAbsolutePath(), "-version"};
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process.getErrorStream();
        int n2 = 500;
        int n3 = 0;
        byte[] byArray = new byte[n2];
        do {
            int n4;
            if ((n4 = inputStream.available()) == 0) {
                n4 = 1;
            }
            if (n3 + n4 >= n2) {
                n4 = n2 - n3;
            }
            if ((n = inputStream.read(byArray, n3, n4)) == -1) continue;
            n3 += n;
        } while (n != -1 && n3 < n2);
        inputStream.close();
        String string = new String(byArray, 0, n3);
        String string2 = "\n" + VM_VERSION_MSG + "\n" + string;
        int n5 = string.indexOf(34);
        if (n5 == -1) {
            throw new IOException(VM_UNKNOWN_MSG + string2);
        }
        if ((string = string.substring(n5 + 1)).startsWith("1.5")) {
            return "jdk15";
        }
        if (string.startsWith("1.6")) {
            return "jdk16";
        }
        if (string.startsWith("1.7")) {
            return "jdk17";
        }
        throw new IOException(VM_INCOMPATIBLE_MSG + string2);
    }

    public static String getLiveClassPathSubset(String string, String string2) {
        ArrayList arrayList = MiscUtils.getPathComponents(string, true, string2);
        StringBuffer stringBuffer = new StringBuffer(arrayList.size() * 10);
        if (arrayList.size() > 0) {
            stringBuffer.append((String)arrayList.get(0));
            for (int i = 1; i < arrayList.size(); ++i) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append((String)arrayList.get(i));
            }
        }
        return stringBuffer.toString();
    }

    public static ArrayList getPathComponents(String string, boolean bl, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() == 0) continue;
                if (bl) {
                    string3 = MiscUtils.getAbsoluteFilePath(string3, string2);
                    if ((string3 = MiscUtils.getCanonicalPath(new File(string3))) == null) continue;
                    arrayList.add(string3);
                    continue;
                }
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static void setSilent(boolean bl) {
        printInfo = !bl;
    }

    public static boolean isSlashedJavaCoreClassName(String string) {
        return string.startsWith("java/") || string.startsWith("sun/") || string.startsWith("javax/");
    }

    public static boolean isSupportedJVM(Map map) {
        String string = (String)map.get("java.version");
        String string2 = (String)map.get("java.vm.name");
        if (string == null || string2 == null) {
            return false;
        }
        return MiscUtils.isSupported15or16or17(string);
    }

    public static boolean isSupportedRunningJVMVersion(String string) {
        return MiscUtils.isSupported15or16or17(string);
    }

    public static void setVerbosePrint() {
        verbosePrint = true;
    }

    public static File checkDirForName(String string) throws IOException {
        File file = new File(string);
        return MiscUtils.checkFile(file, true);
    }

    public static File checkFile(File file, boolean bl) throws IOException {
        if (file.exists()) {
            if (bl) {
                if (!file.isDirectory()) {
                    throw new IOException(MessageFormat.format(NOT_DIRECTORY_MSG, file));
                }
            } else if (!file.isFile()) {
                throw new IOException(MessageFormat.format(NOT_FILE_MSG, file));
            }
            if (!file.canRead()) {
                throw new IOException(MessageFormat.format(FILE_NOT_READABLE_MSG, file));
            }
            return file;
        }
        throw new IOException(FILE_NOT_EXIST_MSG);
    }

    public static File checkFileForName(String string) throws IOException {
        File file = new File(string);
        return MiscUtils.checkFile(file, false);
    }

    public static boolean containsDirectoryOnPath(String string, String string2) {
        String string3 = new File(string).getAbsolutePath().toLowerCase();
        String string4 = new File(string2).getAbsolutePath().toLowerCase();
        ArrayList arrayList = MiscUtils.getPathComponents(string4, false, null);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string3.equals(arrayList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void deleteHeapTempFiles() {
        File file;
        File[] fileArray;
        if (Platform.isWindows() && (fileArray = (file = new File(System.getProperty("java.io.tmpdir"))).listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string = file2.getName();
                if (!string.startsWith("NBProfiler") || !string.endsWith(".map") && !string.endsWith(".ref")) continue;
                file2.delete();
            }
        }
    }

    public static boolean fileForNameOk(String string) {
        try {
            MiscUtils.checkFileForName(string);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean inSamePackage(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 != (n = string2.lastIndexOf(46))) {
            return false;
        }
        if (n2 == -1) {
            return true;
        }
        return string.substring(0, n2).equals(string2.substring(0, n));
    }

    public static void internalError(String string) {
        throw new InternalError(string);
    }

    public static void printErrorMessage(String string) {
        System.err.println("*** Profiler error (" + MiscUtils.getDate() + "): " + string);
    }

    public static void printInfoMessage(String string) {
        if (printInfo) {
            System.err.println("*** Profiler message (" + MiscUtils.getDate() + "): " + string);
        }
    }

    public static void printVerboseInfoMessage(String string) {
        if (verbosePrint) {
            System.err.println("Profiler Engine: " + string);
        }
    }

    public static void printVerboseInfoMessage(String[] stringArray) {
        int n;
        if (!verbosePrint) {
            return;
        }
        for (n = 0; n < stringArray.length - 1; ++n) {
            System.err.print(stringArray[n]);
            System.err.print(" ");
        }
        System.err.println(stringArray[n]);
    }

    public static void printWarningMessage(String string) {
        System.err.println("*** Profiler warning (" + MiscUtils.getDate() + "): " + string);
    }

    public static byte[] readFileIntoBuffer(FileOrZipEntry fileOrZipEntry) throws IOException {
        int n;
        if (fileOrZipEntry.isFile()) {
            MiscUtils.checkFile(fileOrZipEntry.getFile(), false);
        }
        InputStream inputStream = fileOrZipEntry.getInputStream();
        int n2 = (int)fileOrZipEntry.getLength();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = n2;
        do {
            n = inputStream.read(byArray, n3, n4);
            n4 -= n;
        } while ((n3 += n) < n2);
        inputStream.close();
        return byArray;
    }

    private static String getDate() {
        return new Date().toString();
    }

    private static boolean isSupported15or16or17(String string) {
        if (string.startsWith("1.7")) {
            return true;
        }
        if (string.startsWith("1.6")) {
            return true;
        }
        if (string.startsWith("1.5")) {
            return !string.equals("1.5.0") && !string.startsWith("1.5.0_01") && !string.startsWith("1.5.0_02") && !string.startsWith("1.5.0_03");
        }
        return false;
    }
}

