/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.openide.util.Lookup;

public class CCTFlattener
extends CPUCCTVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTFlattener.class.getName());
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private ProfilerClient client;
    private Stack parentStack;
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private int nMethods;
    private CCTResultsFilter currentFilter = null;

    public CCTFlattener(ProfilerClient profilerClient) {
        this.client = profilerClient;
        this.parentStack = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWalk() {
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double d = TimingAdjusterOld.getDefault(profilingSessionStatus).adjustTime(this.timePM0[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], false);
            if (d < 0.0) {
                d = 0.0;
            }
            this.timePM0[i] = (long)d;
            if (i > 0) {
                l = (long)((double)l + d);
            }
            if (profilingSessionStatus.collectingTwoTimeStamps()) {
                d = TimingAdjusterOld.getDefault(profilingSessionStatus).adjustTime(this.timePM1[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], true);
                this.timePM1[i] = (long)d;
                if (i > 0) {
                    l2 = (long)((double)l2 + d);
                }
            }
            l3 += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = new FlatProfileContainerFree(profilingSessionStatus, this.timePM0, this.timePM1, this.invPM, new char[0], l, l2, this.invPM.length);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
        this.currentFilter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeWalk() {
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        this.nMethods = profilingSessionStatus.getNInstrMethods();
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[profilingSessionStatus.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        this.currentFilter = (CCTResultsFilter)Lookup.getDefault().lookup(CCTResultsFilter.class);
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    public void visit(MethodCPUCCTNode methodCPUCCTNode) {
        String string;
        boolean bl;
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        InstrumentationFilter instrumentationFilter = this.client.getSettings().getInstrumentationFilter();
        MethodCPUCCTNode methodCPUCCTNode2 = this.parentStack.isEmpty() ? null : (MethodCPUCCTNode)this.parentStack.peek();
        boolean bl2 = bl = methodCPUCCTNode.getFilteredStatus() == 2;
        if (!bl && methodCPUCCTNode.getFilteredStatus() == 1 && !instrumentationFilter.passesFilter(string = profilingSessionStatus.getInstrMethodClasses()[methodCPUCCTNode.getMethodId()].replace('.', '/'))) {
            bl = true;
        }
        if (!bl && this.currentFilter != null) {
            boolean bl3 = bl = !this.currentFilter.passesFilter();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Processing runtime node: " + profilingSessionStatus.getInstrMethodClasses()[methodCPUCCTNode.getMethodId()] + "." + profilingSessionStatus.getInstrMethodNames()[methodCPUCCTNode.getMethodId()] + "; filtered=" + bl);
            string = methodCPUCCTNode2 != null ? profilingSessionStatus.getInstrMethodClasses()[methodCPUCCTNode2.getMethodId()] + "." + profilingSessionStatus.getInstrMethodNames()[methodCPUCCTNode2.getMethodId()] : "none";
            LOGGER.finest("Currently used parent: " + string);
        }
        if (bl) {
            if (methodCPUCCTNode2 != null && !methodCPUCCTNode2.isRoot()) {
                int n = methodCPUCCTNode2.getMethodId();
                this.invDiff[n] = this.invDiff[n] + methodCPUCCTNode.getNCalls();
                int n2 = methodCPUCCTNode2.getMethodId();
                this.timePM0[n2] = this.timePM0[n2] + methodCPUCCTNode.getNetTime0();
                if (profilingSessionStatus.collectingTwoTimeStamps()) {
                    int n3 = methodCPUCCTNode2.getMethodId();
                    this.timePM1[n3] = this.timePM1[n3] + methodCPUCCTNode.getNetTime1();
                }
            }
        } else {
            int n = methodCPUCCTNode.getMethodId();
            this.timePM0[n] = this.timePM0[n] + methodCPUCCTNode.getNetTime0();
            if (profilingSessionStatus.collectingTwoTimeStamps()) {
                int n4 = methodCPUCCTNode.getMethodId();
                this.timePM1[n4] = this.timePM1[n4] + methodCPUCCTNode.getNetTime1();
            }
            int n5 = methodCPUCCTNode.getMethodId();
            this.invPM[n5] = this.invPM[n5] + methodCPUCCTNode.getNCalls();
            if (methodCPUCCTNode2 != null && !methodCPUCCTNode2.isRoot()) {
                int n6 = methodCPUCCTNode2.getMethodId();
                this.nCalleeInvocations[n6] = this.nCalleeInvocations[n6] + methodCPUCCTNode.getNCalls();
            }
            methodCPUCCTNode2 = methodCPUCCTNode;
        }
        this.parentStack.push(methodCPUCCTNode2);
    }

    public void visitPost(MethodCPUCCTNode methodCPUCCTNode) {
        this.parentStack.pop();
    }

    public void visitPost(ThreadCPUCCTNode threadCPUCCTNode) {
        this.parentStack.clear();
    }
}

