/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchemaTableProvider
implements TableProvider {
    private final SchemaElement schemaElement;
    private final PersistenceGenerator persistenceGen;
    private final Set<Table> tables;

    public DBSchemaTableProvider(SchemaElement schemaElement, PersistenceGenerator persistenceGenerator) {
        this.schemaElement = schemaElement;
        this.persistenceGen = persistenceGenerator;
        this.tables = this.buildTables();
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    private Set<Table> buildTables() {
        ForeignKeyElement[] foreignKeyElementArray;
        Object object;
        HashMap<String, DBSchemaTable> hashMap = new HashMap<String, DBSchemaTable>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        TableElement[] tableElementArray = this.schemaElement.getTables();
        for (Object object2 : tableElementArray) {
            Object object3;
            boolean bl = DbSchemaEjbGenerator.isJoinTable(object2);
            object = DBSchemaTableProvider.getDisabledReasons(object2, this.persistenceGen);
            foreignKeyElementArray = null;
            ForeignKeyElement[] foreignKeyElementArray2 = object.iterator();
            while (foreignKeyElementArray2.hasNext()) {
                object3 = foreignKeyElementArray2.next();
                if (bl && object3 instanceof Table.NoPrimaryKeyDisabledReason) continue;
                foreignKeyElementArray = object3;
                break;
            }
            foreignKeyElementArray2 = object2.getDeclaringSchema().getCatalog().getName();
            object3 = object2.getDeclaringSchema().getSchema().getName();
            String string = object2.getName().getName();
            DBSchemaTable object4 = new DBSchemaTable((String)foreignKeyElementArray2, (String)object3, string, bl, (Table.DisabledReason)foreignKeyElementArray, this.persistenceGen, object2.isTable());
            object4.setUniqueConstraints(this.getUniqueConstraints((TableElement)object2));
            hashMap.put(string, object4);
            hashMap2.put(string, new HashSet());
            hashMap3.put(string, new HashSet());
            hashMap4.put(string, new HashSet());
        }
        for (Object object2 : tableElementArray) {
            if (!object2.isTable()) continue;
            String string = object2.getName().getName();
            object = (Table)hashMap.get(string);
            foreignKeyElementArray = object2.getForeignKeys();
            if (foreignKeyElementArray == null) continue;
            for (ForeignKeyElement foreignKeyElement : foreignKeyElementArray) {
                TableElement tableElement = foreignKeyElement.getReferencedTable();
                String string2 = tableElement.getName().getName();
                Table table = (Table)hashMap.get(string2);
                ((Set)hashMap2.get(string)).add(table);
                ((Set)hashMap3.get(string2)).add(object);
                if (!((Table)object).isJoin()) continue;
                ((Set)hashMap4.get(string2)).add(object);
            }
        }
        HashSet hashSet = new HashSet();
        for (DBSchemaTable dBSchemaTable : hashMap.values()) {
            Object object2;
            object2 = dBSchemaTable.getName();
            dBSchemaTable.setReferencedTables(Collections.unmodifiableSet((Set)hashMap2.get(object2)));
            dBSchemaTable.setReferencedByTables(Collections.unmodifiableSet((Set)hashMap3.get(object2)));
            dBSchemaTable.setJoinTables(Collections.unmodifiableSet((Set)hashMap4.get(object2)));
            hashSet.add(dBSchemaTable);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private Set<List<String>> getUniqueConstraints(TableElement tableElement) {
        HashSet<List<String>> hashSet = new HashSet<List<String>>();
        UniqueKeyElement[] uniqueKeyElementArray = tableElement.getUniqueKeys();
        for (int i = 0; i < uniqueKeyElementArray.length; ++i) {
            ColumnElement[] columnElementArray;
            if (uniqueKeyElementArray[i].isPrimaryKey() || (columnElementArray = uniqueKeyElementArray[i].getColumns()) == null || columnElementArray.length == 0) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = 0; j < columnElementArray.length; ++j) {
                arrayList.add(columnElementArray[j].getName().getName());
            }
            hashSet.add(arrayList);
        }
        return hashSet;
    }

    private static List<Table.DisabledReason> getDisabledReasons(TableElement tableElement, PersistenceGenerator persistenceGenerator) {
        String string;
        ArrayList<Table.DisabledReason> arrayList = new ArrayList<Table.DisabledReason>();
        if (tableElement.isTable() && DBSchemaTableProvider.hasNoPrimaryKey(tableElement)) {
            arrayList.add(new Table.NoPrimaryKeyDisabledReason());
        }
        if ((string = persistenceGenerator.getFQClassName(tableElement.getName().getName())) != null) {
            arrayList.add(new Table.ExistingDisabledReason(string));
        }
        return arrayList;
    }

    private static boolean hasNoPrimaryKey(TableElement tableElement) {
        return tableElement.getPrimaryKey() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DBSchemaTable
    extends Table {
        private final PersistenceGenerator persistenceGen;
        private Set<Table> referencedTables;
        private Set<Table> referencedByTables;
        private Set<Table> joinTables;
        private Set<List<String>> uniqueConstraints;

        public DBSchemaTable(String string, String string2, String string3, boolean bl, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGenerator) {
            super(string, string2, string3, bl, disabledReason);
            this.persistenceGen = persistenceGenerator;
        }

        public DBSchemaTable(String string, String string2, String string3, boolean bl, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGenerator, boolean bl2) {
            super(string, string2, string3, bl, disabledReason, bl2);
            this.persistenceGen = persistenceGenerator;
        }

        @Override
        public Set<Table> getReferencedTables() {
            return this.referencedTables;
        }

        private void setReferencedTables(Set<Table> set) {
            this.referencedTables = set;
        }

        @Override
        public Set<Table> getReferencedByTables() {
            return this.referencedByTables;
        }

        private void setReferencedByTables(Set<Table> set) {
            this.referencedByTables = set;
        }

        @Override
        public Set<Table> getJoinTables() {
            return this.joinTables;
        }

        private void setJoinTables(Set<Table> set) {
            this.joinTables = set;
        }

        @Override
        public Set<List<String>> getUniqueConstraints() {
            return this.uniqueConstraints;
        }

        public void setUniqueConstraints(Set<List<String>> set) {
            this.uniqueConstraints = set;
        }
    }
}

