/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.sql.project.anttasks.ExtensionFilter;

public class DirectoryUtil {
    public static List getFiles(String fromDir) {
        ArrayList<String> filesList = new ArrayList<String>();
        if (DirectoryUtil.dirExists(fromDir)) {
            File aDir = new File(fromDir);
            String[] files = aDir.list();
            int numFiles = files.length;
            for (int i = 0; i < numFiles; ++i) {
                String fileName = fromDir + System.getProperty("file.separator") + files[i];
                if (DirectoryUtil.dirExists(fileName)) continue;
                filesList.add(files[i]);
            }
        }
        return filesList;
    }

    public static void moveTree(File sourceDir, File targetDir, String[] excludeExt) {
        ExtensionFilter filter = new ExtensionFilter(excludeExt, false);
        DirectoryUtil.moveFilesInDir(sourceDir, targetDir, filter, true);
    }

    public static String buildFullPath(String aDir, String aFileName) {
        String currentDir = ".";
        String fullPath = "";
        fullPath = aFileName.startsWith(currentDir) ? aDir + aFileName.substring(1) : (aFileName.startsWith(System.getProperty("file.separator")) ? aDir + aFileName : aDir + System.getProperty("file.separator") + aFileName);
        return fullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File dest) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            DirectoryUtil.copyStream(in, out);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(String source, String destDir) {
        FileInputStream fisource = null;
        FileOutputStream fodest = null;
        try {
            File fsource = new File(source);
            fisource = new FileInputStream(fsource);
            File fdest = new File(destDir, fsource.getName());
            fodest = new FileOutputStream(fdest);
            DirectoryUtil.copyStream(fisource, fodest);
        }
        catch (Throwable e) {
            try {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    fisource.close();
                }
                catch (Throwable e2) {}
                try {
                    fodest.close();
                }
                catch (Throwable e3) {}
            }
        }
        try {
            fisource.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            fodest.close();
            return true;
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static void copyFilesInDir(File sourceDir, File targetDir, FileFilter filter, boolean recursive) {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File[] children = sourceDir.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory() && recursive) {
                DirectoryUtil.copyFilesInDir(children[i], new File(targetDir, children[i].getName()), filter, recursive);
                continue;
            }
            DirectoryUtil.copyFile(children[i], new File(targetDir, children[i].getName()));
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int bytesRead = 0;
        byte[] memBuf = new byte[32768];
        while (bytesRead != -1) {
            bytesRead = is.read(memBuf);
            if (bytesRead == -1) continue;
            os.write(memBuf, 0, bytesRead);
        }
        os.flush();
    }

    public static void copyStream(Reader r, Writer w) throws IOException {
        int nRead;
        char[] memBuf = new char[32768];
        while ((nRead = r.read(memBuf)) != -1) {
            w.write(memBuf, 0, nRead);
        }
        w.flush();
    }

    public static void copyTree(File sourceDir, File targetDir, String[] excludeExt) {
        ExtensionFilter filter = new ExtensionFilter(excludeExt, false);
        DirectoryUtil.copyFilesInDir(sourceDir, targetDir, filter, true);
    }

    public static boolean createDir(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static boolean deleteDir(String dirName) {
        return DirectoryUtil.deleteDir(new File(dirName));
    }

    public static boolean deleteDir(File dir) {
        return DirectoryUtil.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean deleteOriginalDir) {
        if (!dir.isDirectory() || !dir.exists()) {
            return false;
        }
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isDirectory()) {
                DirectoryUtil.deleteDir(file[i]);
            }
            file[i].delete();
        }
        if (deleteOriginalDir) {
            return dir.delete();
        }
        return true;
    }

    public static boolean deleteFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile() && file.canRead()) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteFile(String filename, String dirName) {
        return DirectoryUtil.deleteFile(dirName + File.separator + filename);
    }

    public static boolean dirExists(String dirName) {
        File dir = new File(dirName);
        return dir.exists() && dir.isDirectory();
    }

    public static boolean fileExists(String filename) {
        File file = new File(filename);
        return file.exists() && !file.isDirectory();
    }

    public static boolean moveFile(String filename, String toDir) {
        char fs = System.getProperty("file.separator").charAt(0);
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        String destinationFile = toDir + fs + file.getName();
        File desFile = new File(destinationFile);
        if (desFile.exists()) {
            DirectoryUtil.deleteFile(file.getName(), toDir);
        }
        DirectoryUtil.createDir(toDir);
        if (file.isFile() && file.canRead()) {
            return file.renameTo(new File(toDir, file.getName()));
        }
        return false;
    }

    public static boolean moveFile(File file, String toDir) {
        char fs = System.getProperty("file.separator").charAt(0);
        if (!file.exists()) {
            return false;
        }
        String destinationFile = toDir + fs + file.getName();
        File desFile = new File(destinationFile);
        if (desFile.exists()) {
            DirectoryUtil.deleteFile(file.getName(), toDir);
        }
        DirectoryUtil.createDir(toDir);
        if (file.isFile() && file.canRead()) {
            return file.renameTo(new File(toDir, file.getName()));
        }
        return false;
    }

    public static boolean moveFile(String filename, String fromDir, String toDir) {
        return DirectoryUtil.moveFile(fromDir + File.separator + filename, toDir);
    }

    public static void moveFilesInDir(File sourceDir, File targetDir, FileFilter filter, boolean recursive) {
        char fs = System.getProperty("file.separator").charAt(0);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File[] children = sourceDir.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory() && recursive) {
                DirectoryUtil.moveFilesInDir(children[i], new File(targetDir, children[i].getName()), filter, recursive);
                continue;
            }
            DirectoryUtil.moveFile(children[i], targetDir.getAbsolutePath());
        }
    }

    public static List getFilesRecursively(File dir, FileFilter filter) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!dir.isDirectory()) {
            return ret;
        }
        File[] fileNdirs = dir.listFiles(filter);
        int I = fileNdirs.length;
        for (int i = 0; i < I; ++i) {
            if (fileNdirs[i].isDirectory()) {
                ret.addAll(DirectoryUtil.getFilesRecursively(fileNdirs[i], filter));
                continue;
            }
            ret.add(fileNdirs[i]);
        }
        return ret;
    }

    public static List getFilesRecursively(File dir, String[] extensions) {
        ExtensionFilter filter = new ExtensionFilter(extensions);
        return DirectoryUtil.getFilesRecursively(dir, filter);
    }
}

