/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.modules.project.ant.FileChooserAccessory;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLibraryProvider
implements ArealLibraryProvider<ProjectLibraryArea, ProjectLibraryImplementation>,
PropertyChangeListener,
AntProjectListener {
    private static final String NAMESPACE = "http://www.netbeans.org/ns/ant-project-libraries/1";
    private static final String EL_LIBRARIES = "libraries";
    private static final String EL_DEFINITIONS = "definitions";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private AntProjectListener apl;
    public static ProjectLibraryProvider INSTANCE;
    private volatile boolean listening = true;
    private final Map<ProjectLibraryArea, Reference<LP>> providers = new HashMap<ProjectLibraryArea, Reference<LP>>();
    static final Pattern LIBS_LINE;
    private static final RequestProcessor RP;
    public static boolean FIRE_CHANGES_SYNCH;

    public ProjectLibraryProvider() {
        INSTANCE = this;
    }

    public Class<ProjectLibraryArea> areaType() {
        return ProjectLibraryArea.class;
    }

    public Class<ProjectLibraryImplementation> libraryType() {
        return ProjectLibraryImplementation.class;
    }

    public String toString() {
        return "ProjectLibraryProvider";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ProjectLibraryArea> getOpenAreas() {
        Object object = this;
        synchronized (object) {
            if (this.apl == null) {
                this.apl = (AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, null);
                OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
            }
        }
        object = new HashSet();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            AntProjectHelper antProjectHelper = AntBasedProjectFactorySingleton.getHelperFor(project);
            if (antProjectHelper == null) continue;
            antProjectHelper.removeAntProjectListener(this.apl);
            antProjectHelper.addAntProjectListener(this.apl);
            Definitions definitions = ProjectLibraryProvider.findDefinitions(antProjectHelper);
            if (definitions == null) continue;
            object.add(new ProjectLibraryArea(definitions.mainPropertiesFile));
        }
        return object;
    }

    public ProjectLibraryArea createArea() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(NbBundle.getMessage(ProjectLibraryProvider.class, (String)"ProjectLibraryProvider.open_or_create"));
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".properties") && !file.getName().endsWith("-private.properties");
            }

            public String getDescription() {
                return NbBundle.getMessage(ProjectLibraryProvider.class, (String)"ProjectLibraryProvider.properties_files");
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        while (jFileChooser.showOpenDialog(null) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!fileFilter.accept(file)) continue;
            return new ProjectLibraryArea(file);
        }
        return null;
    }

    public ProjectLibraryArea loadArea(URL uRL) {
        if (uRL.getProtocol().equals("file") && uRL.getPath().endsWith(".properties")) {
            try {
                return new ProjectLibraryArea(new File(uRL.toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
            this.pcs.firePropertyChange("openAreas", null, null);
        }
    }

    @Override
    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.pcs.firePropertyChange("openAreas", null, null);
    }

    @Override
    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    public synchronized LP getLibraries(ProjectLibraryArea projectLibraryArea) {
        LP lP;
        Reference<LP> reference = this.providers.get(projectLibraryArea);
        LP lP2 = lP = reference != null ? reference.get() : null;
        if (lP == null) {
            lP = new LP(projectLibraryArea);
            this.providers.put(projectLibraryArea, new WeakReference<LP>(lP));
        }
        return lP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectLibraryImplementation createLibrary(String string, String string2, ProjectLibraryArea projectLibraryArea, Map<String, List<URI>> map) throws IOException {
        File file = projectLibraryArea.mainPropertiesFile;
        assert (this.listening);
        this.listening = false;
        try {
            if (string.equals("j2se")) {
                ProjectLibraryProvider.replaceProperty(file, true, "libs." + string2 + ".classpath", "");
            } else {
                ProjectLibraryProvider.replaceProperty(file, false, "libs." + string2 + ".type", string);
            }
        }
        finally {
            this.listening = true;
        }
        LP lP = this.getLibraries(projectLibraryArea);
        boolean bl = this.delta(lP.libraries, ProjectLibraryProvider.calculate(projectLibraryArea), new HashMap<ProjectLibraryImplementation, List<String>>());
        ProjectLibraryImplementation projectLibraryImplementation = lP.getLibrary(string2);
        assert (projectLibraryImplementation != null) : string2 + " not found in " + file;
        for (Map.Entry<String, List<URI>> entry : map.entrySet()) {
            projectLibraryImplementation.setURIContent(entry.getKey(), entry.getValue());
        }
        if (bl) {
            lP.pcs.firePropertyChange(EL_LIBRARIES, null, null);
        }
        return projectLibraryImplementation;
    }

    public void remove(ProjectLibraryImplementation projectLibraryImplementation) throws IOException {
        String string = "libs." + projectLibraryImplementation.name + ".";
        for (File file : new File[]{projectLibraryImplementation.mainPropertiesFile, projectLibraryImplementation.privatePropertiesFile}) {
            for (String string2 : ProjectLibraryProvider.loadProperties(file).keySet()) {
                if (!string2.startsWith(string)) continue;
                ProjectLibraryProvider.replaceProperty(file, false, string2, new String[0]);
            }
        }
    }

    private static Definitions findDefinitions(AntProjectHelper antProjectHelper) {
        File file;
        String string = ProjectLibraryProvider.getLibrariesLocationText(antProjectHelper.createAuxiliaryConfiguration());
        if (string != null && (file = antProjectHelper.resolveFile(string)).getName().endsWith(".properties")) {
            return new Definitions(file);
        }
        return null;
    }

    public static File getLibrariesLocation(AuxiliaryConfiguration auxiliaryConfiguration, File file) {
        String string = ProjectLibraryProvider.getLibrariesLocationText(auxiliaryConfiguration);
        if (string != null) {
            return PropertyUtils.resolveFile(file, string);
        }
        return null;
    }

    public static String getLibrariesLocationText(AuxiliaryConfiguration auxiliaryConfiguration) {
        Iterator<Element> iterator;
        Element element = auxiliaryConfiguration.getConfigurationFragment(EL_LIBRARIES, NAMESPACE, true);
        if (element != null && (iterator = Util.findSubElements(element).iterator()).hasNext()) {
            Element element2 = iterator.next();
            assert (element2.getLocalName().equals(EL_DEFINITIONS)) : element2;
            String string = Util.findText(element2);
            assert (string != null) : auxiliaryConfiguration;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadProperties(File file) {
        if (!file.isFile()) {
            return Collections.emptyMap();
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
            return NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true);
        }
        catch (IOException iOException) {
            Exceptions.attachMessage((Throwable)iOException, (String)("Loading: " + file));
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptyMap();
        }
    }

    private static Map<String, ProjectLibraryImplementation> calculate(ProjectLibraryArea projectLibraryArea) {
        HashMap<String, String> hashMap;
        String string;
        Object object;
        HashMap<String, ProjectLibraryImplementation> hashMap2 = new HashMap<String, ProjectLibraryImplementation>();
        Definitions definitions = new Definitions(projectLibraryArea.mainPropertiesFile);
        HashMap<String, HashMap<String, String>> hashMap3 = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> entry : definitions.properties(false).entrySet()) {
            object = LIBS_LINE.matcher(entry.getKey());
            if (!((Matcher)object).matches()) continue;
            string = ((Matcher)object).group(1);
            hashMap = (HashMap<String, String>)hashMap3.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                hashMap3.put(string, hashMap);
            }
            hashMap.put(((Matcher)object).group(2), entry.getValue());
        }
        for (Map.Entry<String, String> entry : hashMap3.entrySet()) {
            object = entry.getKey();
            string = "j2se";
            hashMap = null;
            HashMap<String, List<URI>> hashMap4 = new HashMap<String, List<URI>>();
            for (Map.Entry entry2 : ((Map)((Object)entry.getValue())).entrySet()) {
                String string2 = (String)entry2.getKey();
                if (string2.equals("type")) {
                    string = (String)entry2.getValue();
                    continue;
                }
                if (string2.equals("name")) continue;
                if (string2.equals("description")) {
                    hashMap = (String)entry2.getValue();
                    continue;
                }
                String[] stringArray = PropertyUtils.tokenizePath((String)entry2.getValue());
                ArrayList<URI> arrayList = new ArrayList<URI>(stringArray.length);
                for (String string3 : stringArray) {
                    String string4 = null;
                    int n = string3.indexOf("!" + File.separatorChar);
                    if (n != -1) {
                        string4 = string3.substring(n + 2);
                        string3 = string3.substring(0, n);
                    }
                    String string5 = string3.replace('/', File.separatorChar).replace('\\', File.separatorChar).replace("${base}" + File.separatorChar, "");
                    File file = FileUtil.normalizeFile((File)new File(string3.replace('/', File.separatorChar).replace('\\', File.separatorChar).replace("${base}", projectLibraryArea.mainPropertiesFile.getParent())));
                    try {
                        URI malformedURLException = LibrariesSupport.convertFilePathToURI((String)string5);
                        if (FileUtil.isArchiveFile((URL)file.toURI().toURL())) {
                            malformedURLException = ProjectLibraryProvider.appendJarFolder(malformedURLException, string4);
                        } else if (!malformedURLException.getPath().endsWith("/")) {
                            malformedURLException = new URI(malformedURLException.toString() + "/");
                        }
                        arrayList.add(malformedURLException);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Exceptions.printStackTrace((Throwable)uRISyntaxException);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
                hashMap4.put(string2, arrayList);
            }
            hashMap2.put((String)object, new ProjectLibraryImplementation(definitions.mainPropertiesFile, definitions.privatePropertiesFile, string, (String)object, (String)((Object)hashMap), (Map<String, List<URI>>)hashMap4));
        }
        return hashMap2;
    }

    private boolean delta(Map<String, ProjectLibraryImplementation> map, Map<String, ProjectLibraryImplementation> map2, Map<ProjectLibraryImplementation, List<String>> map3) {
        if (!this.listening) {
            return false;
        }
        assert (map3 != null);
        HashSet<String> hashSet = new HashSet<String>(map2.keySet());
        hashSet.removeAll(map.keySet());
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Map.Entry<String, ProjectLibraryImplementation> object : map.entrySet()) {
            List<String> list;
            String string = object.getKey();
            ProjectLibraryImplementation projectLibraryImplementation = object.getValue();
            ProjectLibraryImplementation projectLibraryImplementation2 = map2.get(string);
            if (projectLibraryImplementation2 == null) {
                hashSet2.add(string);
                continue;
            }
            if (!projectLibraryImplementation.type.equals(projectLibraryImplementation2.type)) {
                hashSet.add(string);
                hashSet2.add(string);
                map.put(string, projectLibraryImplementation2);
                continue;
            }
            assert (projectLibraryImplementation.name.equals(projectLibraryImplementation2.name));
            if (!Utilities.compareObjects((Object)projectLibraryImplementation.description, (Object)projectLibraryImplementation2.description)) {
                projectLibraryImplementation.description = projectLibraryImplementation2.description;
                list = map3.get(projectLibraryImplementation);
                if (list == null) {
                    list = new ArrayList<String>();
                    map3.put(projectLibraryImplementation, list);
                }
                list.add("description");
            }
            if (((Object)projectLibraryImplementation.contents).equals(projectLibraryImplementation2.contents)) continue;
            projectLibraryImplementation.contents = projectLibraryImplementation2.contents;
            list = map3.get(projectLibraryImplementation);
            if (list == null) {
                list = new ArrayList<String>();
                map3.put(projectLibraryImplementation, list);
            }
            list.add("content");
        }
        for (String string : hashSet) {
            map.put(string, map2.get(string));
        }
        for (String string : hashSet2) {
            map.remove(string);
        }
        return !hashSet.isEmpty() || !hashSet2.isEmpty();
    }

    private static String getJarFolder(URI uRI) {
        String string = uRI.toString();
        int n = string.indexOf("!/");
        if (n != -1 && n + 2 < string.length()) {
            return string.substring(n + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI uRI, String string) {
        try {
            if (uRI.isAbsolute()) {
                return new URI("jar:" + uRI.toString() + "!/" + (string == null ? "" : string.replace('\\', '/')));
            }
            return new URI(uRI.toString() + "!/" + (string == null ? "" : string.replace('\\', '/')));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceProperty(File file, boolean bl, String string, String ... stringArray) throws IOException {
        FileInputStream fileInputStream;
        EditableProperties editableProperties = new EditableProperties();
        if (file.isFile()) {
            fileInputStream = new FileInputStream(file);
            try {
                editableProperties.load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        if (Utilities.compareObjects((Object)stringArray, (Object)editableProperties.getProperty(string))) {
            return;
        }
        if (stringArray.length > 0) {
            if (bl) {
                editableProperties.setProperty(string, stringArray);
            } else {
                assert (stringArray.length == 1) : Arrays.asList(stringArray);
                editableProperties.setProperty(string, stringArray[0]);
            }
        } else {
            editableProperties.remove(string);
        }
        fileInputStream = FileUtil.createData((File)file);
        OutputStream outputStream = fileInputStream.getOutputStream();
        try {
            editableProperties.store(outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public static PropertyProvider createPropertyProvider(AntProjectHelper antProjectHelper) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PP
        implements PropertyProvider,
        FileChangeSupportListener,
        AntProjectListener {
            final ChangeSupport cs = new ChangeSupport((Object)this);
            final Set<File> listeningTo = new HashSet<File>();
            final /* synthetic */ AntProjectHelper val$helper;

            PP(AntProjectHelper antProjectHelper) {
                this.val$helper = antProjectHelper;
                this.val$helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)this.val$helper));
            }

            private void listenTo(File file, Set<File> set) {
                if (file != null) {
                    set.remove(file);
                    if (this.listeningTo.add(file)) {
                        FileChangeSupport.DEFAULT.addListener(this, file);
                    }
                }
            }

            @Override
            public synchronized Map<String, String> getProperties() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashSet<File> hashSet = new HashSet<File>(this.listeningTo);
                Definitions definitions = ProjectLibraryProvider.findDefinitions(this.val$helper);
                if (definitions != null) {
                    hashMap.putAll(definitions.properties(true));
                    this.listenTo(definitions.mainPropertiesFile, hashSet);
                    this.listenTo(definitions.privatePropertiesFile, hashSet);
                }
                for (File file : hashSet) {
                    this.listeningTo.remove(file);
                    FileChangeSupport.DEFAULT.removeListener(this, file);
                }
                return hashMap;
            }

            @Override
            public void addChangeListener(ChangeListener changeListener) {
                this.cs.addChangeListener(changeListener);
            }

            @Override
            public void removeChangeListener(ChangeListener changeListener) {
                this.cs.removeChangeListener(changeListener);
            }

            @Override
            public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
                this.fireChangeNowOrLater();
            }

            @Override
            public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
                this.fireChangeNowOrLater();
            }

            @Override
            public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
                this.fireChangeNowOrLater();
            }

            void fireChangeNowOrLater() {
                if (!this.cs.hasListeners()) {
                    return;
                }
                Mutex.Action<Void> action = new Mutex.Action<Void>(){

                    public Void run() {
                        cs.fireChange();
                        return null;
                    }
                };
                if (ProjectManager.mutex().isWriteAccess() || FIRE_CHANGES_SYNCH) {
                    ProjectManager.mutex().readAccess((Mutex.Action)action);
                } else if (ProjectManager.mutex().isReadAccess()) {
                    action.run();
                } else {
                    RP.post(new Runnable((Mutex.Action)action){
                        final /* synthetic */ Mutex.Action val$action;
                        {
                            this.val$action = action;
                        }

                        public void run() {
                            ProjectManager.mutex().readAccess(this.val$action);
                        }
                    });
                }
            }

            @Override
            public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
                this.cs.fireChange();
            }

            @Override
            public void propertiesChanged(AntProjectEvent antProjectEvent) {
            }
        }
        return new PP(antProjectHelper);
    }

    public static boolean isReachableLibrary(Library library, AntProjectHelper antProjectHelper) {
        URL uRL = library.getManager().getLocation();
        if (uRL == null) {
            return false;
        }
        ProjectLibraryArea projectLibraryArea = INSTANCE.loadArea(uRL);
        if (projectLibraryArea == null) {
            return false;
        }
        ProjectLibraryImplementation projectLibraryImplementation = INSTANCE.getLibraries(projectLibraryArea).getLibrary(library.getName());
        if (projectLibraryImplementation == null) {
            return false;
        }
        Definitions definitions = ProjectLibraryProvider.findDefinitions(antProjectHelper);
        if (definitions == null) {
            return false;
        }
        return definitions.mainPropertiesFile.equals(projectLibraryImplementation.mainPropertiesFile);
    }

    public static Element createLibrariesElement(Document document, String string) {
        Element element = document.createElementNS(NAMESPACE, EL_LIBRARIES);
        element.appendChild(element.getOwnerDocument().createElementNS(NAMESPACE, EL_DEFINITIONS)).appendChild(element.getOwnerDocument().createTextNode(string));
        return element;
    }

    public static LibraryManager getProjectLibraryManager(AntProjectHelper antProjectHelper) {
        Definitions definitions = ProjectLibraryProvider.findDefinitions(antProjectHelper);
        if (definitions != null) {
            try {
                return LibraryManager.forLocation((URL)definitions.mainPropertiesFile.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return null;
    }

    public static void setLibrariesLocation(AntProjectHelper antProjectHelper, String string) {
        if (string == null) {
            antProjectHelper.createAuxiliaryConfiguration().removeConfigurationFragment(EL_LIBRARIES, NAMESPACE, true);
            return;
        }
        Element element = antProjectHelper.createAuxiliaryConfiguration().getConfigurationFragment(EL_LIBRARIES, NAMESPACE, true);
        if (element == null) {
            element = XMLUtil.createDocument((String)"dummy", null, null, null).createElementNS(NAMESPACE, EL_LIBRARIES);
        } else {
            List<Element> list = Util.findSubElements(element);
            if (list.size() == 1) {
                element.removeChild(list.get(0));
            }
        }
        element.appendChild(element.getOwnerDocument().createElementNS(NAMESPACE, EL_DEFINITIONS)).appendChild(element.getOwnerDocument().createTextNode(string));
        antProjectHelper.createAuxiliaryConfiguration().putConfigurationFragment(element, true);
    }

    public static List<String> getUnsharablePathsWithinProject(AntProjectHelper antProjectHelper) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Definitions definitions = ProjectLibraryProvider.findDefinitions(antProjectHelper);
        if (definitions != null && definitions.privatePropertiesFile != null) {
            arrayList.add(definitions.privatePropertiesFile.getAbsolutePath());
        }
        return arrayList;
    }

    public static Library copyLibrary(final Library library, URL uRL, final boolean bl) throws IOException {
        LibraryManager libraryManager;
        File file = new File(URI.create(uRL.toExternalForm())).getParentFile();
        FileObject fileObject = null;
        final HashMap hashMap = new HashMap();
        for (String string : libraryManager = LibrariesSupport.getLibraryTypeProvider((String)library.getType()).getSupportedVolumeTypes()) {
            ArrayList<URI> arrayList = new ArrayList<URI>();
            Iterator iterator = library.getContent(string).iterator();
            while (iterator.hasNext()) {
                String string2;
                FileObject fileObject2;
                FileObject fileObject3;
                URL uRL2;
                URL uRL3 = uRL2 = (URL)iterator.next();
                String string3 = null;
                if ("jar".equals(uRL3.getProtocol())) {
                    string3 = ProjectLibraryProvider.getJarFolder(URI.create(uRL3.toExternalForm()));
                    uRL3 = FileUtil.getArchiveFile((URL)uRL3);
                }
                if ((fileObject3 = URLMapper.findFileObject((URL)uRL3)) == null) {
                    if (!"file".equals(uRL3.getProtocol()) && !"nbinst".equals(uRL3.getProtocol())) {
                        Logger.getLogger(ProjectLibraryProvider.class.getName()).info("copyLibrary is ignoring entry " + uRL3);
                        continue;
                    }
                    Logger.getLogger(ProjectLibraryProvider.class.getName()).warning("Library '" + library.getDisplayName() + "' contains entry (" + uRL3 + ") which does not exist. This entry is ignored and will not be copied to sharable libraries location.");
                    continue;
                }
                if (CollocationQuery.areCollocated((File)file, (File)FileUtil.toFile((FileObject)fileObject3))) {
                    fileObject2 = fileObject3;
                    string2 = PropertyUtils.relativizeFile(file, FileUtil.toFile((FileObject)fileObject2));
                } else {
                    if (fileObject == null) {
                        fileObject = ProjectLibraryProvider.getSharedLibFolder(file, library);
                    }
                    if (fileObject3.isFolder()) {
                        fileObject2 = FileChooserAccessory.copyFolderRecursively(fileObject3, fileObject);
                        string2 = fileObject.getNameExt() + File.separatorChar + fileObject2.getName() + File.separatorChar;
                    } else {
                        String string4 = ProjectLibraryProvider.getUniqueName(fileObject, fileObject3.getName(), fileObject3.getExt());
                        fileObject2 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject, (String)string4);
                        string2 = fileObject.getNameExt() + File.separatorChar + fileObject2.getNameExt();
                    }
                }
                URI uRI = LibrariesSupport.convertFilePathToURI((String)string2);
                if (FileUtil.isArchiveFile((FileObject)fileObject2)) {
                    uRI = ProjectLibraryProvider.appendJarFolder(uRI, string3);
                }
                arrayList.add(uRI);
            }
            hashMap.put(string, arrayList);
        }
        final LibraryManager libraryManager2 = LibraryManager.forLocation((URL)uRL);
        try {
            return (Library)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Library>(){

                public Library run() throws IOException {
                    String string = library.getName();
                    if (bl) {
                        int n = 2;
                        while (libraryManager2.getLibrary(string) != null) {
                            string = library.getName() + "-" + n;
                            ++n;
                        }
                    }
                    return libraryManager2.createURILibrary(library.getType(), string, hashMap);
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static FileObject getSharedLibFolder(final File file, final Library library) throws IOException {
        FileObject fileObject;
        try {
            fileObject = (FileObject)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<FileObject>(){

                public FileObject run() throws IOException {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) {
                        fileObject = FileUtil.createFolder((File)file);
                    }
                    return fileObject.createFolder(ProjectLibraryProvider.getUniqueName(fileObject, library.getName(), null));
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        return fileObject;
    }

    private static String getUniqueName(FileObject fileObject, String string, String string2) {
        assert (fileObject != null);
        int n = 2;
        String string3 = string;
        while (fileObject.getFileObject(string3 + (string2 != null ? "." + string2 : "")) != null) {
            string3 = string + "-" + n;
            ++n;
        }
        return string3;
    }

    static {
        LIBS_LINE = Pattern.compile("libs\\.([^${}]+)\\.([^${}.]+)");
        RP = new RequestProcessor("ProjectLibraryProvider.RP");
        FIRE_CHANGES_SYNCH = false;
    }

    public static final class SharabilityQueryImpl
    implements SharabilityQueryImplementation {
        public int getSharability(File file) {
            if (file.getName().endsWith("-private.properties")) {
                return 2;
            }
            return 0;
        }
    }

    static final class ProjectLibraryArea
    implements LibraryStorageArea {
        final File mainPropertiesFile;

        ProjectLibraryArea(File file) {
            assert (file.getName().endsWith(".properties")) : file;
            this.mainPropertiesFile = file;
        }

        public String getDisplayName() {
            return this.mainPropertiesFile.getAbsolutePath();
        }

        public URL getLocation() {
            try {
                return this.mainPropertiesFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }

        public boolean equals(Object object) {
            return object instanceof ProjectLibraryArea && ((ProjectLibraryArea)object).mainPropertiesFile.equals(this.mainPropertiesFile);
        }

        public int hashCode() {
            return this.mainPropertiesFile.hashCode();
        }

        public String toString() {
            return "ProjectLibraryArea[" + this.mainPropertiesFile + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ProjectLibraryImplementation
    implements LibraryImplementation2 {
        final File mainPropertiesFile;
        final File privatePropertiesFile;
        final String type;
        String name;
        String description;
        Map<String, List<URI>> contents;
        final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        static Field libraryImplField;

        private String getGlobalLibBundle(Library library) {
            if (libraryImplField != null) {
                try {
                    LibraryImplementation libraryImplementation = (LibraryImplementation)libraryImplField.get(library);
                    String string = libraryImplementation.getLocalizingBundle();
                    return string;
                }
                catch (Exception exception) {
                    Logger.getLogger(ProjectLibraryProvider.class.getName()).log(Level.FINE, "Cannot access field by reflection", exception);
                }
            }
            return null;
        }

        ProjectLibraryImplementation(File file, File file2, String string, String string2, String string3, Map<String, List<URI>> map) {
            this.mainPropertiesFile = file;
            this.privatePropertiesFile = file2;
            this.type = string;
            this.name = string2;
            this.description = string3;
            this.contents = map;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLocalizingBundle() {
            Library library = LibraryManager.getDefault().getLibrary(this.name);
            if (library != null) {
                return this.getGlobalLibBundle(library);
            }
            return null;
        }

        public List<URL> getContent(String string) throws IllegalArgumentException {
            List<URI> list = this.getURIContent(string);
            ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
            for (URI uRI : list) {
                try {
                    arrayList.add(LibrariesSupport.resolveLibraryEntryURI((URL)this.mainPropertiesFile.toURI().toURL(), (URI)uRI).toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
            return arrayList;
        }

        public List<URI> getURIContent(String string) throws IllegalArgumentException {
            List<URI> list = this.contents.get(string);
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }

        public void setName(String string) {
            this.name = string;
            this.pcs.firePropertyChange("name", null, null);
            throw new UnsupportedOperationException();
        }

        public void setDescription(String string) {
            throw new UnsupportedOperationException();
        }

        public void setContent(String string, List<URL> list) throws IllegalArgumentException {
            ArrayList<URI> arrayList = new ArrayList<URI>(list.size());
            for (URL uRL : list) {
                arrayList.add(URI.create(uRL.toExternalForm()));
            }
            this.setURIContent(string, arrayList);
        }

        public void setURIContent(String string, List<URI> list) throws IllegalArgumentException {
            if (((Object)list).equals(this.getContent(string))) {
                return;
            }
            this.contents.put(string, new ArrayList<URI>(list));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (URI uRI : list) {
                String string2 = null;
                if (uRI.toString().contains("!/")) {
                    string2 = ProjectLibraryProvider.getJarFolder(uRI);
                    uRI = LibrariesSupport.getArchiveFile((URI)uRI);
                } else if (uRI.isAbsolute() && !"file".equals(uRI.getScheme())) {
                    arrayList.add(uRI.toString());
                    Logger.getLogger(ProjectLibraryProvider.class.getName()).fine("Setting uri=" + uRI + " as content for library volume type: " + string);
                    continue;
                }
                String string3 = LibrariesSupport.convertURIToFilePath((URI)uRI).replace('\\', '/');
                StringBuilder stringBuilder = new StringBuilder();
                if (string3.startsWith("${")) {
                    stringBuilder.append(string3.replace('\\', '/'));
                } else if (uRI.isAbsolute()) {
                    stringBuilder.append(string3);
                } else {
                    stringBuilder.append("${base}/" + string3);
                }
                if (string2 != null) {
                    stringBuilder.append("!/");
                    stringBuilder.append(string2);
                }
                if (arrayList.size() + 1 != list.size()) {
                    stringBuilder.append(File.pathSeparatorChar);
                }
                arrayList.add(stringBuilder.toString());
            }
            String string4 = "libs." + this.name + "." + string;
            try {
                ProjectLibraryProvider.replaceProperty(this.mainPropertiesFile, true, string4, arrayList.toArray(new String[arrayList.size()]));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
            this.pcs.firePropertyChange("content", null, null);
        }

        public void setLocalizingBundle(String string) {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public String toString() {
            return "ProjectLibraryImplementation[name=" + this.name + ",file=" + this.mainPropertiesFile + ",contents=" + this.contents + "]";
        }

        static {
            try {
                libraryImplField = Library.class.getDeclaredField("impl");
                libraryImplField.setAccessible(true);
            }
            catch (Exception exception) {
                Logger.getLogger(ProjectLibraryProvider.class.getName()).log(Level.FINE, "Cannot find field by reflection", exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Definitions {
        final File mainPropertiesFile;
        final File privatePropertiesFile;
        private Map<String, String> properties;

        Definitions(File file) {
            this.mainPropertiesFile = file;
            String string = ".properties";
            String string2 = file.getName();
            this.privatePropertiesFile = string2.endsWith(string) ? new File(file.getParentFile(), string2.substring(0, string2.length() - string.length()) + "-private" + string) : null;
        }

        synchronized Map<String, String> properties(boolean bl) {
            if (this.properties == null) {
                String string;
                this.properties = new HashMap<String, String>();
                String string2 = this.mainPropertiesFile.getParent();
                for (Map.Entry entry : ProjectLibraryProvider.loadProperties(this.mainPropertiesFile).entrySet()) {
                    string = (String)entry.getValue();
                    if (bl) {
                        string = string.replace("${base}", string2);
                    }
                    this.properties.put((String)entry.getKey(), string.replace('/', File.separatorChar));
                }
                if (this.privatePropertiesFile != null) {
                    for (Map.Entry entry : ProjectLibraryProvider.loadProperties(this.privatePropertiesFile).entrySet()) {
                        string = (String)entry.getValue();
                        if (bl) {
                            string = string.replace("${base}", string2);
                        }
                        this.properties.put((String)entry.getKey(), string.replace('/', File.separatorChar));
                    }
                }
            }
            return this.properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LP
    implements LibraryProvider<ProjectLibraryImplementation>,
    FileChangeSupportListener {
        private final ProjectLibraryArea area;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Map<String, ProjectLibraryImplementation> libraries;

        LP(ProjectLibraryArea projectLibraryArea) {
            this.area = projectLibraryArea;
            this.libraries = ProjectLibraryProvider.calculate(projectLibraryArea);
            Definitions definitions = new Definitions(projectLibraryArea.mainPropertiesFile);
            FileChangeSupport.DEFAULT.addListener(this, definitions.mainPropertiesFile);
            FileChangeSupport.DEFAULT.addListener(this, definitions.privatePropertiesFile);
        }

        public synchronized ProjectLibraryImplementation[] getLibraries() {
            return this.libraries.values().toArray(new ProjectLibraryImplementation[this.libraries.size()]);
        }

        ProjectLibraryImplementation getLibrary(String string) {
            return this.libraries.get(string);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.recalculate();
        }

        @Override
        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.recalculate();
        }

        @Override
        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.recalculate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recalculate() {
            boolean bl;
            HashMap hashMap = new HashMap();
            LP lP = this;
            synchronized (lP) {
                bl = ProjectLibraryProvider.this.delta(this.libraries, ProjectLibraryProvider.calculate(this.area), hashMap);
            }
            if (hashMap.size() > 0) {
                for (ProjectLibraryImplementation projectLibraryImplementation : hashMap.keySet()) {
                    for (String string : (List)hashMap.get(projectLibraryImplementation)) {
                        projectLibraryImplementation.pcs.firePropertyChange(string, null, null);
                    }
                }
            }
            if (bl) {
                this.pcs.firePropertyChange(ProjectLibraryProvider.EL_LIBRARIES, null, null);
            }
        }
    }
}

