/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ant.VariablesModel;
import org.netbeans.modules.project.ant.VariablesPanel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private File baseFolder;
    private final File sharedLibrariesFolder;
    private boolean copyAllowed;
    private JFileChooser chooser;
    private List<String> copiedRelativeFiles = null;
    private File usetThisFileInsteadOfOneFromChooser = null;
    private VariablesModel varModel;
    private boolean enableVariableBasedSelection = false;
    private JTextField absolutePath;
    private ButtonGroup buttonGroup1;
    private JTextField copyTo;
    private JRadioButton rbAbsolute;
    private JRadioButton rbCopy;
    private JRadioButton rbRelative;
    private JRadioButton rbVariable;
    private JTextField relativePath;
    private JTextField variablePath;
    private JButton variablesButton;

    public FileChooserAccessory(File file, File file2, boolean bl, File file3) {
        this(null, file, file2, bl);
        this.usetThisFileInsteadOfOneFromChooser = file3;
        this.enableAccessory(true);
        this.update(Collections.singletonList(this.usetThisFileInsteadOfOneFromChooser));
        if (CollocationQuery.areCollocated((File)file, (File)file3)) {
            this.rbRelative.setSelected(true);
        } else if (this.getVariablesModel().getRelativePath(file3, true) != null) {
            this.rbVariable.setSelected(true);
        } else if (bl) {
            this.rbCopy.setSelected(true);
        } else {
            this.rbAbsolute.setSelected(true);
        }
        this.enableVariableBasedSelection(this.enableVariableBasedSelection);
    }

    public FileChooserAccessory(JFileChooser jFileChooser, File file, File file2, boolean bl) {
        assert (file != null);
        assert (!file.isFile());
        if (file2 != null) {
            assert (!file2.isFile()) : true;
            if (!file2.equals(FileUtil.normalizeFile((File)file2))) {
                throw new IllegalArgumentException("Parameter file was not normalized. Was " + file2 + " instead of " + FileUtil.normalizeFile((File)file2));
            }
        }
        this.baseFolder = file;
        this.sharedLibrariesFolder = file2;
        this.copyAllowed = bl && file2 != null;
        this.chooser = jFileChooser;
        this.initComponents();
        this.rbCopy.addActionListener(this);
        this.rbRelative.addActionListener(this);
        this.rbAbsolute.addActionListener(this);
        this.rbVariable.addActionListener(this);
        if (jFileChooser != null) {
            jFileChooser.addPropertyChangeListener(this);
        }
        if (file2 != null) {
            this.copyTo.setText(file2.getAbsolutePath());
        }
        this.enableAccessory(false);
        if (!bl) {
            this.rbCopy.setVisible(false);
            this.copyTo.setVisible(false);
        }
        this.enableVariableBasedSelection(this.enableVariableBasedSelection);
    }

    public void enableVariableBasedSelection(boolean bl) {
        this.enableVariableBasedSelection = bl;
        this.rbVariable.setVisible(this.enableVariableBasedSelection);
        this.variablePath.setVisible(this.enableVariableBasedSelection);
        this.variablesButton.setVisible(this.enableVariableBasedSelection);
    }

    public String[] getFiles() {
        assert (this.isRelative());
        if (this.isCopy()) {
            return this.copiedRelativeFiles.toArray(new String[this.copiedRelativeFiles.size()]);
        }
        List<File> list = Arrays.asList(this.getSelectedFiles());
        List<String> list2 = this.getRelativeFiles(list);
        return list2.toArray(new String[list2.size()]);
    }

    public boolean canApprove() {
        if (!this.isCopy()) {
            return true;
        }
        File file = FileUtil.normalizeFile((File)new File(this.copyTo.getText()));
        if (!file.getPath().equals(this.sharedLibrariesFolder.getPath()) && !file.getPath().startsWith(this.sharedLibrariesFolder.getPath() + File.separatorChar)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.warning1"), this.sharedLibrariesFolder.getPath())));
            return false;
        }
        File[] fileArray = this.getSelectedFiles();
        if (file.exists()) {
            for (File file2 : fileArray) {
                File file3 = new File(file, file2.getName());
                if (!file3.exists()) continue;
                if (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.warning3")))) {
                    return false;
                }
                break;
            }
        } else if (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.warning2"), file.getPath())))) {
            return false;
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            if (NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.warning4")))) break;
            return false;
        }
        return true;
    }

    public void copyFilesIfNecessary() throws IOException {
        if (!this.isCopy()) {
            return;
        }
        File file = FileUtil.normalizeFile((File)new File(this.copyTo.getText()));
        FileUtil.createFolder((File)file);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        List<File> list = Arrays.asList(this.getSelectedFiles());
        this.copyFiles(list, fileObject);
    }

    private void enableAccessory(boolean bl) {
        this.rbRelative.setEnabled(bl);
        this.relativePath.setEnabled(bl);
        this.rbCopy.setEnabled(bl && this.copyAllowed);
        this.rbAbsolute.setEnabled(bl);
        this.absolutePath.setEnabled(bl);
        this.copyTo.setEnabled(bl);
        this.copyTo.setEditable(bl && this.rbCopy.isSelected());
        if (bl) {
            File file = this.getSelectedFiles()[0];
            boolean bl2 = this.getVariablesModel().getRelativePath(file, true) != null;
            this.rbVariable.setEnabled(bl2);
            this.variablePath.setEnabled(bl2);
        } else {
            this.rbVariable.setEnabled(false);
            this.variablePath.setEnabled(false);
        }
        this.variablePath.setEditable(false);
        this.variablesButton.setEnabled(bl);
    }

    private File[] getSelectedFiles() {
        if (this.usetThisFileInsteadOfOneFromChooser != null) {
            return new File[]{this.usetThisFileInsteadOfOneFromChooser};
        }
        File[] fileArray = this.chooser.isMultiSelectionEnabled() ? this.chooser.getSelectedFiles() : (this.chooser.getSelectedFile() != null ? new File[]{this.chooser.getSelectedFile()} : new File[]{});
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getPath().contains("..")) continue;
            fileArray[i] = FileUtil.normalizeFile((File)fileArray[i]);
        }
        return fileArray;
    }

    public boolean isRelative() {
        return this.rbRelative.isEnabled() && this.rbRelative.isSelected() || this.isCopy();
    }

    public boolean isVariableBased() {
        return this.rbVariable.isEnabled() && this.rbVariable.isSelected();
    }

    private boolean isCopy() {
        return this.rbCopy.isEnabled() && this.rbCopy.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.copyTo.setEditable(actionEvent.getSource() == this.rbCopy);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName()) && !"SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        File[] fileArray = this.getSelectedFiles();
        this.enableAccessory(fileArray.length != 0);
        this.update(Arrays.asList(fileArray));
    }

    private void update(List<File> list) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        boolean bl = true;
        for (File file : list) {
            String string = this.getVariablesModel().getRelativePath(file, true);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
                stringBuffer2.append(", ");
                if (string != null) {
                    stringBuffer3.append(", ");
                }
            }
            stringBuffer.append(file.getAbsolutePath());
            String string2 = PropertyUtils.relativizeFile(this.baseFolder, file);
            if (string2 == null) {
                bl = false;
            }
            stringBuffer2.append(string2);
            if (string == null) continue;
            stringBuffer3.append(string);
        }
        this.rbRelative.setEnabled(bl && this.rbRelative.isEnabled());
        this.relativePath.setText(stringBuffer2.toString());
        this.relativePath.setCaretPosition(0);
        this.relativePath.setToolTipText(stringBuffer2.toString());
        if (!bl) {
            this.relativePath.setText("");
            this.relativePath.setToolTipText("");
        }
        this.absolutePath.setText(stringBuffer.toString());
        this.absolutePath.setCaretPosition(0);
        this.absolutePath.setToolTipText(stringBuffer.toString());
        if (stringBuffer3.length() == 0) {
            stringBuffer3.append(NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.noSuitableVariable"));
        }
        this.variablePath.setText(stringBuffer3.toString());
        this.variablePath.setCaretPosition(0);
        this.variablePath.setToolTipText(stringBuffer3.toString());
    }

    private VariablesModel getVariablesModel() {
        if (this.varModel == null) {
            this.varModel = new VariablesModel();
        }
        return this.varModel;
    }

    private List<String> getRelativeFiles(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            String string = PropertyUtils.relativizeFile(this.baseFolder, file);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String[] getVariableBasedFiles() {
        assert (this.isVariableBased());
        List<File> list = Arrays.asList(this.getSelectedFiles());
        List<String> list2 = this.getVariableBasedFiles(list);
        return list2.toArray(new String[list2.size()]);
    }

    private List<String> getVariableBasedFiles(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            String string = this.getVariablesModel().getRelativePath(file, false);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void copyFiles(List<File> list, FileObject fileObject) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            FileObject fileObject2;
            FileObject fileObject3 = FileUtil.toFileObject((File)file);
            if (fileObject3.isFolder()) {
                fileObject2 = FileChooserAccessory.copyFolderRecursively(fileObject3, fileObject);
            } else {
                FileObject fileObject4 = fileObject.getFileObject(fileObject3.getName(), fileObject3.getExt());
                if (fileObject4 != null) {
                    fileObject4.delete();
                }
                fileObject2 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject, (String)fileObject3.getName(), (String)fileObject3.getExt());
            }
            arrayList.add(FileUtil.toFile((FileObject)fileObject2));
        }
        this.copiedRelativeFiles = this.getRelativeFiles(arrayList);
    }

    public static FileObject copyFolderRecursively(FileObject fileObject, FileObject fileObject2) throws IOException {
        assert (fileObject.isFolder()) : fileObject;
        assert (fileObject2.isFolder()) : fileObject2;
        FileObject fileObject3 = fileObject2.getFileObject(fileObject.getName());
        if (fileObject3 == null) {
            fileObject3 = fileObject2.createFolder(fileObject.getName());
        }
        for (FileObject fileObject4 : fileObject.getChildren()) {
            if (fileObject4.isFolder()) {
                FileChooserAccessory.copyFolderRecursively(fileObject4, fileObject3);
                continue;
            }
            FileObject fileObject5 = fileObject3.getFileObject(fileObject4.getName(), fileObject4.getExt());
            if (fileObject5 != null) {
                fileObject5.delete();
            }
            FileObject fileObject6 = FileUtil.copyFile((FileObject)fileObject4, (FileObject)fileObject3, (String)fileObject4.getName(), (String)fileObject4.getExt());
        }
        return fileObject3;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.rbRelative = new JRadioButton();
        this.relativePath = new JTextField();
        this.rbCopy = new JRadioButton();
        this.copyTo = new JTextField();
        this.rbAbsolute = new JRadioButton();
        this.absolutePath = new JTextField();
        this.rbVariable = new JRadioButton();
        this.variablePath = new JTextField();
        this.variablesButton = new JButton();
        this.buttonGroup1.add(this.rbRelative);
        this.rbRelative.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRelative, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbRelative.text"));
        this.relativePath.setEditable(false);
        this.relativePath.setText(null);
        this.buttonGroup1.add(this.rbCopy);
        Mnemonics.setLocalizedText((AbstractButton)this.rbCopy, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbCopy.text"));
        this.copyTo.setEditable(false);
        this.copyTo.setText(null);
        this.buttonGroup1.add(this.rbAbsolute);
        Mnemonics.setLocalizedText((AbstractButton)this.rbAbsolute, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbAbsolute.text"));
        this.absolutePath.setEditable(false);
        this.absolutePath.setText(null);
        this.buttonGroup1.add(this.rbVariable);
        Mnemonics.setLocalizedText((AbstractButton)this.rbVariable, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbVariable.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.variablesButton, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.variablesButton.text"));
        this.variablesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserAccessory.this.variablesButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbAbsolute).addContainerGap(104, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbCopy, -1, 238, Short.MAX_VALUE).addContainerGap(12, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbVariable).addContainerGap(108, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbRelative).addContainerGap(110, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.copyTo, -1, 229, Short.MAX_VALUE).add((Component)this.relativePath, -1, 229, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.variablePath, -1, 199, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.variablesButton)).add((Component)this.absolutePath, -1, 229, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbRelative).add(0, 0, 0).add((Component)this.relativePath, -2, -1, -2).addPreferredGap(0).add((Component)this.rbVariable).add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.variablesButton).add((Component)this.variablePath, -2, -1, -2)).addPreferredGap(0).add((Component)this.rbCopy).add(0, 0, 0).add((Component)this.copyTo, -2, -1, -2).addPreferredGap(0).add((Component)this.rbAbsolute).add(0, 0, 0).add((Component)this.absolutePath, -2, -1, -2)));
        this.rbRelative.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.rbCopy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.rbAbsolute.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.rbVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.variablesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory.variablesButton.text"));
    }

    private void variablesButtonActionPerformed(ActionEvent actionEvent) {
        VariablesModel.Variable variable = VariablesPanel.showVariablesCustomizer();
        this.varModel = null;
        File[] fileArray = this.getSelectedFiles();
        if (variable != null && (fileArray.length > 0 && this.getVariablesModel().getRelativePath(fileArray[0], true) == null || fileArray.length == 0)) {
            this.chooser.setSelectedFile(variable.getValue());
            fileArray = this.getSelectedFiles();
        }
        this.update(Arrays.asList(fileArray));
        this.enableAccessory(fileArray.length != 0);
    }
}

