/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.ant.AntArtifactQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class AntArtifactQuery {
    private AntArtifactQuery() {
    }

    public static AntArtifact findArtifactFromFile(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        for (AntArtifactQueryImplementation antArtifactQueryImplementation : Lookup.getDefault().lookupAll(AntArtifactQueryImplementation.class)) {
            AntArtifact antArtifact = antArtifactQueryImplementation.findArtifact(file);
            if (antArtifact == null) continue;
            return antArtifact;
        }
        return null;
    }

    public static AntArtifact findArtifactByID(Project project, String string) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider == null) {
            return null;
        }
        for (AntArtifact antArtifact : antArtifactProvider.getBuildArtifacts()) {
            if (!antArtifact.getID().equals(string)) continue;
            return antArtifact;
        }
        return null;
    }

    public static AntArtifact[] findArtifactsByType(Project project, String string) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider == null) {
            return new AntArtifact[0];
        }
        AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
        ArrayList<AntArtifact> arrayList = new ArrayList<AntArtifact>(antArtifactArray.length);
        for (AntArtifact antArtifact : antArtifactArray) {
            if (!antArtifact.getType().equals(string)) continue;
            arrayList.add(antArtifact);
        }
        return arrayList.toArray(new AntArtifact[arrayList.size()]);
    }
}

