/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.common.CatalogWSDL;
import org.netbeans.modules.compapp.projects.common.ImplicitCatalogSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ImplicitCatalogValidator {
    private static final Logger sLogger = Logger.getLogger(ImplicitCatalogValidator.class.getName());
    private Project mPrj;
    private CatalogWSDL mCatalogWSDL;
    private ImplicitCatalogSupport mCatalogSupport;
    private ResultPrinter mPrn = new ResultPrinter();

    public ImplicitCatalogValidator(ImplicitCatalogSupport implicitCatalogSupport, CatalogWSDL catalogWSDL) {
        this.mCatalogSupport = implicitCatalogSupport;
        this.mCatalogWSDL = catalogWSDL;
    }

    public static ImplicitCatalogValidator newInstance(Project project) throws IOException {
        ImplicitCatalogValidator implicitCatalogValidator = null;
        ImplicitCatalogSupport implicitCatalogSupport = ImplicitCatalogSupport.getInstance(project);
        CatalogWSDL catalogWSDL = CatalogWSDL.loadCatalogWSDL(project);
        implicitCatalogValidator = new ImplicitCatalogValidator(implicitCatalogSupport, catalogWSDL);
        return implicitCatalogValidator;
    }

    public void setResultPrinter(ResultPrinter resultPrinter) {
        this.mPrn = resultPrinter;
    }

    protected ResultPrinter getResultPrinter() {
        return this.mPrn;
    }

    protected CatalogWSDL getCatalogWSDL() {
        return this.mCatalogWSDL;
    }

    protected ImplicitCatalogSupport getImplicitCatalogSupport() {
        return this.mCatalogSupport;
    }

    public boolean validate() {
        String string = NbBundle.getMessage(ImplicitCatalogValidator.class, (String)"icat.validator.msg.started");
        String string2 = NbBundle.getMessage(ImplicitCatalogValidator.class, (String)"icat.validator.msg.finished");
        this.mPrn.println(string);
        List<CatalogWSDL.Entry> list = this.mCatalogWSDL.getEntries();
        for (CatalogWSDL.Entry entry : list) {
            FileObject fileObject = null;
            try {
                fileObject = this.mCatalogSupport.resolveImplicitReference(entry.getLocation());
                this.printResult(entry, fileObject);
            }
            catch (Exception exception) {
                this.printResult(entry, exception);
                sLogger.log(Level.FINE, exception.getMessage(), exception);
            }
        }
        this.mPrn.println(string2);
        return true;
    }

    protected void printResult(CatalogWSDL.Entry entry, FileObject fileObject) {
        String string = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.systemid", (Object)entry.getLocation());
        String string2 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.type", (Object)((Object)entry.getType()));
        if (fileObject == null) {
            String string3 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.error", (Object)entry.getNamesapce());
            String string4 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.result.file.not.found");
            String string5 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.result", (Object)string4);
            this.mPrn.println(string3);
            this.mPrn.println(string);
            this.mPrn.println(string2);
            this.mPrn.println(string5);
        } else {
            String string6 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.info", (Object)entry.getNamesapce());
            String string7 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.result.file", (Object)fileObject.getPath());
            String string8 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.result", (Object)string7);
            this.mPrn.println(string6);
            this.mPrn.println(string);
            this.mPrn.println(string2);
            this.mPrn.println(string8);
        }
    }

    protected void printResult(CatalogWSDL.Entry entry, Exception exception) {
        String string = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.error", (Object)entry.getNamesapce());
        String string2 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.systemid", (Object)entry.getLocation());
        String string3 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.type", (Object)((Object)entry.getType()));
        String string4 = NbBundle.getMessage(this.getClass(), (String)"icat.validator.msg.entry.result", (Object)exception.getMessage());
        this.mPrn.println(string);
        this.mPrn.println(string2);
        this.mPrn.println(string3);
        this.mPrn.println(string4);
    }

    public static class StringResult
    extends ResultPrinter {
        private StringWriter mStrWriter;

        protected void initWriters() {
            this.mStrWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)this.mStrWriter, true);
            this.setOutWriter(printWriter);
            this.setErrorWriter(printWriter);
        }

        public String toString() {
            return this.mStrWriter.getBuffer().toString();
        }
    }

    public static class ResultPrinter {
        private PrintWriter mOut;
        private PrintWriter mErr;

        public ResultPrinter() {
            this.initWriters();
        }

        protected void initWriters() {
            PrintWriter printWriter = new PrintWriter(System.out, true);
            PrintWriter printWriter2 = new PrintWriter(System.err, true);
            this.setOutWriter(printWriter);
            this.setErrorWriter(printWriter2);
        }

        protected final void setOutWriter(PrintWriter printWriter) {
            this.mOut = printWriter;
        }

        protected final PrintWriter getOutWriter() {
            return this.mOut;
        }

        protected final void setErrorWriter(PrintWriter printWriter) {
            this.mErr = printWriter;
        }

        protected final PrintWriter getErrorWriter() {
            return this.mErr;
        }

        public void println(Object object) {
            this.mOut.println(object);
        }

        public void error(Object object) {
            this.mErr.print(object);
        }

        public void warning(Object object) {
            this.mErr.print(object);
        }
    }
}

