/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.utils.MapperTreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static Color gray(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = Math.round((float)n2 * 0.299f + (float)n3 * 0.587f + (float)n4 * 0.114f);
        float f = (float)n / 100.0f;
        n2 = Math.round((float)n2 + f * (float)(n5 - n2));
        n3 = Math.round((float)n3 + f * (float)(n5 - n3));
        n4 = Math.round((float)n4 + f * (float)(n5 - n4));
        if (n2 > 255) {
            n2 = 255;
        } else if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        } else if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > 255) {
            n4 = 255;
        } else if (n4 < 0) {
            n4 = 0;
        }
        return new Color(n2, n3, n4, color.getAlpha());
    }

    public static Set<Graph> findGraphs(MapperModel mapperModel, TreePath treePath, Set<Graph> set) {
        if (set == null) {
            set = new HashSet<Graph>();
        }
        Object object = treePath.getLastPathComponent();
        if (mapperModel.searchGraphsInside(treePath) && !mapperModel.isLeaf(object)) {
            int n = mapperModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = mapperModel.getChild(object, i);
                MapperTreePath mapperTreePath = new MapperTreePath(treePath, object2);
                Graph graph = mapperModel.getGraph(mapperTreePath);
                if (graph != null) {
                    set.add(graph);
                }
                set = Utils.findGraphs(mapperModel, mapperTreePath, set);
            }
        }
        return set;
    }

    public static boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return object == null || object2 == null ? false : object.equals(object2);
    }

    public static Point toScrollPane(Component component, Point point, Point point2) {
        int n = point.x;
        int n2 = point.y;
        while (!(component instanceof JScrollPane)) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        if (point2 == null) {
            point2 = new Point(n, n2);
        } else {
            point2.setLocation(n, n2);
        }
        return point2;
    }

    public static Point fromScrollPane(Component component, Point point, Point point2) {
        int n = point.x;
        int n2 = point.y;
        while (!(component instanceof JScrollPane)) {
            n -= component.getX();
            n2 -= component.getY();
            component = component.getParent();
        }
        if (point2 == null) {
            point2 = new Point(n, n2);
        } else {
            point2.setLocation(n, n2);
        }
        return point2;
    }

    public static List<TreePath> getNonEmptyGraphs(MapperModel mapperModel) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        if (mapperModel != null) {
            int n;
            Object object = mapperModel.getRoot();
            int n2 = n = object != null && !mapperModel.isLeaf(object) ? mapperModel.getChildCount(object) : 0;
            if (n > 0) {
                TreePath treePath = new TreePath(object);
                for (int i = 0; i < n; ++i) {
                    Object object2 = mapperModel.getChild(object, i);
                    Utils.collectNonEmptyGraphs(mapperModel, treePath.pathByAddingChild(object2), arrayList);
                }
            }
        }
        return arrayList;
    }

    private static void collectNonEmptyGraphs(MapperModel mapperModel, TreePath treePath, List<TreePath> list) {
        Object object = treePath.getLastPathComponent();
        Graph graph = mapperModel.getGraph(treePath);
        if (graph != null && !graph.isEmpty()) {
            list.add(treePath);
        }
        int n = !mapperModel.isLeaf(object) && mapperModel.searchGraphsInside(treePath) ? mapperModel.getChildCount(object) : 0;
        for (int i = 0; i < n; ++i) {
            Object object2 = mapperModel.getChild(object, i);
            Utils.collectNonEmptyGraphs(mapperModel, treePath.pathByAddingChild(object2), list);
        }
    }

    public static double distance(Shape shape, int n, int n2) {
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Double.POSITIVE_INFINITY;
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            double d6;
            double d7;
            int n3 = pathIterator.currentSegment(dArray);
            if (n3 == 0) {
                d = d3 = dArray[0];
                d2 = d4 = dArray[1];
            } else if (n3 == 1) {
                d7 = dArray[0];
                d6 = dArray[1];
                d5 = Math.min(d5, Line2D.ptSegDist(d3, d4, d7, d6, n, n2));
                d3 = d7;
                d4 = d6;
            } else if (n3 == 4) {
                d7 = d;
                d6 = d2;
                d5 = Math.min(d5, Line2D.ptSegDist(d3, d4, d7, d6, n, n2));
                d3 = d7;
                d4 = d6;
            }
            pathIterator.next();
        }
        return d5;
    }

    public static boolean isTreePathExpandable(TreeModel treeModel, TreePath treePath) {
        if (treeModel == null) {
            return false;
        }
        if (treePath == null) {
            return false;
        }
        return !treeModel.isLeaf(treePath.getLastPathComponent()) && Utils.isTreePathInModel(treeModel, treePath);
    }

    public static boolean isTreePathInModel(TreeModel treeModel, TreePath treePath) {
        if (treeModel == null) {
            return false;
        }
        if (treePath == null) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return treeModel.getRoot() == treePath.getLastPathComponent();
        }
        if (!Utils.isTreePathInModel(treeModel, treePath2)) {
            return false;
        }
        Object object = treePath.getLastPathComponent();
        Object object2 = treePath2.getLastPathComponent();
        return treeModel.getIndexOfChild(object2, object) >= 0;
    }
}

