/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.utils;

import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapperCollection {
    private static final MapperCollection EMPTY_COLLECTION = new MapperCollection(){

        public boolean contains(TreePath treePath, Vertex vertex) {
            return false;
        }

        public boolean contains(TreePath treePath, VertexItem vertexItem) {
            return false;
        }
    };

    private MapperCollection() {
    }

    public abstract boolean contains(TreePath var1, Vertex var2);

    public abstract boolean contains(TreePath var1, VertexItem var2);

    public static MapperCollection create() {
        return EMPTY_COLLECTION;
    }

    public static MapperCollection createVerteces(TreePath treePath, Set<Vertex> set) {
        return set == null || set.isEmpty() ? EMPTY_COLLECTION : new VertecesCollection(treePath, set);
    }

    public static MapperCollection createVertexItems(TreePath treePath, Set<VertexItem> set) {
        return set == null || set.isEmpty() ? EMPTY_COLLECTION : new SingleGraphVertexItemCollection(treePath, set);
    }

    public static MapperCollection create(Map<TreePath, Set<VertexItem>> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_COLLECTION;
        }
        if (map.size() == 1) {
            return new SingleGraphVertexItemCollection(map.keySet().iterator().next(), map.values().iterator().next());
        }
        return new MultiGraphVertexItemsCollection(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleGraphVertexItemCollection
    extends MapperCollection {
        TreePath treePath;
        Set<VertexItem> vertexItems;

        SingleGraphVertexItemCollection(TreePath treePath, Set<VertexItem> set) {
            this.treePath = treePath;
            this.vertexItems = set;
        }

        @Override
        public boolean contains(TreePath treePath, Vertex vertex) {
            return false;
        }

        @Override
        public boolean contains(TreePath treePath, VertexItem vertexItem) {
            return Utils.equal(this.treePath, treePath) && this.vertexItems.contains(vertexItem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiGraphVertexItemsCollection
    extends MapperCollection {
        Map<TreePath, Set<VertexItem>> vertexItemsMap;

        MultiGraphVertexItemsCollection(Map<TreePath, Set<VertexItem>> map) {
            this.vertexItemsMap = map;
        }

        @Override
        public boolean contains(TreePath treePath, VertexItem vertexItem) {
            if (treePath == null) {
                return false;
            }
            Set<VertexItem> set = this.vertexItemsMap.get(treePath);
            return set != null && set.contains(vertexItem);
        }

        @Override
        public boolean contains(TreePath treePath, Vertex vertex) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VertecesCollection
    extends MapperCollection {
        TreePath treePath;
        Set<Vertex> verteces;

        VertecesCollection(TreePath treePath, Set<Vertex> set) {
            this.treePath = treePath;
            this.verteces = set;
        }

        @Override
        public boolean contains(TreePath treePath, Vertex vertex) {
            return Utils.equal(this.treePath, treePath) && this.verteces.contains(vertex);
        }

        @Override
        public boolean contains(TreePath treePath, VertexItem vertexItem) {
            return false;
        }
    }
}

