/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.netbeans.modules.soa.mappercore.dnd.DnDConstants;
import org.netbeans.modules.soa.mappercore.dnd.DnDHandler;

public class DnDSupport
implements DnDConstants {
    private DnDHandler dndHandler;
    private JComponent component;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private DnDRecognizer recognizer;
    private Transferable cachedTransferable;
    private DragHandler dragHandler;
    private DropHandler dropHandler;

    public DnDSupport(JComponent jComponent, DnDHandler dnDHandler) {
        this.component = jComponent;
        this.dndHandler = dnDHandler;
        this.dropHandler = new DropHandler();
        this.dropTarget = new DropTarget(jComponent, this.dropHandler);
    }

    private DragHandler getDragHandler() {
        if (this.dragHandler == null) {
            this.dragHandler = new DragHandler();
        }
        return this.dragHandler;
    }

    private DragSource getDragSource() {
        if (this.dragSource == null) {
            this.dragSource = new DragSource();
        }
        return this.dragSource;
    }

    private DnDRecognizer getDnDRecognizer() {
        if (this.recognizer == null) {
            this.recognizer = new DnDRecognizer(this.getDragSource(), this.getDragHandler());
        }
        return this.recognizer;
    }

    public void startDrag(MouseEvent mouseEvent, Transferable transferable, int n) {
        if (n != 0) {
            this.cachedTransferable = transferable;
            this.getDnDRecognizer().startDrag(this.component, mouseEvent, 0x40000003, n);
        }
    }

    private static class DnDRecognizer
    extends DragGestureRecognizer {
        DnDRecognizer(DragSource dragSource, DragGestureListener dragGestureListener) {
            super(dragSource, null, 0, dragGestureListener);
        }

        void startDrag(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private class DragHandler
    implements DragSourceListener,
    DragGestureListener {
        private DragHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (DnDSupport.this.cachedTransferable != null) {
                try {
                    dragGestureEvent.startDrag(null, DnDSupport.this.cachedTransferable, this);
                }
                finally {
                    DnDSupport.this.cachedTransferable = null;
                }
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DnDSupport.this.dndHandler.dragDone(DnDSupport.this.component, dragSourceDropEvent);
        }
    }

    private class DropHandler
    implements DropTargetListener {
        private DropHandler() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DnDSupport.this.dndHandler.drag(DnDSupport.this.component, dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            DnDSupport.this.dndHandler.drag(DnDSupport.this.component, dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            DnDSupport.this.dndHandler.dragExit(DnDSupport.this.component);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DnDSupport.this.dndHandler.drop(DnDSupport.this.component, dropTargetDropEvent);
        }
    }
}

